<?php
// get.php - Versão Corrigida (Backticks na tabela `lines`)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
set_time_limit(0);

// Inicia buffer
ob_start();

// Verifica config
if (!file_exists('config.php')) {
    die("ERRO CRÍTICO: 'config.php' não encontrado.");
}
require_once 'config.php';

if (!isset($pdo)) {
    die("ERRO CRÍTICO: Conexão com banco ($pdo) não configurada.");
}

// =======================================================================
// BLOCO 1: GERADOR DE LISTA M3U (Download)
// =======================================================================
if (isset($_GET['username']) && isset($_GET['password'])) {
    $username = $_GET['username'];
    $password = $_GET['password'];

    // CORREÇÃO AQUI: Adicionado crases `` em volta de `lines`
    try {
        $stmt = $pdo->prepare("SELECT id, username, exp_date FROM `lines` WHERE username = :user AND password = :pass AND enabled = 1 LIMIT 1");
        $stmt->execute(['user' => $username, 'pass' => $password]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        die("ERRO SQL (Buscar Usuário): " . $e->getMessage());
    }

    if (!$user) {
        http_response_code(401);
        die("ERRO: Usuário inválido, senha incorreta ou linha desativada.");
    }

    // Verifica validade
    if (!empty($user['exp_date']) && $user['exp_date'] < time()) {
         die("ERRO: Sua conta expirou.");
    }

    // Define cabeçalhos para Download
    ob_clean();
    header("Content-Type: application/x-mpegurl");
    header('Content-Disposition: attachment; filename="lista_' . $username . '.m3u"');

    // Monta a URL do servidor
    $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
    $host = $_SERVER['HTTP_HOST'];
    $path = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
    $serverUrl = "$protocol://$host$path";

    // Imprime cabeçalho M3U
    echo "#EXTM3U\n";

    // Busca os canais
    try {
        $sqlStreams = "SELECT id, stream_display_name, stream_icon FROM streams ORDER BY stream_display_name ASC";
        $q = $pdo->query($sqlStreams);
        
        while ($stream = $q->fetch(PDO::FETCH_ASSOC)) {
            $id   = $stream['id'];
            $name = str_replace(['"', ',', "\r", "\n"], '', $stream['stream_display_name']);
            $logo = $stream['stream_icon'] ?? '';

            echo "#EXTINF:-1 tvg-logo=\"$logo\" group-title=\"Canais\", $name\n";
            echo "{$serverUrl}/get.php?stream_id={$id}\n";
        }
    } catch (PDOException $e) {
        echo "\n# ERRO AO BUSCAR CANAIS: " . $e->getMessage();
    }

    exit;
}

// =======================================================================
// BLOCO 2: PLAYER / PROXY (Reprodução)
// =======================================================================

$stream_id = $_GET['stream_id'] ?? 0;

if ($stream_id == 0) {
    $uri = $_SERVER['REQUEST_URI'];
    if (preg_match('/\/([0-9]+)\.(mp4|mkv|avi|ts|m3u8)/i', $uri, $matches)) {
        $stream_id = $matches[1];
    }
}

if ($stream_id == 0) {
    die("ERRO: ID do canal não informado.");
}

// Busca o link original
try {
    $stmt = $pdo->prepare("SELECT stream_source FROM streams WHERE id = :id LIMIT 1");
    $stmt->execute(['id' => $stream_id]);
    $stream = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("ERRO SQL (Buscar Stream): " . $e->getMessage());
}

if (!$stream) {
    http_response_code(404);
    die("ERRO: Canal não encontrado.");
}

$source = $stream['stream_source'];
$json = json_decode($source, true);
$url = (is_array($json) && isset($json[0])) ? $json[0] : str_replace(['[', ']', '"', '\\'], '', $source);
$url = trim($url);

if (empty($url) || !filter_var($url, FILTER_VALIDATE_URL)) {
    die("ERRO: URL do canal inválida.");
}

$parsed = parse_url($url);
$domain = $parsed['scheme'] . '://' . $parsed['host'];

ob_end_clean(); 

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, false);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 0);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36',
    "Referer: $domain" 
]);

curl_setopt($ch, CURLOPT_HEADERFUNCTION, function($curl, $header) {
    $len = strlen($header);
    $parts = explode(':', $header, 2);
    if (count($parts) < 2) return $len;
    $name = strtolower(trim($parts[0]));
    $value = trim($parts[1]);
    if (!in_array($name, ['content-length', 'transfer-encoding', 'connection'])) {
        header("$name: $value");
    }
    return $len;
});

curl_exec($ch);
curl_close($ch);
exit;
?>