<?php

// get.php - Versão FINAL com Autenticação, Registro de Atividade Live (lines_live) e Proxy Reverso

require_once 'config.php';
ini_set('display_errors', 0);
set_time_limit(0); 

// --- 1. COLETA DE PARÂMETROS ---
$stream_id = $_GET['stream_id'] ?? 0;
$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';

// Tenta extrair o ID do Stream da URL (fallback para IPTV Smarters e outros)
if ($stream_id == 0) {
    if (preg_match('/\/([0-9]+)\.(mp4|mkv|avi|ts|m3u8)$/i', $_SERVER['REQUEST_URI'], $matches)) {
        $stream_id = $matches[1];
    }
}

// Se não houver stream_id, não há como continuar
if ($stream_id == 0) die();

// --- 2. AUTENTICAÇÃO E BUSCA DE DADOS DO CLIENTE ---

$user = null;
if ($username && $password) {
    $stmt = $pdo->prepare("SELECT id, exp_date, enabled FROM `lines` WHERE username = :u AND password = :p LIMIT 1");
    $stmt->execute(['u' => $username, 'p' => $password]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Verifica autenticação
if (!$user || $user['enabled'] == 0 || $user['exp_date'] < time()) { 
    // Se a autenticação falhar, mata a conexão
    die("Acesso Negado ou Linha Expirada.");
}

$user_id = $user['id'];
$user_ip = $_SERVER['REMOTE_ADDR'];
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown Agent';

// --- 3. REGISTRO DE ATIVIDADE LIVE (CRÍTICO PARA O PAINEL) ---

// A. Tenta remover registros antigos/duplicados (ajuda na limpeza imediata)
// O cronjob fará a limpeza pesada dos inativos.
try {
    // Tenta remover o registro existente antes de inserir um novo para evitar duplicação imediata
    $pdo->query("DELETE FROM lines_live WHERE user_id = $user_id AND stream_id = $stream_id");
} catch (PDOException $e) {
    // Ignora erros de exclusão
}

// B. Insere o novo registro na lines_live (Aparecerá no Gerenciar Atividade)
try {
    $sql_insert_live = "INSERT INTO lines_live (user_id, stream_id, user_agent, user_ip, date_start, container, geoip_country_code)
                        VALUES (?, ?, ?, ?, UNIX_TIMESTAMP(), ?, ?)";

    // Lógica simples para identificar o container ou app
    $container = (strpos(strtolower($user_agent), 'smarters') !== false) ? 'Smarters' : 'Browser/Outro';
    $country_code = 'BR'; // Substitua por uma função GeoIP se você tiver o módulo instalado no servidor

    $pdo->prepare($sql_insert_live)->execute([
        $user_id, 
        $stream_id, 
        $user_agent, 
        $user_ip, 
        $container, 
        $country_code
    ]);
} catch (PDOException $e) {
    // Apenas ignora falhas de inserção, mas o proxy deve continuar
}


// --- 4. BUSCA E PROXY DA STREAM ---

// Busca o Link de Origem (Stream Source)
$stmt_stream = $pdo->prepare("SELECT stream_source FROM streams WHERE id = :id LIMIT 1");
$stmt_stream->execute(['id' => $stream_id]);
$stream_data = $stmt_stream->fetch(PDO::FETCH_ASSOC);

if (!$stream_data) die("Stream não encontrada.");

// Limpa e Pega a URL
$source = $stream_data['stream_source'];
$json = json_decode($source, true);
$url = (is_array($json) && isset($json[0])) ? $json[0] : str_replace(['[', ']', '"', '\\'], '', $source);
$url = trim($url);

if (empty($url)) die("URL de stream vazia.");

// Proxy Reverso com Mascaramento de Referer
$parsed_url = parse_url($url);
$domain = $parsed_url['scheme'] . '://' . $parsed_url['host'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, false); 
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36',
    "Referer: $domain" 
]);

// Copia os Headers de volta para o cliente
curl_setopt($ch, CURLOPT_HEADERFUNCTION, function($curl, $header) {
    $len = strlen($header);
    $header = explode(':', $header, 2);
    if (count($header) < 2) return $len;

    $name = strtolower(trim($header[0]));
    $value = trim($header[1]);

    // Ignora headers problemáticos que não devem ser repassados
    if (in_array($name, ['content-type', 'content-length', 'transfer-encoding', 'connection'])) {
        return $len;
    }
    
    header("$name: $value");
    return $len;
});

// Executa e Strea
curl_exec($ch);
curl_close($ch);
exit;
?>
