<?php
// header.php - Estrutura Completa XUI One
if (session_status() === PHP_SESSION_NONE) { session_start(); }

if (!isset($_SESSION['logado']) && basename($_SERVER['PHP_SELF']) != 'login.php') {
    header("Location: login.php");
    exit;
}

require_once 'config.php';

$my_id = $_SESSION['user_id'] ?? 0;
$group_id = $_SESSION['group_id'] ?? 0;
$is_admin = ($group_id == 1 || $my_id == 1); 
$username = $_SESSION['username'] ?? 'Admin';

// Créditos
$creditos_atuais = 0;
if(isset($pdo) && $my_id > 0) {
    $stmt = $pdo->prepare("SELECT credits FROM users WHERE id = ?");
    $stmt->execute([$my_id]);
    $creditos_atuais = (float)$stmt->fetchColumn();
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8" />
    <title>XUI | Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font/css/materialdesignicons.min.css" rel="stylesheet">

    <style>
        body { background-color: #f5f6f8; font-family: "Nunito", sans-serif; color: #6c757d; padding-bottom: 60px; overflow-x: hidden; }
        a { text-decoration: none; }

        /* --- TOPBAR ESCURA --- */
        .navbar-custom {
            background-color: #2f343d;
            height: 70px;
            padding: 0 15px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: fixed; top: 0; left: 0; right: 0; z-index: 1030;
            box-shadow: 0 0 35px 0 rgba(154,161,171,.15);
        }
        .logo-box { color: #fff; font-size: 20px; font-weight: 800; text-transform: uppercase; letter-spacing: 1px; }
        .topbar-right { display: flex; align-items: center; gap: 15px; }
        .user-info { color: #fff; font-weight: 600; font-size: 14px; }

        /* --- MENU DE NAVEGAÇÃO BRANCO --- */
        .topbar-menu {
            background-color: #fff;
            margin-top: 70px;
            padding: 0;
            box-shadow: 0 0 35px 0 rgba(154,161,171,.15);
            position: relative;
            z-index: 1020;
        }

        .navigation-menu {
            list-style: none; padding: 0; margin: 0;
            display: flex; 
            justify-content: center; 
            flex-wrap: wrap; 
        }

        .navigation-menu > li { position: relative; }
        
        .navigation-menu > li > a {
            display: block;
            padding: 18px 15px;
            color: #6c757d;
            font-weight: 700;
            font-size: 14px;
            transition: all 0.3s;
            white-space: nowrap; 
        }
        
        .navigation-menu > li > a:hover, .navigation-menu > li > a.active { 
            color: #56c2d6; 
            background-color: rgba(86, 194, 214, 0.05);
        }
        
        .navigation-menu > li > a i { font-size: 16px; margin-right: 5px; vertical-align: middle; }

        /* --- DROPDOWN DO MENU --- */
        .submenu {
            display: none;
            position: absolute;
            top: 100%; left: 0;
            background: #fff;
            min-width: 220px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border-radius: 0 0 4px 4px;
            z-index: 1001;
            padding: 10px 0;
            border-top: 2px solid #56c2d6;
        }
        
        /* Submenu em Nível 2 (Ferramentas > Limpeza) */
        .has-submenu-level { position: relative; }
        .submenu-level {
            display: none;
            position: absolute;
            left: 100%; top: 0;
            background: #fff;
            min-width: 200px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            padding: 10px 0;
            border-radius: 4px;
        }
        .has-submenu-level:hover > .submenu-level { display: block; }

        /* Mostrar submenu ao passar o mouse (Desktop) */
        @media (min-width: 992px) {
            .navigation-menu > li:hover > .submenu { display: block; }
        }

        .submenu li a {
            display: block; padding: 9px 20px; color: #6c757d; font-size: 13px; font-weight: 600;
        }
        .submenu li a:hover { color: #56c2d6; background: #f8f9fa; padding-left: 25px; transition: 0.2s; }

        .credits-badge {
            background: rgba(255,255,255,0.1);
            padding: 5px 12px;
            border-radius: 20px;
            color: #fff;
            font-size: 12px;
            white-space: nowrap;
        }

        .content-page { padding-top: 30px; }

        /* --- AJUSTES MOBILE (ROLAGEM HORIZONTAL) --- */
        @media (max-width: 991px) {
            .topbar-menu {
                overflow-x: auto; 
                -webkit-overflow-scrolling: touch; 
            }
            .topbar-menu::-webkit-scrollbar { display: none; }

            .navigation-menu {
                display: flex;
                flex-wrap: nowrap !important;
                justify-content: flex-start;
                width: max-content;
                padding: 0 10px;
            }

            .navigation-menu > li { display: inline-block; }
            .navigation-menu > li > a { padding: 15px 15px; border-bottom: 2px solid transparent; }
            .navigation-menu > li > a.active { border-bottom: 2px solid #56c2d6; }

            /* Dropdown Mobile Fixo */
            .submenu {
                position: fixed; 
                top: 125px; left: 10px; right: 10px; 
                width: auto; border-radius: 6px;
                border-top: none;
                box-shadow: 0 0 50px rgba(0,0,0,0.2);
            }
            /* Esconde submenu lateral no mobile e faz lista plana */
            .submenu-level {
                position: static; display: block; box-shadow: none; padding-left: 20px; border-left: 2px solid #eee;
            }
            .has-submenu-level:hover > .submenu-level { display: block; }
        }
    </style>
</head>
<body>

<header class="navbar-custom">
    <div class="logo-box">
        <img src="assets/images/logo-topbar.png" onerror="this.style.display='none'" height="24" style="margin-right:5px;">
        XUI
    </div>
    <div class="topbar-right">
        <?php if(!$is_admin): ?>
            <div class="credits-badge">
                <i class="fas fa-wallet"></i> <?= number_format($creditos_atuais, 0) ?>
            </div>
        <?php else: ?>
            <div class="credits-badge text-warning"><i class="fas fa-crown"></i></div>
        <?php endif; ?>
        
        <div class="dropdown">
            <a href="#" class="user-info dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-user-circle fa-lg"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-end">
                <div class="dropdown-header"><?= htmlspecialchars($username) ?></div>
                <a href="logout.php" class="dropdown-item text-danger"><i class="fas fa-sign-out-alt me-2"></i> Sair</a>
            </div>
        </div>
    </div>
</header>

<div class="topbar-menu">
    <ul class="navigation-menu">
        
        <li>
            <a href="index.php" class="<?= basename($_SERVER['PHP_SELF'])=='index.php'?'active':'' ?>">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>
        </li>

        <?php if($is_admin): ?>
        <li>
            <a href="#" onclick="toggleSubmenu(event, 'sub-servers')">
                <i class="fas fa-server"></i> Servers <i class="fas fa-chevron-down small ms-1"></i>
            </a>
            <ul class="submenu" id="sub-servers">
                <li><a href="gerenciar_servers.php">Manage Servers</a></li>
                <li><a href="gerenciar_servers.php?add=1">Add Server</a></li>
                <li><a href="#">Server Order</a></li>
            </ul>
        </li>
        <?php endif; ?>

        <?php if($is_admin): ?>
        <li>
            <a href="#" onclick="toggleSubmenu(event, 'sub-users')">
                <i class="fas fa-users"></i> Users <i class="fas fa-chevron-down small ms-1"></i>
            </a>
            <ul class="submenu" id="sub-users">
                <li><a href="revendedores.php?add=1">Add User (Reseller)</a></li>
                <li><a href="revendedores.php">Manage Users</a></li>
            </ul>
        </li>
        <?php endif; ?>

        <li>
            <a href="#" onclick="toggleSubmenu(event, 'sub-lines')">
                <i class="fas fa-desktop"></i> Lines <i class="fas fa-chevron-down small ms-1"></i>
            </a>
            <ul class="submenu" id="sub-lines">
                <li><a href="clientes.php?add=1">Add Line</a></li>
                <li><a href="clientes.php">Manage Lines</a></li>
                <li><a href="testes.php">Test Lines</a></li>
                <?php if($is_admin): ?>
                <li><a href="gerenciar_atividade.php">Live Connections</a></li>
                <li><a href="gerenciar_dispositivos.php">MAG Devices</a></li>
                <?php endif; ?>
            </ul>
        </li>

        <?php if($is_admin): ?>
        <li>
            <a href="#" onclick="toggleSubmenu(event, 'sub-content')">
                <i class="fas fa-play-circle"></i> Content <i class="fas fa-chevron-down small ms-1"></i>
            </a>
            <ul class="submenu" id="sub-content">
                <li class="has-submenu-level">
                    <a href="#">Streams <i class="fas fa-chevron-right float-end small mt-1"></i></a>
                    <ul class="submenu-level">
                        <li><a href="canais.php">Manage Streams</a></li>
                        <li><a href="importar.php">Import Streams</a></li>
                    </ul>
                </li>
                <li><a href="filmes.php">Movies</a></li>
                <li><a href="series.php">Series</a></li>
                <li><a href="gerenciar_epg.php">TV Guide (EPG)</a></li>
            </ul>
        </li>
        <?php endif; ?>

        <?php if($is_admin): ?>
        <li>
            <a href="#" onclick="toggleSubmenu(event, 'sub-bouquets')">
                <i class="fas fa-spa"></i> Bouquets <i class="fas fa-chevron-down small ms-1"></i>
            </a>
            <ul class="submenu" id="sub-bouquets">
                <li><a href="bouquets.php?add=1">Add Bouquet</a></li>
                <li><a href="bouquets.php">Manage Bouquets</a></li>
            </ul>
        </li>
        <?php endif; ?>

        <?php if($is_admin): ?>
        <li>
            <a href="#" onclick="toggleSubmenu(event, 'sub-management')">
                <i class="fas fa-wrench"></i> Management <i class="fas fa-chevron-down small ms-1"></i>
            </a>
            <ul class="submenu" id="sub-management">
                <li class="has-submenu-level">
                    <a href="#">Access Control <i class="fas fa-chevron-right float-end small mt-1"></i></a>
                    <ul class="submenu-level">
                        <li><a href="gerenciar_bloqueios.php">Blocked IPs/ISP</a></li>
                    </ul>
                </li>
                
                <li class="has-submenu-level">
                    <a href="#">Tools <i class="fas fa-chevron-right float-end small mt-1"></i></a>
                    <ul class="submenu-level">
                        <li><a href="limpeza.php">Mass Delete</a></li>
                        <li><a href="limpeza_inteligente.php">Smart Cleanup</a></li>
                        <li><a href="organizar_categorias.php">Channel Order</a></li>
                        <li><a href="trocar_dns.php">Change DNS</a></li>
                        <li><a href="atualizar_tmdb.php">Update TMDB</a></li>
                    </ul>
                </li>

                <li><a href="gerenciar_restream.php">Restream Detection</a></li>
            </ul>
        </li>
        <?php else: ?>
        <li>
            <a href="revendedores.php"><i class="fas fa-users-cog"></i> Minha Equipe</a>
        </li>
        <?php endif; ?>
        
        <li style="width: 20px;"></li>
    </ul>
</div>

<div class="content-page">
    <div class="container-fluid">

<script>
// Script para Mobile (Scroll e Dropdown)
function toggleSubmenu(e, id) {
    if (window.innerWidth < 992) {
        e.preventDefault(); 
        
        // Fecha todos
        document.querySelectorAll('.submenu').forEach(el => {
            if(el.id !== id) el.style.display = 'none';
        });

        // Alterna o clicado
        var el = document.getElementById(id);
        if (el.style.display === 'block') {
            el.style.display = 'none';
        } else {
            el.style.display = 'block';
        }
    }
}

// Fecha menus ao clicar fora
document.addEventListener('click', function(event) {
    if (window.innerWidth < 992) {
        if (!event.target.closest('.navigation-menu')) {
            document.querySelectorAll('.submenu').forEach(el => el.style.display = 'none');
        }
    }
});
</script>