<?php
// Tenta carregar o header, se der erro, exibe na tela para sabermos o que é
error_reporting(E_ALL);
ini_set('display_errors', 1);

require 'header.php';
require_once 'config.php';

// Configurações de Memória
ini_set('memory_limit', '512M');
set_time_limit(0); 

$tmdb_key = "f99aa9ae1fe7619969cc7db0938c1ae5"; 
$categorias_m3u = [];
$show_selection = false;

// 1. LEITURA OTIMIZADA DA LISTA
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['ler_lista'])) {
    $caminho_arquivo = "";
    
    if (!empty($_POST['url_m3u'])) {
        $caminho_arquivo = $_POST['url_m3u'];
    } elseif (isset($_FILES['arquivo_m3u']) && $_FILES['arquivo_m3u']['tmp_name']) {
        $caminho_arquivo = $_FILES['arquivo_m3u']['tmp_name'];
    }

    if ($caminho_arquivo) {
        $handle = @fopen($caminho_arquivo, "r");
        if ($handle) {
            $current_cat = "Importados M3U";
            $current_name = "";
            
            while (($line = fgets($handle)) !== false) {
                $line = trim($line);
                if (empty($line)) continue;

                if (strpos($line, '#EXTINF') !== false) {
                    if (preg_match('/group-title="([^"]*)"/', $line, $cat_match)) {
                        $current_cat = $cat_match[1];
                    }
                    $parts = explode(',', $line);
                    $current_name = end($parts);
                } 
                elseif (strpos($line, 'http') === 0) {
                    $categorias_m3u[$current_cat][] = [
                        'nome' => trim($current_name),
                        'link' => $line
                    ];
                }
            }
            fclose($handle);
            $show_selection = true;
        }
    }
}
?>

<style>
    .log-container { background: #121212; color: #00ff41; height: 350px; overflow-y: auto; padding: 15px; font-family: 'Consolas', monospace; border-radius: 8px; border: 3px solid #333; font-size: 12px; }
    .cat-card { background: #fff; padding: 10px; border-radius: 8px; margin-bottom: 8px; border: 1px solid #ddd; }
    .sticky-top-custom { position: sticky; top: 20px; z-index: 100; }
</style>

<div class="container-fluid p-4">
    <div class="d-flex justify-content-between align-items-center mb-4 text-dark">
        <h3 class="fw-bold m-0">Sincronizador M3U Automático</h3>
        <?php if($show_selection): ?>
            <a href="importador_m3u.php" class="btn btn-secondary btn-sm">Nova Lista</a>
        <?php endif; ?>
    </div>

    <?php if (!$show_selection): ?>
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card shadow-sm p-4 border-0" style="border-radius: 15px;">
                <form method="POST" enctype="multipart/form-data">
                    <div class="mb-3 text-dark">
                        <label class="fw-bold">URL M3U</label>
                        <input type="url" name="url_m3u" class="form-control" placeholder="http://...">
                    </div>
                    <div class="text-center mb-3 text-muted small">OU</div>
                    <div class="mb-4">
                        <label class="fw-bold text-dark">Arquivo M3U</label>
                        <input type="file" name="arquivo_m3u" class="form-control">
                    </div>
                    <button type="submit" name="ler_lista" class="btn btn-primary w-100 fw-bold py-3">PROCESSAR E ANALISAR</button>
                </form>
            </div>
        </div>
    </div>

    <?php else: ?>
    <div class="row">
        <div class="col-md-4">
            <div class="card shadow-sm p-3 border-0 text-dark" style="border-radius: 15px;">
                <div class="d-flex justify-content-between mb-3">
                    <h6 class="fw-bold">Categorias Encontradas</h6>
                    <label class="small"><input type="checkbox" id="selectAll"> Marcar Todas</label>
                </div>
                <div style="max-height: 600px; overflow-y: auto;">
                    <?php foreach ($categorias_m3u as $nome_cat => $itens): $id_enc = base64_encode($nome_cat); ?>
                    <div class="cat-card">
                        <input type="checkbox" value="<?= $id_enc ?>" class="cat-check me-2">
                        <span class="fw-bold"><?= htmlspecialchars($nome_cat) ?></span>
                        <span class="badge bg-primary float-end"><?= count($itens) ?></span>
                        <textarea style="display:none;" id="data_<?= $id_enc ?>"><?= json_encode($itens) ?></textarea>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="sticky-top-custom">
                <div class="card shadow-sm p-4 border-0 mb-3" style="border-radius: 15px;">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="text-dark">
                            <h6 class="fw-bold m-0">Automação Inteligente Ativa</h6>
                            <small class="text-muted">As categorias serão criadas automaticamente se não existirem.</small>
                        </div>
                        <button onclick="iniciarSincronizacao()" class="btn btn-success px-5 fw-bold">INICIAR AGORA</button>
                    </div>
                </div>
                <div class="log-container" id="log_area">Aguardando comando...</div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    if(document.getElementById('selectAll')){
        document.getElementById('selectAll').addEventListener('change', function() {
            document.querySelectorAll('.cat-check').forEach(c => c.checked = this.checked);
        });
    }

    async function iniciarSincronizacao() {
        const boxes = document.querySelectorAll('.cat-check:checked');
        const log = document.getElementById('log_area');
        if(boxes.length === 0) return Swal.fire('Erro', 'Selecione as categorias.', 'error');

        log.innerHTML = "<b>[SISTEMA] Iniciando Sincronização...</b><br>";

        for (let box of boxes) {
            const catNome = atob(box.value);
            const itens = JSON.parse(document.getElementById('data_' + box.value).value);
            log.innerHTML += `<br><span style="color: #00ffff">Sincronizando Categoria: ${catNome}</span><br>`;
            
            for (let item of itens) {
                log.innerHTML += `> Verificando: ${item.nome}... `;
                log.scrollTop = log.scrollHeight;

                try {
                    const response = await fetch('processar_item.php', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                        body: `nome=${encodeURIComponent(item.nome)}&link=${encodeURIComponent(item.link)}&cat_m3u=${encodeURIComponent(catNome)}&api_key=<?= $tmdb_key ?>`
                    });
                    const res = await response.json();
                    
                    if(res.status === 'success') log.innerHTML += `<span style="color: #00ff00">IMPORTADO</span><br>`;
                    else if(res.status === 'exists') log.innerHTML += `<span style="color: #888">PULADO (EXISTENTE)</span><br>`;
                    else log.innerHTML += `<span style="color: #ff0000">ERRO</span><br>`;
                } catch (e) { log.innerHTML += `<span style="color: #ff0000">FALHA COMUNICAÇÃO</span><br>`; }
            }
        }
        Swal.fire('Fim', 'O servidor está atualizado!', 'success');
    }
</script>

<?php 
if (file_exists('footer.php')) { require 'footer.php'; } 
else { echo '</body></html>'; }
?>