<?php
require 'config.php';
require 'header.php';
// Apenas Admin
if ($_SESSION['group_id'] != 1) { echo "<script>window.location='index.php';</script>"; exit; }
?>

<style>
    /* Estilo K-Office para Importação */
    .k-card { background: #fff; border-radius: 12px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 20px; }
    .k-header { background: linear-gradient(135deg, #0d6efd, #0a58ca); color: white; padding: 15px 20px; font-weight: bold; border-bottom: 1px solid rgba(0,0,0,0.1); }
    
    /* Terminal de Logs */
    #terminal-window {
        background-color: #1e1e1e;
        color: #00ff00;
        font-family: 'Courier New', Courier, monospace;
        padding: 15px;
        border-radius: 8px;
        height: 300px;
        overflow-y: auto;
        font-size: 0.85rem;
        border: 2px solid #333;
        box-shadow: inset 0 0 10px #000;
    }
    .log-line { margin-bottom: 2px; border-bottom: 1px solid #333; padding-bottom: 2px; }
    .log-success { color: #00ff00; }
    .log-error { color: #ff4444; }
    .log-info { color: #00ccff; }

    /* Checkboxes */
    .cat-card { cursor: pointer; transition: 0.2s; border: 1px solid #eee; }
    .cat-card:hover { background-color: #f8f9fa; border-color: #0d6efd; }
    .cat-badge { font-size: 0.7rem; text-transform: uppercase; letter-spacing: 0.5px; }
</style>

<div class="container-fluid">
    
    <div class="d-flex justify-content-between align-items-center mb-4 mt-2">
        <div>
            <h4 class="fw-bold mb-0 text-dark">Importador de Conteúdo</h4>
            <small class="text-muted">Adicione canais, filmes e séries via M3U</small>
        </div>
    </div>

    <div class="k-card" id="cardAnalise">
        <div class="k-header"><i class="fas fa-search me-2"></i>Passo 1: Analisar Lista</div>
        <div class="card-body p-4">
            <form id="formAnalise" enctype="multipart/form-data">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold text-muted small">OPÇÃO 1: LINK M3U</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light"><i class="fas fa-link"></i></span>
                            <input type="url" name="url_m3u" class="form-control" placeholder="http://servidor.com/get.php...">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold text-muted small">OPÇÃO 2: ARQUIVO .M3U</label>
                        <div class="input-group">
                            <span class="input-group-text bg-light"><i class="fas fa-file-upload"></i></span>
                            <input type="file" name="file_m3u" class="form-control" accept=".m3u,.m3u8">
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary w-100 fw-bold mt-4 py-2 shadow-sm" id="btnAnalisar">
                    <i class="fas fa-bolt me-2"></i> CARREGAR CATEGORIAS
                </button>
            </form>
        </div>
    </div>

    <div class="k-card" id="areaSelecao" style="display:none;">
        <div class="k-header bg-success" style="background: linear-gradient(135deg, #198754, #157347);">
            <i class="fas fa-check-double me-2"></i>Passo 2: Selecionar Conteúdo
        </div>
        <div class="card-body p-4">
            
            <div class="alert alert-info border-0 shadow-sm d-flex align-items-center">
                <i class="fas fa-info-circle fa-2x me-3"></i>
                <div>
                    <strong>Dica:</strong> O sistema buscará automaticamente capas e sinopses no TMDB para Filmes e Séries. <br>
                    Isso pode levar um tempo. Acompanhe pelo log abaixo.
                </div>
            </div>

            <div class="d-flex justify-content-between mb-3">
                <button type="button" class="btn btn-sm btn-outline-dark fw-bold" onclick="marcarTudo(true)">Marcar Tudo</button>
                <button type="button" class="btn btn-sm btn-outline-danger fw-bold" onclick="marcarTudo(false)">Desmarcar Tudo</button>
            </div>

            <form id="formImportar">
                <div class="row g-2" id="listaCategorias" style="max-height: 400px; overflow-y: auto;">
                    </div>
                
                <input type="hidden" name="temp_file" id="tempFile">

                <button type="submit" class="btn btn-success w-100 mt-4 py-3 fw-bold shadow-lg text-uppercase" id="btnImportarFinal">
                    <i class="fas fa-cloud-download-alt me-2"></i> Iniciar Importação
                </button>
            </form>
        </div>
    </div>

    <div class="k-card" id="areaLog" style="display:none;">
        <div class="k-header bg-dark">
            <div class="d-flex justify-content-between align-items-center">
                <span><i class="fas fa-terminal me-2"></i>Processando Importação...</span>
                <span class="badge bg-danger animate-pulse" id="statusBadge">RODANDO</span>
            </div>
        </div>
        <div class="card-body p-0 bg-dark">
            <div class="progress" style="height: 5px; border-radius: 0;">
                <div id="progressBar" class="progress-bar bg-success progress-bar-striped progress-bar-animated" style="width: 0%"></div>
            </div>
            
            <div id="terminal-window">
                <div class="log-line log-info">> Sistema iniciado... aguardando comando.</div>
            </div>
        </div>
    </div>

</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
// --- 1. ANALISAR ---
$('#formAnalise').on('submit', function(e){
    e.preventDefault();
    var btn = $('#btnAnalisar');
    var originalText = btn.html();
    
    btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-2"></i> Lendo M3U...');
    $('#areaSelecao').hide();
    $('#areaLog').hide();

    $.ajax({
        url: 'processar_lista.php',
        type: 'POST',
        data: new FormData(this),
        contentType: false,
        processData: false,
        success: function(response){
            btn.prop('disabled', false).html(originalText);
            try {
                var data = JSON.parse(response);
                if(data.erro) { alert(data.erro); } 
                else {
                    renderCategorias(data.categorias);
                    $('#tempFile').val(data.temp_file);
                    $('#cardAnalise').slideUp(); // Esconde o passo 1
                    $('#areaSelecao').fadeIn(); // Mostra o passo 2
                }
            } catch(e) { alert("Erro no servidor: " + response); }
        }
    });
});

function renderCategorias(cats) {
    var html = '';
    Object.keys(cats).sort().forEach(function(nome) {
        var qtd = cats[nome].qtd;
        var tipo = cats[nome].tipo;
        var badgeColor = tipo === 'VOD' ? 'bg-warning text-dark' : 'bg-info text-dark';
        
        html += `
            <div class="col-md-4 col-sm-6">
                <div class="cat-card p-3 rounded bg-white shadow-sm position-relative">
                    <div class="form-check">
                        <input class="form-check-input cat-checkbox" type="checkbox" name="categorias[]" value="${nome}" id="id_${nome.replace(/\W/g,'')}">
                        <label class="form-check-label w-100 stretched-link fw-bold text-dark" for="id_${nome.replace(/\W/g,'')}">
                            ${nome}
                        </label>
                    </div>
                    <div class="mt-2 d-flex justify-content-between align-items-center">
                        <span class="badge ${badgeColor} cat-badge">${tipo}</span>
                        <small class="text-muted fw-bold">${qtd} itens</small>
                    </div>
                </div>
            </div>`;
    });
    $('#listaCategorias').html(html);
}

function marcarTudo(status) { $('.cat-checkbox').prop('checked', status); }

// --- 2. IMPORTAR COM LOG ---
var logInterval;

$('#formImportar').on('submit', function(e){
    e.preventDefault();
    if($('.cat-checkbox:checked').length == 0) { alert("Selecione algo!"); return; }

    if(!confirm("Iniciar importação? O painel ficará trabalhando em segundo plano.")) return;

    $('#areaSelecao').slideUp();
    $('#areaLog').fadeIn();
    
    // Inicia o Polling do Log
    iniciarLeituraLog();

    $.ajax({
        url: 'executar_importacao.php',
        type: 'POST',
        data: $(this).serialize(),
        success: function(){
            clearInterval(logInterval);
            $('#statusBadge').removeClass('bg-danger animate-pulse').addClass('bg-success').text('CONCLUÍDO');
            addLog(">>> IMPORTAÇÃO FINALIZADA COM SUCESSO!", "log-success");
            alert("Conteúdo Importado!");
            window.location.reload();
        },
        error: function() {
            clearInterval(logInterval);
            addLog(">>> ERRO FATAL NA EXECUÇÃO", "log-error");
        }
    });
});

function iniciarLeituraLog() {
    // Limpa terminal
    $('#terminal-window').html('<div class="log-line">> Iniciando processo...</div>');
    
    logInterval = setInterval(function(){
        $.get('ler_log.php', function(data) {
            if(data) {
                // Atualiza o terminal
                $('#terminal-window').html(data);
                // Rola para baixo
                var terminal = document.getElementById('terminal-window');
                terminal.scrollTop = terminal.scrollHeight;
            }
        });
    }, 1000); // Lê a cada 1 segundo
}

function addLog(msg, classe) {
    $('#terminal-window').append(`<div class="log-line ${classe}">${msg}</div>`);
}
</script>
