<?php require 'config.php'; require 'header.php'; ?>

<style>
    body { background-color: #f0f2f5; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
    .import-card { background: #fff; border-radius: 12px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); margin-bottom: 20px; border: 1px solid #e1e4e8; overflow: hidden; }
    .card-header-clean { padding: 20px; border-bottom: 1px solid #eee; background: #fff; }
    .form-control-lg { border-radius: 8px; font-size: 1rem; padding: 12px; }
    .cat-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px; padding: 20px; max-height: 450px; overflow-y: auto; background: #f8f9fa; }
    .cat-item { background: #fff; border: 1px solid #ddd; border-radius: 6px; padding: 10px; cursor: pointer; display: flex; align-items: center; user-select: none; }
    .cat-item:hover { border-color: #0d6efd; background: #f8f9ff; }
    .cat-item.active { background: #e7f1ff; border-color: #0d6efd; color: #0d6efd; font-weight: bold; }
    .cat-badge { background: #eee; font-size: 0.75rem; padding: 2px 8px; border-radius: 10px; margin-left: auto; color: #333; }
</style>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-9">
            
            <div class="d-flex align-items-center mb-4">
                <i class="fas fa-file-import fa-2x text-primary me-3"></i>
                <div>
                    <h3 class="fw-bold m-0">Importador de Canais</h3>
                    <small class="text-muted">Compatível com listas M3U pesadas</small>
                </div>
            </div>

            <div class="import-card" id="step1">
                <div class="card-header-clean">
                    <h5 class="fw-bold m-0">1. Escolha a Lista</h5>
                </div>
                <div class="p-4">
                    <ul class="nav nav-pills mb-3 nav-fill bg-light rounded p-1" id="tabSource">
                        <li class="nav-item"><button class="nav-link active fw-bold" data-bs-toggle="pill" data-bs-target="#tab-url">Por Link (URL)</button></li>
                        <li class="nav-item"><button class="nav-link fw-bold" data-bs-toggle="pill" data-bs-target="#tab-file">Por Arquivo (Upload)</button></li>
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="tab-url">
                            <form id="formUrl">
                                <input type="hidden" name="action" value="preview">
                                <input type="hidden" name="type" value="url">
                                <div class="input-group">
                                    <input type="text" id="urlInput" name="m3u_url" class="form-control form-control-lg" placeholder="http://..." required>
                                    <button class="btn btn-primary fw-bold px-4">ANALISAR</button>
                                </div>
                            </form>
                            <div id="blockAlert" class="alert alert-warning mt-3 d-none border-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i> <strong>Atenção:</strong> O servidor da lista bloqueou a conexão automática.
                                <br><br>
                                <a href="#" id="btnManualDownload" target="_blank" class="btn btn-dark btn-sm fw-bold">1. Clique aqui para Baixar a Lista</a>
                                <div class="mt-2 text-muted small">2. Depois, envie o arquivo baixado na aba "Por Arquivo".</div>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="tab-file">
                            <form id="formFile">
                                <input type="hidden" name="action" value="preview">
                                <input type="hidden" name="type" value="file">
                                <div class="input-group">
                                    <input type="file" name="m3u_file" class="form-control form-control-lg" accept=".m3u" required>
                                    <button class="btn btn-success fw-bold px-4">ENVIAR</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div id="loader" class="text-center py-4 d-none">
                <div class="spinner-border text-primary" role="status"></div>
                <div class="mt-2 fw-bold text-muted" id="loaderText">Processando...</div>
            </div>

            <div class="import-card d-none" id="step2">
                <div class="card-header-clean d-flex justify-content-between align-items-center">
                    <h5 class="fw-bold m-0">2. Selecione as Categorias</h5>
                    <div>
                        <button class="btn btn-sm btn-outline-primary" onclick="$('.cat-item').addClass('active'); upd();">Todas</button>
                        <button class="btn btn-sm btn-outline-secondary" onclick="$('.cat-item').removeClass('active'); upd();">Nenhuma</button>
                    </div>
                </div>
                
                <div id="catGrid" class="cat-grid"></div>

                <div class="p-3 text-end bg-light border-top">
                    <span class="me-3 fw-bold small"><span id="selCount">0</span> Selecionadas</span>
                    <button id="btnImport" class="btn btn-primary fw-bold px-5">IMPORTAR</button>
                </div>
            </div>

        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
let tempFile = '';

function startPreview(formId) {
    let form = document.getElementById(formId);
    let formData = new FormData(form);
    
    $('#step1, #blockAlert').addClass('d-none');
    $('#loader').removeClass('d-none');
    $('#loaderText').text('Lendo Lista...');

    $.ajax({
        url: 'api_import_v2.php', type: 'POST', data: formData,
        contentType: false, processData: false,
        success: function(resp) {
            $('#loader').addClass('d-none');
            
            // SE FOR BLOQUEADO PELO FIREWALL
            if(resp.status === 'blocked') {
                $('#step1').removeClass('d-none');
                $('#blockAlert').removeClass('d-none');
                
                // Configura o botão de download manual
                let url = $('#urlInput').val();
                $('#btnManualDownload').attr('href', url);
                
                // Abre a aba de arquivo automaticamente para facilitar
                $('[data-bs-target="#tab-file"]').tab('show');
                alert("Bloqueio de Firewall detectado! Baixe o arquivo no botão preto e envie na aba 'Por Arquivo'.");
                return;
            }

            if(resp.status === 'success') {
                tempFile = resp.temp_file;
                renderCats(resp.categories);
                $('#step1').addClass('d-none');
                $('#step2').removeClass('d-none');
            } else {
                $('#step1').removeClass('d-none');
                alert(resp.message);
            }
        },
        error: function() {
            $('#loader').addClass('d-none');
            $('#step1').removeClass('d-none');
            alert("Erro de conexão com o servidor.");
        }
    });
}

$('#formUrl').submit(function(e){ e.preventDefault(); startPreview('formUrl'); });
$('#formFile').submit(function(e){ e.preventDefault(); startPreview('formFile'); });

function renderCats(cats) {
    let h = '';
    cats.forEach(c => {
        h += `<div class="cat-item" onclick="$(this).toggleClass('active'); upd();" data-n="${c.nome}">
                <div class="text-truncate" style="flex:1" title="${c.nome}">${c.nome}</div>
                <span class="cat-badge">${c.qtd}</span>
              </div>`;
    });
    $('#catGrid').html(h);
    upd();
}

function upd() {
    let c = $('.cat-item.active').length;
    $('#selCount').text(c);
    $('#btnImport').prop('disabled', c === 0);
}

$('#btnImport').click(function(){
    let cats = [];
    $('.cat-item.active').each(function(){ cats.push($(this).data('n')); });
    
    $('#step2').addClass('d-none');
    $('#loader').removeClass('d-none');
    $('#loaderText').text('Importando para o Banco de Dados...');

    $.ajax({
        url: 'api_import_v2.php', type: 'POST',
        data: { action: 'import', temp_file: tempFile, cats: JSON.stringify(cats) },
        dataType: 'json',
        success: function(r) {
            $('#loader').addClass('d-none');
            alert(r.message);
            window.location = 'canais.php';
        }
    });
});
</script>
