<?php
require 'header.php'; 

// --- 1. LÓGICA DE DADOS ---
if (session_status() === PHP_SESSION_NONE) { session_start(); }

$my_id = $_SESSION['user_id'];
$is_admin = ($_SESSION['group_id'] == 1);

// Filtros SQL
$sql_dono   = $is_admin ? "" : "WHERE member_id = $my_id";
$sql_ativos = $is_admin ? "" : "AND member_id = $my_id";

// Estatísticas Básicas
$total_users = $pdo->query("SELECT count(*) FROM `lines` $sql_dono")->fetchColumn();
$active_users = $pdo->query("SELECT count(*) FROM `lines` WHERE exp_date > UNIX_TIMESTAMP() $sql_ativos")->fetchColumn();
$expired_users = $total_users - $active_users;

$total_live   = $pdo->query("SELECT count(*) FROM streams WHERE type = 1")->fetchColumn();
$total_movies = $pdo->query("SELECT count(*) FROM streams WHERE type = 2")->fetchColumn();
$total_series = $pdo->query("SELECT count(*) FROM streams_series")->fetchColumn();

// --- 2. DADOS DO SERVIDOR (Simulação e Leitura Real) ---
// Conexões Ativas (Pega da tabela de atividade se existir, senão 0)
$conns_live = 0;
try {
    $conns_live = $pdo->query("SELECT count(*) FROM lines_live")->fetchColumn();
} catch (Exception $e) {}

// Uptime (Tempo ligado)
$uptime = "Desconhecido";
if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
    $uptime_sys = @shell_exec('uptime -p');
    if ($uptime_sys) {
        $uptime = str_replace("up ", "", $uptime_sys);
    }
}

// Uso de CPU/RAM/Disco (Tenta ler do Linux)
$cpu_usage = 0;
$mem_usage = 0;
$disk_usage = 0;

if (function_exists('sys_getloadavg')) {
    $load = sys_getloadavg();
    $cpu_usage = (int)($load[0] * 10); // Estimativa simples
}
// Disco
$dt = @disk_total_space(".");
$df = @disk_free_space(".");
if ($dt > 0) {
    $disk_usage = 100 - (int)(($df / $dt) * 100);
}
// Memória (Via arquivo /proc/meminfo no Linux)
if (@file_exists("/proc/meminfo")) {
    $mem_data = explode("\n", file_get_contents("/proc/meminfo"));
    $mem_total = 0; $mem_free = 0;
    foreach ($mem_data as $line) {
        if (preg_match('/^MemTotal:\s+(\d+)\skB$/', $line, $pieces)) $mem_total = $pieces[1];
        if (preg_match('/^MemAvailable:\s+(\d+)\skB$/', $line, $pieces)) $mem_free = $pieces[1];
    }
    if ($mem_total > 0) {
        $mem_usage = 100 - (int)(($mem_free / $mem_total) * 100);
    }
}

// Limites visuais (0 a 100)
$cpu_usage = min(100, max(0, $cpu_usage));
$mem_usage = min(100, max(0, $mem_usage));
$disk_usage = min(100, max(0, $disk_usage));

// Rede (Simulada pois requer monitoramento contínuo)
$net_in = 0;
$net_out = 0;

// Últimos Clientes
$recent_users = $pdo->query("SELECT username, exp_date, created_at, enabled FROM `lines` $sql_dono ORDER BY id DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    /* Estilos XUI One Originais */
    .cta-box {
        color: #fff;
        border: none;
        border-radius: 4px;
        position: relative;
        overflow: hidden;
        margin-bottom: 24px;
        box-shadow: 0 0 20px 0 rgba(0,0,0,0.05);
    }
    .cta-box .card-body { padding: 1.5rem; }
    
    .bg-purple { background-color: #675db7 !important; }
    .bg-success { background-color: #23b397 !important; }
    .bg-info { background-color: #56c2d6 !important; }
    .bg-pink { background-color: #e36498 !important; }
    .bg-primary { background-color: #4a81d4 !important; }
    .bg-danger { background-color: #f1556c !important; }

    .avatar-sm {
        height: 48px; width: 48px;
        background-color: rgba(255,255,255,0.2);
        border-radius: 50%;
        display: flex; align-items: center; justify-content: center;
        font-size: 22px;
    }
    
    .cta-box h3 { margin: 0; font-size: 24px; font-weight: 700; }
    .cta-box p { margin: 0; font-size: 13px; text-transform: uppercase; opacity: 0.9; margin-top: 2px; }

    /* CARD DE SERVIDOR (O Novo Bloco) */
    .server-card {
        background: #fff;
        border-radius: 4px;
        box-shadow: 0 0 20px 0 rgba(0,0,0,0.05);
        overflow: hidden;
        margin-bottom: 24px;
    }
    .server-header {
        background-color: #675db7; /* Roxo do XUI */
        padding: 20px;
        text-align: center;
        color: white;
    }
    .server-header h5 { margin: 0; font-weight: 700; font-size: 18px; }
    .server-header small { opacity: 0.8; }

    .server-body { padding: 20px; }
    
    /* Stats Grid */
    .stat-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 20px;
        text-align: center;
    }
    .stat-item h6 { font-size: 14px; color: #6c757d; font-weight: 700; margin-bottom: 5px; }
    .stat-item span { font-size: 16px; color: #343a40; font-weight: 600; }

    /* Circular Progress (CSS Puro) */
    .circle-wrap {
        width: 80px;
        height: 80px;
        background: #f1f1f1;
        border-radius: 50%;
        position: relative;
        margin: 0 auto;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .circle-inner {
        width: 65px;
        height: 65px;
        background: #fff;
        border-radius: 50%;
        position: absolute;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        font-size: 14px;
        color: #675db7;
        z-index: 2;
    }
    /* Criando o gráfico com Conic Gradient */
    .pie-cpu { background: conic-gradient(#675db7 <?= $cpu_usage ?>%, #eef2f7 0); }
    .pie-mem { background: conic-gradient(#675db7 <?= $mem_usage ?>%, #eef2f7 0); }
    .pie-disk { background: conic-gradient(#675db7 <?= $disk_usage ?>%, #eef2f7 0); }

    .chart-label { text-align: center; font-size: 13px; font-weight: 700; color: #6c757d; margin-bottom: 10px; margin-top: 5px; text-transform: uppercase; }

    /* Tabela */
    .table-responsive { overflow-x: auto; }
    .badge-xui-success { background: rgba(35,179,151,0.15); color: #23b397; padding: 5px 10px; border-radius: 4px; font-weight: 700; font-size: 11px; }
    .badge-xui-danger { background: rgba(241,85,108,0.15); color: #f1556c; padding: 5px 10px; border-radius: 4px; font-weight: 700; font-size: 11px; }
</style>

<div class="row">
    <div class="col-12">
        <h4 class="mb-4 text-dark fw-bold">Dashboard</h4>
    </div>
</div>

<div class="row">
    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-purple">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-plug text-white"></i></div>
                    <div><h3><?= $conns_live ?></h3><p>Online Connections</p></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-users text-white"></i></div>
                    <div><h3><?= $active_users ?></h3><p>Active Lines</p></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-play text-white"></i></div>
                    <div><h3><?= $total_live ?></h3><p>Live Streams</p></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-pink">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-exclamation-triangle text-white"></i></div>
                    <div><h3>0</h3><p>Down Streams</p></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-arrow-up text-white"></i></div>
                    <div><h3><?= $net_out ?> Mbps</h3><p>Network Output</p></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-danger">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-arrow-down text-white"></i></div>
                    <div><h3><?= $net_in ?> Mbps</h3><p>Network Input</p></div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-xl-4 col-md-6">
        <div class="server-card">
            <div class="server-header">
                <h5>Main Server</h5>
                <small>Main Server</small>
            </div>
            <div class="server-body">
                
                <div class="stat-row">
                    <div class="stat-item col-6">
                        <h6>Conns.</h6>
                        <span><?= $conns_live ?></span>
                    </div>
                    <div class="stat-item col-6">
                        <h6>Users</h6>
                        <span><?= $total_users ?></span>
                    </div>
                </div>
                <div class="stat-row">
                    <div class="stat-item col-6">
                        <h6>Online</h6>
                        <span><?= $total_live ?></span>
                    </div>
                    <div class="stat-item col-6">
                        <h6>Input</h6>
                        <span><?= $net_in ?></span>
                    </div>
                </div>
                <div class="stat-row">
                    <div class="stat-item col-6">
                        <h6>Output</h6>
                        <span><?= $net_out ?></span>
                    </div>
                    <div class="stat-item col-6">
                        <h6>Uptime</h6>
                        <span><?= $uptime ?></span>
                    </div>
                </div>

                <hr class="my-4">

                <div class="row text-center">
                    <div class="col-4">
                        <div class="chart-label">CPU %</div>
                        <div class="circle-wrap pie-cpu">
                            <div class="circle-inner"><?= $cpu_usage ?>%</div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="chart-label">MEM %</div>
                        <div class="circle-wrap pie-mem">
                            <div class="circle-inner"><?= $mem_usage ?>%</div>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="chart-label">DISK %</div>
                        <div class="circle-wrap pie-disk">
                            <div class="circle-inner"><?= $disk_usage ?>%</div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="col-xl-8 col-md-6">
        <div class="card" style="border:none; box-shadow: 0 0 20px 0 rgba(0,0,0,0.05);">
            <div class="card-body">
                <h4 class="header-title mb-3" style="font-size: 16px; font-weight: 700; color: #343a40;">Últimos Clientes</h4>
                <div class="table-responsive">
                    <table class="table table-hover table-centered mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Usuário</th>
                                <th>Criado Em</th>
                                <th>Vencimento</th>
                                <th class="text-center">Status</th>
                                <th class="text-end">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(count($recent_users) == 0): ?>
                                <tr><td colspan="5" class="text-center py-3">Nenhum registro encontrado.</td></tr>
                            <?php endif; ?>

                            <?php foreach($recent_users as $u): 
                                $is_vencido = $u['exp_date'] < time();
                                $status_class = $is_vencido ? 'badge-xui-danger' : 'badge-xui-success';
                                $status_text = $is_vencido ? 'EXPIRADO' : 'ATIVO';
                            ?>
                            <tr>
                                <td class="fw-bold text-dark"><?= $u['username'] ?></td>
                                <td><?= date('d/m H:i', $u['created_at']) ?></td>
                                <td><?= date('d/m/Y', $u['exp_date']) ?></td>
                                <td class="text-center"><span class="<?= $status_class ?>"><?= $status_text ?></span></td>
                                <td class="text-end">
                                    <a href="clientes.php?busca=<?= $u['username'] ?>" class="btn btn-sm btn-light border"><i class="fas fa-cog text-muted"></i></a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</div> </div> <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>