<?php
require 'config.php';
require 'header.php'; 

// --- 1. DEFINIR QUEM É O DONO ---
// Se for Admin, vê tudo. Se for Revenda, vê só os dele.
$my_id = $_SESSION['user_id'];
$is_admin = ($_SESSION['group_id'] == 1);

// Filtros SQL
$sql_dono   = $is_admin ? "" : "WHERE member_id = $my_id";
$sql_ativos = $is_admin ? "" : "AND member_id = $my_id";

// --- 2. ESTATÍSTICAS DE CLIENTES (FILTRADAS) ---
// Total de Clientes
$total_users = $pdo->query("SELECT count(*) FROM `lines` $sql_dono")->fetchColumn();

// Clientes Ativos
$active_users = $pdo->query("SELECT count(*) FROM `lines` WHERE exp_date > UNIX_TIMESTAMP() $sql_ativos")->fetchColumn();

// Vencidos (Cálculo matemático simples)
$expired_users = $total_users - $active_users;

// --- 3. CONTEÚDO (GLOBAL) ---
// O revendedor vê a quantidade total do servidor (para marketing), mas não edita.
$total_live   = $pdo->query("SELECT count(*) FROM streams WHERE type = 1")->fetchColumn();
$total_movies = $pdo->query("SELECT count(*) FROM streams WHERE type = 2")->fetchColumn();

// --- CORREÇÃO AQUI: Tabela ajustada para 'streams_series' ---
$total_series = $pdo->query("SELECT count(*) FROM streams_series")->fetchColumn();

// --- 4. ÚLTIMOS CLIENTES (FILTRADOS) ---
// Se for Admin, vê os últimos 5 de todo o servidor. Se for Revenda, vê os últimos 5 dele.
$recent_users = $pdo->query("SELECT username, exp_date, created_at FROM `lines` $sql_dono ORDER BY id DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    .stat-card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        overflow: hidden;
        position: relative;
        height: 100%;
        background: #fff;
    }
    
    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }

    .stat-icon {
        position: absolute;
        right: 20px;
        top: 20px;
        font-size: 3.5rem;
        opacity: 0.1;
        transform: rotate(-15deg);
    }

    .stat-value { font-size: 2.2rem; font-weight: 700; margin-bottom: 0; }
    .stat-label { font-size: 0.9rem; text-transform: uppercase; letter-spacing: 1px; color: #6c757d; font-weight: 600; }

    /* Cores das Bordas Laterais */
    .border-l-primary { border-left: 5px solid #0d6efd; }
    .border-l-success { border-left: 5px solid #198754; }
    .border-l-danger  { border-left: 5px solid #dc3545; }
    .border-l-warning { border-left: 5px solid #ffc107; }
    .border-l-info    { border-left: 5px solid #0dcaf0; }
    .border-l-purple  { border-left: 5px solid #6f42c1; }

    .welcome-banner {
        background: linear-gradient(135deg, #212529, #343a40);
        color: white;
        border-radius: 12px;
        padding: 30px;
        margin-bottom: 30px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    }
</style>

<div class="container-fluid">
    
    <div class="welcome-banner d-flex justify-content-between align-items-center">
        <div>
            <h2 class="fw-bold mb-1">Painel de Controle</h2>
            <p class="mb-0 text-white-50">
                <?php if($is_admin): ?>
                    Visão Geral do Servidor (Administrador)
                <?php else: ?>
                    Bem-vindo, Revendedor! Aqui estão seus números.
                <?php endif; ?>
            </p>
        </div>
        <div class="d-none d-md-block">
            <i class="fas fa-chart-line fa-3x text-white-50"></i>
        </div>
    </div>

    <h5 class="text-muted mb-3 ps-1"><i class="fas fa-users me-2"></i>Status dos Clientes</h5>
    <div class="row g-4 mb-5">
        
        <div class="col-12 col-md-4">
            <div class="stat-card border-l-primary p-4">
                <i class="fas fa-users stat-icon text-primary"></i>
                <div class="stat-label">Total Clientes</div>
                <div class="stat-value text-primary"><?= number_format($total_users) ?></div>
                <small class="text-muted">Registrados na sua conta</small>
            </div>
        </div>

        <div class="col-12 col-md-4">
            <div class="stat-card border-l-success p-4">
                <i class="fas fa-user-check stat-icon text-success"></i>
                <div class="stat-label">Clientes Ativos</div>
                <div class="stat-value text-success"><?= number_format($active_users) ?></div>
                <small class="text-muted">Contas em dia</small>
            </div>
        </div>

        <div class="col-12 col-md-4">
            <div class="stat-card border-l-danger p-4">
                <i class="fas fa-user-times stat-icon text-danger"></i>
                <div class="stat-label">Vencidos</div>
                <div class="stat-value text-danger"><?= number_format($expired_users) ?></div>
                <small class="text-muted">Precisam renovar</small>
            </div>
        </div>
    </div>

    <h5 class="text-muted mb-3 ps-1"><i class="fas fa-database me-2"></i>Conteúdo Disponível</h5>
    <div class="row g-4 mb-5">
        
        <div class="col-12 col-md-4">
            <div class="stat-card border-l-info p-4">
                <i class="fas fa-broadcast-tower stat-icon text-info"></i>
                <div class="stat-label">Canais (Live)</div>
                <div class="stat-value text-dark"><?= number_format($total_live) ?></div>
                <?php if($is_admin): ?>
                    <a href="canais.php" class="btn btn-sm btn-outline-info mt-2">Gerenciar</a>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-12 col-md-4">
            <div class="stat-card border-l-warning p-4">
                <i class="fas fa-film stat-icon text-warning"></i>
                <div class="stat-label">Filmes (VOD)</div>
                <div class="stat-value text-dark"><?= number_format($total_movies) ?></div>
                <?php if($is_admin): ?>
                    <a href="filmes.php" class="btn btn-sm btn-outline-warning mt-2">Gerenciar</a>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-12 col-md-4">
            <div class="stat-card border-l-purple p-4">
                <i class="fas fa-tv stat-icon text-purple" style="color: #6f42c1;"></i>
                <div class="stat-label">Séries</div>
                <div class="stat-value text-dark"><?= number_format($total_series) ?></div>
                <?php if($is_admin): ?>
                    <a href="series.php" class="btn btn-sm mt-2" style="border-color: #6f42c1; color: #6f42c1;">Gerenciar</a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card border-0 shadow-sm" style="border-radius: 12px;">
                <div class="card-header bg-white py-3 border-0">
                    <h6 class="mb-0 fw-bold"><i class="fas fa-history me-2 text-primary"></i>Últimos Clientes Adicionados</h6>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0 align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th class="ps-4">Usuário</th>
                                    <th>Vencimento</th>
                                    <th>Criado em</th>
                                    <th class="text-end pe-4">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(count($recent_users) == 0): ?>
                                    <tr>
                                        <td colspan="4" class="text-center py-4 text-muted">Nenhum cliente recente encontrado.</td>
                                    </tr>
                                <?php endif; ?>

                                <?php foreach($recent_users as $u): 
                                    $ativo = $u['exp_date'] > time();
                                    $status = $ativo ? '<span class="badge bg-success rounded-pill">Ativo</span>' : '<span class="badge bg-danger rounded-pill">Vencido</span>';
                                ?>
                                <tr>
                                    <td class="ps-4 fw-bold"><?= $u['username'] ?></td>
                                    <td><?= date('d/m/Y', $u['exp_date']) ?></td>
                                    <td class="text-muted small"><?= date('d/m/Y H:i', $u['created_at']) ?></td>
                                    <td class="text-end pe-4"><?= $status ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer bg-white border-0 text-center py-3">
                    <a href="clientes.php" class="text-decoration-none fw-bold small">Ver Todos os Clientes <i class="fas fa-arrow-right ms-1"></i></a>
                </div>
            </div>
        </div>
    </div>

</div>

</div> <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
