<?php
require 'header.php'; // Já inclui config.php e verificações

// --- LÓGICA DE DADOS ---
// Se for Admin, vê tudo. Se for Revenda, vê só os dele.
$sql_dono   = $is_admin ? "" : "WHERE member_id = $my_id";
$sql_ativos = $is_admin ? "" : "AND member_id = $my_id";

// Contagens
$total_users = $pdo->query("SELECT count(*) FROM `lines` $sql_dono")->fetchColumn();
$active_users = $pdo->query("SELECT count(*) FROM `lines` WHERE exp_date > UNIX_TIMESTAMP() $sql_ativos")->fetchColumn();
$expired_users = $total_users - $active_users;

// Conteúdo (Apenas leitura para estatística)
$total_live   = $pdo->query("SELECT count(*) FROM streams WHERE type = 1")->fetchColumn();
$total_movies = $pdo->query("SELECT count(*) FROM streams WHERE type = 2")->fetchColumn();
$total_series = $pdo->query("SELECT count(*) FROM streams_series")->fetchColumn();

// Últimos Clientes
$recent_users = $pdo->query("SELECT username, exp_date, created_at FROM `lines` $sql_dono ORDER BY id DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    /* Estilos Específicos do Dashboard XUI */
    .cta-box {
        color: #fff;
        border: none;
        border-radius: 4px;
        position: relative;
        overflow: hidden;
        margin-bottom: 24px;
        box-shadow: 0 0 20px 0 rgba(0,0,0,0.05);
    }
    .cta-box .card-body { padding: 1.5rem; }
    
    /* Cores Oficiais XUI */
    .bg-purple { background-color: #675db7 !important; }
    .bg-success { background-color: #23b397 !important; }
    .bg-info { background-color: #56c2d6 !important; }
    .bg-pink { background-color: #e36498 !important; }
    .bg-primary { background-color: #4a81d4 !important; }
    .bg-danger { background-color: #f1556c !important; }

    .avatar-sm {
        height: 48px; width: 48px;
        background-color: rgba(255,255,255,0.2);
        border-radius: 50%;
        display: flex; align-items: center; justify-content: center;
        font-size: 22px;
    }
    
    .cta-box h3 { margin: 0; font-size: 24px; font-weight: 700; }
    .cta-box p { margin: 0; font-size: 13px; text-transform: uppercase; opacity: 0.9; margin-top: 2px; }

    /* Tabela XUI */
    .card-xui {
        background: #fff; border: none; border-radius: 4px;
        box-shadow: 0 0 20px 0 rgba(0,0,0,0.05);
        margin-bottom: 20px;
    }
    .header-title { font-size: 16px; font-weight: 700; color: #343a40; margin-bottom: 20px; }
    
    .badge-xui-success { background: rgba(35,179,151,0.15); color: #23b397; padding: 5px 10px; border-radius: 4px; font-weight: 700; font-size: 11px; }
    .badge-xui-danger { background: rgba(241,85,108,0.15); color: #f1556c; padding: 5px 10px; border-radius: 4px; font-weight: 700; font-size: 11px; }
</style>

<div class="row">
    <div class="col-12">
        <h4 class="mb-4 text-dark fw-bold">Dashboard</h4>
    </div>
</div>

<div class="row">
    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-purple">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-plug text-white"></i></div>
                    <div>
                        <h3><?= $total_users ?></h3>
                        <p>Total Clientes</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-success">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-users text-white"></i></div>
                    <div>
                        <h3><?= $active_users ?></h3>
                        <p>Linhas Ativas</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-info">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-play text-white"></i></div>
                    <div>
                        <h3><?= $total_live ?></h3>
                        <p>Canais Online</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-pink">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-exclamation-triangle text-white"></i></div>
                    <div>
                        <h3><?= $expired_users ?></h3>
                        <p>Clientes Vencidos</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-primary">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-film text-white"></i></div>
                    <div>
                        <h3><?= $total_movies ?></h3>
                        <p>Filmes VOD</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6 col-xl-4">
        <div class="card cta-box bg-danger">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="avatar-sm me-3"><i class="fas fa-tv text-white"></i></div>
                    <div>
                        <h3><?= $total_series ?></h3>
                        <p>Séries</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card card-xui p-4">
            <h4 class="header-title">Clientes Recentes</h4>
            <div class="table-responsive">
                <table class="table table-hover table-centered mb-0 border-top">
                    <thead class="table-light">
                        <tr>
                            <th>Usuário</th>
                            <th>Data Cadastro</th>
                            <th>Vencimento</th>
                            <th class="text-center">Status</th>
                            <th class="text-end">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(count($recent_users) == 0): ?>
                            <tr><td colspan="5" class="text-center py-3">Nenhum registro encontrado.</td></tr>
                        <?php endif; ?>

                        <?php foreach($recent_users as $u): 
                            $is_ativo = $u['exp_date'] > time();
                            $badge = $is_ativo ? 'badge-xui-success' : 'badge-xui-danger';
                            $status = $is_ativo ? 'ATIVO' : 'VENCIDO';
                        ?>
                        <tr>
                            <td class="fw-bold text-dark"><?= $u['username'] ?></td>
                            <td><?= date('d/m/Y H:i', $u['created_at']) ?></td>
                            <td><?= date('d/m/Y', $u['exp_date']) ?></td>
                            <td class="text-center"><span class="<?= $badge ?>"><?= $status ?></span></td>
                            <td class="text-end">
                                <a href="clientes.php?busca=<?= $u['username'] ?>" class="btn btn-sm btn-light border"><i class="fas fa-cog text-muted"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

</div> </div> <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>