<?php
require 'config.php';
require 'header.php';

// Segurança: Apenas Admin (Grupo 1)
$grupo = $_SESSION['group_id'] ?? 0;
if ($grupo != 1) { echo "<script>window.location='index.php';</script>"; exit; }

// --- LÓGICA DE EXCLUSÃO (BACKEND) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $tipo_alvo = $_POST['tipo_alvo']; 
    $modo = $_POST['modo']; 
    
    try {
        $pdo->beginTransaction();

        // 1. APAGAR TUDO (NUCLEAR)
        if ($modo === 'tudo') {
            if ($tipo_alvo === 'live') {
                // Apaga Canais (type 1)
                $pdo->query("DELETE FROM streams WHERE type = 1");
                $pdo->query("DELETE FROM streams_categories WHERE category_type = 'live'");
            
            } elseif ($tipo_alvo === 'movie') {
                // Apaga Filmes (type 2)
                $pdo->query("DELETE FROM streams WHERE type = 2");
                $pdo->query("DELETE FROM streams_categories WHERE category_type = 'movie'");
            
            } elseif ($tipo_alvo === 'series') {
                // CORREÇÃO: Tabelas certas (streams_series e streams_episodes)
                
                // Opcional: Apagar os arquivos dos episódios da tabela streams antes de apagar o vínculo
                // (Isso evita que fiquem arquivos "fantasmas" no banco)
                $pdo->query("DELETE FROM streams WHERE id IN (SELECT stream_id FROM streams_episodes)");

                // Apaga Vínculos de Episódios
                $pdo->query("DELETE FROM streams_episodes");
                
                // Apaga as Séries
                $pdo->query("DELETE FROM streams_series");
                
                // Apaga Categorias
                $pdo->query("DELETE FROM streams_categories WHERE category_type = 'series'");
            }
            echo "<script>alert('Limpeza TOTAL realizada com sucesso!'); window.location='limpeza.php';</script>";
        } 
        
        // 2. APAGAR POR CATEGORIAS SELECIONADAS
        elseif ($modo === 'categorias' && !empty($_POST['cats'])) {
            // Sanitiza os IDs
            $cats_ids = implode(',', array_map('intval', $_POST['cats']));
            
            if ($tipo_alvo === 'live') {
                // Apaga canais dessas categorias
                $pdo->query("DELETE FROM streams WHERE type = 1 AND category_id IN ($cats_ids)");
            
            } elseif ($tipo_alvo === 'movie') {
                // Apaga filmes dessas categorias
                $pdo->query("DELETE FROM streams WHERE type = 2 AND category_id IN ($cats_ids)");
            
            } elseif ($tipo_alvo === 'series') {
                // CORREÇÃO: Busca na tabela streams_series
                $series = $pdo->query("SELECT id FROM streams_series WHERE category_id IN ($cats_ids)")->fetchAll(PDO::FETCH_COLUMN);
                
                if(!empty($series)) {
                    $ids_serie = implode(',', $series);
                    
                    // 1. Apaga os arquivos (streams) vinculados aos episódios dessas séries
                    $pdo->query("DELETE FROM streams WHERE id IN (SELECT stream_id FROM streams_episodes WHERE series_id IN ($ids_serie))");

                    // 2. Apaga os vínculos na tabela streams_episodes
                    $pdo->query("DELETE FROM streams_episodes WHERE series_id IN ($ids_serie)");
                }

                // 3. Apaga as séries
                $pdo->query("DELETE FROM streams_series WHERE category_id IN ($cats_ids)");
            }
            
            // Por fim, apaga as categorias
            $pdo->query("DELETE FROM streams_categories WHERE id IN ($cats_ids)");
            
            echo "<script>alert('Categorias selecionadas foram excluídas!'); window.location='limpeza.php';</script>";
        }

        $pdo->commit();
        
    } catch (Exception $e) {
        $pdo->rollBack();
        echo "<script>alert('Erro ao processar: " . addslashes($e->getMessage()) . "');</script>";
    }
}

// --- BUSCA DAS CATEGORIAS ---
try {
    $todas_cats = $pdo->query("SELECT id, category_name, category_type FROM streams_categories ORDER BY category_name ASC")->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $todas_cats = [];
    echo "<div class='alert alert-danger'>Erro ao ler tabela streams_categories.</div>";
}

$cats_live = [];
$cats_movie = [];
$cats_series = [];

foreach($todas_cats as $c) {
    $tipo = strtolower(trim($c['category_type']));
    if($tipo == 'live') { $cats_live[] = $c; } 
    elseif($tipo == 'movie' || $tipo == 'vod') { $cats_movie[] = $c; } 
    elseif($tipo == 'series' || $tipo == 'serie') { $cats_series[] = $c; }
}
?>

<style>
    .k-card { background: #fff; border-radius: 12px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 20px; }
    .k-header { padding: 15px 20px; border-bottom: 1px solid #eee; font-weight: bold; font-size: 1.1rem; }
    .cat-list-box { max-height: 400px; overflow-y: auto; background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 8px; padding: 15px; }
    .nav-pills .nav-link { border-radius: 50px; padding: 10px 25px; font-weight: bold; color: #555; background: #fff; border: 1px solid #eee; margin-right: 10px; transition:0.3s; }
    .nav-pills .nav-link:hover { background-color: #f0f0f0; }
    .nav-pills .nav-link.active { background-color: #dc3545; color: #fff; border-color: #dc3545; box-shadow: 0 4px 10px rgba(220, 53, 69, 0.3); }
    .form-check-input { cursor: pointer; transform: scale(1.1); }
    .form-check-label { cursor: pointer; }
</style>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4 mt-2">
        <div>
            <h4 class="fw-bold mb-0 text-dark">Limpeza de Conteúdo</h4>
            <small class="text-muted">Gerencie e exclua canais, filmes e séries.</small>
        </div>
    </div>

    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" id="pills-live-tab" data-bs-toggle="pill" data-bs-target="#pills-live">
                📺 Canais (<?= count($cats_live) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" id="pills-movie-tab" data-bs-toggle="pill" data-bs-target="#pills-movie">
                🎬 Filmes (<?= count($cats_movie) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" id="pills-series-tab" data-bs-toggle="pill" data-bs-target="#pills-series">
                🍿 Séries (<?= count($cats_series) ?>)
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        <div class="tab-pane fade show active" id="pills-live">
            <?php renderCard('live', 'Canais', $cats_live); ?>
        </div>
        <div class="tab-pane fade" id="pills-movie">
            <?php renderCard('movie', 'Filmes', $cats_movie); ?>
        </div>
        <div class="tab-pane fade" id="pills-series">
            <?php renderCard('series', 'Séries', $cats_series); ?>
        </div>
    </div>
</div>

<?php
function renderCard($tipo, $nome, $categorias) {
    ?>
    <div class="k-card border-danger border-top border-3">
        <div class="k-header d-flex justify-content-between align-items-center">
            <span><i class="fas fa-trash-alt me-2 text-danger"></i>Excluir <?= $nome ?></span>
            <span class="badge bg-secondary"><?= count($categorias) ?> Categorias</span>
        </div>
        <div class="card-body p-4">
            
            <form method="POST" onsubmit="return confirm('ATENÇÃO! Você está prestes a excluir conteúdo. Tem certeza?');">
                <input type="hidden" name="tipo_alvo" value="<?= $tipo ?>">
                
                <div class="alert alert-danger shadow-sm mb-4">
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="modo" id="modo_tudo_<?= $tipo ?>" value="tudo" onchange="toggleList('<?= $tipo ?>', false)">
                        <label class="form-check-label fw-bold text-danger" for="modo_tudo_<?= $tipo ?>">
                            <i class="fas fa-radiation-alt me-1"></i> APAGAR TODOS OS <?= strtoupper($nome) ?> (NUCLEAR)
                        </label>
                        <div class="small text-muted mt-1 ms-4">Apaga todo o conteúdo de <?= strtolower($nome) ?> do painel.</div>
                    </div>
                </div>

                <div class="mb-3">
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" name="modo" id="modo_cat_<?= $tipo ?>" value="categorias" checked onchange="toggleList('<?= $tipo ?>', true)">
                        <label class="form-check-label fw-bold text-dark" for="modo_cat_<?= $tipo ?>">
                            Selecionar Categorias
                        </label>
                    </div>

                    <div id="lista_<?= $tipo ?>" class="cat-list-box">
                        <?php if(empty($categorias)): ?>
                            <div class="text-center py-4 text-muted">
                                <i class="fas fa-folder-open fa-2x mb-2"></i><br>
                                Nenhuma categoria encontrada.
                            </div>
                        <?php else: ?>
                            
                            <div class="d-flex gap-2 mb-3 sticky-top bg-white border-bottom pb-2">
                                <button type="button" class="btn btn-sm btn-dark" onclick="checkAll('<?= $tipo ?>', true)">Marcar Todas</button>
                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="checkAll('<?= $tipo ?>', false)">Desmarcar</button>
                            </div>

                            <div class="row g-2">
                                <?php foreach($categorias as $c): ?>
                                <div class="col-md-4 col-sm-6">
                                    <div class="form-check bg-white p-2 border rounded shadow-sm">
                                        <input class="form-check-input check-<?= $tipo ?> ms-1" type="checkbox" name="cats[]" value="<?= $c['id'] ?>" id="c_<?= $tipo ?>_<?= $c['id'] ?>">
                                        <label class="form-check-label w-100 ps-2 text-truncate" for="c_<?= $tipo ?>_<?= $c['id'] ?>">
                                            <span class="fw-bold text-dark"><?= $c['category_name'] ?></span><br>
                                            <small class="text-muted" style="font-size:0.75rem">ID: <?= $c['id'] ?></small>
                                        </label>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>

                        <?php endif; ?>
                    </div>
                </div>

                <div class="text-end mt-4">
                    <button type="submit" class="btn btn-danger btn-lg px-5 fw-bold shadow">
                        <i class="fas fa-trash me-2"></i> EXECUTAR LIMPEZA
                    </button>
                </div>

            </form>
        </div>
    </div>
    <?php
}
?>

<script>
    function toggleList(tipo, show) {
        var el = document.getElementById('lista_' + tipo);
        if(show) { el.style.opacity = '1'; el.style.pointerEvents = 'auto'; } 
        else { el.style.opacity = '0.4'; el.style.pointerEvents = 'none'; }
    }
    function checkAll(tipo, status) {
        document.querySelectorAll('.check-' + tipo).forEach(cb => cb.checked = status);
    }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>