<?php
// limpeza_inteligente.php - Ferramenta de Deduplicação K-Office Style
require_once 'config.php';
require_once 'header.php';

// --- SEGURANÇA: APENAS ADMIN ---
if ((!isset($_SESSION['group_id']) || $_SESSION['group_id'] != 1) && (!isset($_SESSION['is_admin']) || !$_SESSION['is_admin'])) {
    echo "<script>window.location='index.php';</script>"; exit;
}

$msg = "";
$msg_type = "";

// ====================================================================
// --- LÓGICA DE LIMPEZA (DELETE) ---
// ====================================================================

// 1. LIMPAR CANAIS (LIVE) DUPLICADOS
if (isset($_POST['clean_live'])) {
    try {
        // Deleta o ID maior (o mais novo), mantendo o ID menor (o mais antigo)
        $sql = "DELETE s1 FROM streams s1
                INNER JOIN streams s2 
                WHERE s1.id > s2.id 
                AND s1.stream_display_name = s2.stream_display_name 
                AND s1.stream_source = s2.stream_source 
                AND s1.type = 1";
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        $count = $stmt->rowCount();
        $msg = "Sucesso! $count Canais duplicados foram removidos.";
        $msg_type = "success";
    } catch (Exception $e) {
        $msg = "Erro ao limpar canais: " . $e->getMessage();
        $msg_type = "danger";
    }
}

// 2. LIMPAR FILMES (VOD) DUPLICADOS
if (isset($_POST['clean_vod'])) {
    try {
        $sql = "DELETE s1 FROM streams s1
                INNER JOIN streams s2 
                WHERE s1.id > s2.id 
                AND s1.stream_display_name = s2.stream_display_name 
                AND s1.stream_source = s2.stream_source 
                AND s1.type = 2";
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        $count = $stmt->rowCount();
        $msg = "Sucesso! $count Filmes duplicados foram removidos.";
        $msg_type = "success";
    } catch (Exception $e) {
        $msg = "Erro ao limpar filmes: " . $e->getMessage();
        $msg_type = "danger";
    }
}

// 3. LIMPAR SÉRIES DUPLICADAS (Pelo Título)
if (isset($_POST['clean_series'])) {
    try {
        $sql = "DELETE s1 FROM streams_series s1
                INNER JOIN streams_series s2 
                WHERE s1.id > s2.id 
                AND s1.title = s2.title";
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        $count = $stmt->rowCount();
        $msg = "Sucesso! $count Séries duplicadas foram removidas.";
        $msg_type = "success";
    } catch (Exception $e) {
        $msg = "Erro ao limpar séries: " . $e->getMessage();
        $msg_type = "danger";
    }
}

// 4. LIMPAR EPISÓDIOS DUPLICADOS (Mesma Série, Temp e Ep)
if (isset($_POST['clean_episodes'])) {
    try {
        $sql = "DELETE e1 FROM streams_episodes e1
                INNER JOIN streams_episodes e2 
                WHERE e1.id > e2.id 
                AND e1.series_id = e2.series_id 
                AND e1.season_num = e2.season_num
                AND e1.episode_num = e2.episode_num";
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
        $count = $stmt->rowCount();
        $msg = "Sucesso! $count Episódios duplicados foram removidos.";
        $msg_type = "success";
    } catch (Exception $e) {
        $msg = "Erro ao limpar episódios: " . $e->getMessage();
        $msg_type = "danger";
    }
}

// ====================================================================
// --- CONTAGEM DE DUPLICADOS (PARA O DASHBOARD) ---
// ====================================================================

// Conta Canais Duplicados
$sql_dup_live = "SELECT COUNT(*) as total FROM (
                    SELECT id FROM streams WHERE type=1 
                    GROUP BY stream_display_name, stream_source 
                    HAVING COUNT(*) > 1
                 ) as temp";
$dup_live = $pdo->query($sql_dup_live)->fetchColumn();

// Conta Filmes Duplicados
$sql_dup_vod = "SELECT COUNT(*) as total FROM (
                    SELECT id FROM streams WHERE type=2 
                    GROUP BY stream_display_name, stream_source 
                    HAVING COUNT(*) > 1
                 ) as temp";
$dup_vod = $pdo->query($sql_dup_vod)->fetchColumn();

// Conta Séries Duplicadas
$sql_dup_series = "SELECT COUNT(*) as total FROM (
                    SELECT id FROM streams_series 
                    GROUP BY title 
                    HAVING COUNT(*) > 1
                 ) as temp";
$dup_series = $pdo->query($sql_dup_series)->fetchColumn();

// Conta Episódios Duplicados
$sql_dup_ep = "SELECT COUNT(*) as total FROM (
                    SELECT id FROM streams_episodes 
                    GROUP BY series_id, season_num, episode_num 
                    HAVING COUNT(*) > 1
                 ) as temp";
$dup_ep = $pdo->query($sql_dup_ep)->fetchColumn();

?>

<style>
    .k-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.05);
        border: none;
        transition: transform 0.2s;
        height: 100%;
    }
    .k-card:hover { transform: translateY(-5px); }
    .icon-box {
        width: 60px; height: 60px;
        border-radius: 50%;
        display: flex; align-items: center; justify-content: center;
        font-size: 24px; margin-bottom: 15px;
    }
    .bg-live { background: rgba(25, 135, 84, 0.1); color: #198754; }
    .bg-vod { background: rgba(13, 202, 240, 0.1); color: #0dcaf0; }
    .bg-series { background: rgba(255, 193, 7, 0.1); color: #ffc107; }
    .bg-ep { background: rgba(111, 66, 193, 0.1); color: #6f42c1; }
    .stat-value { font-size: 2rem; font-weight: 800; color: #343a40; }
    .stat-label { color: #6c757d; font-weight: 600; text-transform: uppercase; font-size: 0.8rem; letter-spacing: 1px; }
</style>

<div class="container-fluid py-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0 text-dark"><i class="fas fa-broom me-2 text-primary"></i>Limpeza Inteligente</h4>
        <span class="text-muted">Detecta e remove duplicatas mantendo o item mais antigo.</span>
    </div>

    <?php if ($msg): ?>
    <div class="alert alert-<?= $msg_type ?> alert-dismissible fade show shadow-sm" role="alert">
        <strong><?= $msg_type == 'success' ? 'Sucesso!' : 'Atenção!' ?></strong> <?= $msg ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php endif; ?>

    <div class="row g-4">
        
        <div class="col-xl-3 col-md-6">
            <div class="k-card p-4 text-center">
                <div class="d-flex justify-content-center">
                    <div class="icon-box bg-live"><i class="fas fa-broadcast-tower"></i></div>
                </div>
                <div class="stat-value"><?= $dup_live ?></div>
                <div class="stat-label mb-3">Canais Duplicados</div>
                
                <?php if($dup_live > 0): ?>
                    <button class="btn btn-outline-success w-100 fw-bold" data-bs-toggle="modal" data-bs-target="#modalLive">
                        <i class="fas fa-eye me-1"></i> Visualizar & Limpar
                    </button>
                <?php else: ?>
                    <button class="btn btn-light w-100 text-muted" disabled><i class="fas fa-check me-1"></i> Tudo Limpo</button>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="k-card p-4 text-center">
                <div class="d-flex justify-content-center">
                    <div class="icon-box bg-vod"><i class="fas fa-film"></i></div>
                </div>
                <div class="stat-value"><?= $dup_vod ?></div>
                <div class="stat-label mb-3">Filmes Duplicados</div>

                <?php if($dup_vod > 0): ?>
                    <button class="btn btn-outline-info w-100 fw-bold" data-bs-toggle="modal" data-bs-target="#modalVod">
                        <i class="fas fa-eye me-1"></i> Visualizar & Limpar
                    </button>
                <?php else: ?>
                    <button class="btn btn-light w-100 text-muted" disabled><i class="fas fa-check me-1"></i> Tudo Limpo</button>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="k-card p-4 text-center">
                <div class="d-flex justify-content-center">
                    <div class="icon-box bg-series"><i class="fas fa-tv"></i></div>
                </div>
                <div class="stat-value"><?= $dup_series ?></div>
                <div class="stat-label mb-3">Séries Duplicadas</div>

                <?php if($dup_series > 0): ?>
                    <button class="btn btn-outline-warning w-100 fw-bold text-dark" data-bs-toggle="modal" data-bs-target="#modalSeries">
                        <i class="fas fa-eye me-1"></i> Visualizar & Limpar
                    </button>
                <?php else: ?>
                    <button class="btn btn-light w-100 text-muted" disabled><i class="fas fa-check me-1"></i> Tudo Limpo</button>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="k-card p-4 text-center">
                <div class="d-flex justify-content-center">
                    <div class="icon-box bg-ep"><i class="fas fa-video"></i></div>
                </div>
                <div class="stat-value"><?= $dup_ep ?></div>
                <div class="stat-label mb-3">Episódios Duplicados</div>

                <?php if($dup_ep > 0): ?>
                    <button class="btn btn-outline-primary w-100 fw-bold" data-bs-toggle="modal" data-bs-target="#modalEp">
                        <i class="fas fa-eye me-1"></i> Visualizar & Limpar
                    </button>
                <?php else: ?>
                    <button class="btn btn-light w-100 text-muted" disabled><i class="fas fa-check me-1"></i> Tudo Limpo</button>
                <?php endif; ?>
            </div>
        </div>

    </div>
    
    <div class="alert alert-secondary mt-4">
        <i class="fas fa-info-circle me-2"></i> <strong>Como funciona?</strong> O sistema busca itens com o <strong>MESMO NOME</strong> e o <strong>MESMO LINK/FONTE</strong>. Ao clicar em limpar, ele remove as versões mais recentes (IDs maiores) e mantém apenas a versão original (ID menor).
    </div>
</div>

<div class="modal fade" id="modalLive" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">Limpar Canais Duplicados</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Foram encontrados <strong><?= $dup_live ?></strong> grupos de canais com mesmo nome e link.</p>
                <p class="text-danger small">Atenção: Esta ação é irreversível.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <form method="POST">
                    <button type="submit" name="clean_live" class="btn btn-success fw-bold">Confirmar Limpeza</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalVod" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title">Limpar Filmes Duplicados</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Foram encontrados <strong><?= $dup_vod ?></strong> grupos de filmes com mesmo nome e link.</p>
                <p class="text-danger small">Atenção: Esta ação é irreversível.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <form method="POST">
                    <button type="submit" name="clean_vod" class="btn btn-info text-white fw-bold">Confirmar Limpeza</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalSeries" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title">Limpar Séries Duplicadas</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Foram encontrados <strong><?= $dup_series ?></strong> títulos de séries duplicados.</p>
                <p class="text-muted small">A verificação é feita apenas pelo Nome da Série.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <form method="POST">
                    <button type="submit" name="clean_series" class="btn btn-warning fw-bold">Confirmar Limpeza</button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEp" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">Limpar Episódios Duplicados</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Foram encontrados <strong><?= $dup_ep ?></strong> episódios duplicados.</p>
                <p class="text-muted small">Verificação: Mesmo ID de Série + Temporada + Episódio.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <form method="POST">
                    <button type="submit" name="clean_episodes" class="btn btn-primary fw-bold">Confirmar Limpeza</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
