<?php
// login.php - Visual XUI Verde + Logo na Aba (Favicon)
require 'config.php';

$erro = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user = trim($_POST['user']);
    $pass = trim($_POST['pass']);

    try {
        $stmt = $pdo->prepare("SELECT id, username, password, member_group_id FROM users WHERE username = ?");
        $stmt->execute([$user]);
        $u = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($u && $u['password'] == $pass) {
            if (session_status() === PHP_SESSION_NONE) { session_start(); }
            $_SESSION['logado'] = true;
            $_SESSION['user_id'] = $u['id'];
            $_SESSION['username'] = $u['username'];
            $_SESSION['group_id'] = $u['member_group_id'];
            
            header("Location: index.php");
            exit;
        } else {
            $erro = "Login inválido";
        }
    } catch (Exception $e) {
        $erro = "Erro de conexão";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8" />
    
    <title>XUI | Login</title>
    
    <link rel="icon" type="image/png" href="logo.png">
    
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600;700&display=swap" rel="stylesheet">
    
    <style>
        /* RESET BÁSICO */
        * { box-sizing: border-box; margin: 0; padding: 0; outline: none; }
        
        body {
            font-family: 'Open Sans', sans-serif;
            /* Cor de fundo Teal (Verde XUI) */
            background-color: #186366; 
            background-image: linear-gradient(135deg, #186366 0%, #104e52 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            position: relative;
        }

        /* Formas de Fundo */
        .bg-square {
            position: absolute;
            background: rgba(255,255,255,0.03);
            border-radius: 10px;
            z-index: 0;
        }
        .sq1 { width: 100px; height: 100px; top: 10%; left: 10%; transform: rotate(15deg); }
        .sq2 { width: 150px; height: 150px; bottom: 20%; right: 10%; transform: rotate(-10deg); }
        .sq3 { width: 60px; height: 60px; top: 20%; right: 30%; transform: rotate(45deg); }

        /* LOGO */
        .logo-container {
            text-align: center;
            margin-bottom: 25px;
            z-index: 1;
            position: relative;
        }
        
        .logo-img {
            max-width: 180px; /* Tamanho da logo na tela */
            max-height: 100px;
            height: auto;
            display: block;
            margin: 0 auto;
            filter: drop-shadow(0 5px 5px rgba(0,0,0,0.3));
        }

        /* CAIXA DE LOGIN */
        .login-card {
            background: #ffffff;
            width: 100%;
            max-width: 420px;
            padding: 40px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
            z-index: 10;
            position: relative;
            border-radius: 4px;
        }

        .form-group { margin-bottom: 20px; }

        .form-label {
            display: block;
            color: #555;
            font-size: 14px;
            margin-bottom: 8px;
            font-weight: 600;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            background: #fdfdfd;
            font-size: 14px;
            color: #333;
            transition: 0.3s;
            border-radius: 3px;
        }

        .form-control:focus {
            border-color: #186366;
            background: #fff;
        }

        /* BOTÃO */
        .btn-submit {
            width: 100%;
            background-color: #1286b8; /* Azul XUI */
            color: white;
            padding: 14px;
            border: none;
            font-size: 14px;
            font-weight: 700;
            cursor: pointer;
            text-transform: uppercase;
            transition: 0.3s;
            margin-top: 10px;
            border-radius: 3px;
        }

        .btn-submit:hover { background-color: #0e729e; }

        .alert-error {
            background: #ffecec;
            color: #d9534f;
            border: 1px solid #ebccd1;
            padding: 10px;
            margin-bottom: 20px;
            text-align: center;
            font-size: 13px;
            border-radius: 3px;
        }

        @media (max-width: 480px) {
            .login-card { width: 90%; padding: 25px; }
        }
    </style>
</head>
<body>

    <div class="bg-square sq1"></div>
    <div class="bg-square sq2"></div>
    <div class="bg-square sq3"></div>

    <div style="width: 100%; display: flex; flex-direction: column; align-items: center;">
        
        <div class="logo-container">
            <img src="logo.png" alt="Logo" class="logo-img" onerror="this.style.display='none'; document.getElementById('txt-logo').style.display='block';">
            <h1 id="txt-logo" style="display:none; color:white; font-size:40px; margin:0;">XUI</h1>
        </div>

        <div class="login-card">
            
            <?php if($erro): ?>
                <div class="alert-error"><?= $erro ?></div>
            <?php endif; ?>

            <form method="POST">
                <div class="form-group">
                    <label class="form-label">Usuário</label>
                    <input type="text" name="user" class="form-control" required autocomplete="off">
                </div>

                <div class="form-group">
                    <label class="form-label">Senha</label>
                    <input type="password" name="pass" class="form-control" required autocomplete="off">
                </div>

                <button type="submit" class="btn-submit">ENTRAR</button>
            </form>
        </div>

    </div>

</body>
</html>