<?php
/**
 * ORGANIZADOR IPTV INTEGRADO (MODO FULL DESTINO)
 * - Origem: Filtra pelo tipo selecionado (Canais, Filmes ou Séries)
 * - Destino: Mostra TUDO misturado e organizado
 */

require 'header.php'; 
require_once 'config.php';
global $pdo;

$message = "";
$error_detail = "";

// --- CONFIGURAÇÃO INICIAL ---
// Tipo ativo define o que estamos LENDO (Origem)
$tipo_ativo = isset($_GET['type']) && in_array($_GET['type'], ['live', 'movie', 'series']) ? $_GET['type'] : 'live';

// Mapa para traduzir o tipo do banco para texto legível
$mapa_nomes = [
    'live' => 'Canais ao Vivo',
    'movie' => 'Filmes',
    'series' => 'Séries'
];

// Mapa de IDs da tabela streams (1 = Live, 2 = Movie) - Séries tem tabela própria
$map_tipo_stream = ['live' => 1, 'movie' => 2];

// --- 1. BUSCA CATEGORIAS DE ORIGEM (Filtradas pelo tipo atual) ---
$categorias_origem = [];
try {
    $sql_cats = "SELECT id, category_name FROM streams_categories WHERE category_type = ? ORDER BY category_name ASC";
    $stmt_cats = $pdo->prepare($sql_cats);
    $stmt_cats->execute([$tipo_ativo]);
    $categorias_origem = $stmt_cats->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $error_detail .= "Erro ao ler categorias origem: " . $e->getMessage();
}

// --- 2. BUSCA CATEGORIAS DE DESTINO (TODAS: Live, Movie, Series) ---
// Aqui está a mágica que você pediu: pegamos tudo para montar o dropdown da direita
$categorias_destino_agrupadas = ['live' => [], 'movie' => [], 'series' => []];
try {
    $sql_all = "SELECT id, category_name, category_type FROM streams_categories ORDER BY category_type ASC, category_name ASC";
    $stmt_all = $pdo->query($sql_all);
    $todas_cats = $stmt_all->fetchAll(PDO::FETCH_ASSOC);

    // Organiza o array por tipo
    foreach ($todas_cats as $cat) {
        // Se o tipo vier nulo ou estranho, joga em 'live' por padrão ou cria chave nova
        $tipo = $cat['category_type'] ?? 'live';
        $categorias_destino_agrupadas[$tipo][] = $cat;
    }
} catch (Exception $e) {
    $error_detail .= "<br>Erro ao ler destinos: " . $e->getMessage();
}

// --- 3. BUSCA CONTEÚDOS (Itens da Esquerda) ---
$itens = [];
$cat_origem = $_GET['cat_id'] ?? '';

if ($cat_origem) {
    try {
        $busca_json_quote = '%"' . $cat_origem . '"%'; 
        $busca_json_raw   = '%[' . $cat_origem . ']%';
        
        if ($tipo_ativo == 'series') {
            $sql = "SELECT id, title as name FROM streams_series 
                    WHERE category_id = ? OR category_id LIKE ? OR category_id LIKE ? 
                    ORDER BY title ASC";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$cat_origem, $busca_json_quote, $busca_json_raw]);
        } else {
            $type_id = $map_tipo_stream[$tipo_ativo];
            $sql = "SELECT id, stream_display_name as name FROM streams 
                    WHERE type = ? AND (category_id = ? OR category_id LIKE ? OR category_id LIKE ?) 
                    ORDER BY stream_display_name ASC";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$type_id, $cat_origem, $busca_json_quote, $busca_json_raw]);
        }
        $itens = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        $error_detail .= "<br>Erro ao ler itens: " . $e->getMessage();
    }
}

// --- 4. PROCESSA A MOVIMENTAÇÃO (UPDATE) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['acao_mover'])) {
    $ids_selecionados = $_POST['selected_items'] ?? [];
    $nova_cat = $_POST['target_category'] ?? '';

    if (!empty($ids_selecionados) && !empty($nova_cat)) {
        try {
            $tabela = ($tipo_ativo == 'series') ? 'streams_series' : 'streams';
            $cat_json = '["' . $nova_cat . '"]'; // Formato padrão painel
            
            $placeholders = implode(',', array_fill(0, count($ids_selecionados), '?'));
            $sql = "UPDATE $tabela SET category_id = ? WHERE id IN ($placeholders)";
            
            $params = array_merge([$cat_json], $ids_selecionados);
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            
            $message = "success";
        } catch (PDOException $e) {
            $message = "error";
            $error_detail = $e->getMessage();
        }
    } else {
        $message = "empty";
    }
}
?>

<style>
    .card-organizador { background: #fff; border-radius: 8px; box-shadow: 0 0 15px rgba(0,0,0,0.05); border:none; margin-bottom: 20px; }
    .list-container { height: 450px; overflow-y: auto; background: #fff; border: 1px solid #eee; border-radius: 8px; }
    .item-row { display: flex; align-items: center; padding: 10px 15px; border-bottom: 1px solid #f8f9fa; cursor: pointer; user-select: none; }
    .item-row:hover { background: #f0f7ff; }
    .item-row input { margin-right: 12px; width: 18px; height: 18px; cursor: pointer; }
    .nav-custom { margin-bottom: 20px; }
    .nav-custom .btn { margin-right: 5px; font-weight: bold; border-radius: 20px; padding: 8px 20px; }
    .badge-count { background: #e9ecef; color: #333; padding: 2px 8px; border-radius: 10px; font-size: 0.8em; }
    
    /* Estilo para os grupos do select */
    optgroup { font-weight: bold; color: #0d6efd; background: #f8f9fa; }
    option { color: #333; background: #fff; padding: 5px; }
</style>

<?php if (!empty($error_detail)): ?>
    <div class="alert alert-danger">
        <strong>Erro Técnico:</strong><br><?= $error_detail ?>
    </div>
<?php endif; ?>

<div class="row">
    <div class="col-12">
        <h3 class="mb-4 text-dark fw-bold"><i class="fas fa-random"></i> Mover Conteúdo (Painel Full)</h3>
    </div>
</div>

<div class="nav-custom">
    <a href="?type=live" class="btn <?= $tipo_ativo=='live'?'btn-primary':'btn-light border' ?>"><i class="fas fa-tv"></i> Canais</a>
    <a href="?type=movie" class="btn <?= $tipo_ativo=='movie'?'btn-primary':'btn-light border' ?>"><i class="fas fa-film"></i> Filmes</a>
    <a href="?type=series" class="btn <?= $tipo_ativo=='series'?'btn-primary':'btn-light border' ?>"><i class="fas fa-video"></i> Séries</a>
</div>

<form method="POST" id="formMover">
    <div class="row">
        
        <div class="col-md-6">
            <div class="card card-organizador p-3">
                <label class="fw-bold mb-2 text-primary">1. O que você quer mover? (Origem)</label>
                <select class="form-select mb-3 shadow-sm" onchange="location.href='?type=<?= $tipo_ativo ?>&cat_id=' + this.value">
                    <option value="">-- Escolha a Categoria de Origem --</option>
                    <?php foreach ($categorias_origem as $cat): ?>
                        <option value="<?= $cat['id'] ?>" <?= $cat_origem == $cat['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($cat['category_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>

                <div class="input-group mb-3">
                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                    <input type="text" id="lupa" class="form-control" placeholder="Buscar nome...">
                </div>

                <div class="d-flex justify-content-between mb-2 small fw-bold text-muted align-items-center">
                    <label class="d-flex align-items-center cursor-pointer">
                        <input type="checkbox" id="checkAll" style="width: 16px; height: 16px; margin-right: 5px;"> Todos
                    </label>
                    <span id="badgeCount" class="badge-count"><?= count($itens) ?> itens</span>
                </div>

                <div class="list-container">
                    <?php if (empty($itens) && $cat_origem): ?>
                        <div class="text-center py-5 text-muted">Vazio.</div>
                    <?php elseif (empty($cat_origem)): ?>
                        <div class="text-center py-5 text-muted">Selecione uma categoria acima.</div>
                    <?php else: ?>
                        <?php foreach ($itens as $item): ?>
                            <label class="item-row" data-name="<?= strtolower(htmlspecialchars($item['name'])) ?>">
                                <input type="checkbox" name="selected_items[]" value="<?= $item['id'] ?>" class="item-check">
                                <span><?= htmlspecialchars($item['name']) ?></span>
                            </label>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card card-organizador p-4 text-center h-100 justify-content-center">
                <div class="mb-4">
                    <i class="fas fa-exchange-alt fa-3x text-primary mb-3"></i>
                    <h5 class="fw-bold">Para onde vai?</h5>
                    <p class="text-muted small">Escolha qualquer categoria abaixo (Canais, Filmes ou Séries).</p>
                </div>

                <div class="text-start mb-4">
                    <label class="fw-bold mb-2">Categoria de Destino (Lista Completa)</label>
                    <select name="target_category" class="form-select form-select-lg shadow-sm" required style="border: 2px solid #0d6efd;">
                        <option value="">-- Selecione o destino --</option>
                        
                        <?php foreach (['live', 'movie', 'series'] as $type_key): ?>
                            <?php if (!empty($categorias_destino_agrupadas[$type_key])): ?>
                                <optgroup label="<?= $mapa_nomes[$type_key] ?>">
                                    <?php foreach ($categorias_destino_agrupadas[$type_key] as $cat): ?>
                                        <?php if ($cat['id'] != $cat_origem): ?>
                                            <option value="<?= $cat['id'] ?>">
                                                <?= htmlspecialchars($cat['category_name']) ?>
                                            </option>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endif; ?>
                        <?php endforeach; ?>

                        <?php foreach ($categorias_destino_agrupadas as $key => $grupo): ?>
                            <?php if (!in_array($key, ['live', 'movie', 'series']) && !empty($grupo)): ?>
                                <optgroup label="Outros (<?= $key ?>)">
                                    <?php foreach ($grupo as $cat): ?>
                                        <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['category_name']) ?></option>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endif; ?>
                        <?php endforeach; ?>

                    </select>
                </div>

                <button type="button" onclick="confirmarMudanca()" class="btn btn-primary btn-lg w-100 fw-bold shadow">
                    <i class="fas fa-check-circle"></i> MOVER AGORA
                </button>
            </div>
        </div>
    </div>
    <input type="hidden" name="acao_mover" value="1">
</form>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.getElementById('lupa').addEventListener('input', function(e) {
        let t = e.target.value.toLowerCase();
        let rows = document.querySelectorAll('.item-row');
        let count = 0;
        rows.forEach(r => {
            if(r.getAttribute('data-name').includes(t)) { r.style.display = 'flex'; count++; } 
            else { r.style.display = 'none'; }
        });
        document.getElementById('badgeCount').innerText = count + ' itens';
    });

    document.getElementById('checkAll').onclick = function() {
        let isChecked = this.checked;
        document.querySelectorAll('.item-check').forEach(c => {
            if(c.closest('.item-row').style.display !== 'none') c.checked = isChecked;
        });
    }
    
    function confirmarMudanca() {
        const checks = document.querySelectorAll('.item-check:checked').length;
        const target = document.querySelector('select[name="target_category"]').value;
        if(checks === 0) { Swal.fire('Atenção', 'Selecione itens na lista esquerda.', 'warning'); return; }
        if(!target) { Swal.fire('Atenção', 'Selecione a categoria de destino na direita.', 'warning'); return; }

        Swal.fire({
            title: 'Confirmar Mover?',
            text: `Mover ${checks} itens para a nova categoria?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Sim',
            cancelButtonText: 'Não'
        }).then((res) => {
            if (res.isConfirmed) document.getElementById('formMover').submit();
        })
    }

    <?php if ($message == "success"): ?>
    Swal.fire({ icon: 'success', title: 'Sucesso!', text: 'Itens movidos.' }).then(() => { location.href = '?type=<?= $tipo_ativo ?>&cat_id=<?= $cat_origem ?>'; });
    <?php elseif ($message == "error"): ?>
    Swal.fire({ icon: 'error', title: 'Erro', text: '<?= addslashes($error_detail) ?>' });
    <?php endif; ?>
</script>


