<?php
/**
 * ORGANIZADOR IPTV INTEGRADO
 * Este arquivo abre dentro da estrutura do seu painel
 */

require 'header.php'; // Isso puxa o seu menu e sidebar oficial

// --- LÓGICA DE DADOS (Mantida) ---
require_once 'config.php';
global $pdo;

$message = "";
$error_detail = "";
$tipo_ativo = $_GET['type'] ?? 'live'; 
$map_tipo_stream = ['live' => 1, 'movie' => 2];

// 1. BUSCA CATEGORIAS
try {
    $sql_cats = "SELECT id, category_name FROM streams_categories WHERE category_type = ? ORDER BY category_name ASC";
    $stmt_cats = $pdo->prepare($sql_cats);
    $stmt_cats->execute([$tipo_ativo]);
    $categorias = $stmt_cats->fetchAll();
} catch (Exception $e) { $error_detail = $e->getMessage(); }

// 2. BUSCA CONTEÚDOS
$itens = [];
$cat_origem = $_GET['cat_id'] ?? '';

if ($cat_origem) {
    try {
        if ($tipo_ativo == 'series') {
            $stmt = $pdo->prepare("SELECT id, title as name FROM streams_series WHERE category_id = ? OR category_id LIKE ? ORDER BY title ASC");
            $stmt->execute([$cat_origem, '%"' . $cat_origem . '"%']);
        } else {
            $type_id = $map_tipo_stream[$tipo_ativo];
            $stmt = $pdo->prepare("SELECT id, stream_display_name as name FROM streams WHERE type = ? AND (category_id = ? OR category_id LIKE ?) ORDER BY stream_display_name ASC");
            $stmt->execute([$type_id, $cat_origem, '%"' . $cat_origem . '"%']);
        }
        $itens = $stmt->fetchAll();
    } catch (Exception $e) { $error_detail = $e->getMessage(); }
}

// 3. PROCESSA MOVIMENTAÇÃO
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['acao_mover'])) {
    $ids_selecionados = $_POST['selected_items'] ?? [];
    $nova_cat = $_POST['target_category'] ?? '';

    if (!empty($ids_selecionados) && !empty($nova_cat)) {
        try {
            $tabela = ($tipo_ativo == 'series') ? 'streams_series' : 'streams';
            $cat_json = '["' . $nova_cat . '"]';
            $placeholders = implode(',', array_fill(0, count($ids_selecionados), '?'));
            $sql = "UPDATE $tabela SET category_id = ? WHERE id IN ($placeholders)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute(array_merge([$cat_json], $ids_selecionados));
            $message = "success";
        } catch (PDOException $e) { $message = "error"; $error_detail = $e->getMessage(); }
    } else { $message = "empty"; }
}
?>

<style>
    /* Estilos específicos para o conteúdo interno */
    .card-organizador { background: #fff; border-radius: 8px; box-shadow: 0 0 15px rgba(0,0,0,0.05); border:none; margin-bottom: 20px; }
    .list-container { height: 450px; overflow-y: auto; background: #fff; border: 1px solid #eee; border-radius: 8px; }
    .item-row { display: flex; align-items: center; padding: 10px 15px; border-bottom: 1px solid #f8f9fa; cursor: pointer; }
    .item-row:hover { background: #f0f7ff; }
    .item-row input { margin-right: 12px; width: 18px; height: 18px; }
    .nav-custom { margin-bottom: 20px; }
    .nav-custom .btn { margin-right: 5px; font-weight: bold; border-radius: 20px; }
</style>

<div class="row">
    <div class="col-12">
        <h4 class="mb-4 text-dark fw-bold">Organizador de Conteúdo</h4>
    </div>
</div>

<div class="nav-custom">
    <a href="?type=live" class="btn <?= $tipo_ativo=='live'?'btn-primary':'btn-light border' ?>">Canais</a>
    <a href="?type=movie" class="btn <?= $tipo_ativo=='movie'?'btn-primary':'btn-light border' ?>">Filmes</a>
    <a href="?type=series" class="btn <?= $tipo_ativo=='series'?'btn-primary':'btn-light border' ?>">Séries</a>
</div>

<form method="POST">
    <div class="row">
        <div class="col-md-6">
            <div class="card card-organizador p-3">
                <label class="fw-bold mb-2">1. Selecione a Origem</label>
                <select class="form-select mb-3" onchange="location.href='?type=<?= $tipo_ativo ?>&cat_id=' + this.value">
                    <option value="">-- Escolha a Categoria --</option>
                    <?php foreach ($categorias as $cat): ?>
                        <option value="<?= $cat['id'] ?>" <?= $cat_origem == $cat['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($cat['category_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>

                <input type="text" id="lupa" class="form-control mb-3" placeholder="Filtrar por nome...">

                <div class="d-flex justify-content-between mb-2 small fw-bold text-muted">
                    <label><input type="checkbox" id="checkAll"> Selecionar Tudo</label>
                    <span id="badgeCount"><?= count($itens) ?> itens</span>
                </div>

                <div class="list-container">
                    <?php if (empty($itens)): ?>
                        <div class="text-center py-5 text-muted">Selecione uma categoria acima</div>
                    <?php else: ?>
                        <?php foreach ($itens as $item): ?>
                            <label class="item-row" data-name="<?= strtolower(htmlspecialchars($item['name'])) ?>">
                                <input type="checkbox" name="selected_items[]" value="<?= $item['id'] ?>" class="item-check">
                                <span><?= htmlspecialchars($item['name']) ?></span>
                            </label>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card card-organizador p-4 text-center">
                <div class="py-4">
                    <i class="fas fa-arrow-right fa-3x text-primary mb-3"></i>
                    <h5 class="fw-bold">Mover para onde?</h5>
                </div>

                <div class="text-start mb-4">
                    <label class="fw-bold mb-2">Categoria de Destino</label>
                    <select name="target_category" class="form-select form-select-lg" required style="border: 2px solid #0d6efd;">
                        <option value="">-- Selecione o destino --</option>
                        <?php foreach ($categorias as $cat): ?>
                            <?php if ($cat['id'] != $cat_origem): ?>
                                <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['category_name']) ?></option>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </select>
                </div>

                <button type="submit" name="acao_mover" class="btn btn-primary btn-lg w-100 fw-bold">
                    EXECUTAR MUDANÇA AGORA
                </button>
            </div>
        </div>
    </div>
</form>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // Filtro da Lupa
    document.getElementById('lupa').addEventListener('input', function(e) {
        let t = e.target.value.toLowerCase();
        let rows = document.querySelectorAll('.item-row');
        let count = 0;
        rows.forEach(r => {
            if(r.getAttribute('data-name').includes(t)) { r.style.display = 'flex'; count++; }
            else { r.style.display = 'none'; }
        });
        document.getElementById('badgeCount').innerText = count + ' itens';
    });

    // Checkbox Marcar Todos
    document.getElementById('checkAll').onclick = function() {
        document.querySelectorAll('.item-check').forEach(c => {
            if(c.closest('.item-row').style.display !== 'none') c.checked = this.checked;
        });
    }

    // Alertas de Sucesso/Erro
    <?php if ($message == "success"): ?>
    Swal.fire({ icon: 'success', title: 'Sucesso!', text: 'Conteúdo movido com sucesso.', confirmButtonColor: '#0d6efd' })
    .then(() => { location.href = '?type=<?= $tipo_ativo ?>&cat_id=<?= $cat_origem ?>'; });
    <?php elseif ($message == "empty"): ?>
    Swal.fire({ icon: 'warning', title: 'Atenção', text: 'Selecione os itens e o destino.' });
    <?php endif; ?>
</script>

<?php require 'footer.php'; ?>