<?php
// organizar_categorias.php - VERSÃO COM ADICIONAR E EXCLUIR

// O arquivo de configuração PRECISA vir primeiro
require 'config.php'; 

// Segurança: Apenas Admin
$grupo = $_SESSION['group_id'] ?? 0;

// ====================================================================
// --- BLOCO AJAX (SALVAR, ADICIONAR, EXCLUIR) ---
// ====================================================================
if (isset($_POST['action'])) {
    // Limpa buffer para evitar erros no JSON/Texto
    if (ob_get_length()) ob_clean(); 
    
    // Verifica segurança novamente
    if ($grupo != 1) { echo "erro: Acesso negado."; exit; }

    // 1. SALVAR ORDEM
    if ($_POST['action'] == 'salvar_ordem') {
        $ordem = $_POST['ordem'];
        if (is_array($ordem)) {
            $pdo->beginTransaction();
            try {
                $sql = "UPDATE streams_categories SET cat_order = ? WHERE id = ?";
                $stmt = $pdo->prepare($sql);
                foreach ($ordem as $posicao => $id_cat) {
                    $stmt->execute([$posicao, $id_cat]);
                }
                $pdo->commit();
                echo "sucesso";
            } catch (Exception $e) {
                $pdo->rollBack();
                echo "erro: " . $e->getMessage();
            }
        }
        exit;
    }

    // 2. ADICIONAR CATEGORIA
    if ($_POST['action'] == 'adicionar_categoria') {
        $nome = trim($_POST['nome']);
        $tipo = $_POST['tipo']; // live, movie, series

        if(empty($nome) || empty($tipo)) { echo "erro: Preencha todos os campos."; exit; }

        try {
            // Define uma ordem alta (99999) para ir para o final da lista
            $sql = "INSERT INTO streams_categories (category_name, category_type, cat_order) VALUES (?, ?, 99999)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$nome, $tipo]);
            echo "sucesso";
        } catch (Exception $e) {
            echo "erro: " . $e->getMessage();
        }
        exit;
    }

    // 3. EXCLUIR CATEGORIA
    if ($_POST['action'] == 'excluir_categoria') {
        $id = (int)$_POST['id'];
        
        try {
            // Opcional: Verificar se tem canais dentro antes de apagar
            // $count = $pdo->query("SELECT count(*) FROM streams WHERE category_id = $id")->fetchColumn();
            // if($count > 0) { echo "erro: Esta categoria não está vazia."; exit; }

            $stmt = $pdo->prepare("DELETE FROM streams_categories WHERE id = ?");
            $stmt->execute([$id]);
            echo "sucesso";
        } catch (Exception $e) {
            echo "erro: " . $e->getMessage();
        }
        exit;
    }
}
// ====================================================================

// Redireciona se não for admin (após processar AJAX)
if ($grupo != 1) { echo "<script>window.location='index.php';</script>"; exit; }

require 'header.php';

// --- BUSCAR CATEGORIAS ---
$sql = "SELECT id, category_name, category_type FROM streams_categories ORDER BY cat_order ASC";
$todas = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

$cats_live = [];
$cats_movie = [];
$cats_series = [];

foreach($todas as $c) {
    $tipo = strtolower($c['category_type']);
    if($tipo == 'live') { $cats_live[] = $c; }
    elseif($tipo == 'movie') { $cats_movie[] = $c; }
    elseif($tipo == 'series') { $cats_series[] = $c; }
}
?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js"></script>

<style>
    .k-card { background: #fff; border-radius: 12px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 20px; }
    
    .sortable-list { list-style: none; padding: 0; margin: 0; }
    .sortable-item {
        background: #fff;
        border: 1px solid #eee;
        padding: 12px 15px;
        margin-bottom: 8px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        transition: transform 0.2s, box-shadow 0.2s;
    }
    .sortable-item:hover { border-color: #0d6efd; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
    .sortable-ghost { opacity: 0.4; background: #cce5ff; border: 2px dashed #0d6efd; }
    
    .handle { color: #ccc; margin-right: 15px; cursor: grab; padding: 5px; }
    .sortable-item:hover .handle { color: #0d6efd; }

    /* Botão Excluir */
    .btn-del-cat {
        color: #dc3545;
        background: rgba(220, 53, 69, 0.1);
        border: none;
        width: 32px;
        height: 32px;
        border-radius: 6px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: 0.2s;
        margin-left: 10px;
        cursor: pointer;
    }
    .btn-del-cat:hover { background: #dc3545; color: #fff; }

    /* Abas e Botões */
    .nav-pills .nav-link { border-radius: 50px; padding: 10px 25px; font-weight: bold; color: #555; background: #fff; border: 1px solid #eee; margin-right: 10px; }
    .nav-pills .nav-link.active { background-color: #0d6efd; color: #fff; border-color: #0d6efd; }
    
    .btn-save-float { position: fixed; bottom: 20px; right: 20px; z-index: 1000; border-radius: 50px; padding: 15px 30px; box-shadow: 0 4px 15px rgba(0,0,0,0.3); display: none; }
</style>

<div class="container-fluid pb-5">
    
    <div class="d-flex justify-content-between align-items-center mb-4 mt-2">
        <div>
            <h4 class="fw-bold mb-0 text-dark">Gerenciar Categorias</h4>
            <small class="text-muted">Adicione, exclua ou arraste para organizar.</small>
        </div>
        <div>
            <button class="btn btn-primary fw-bold shadow-sm me-2" data-bs-toggle="modal" data-bs-target="#modalAdd" onclick="prepararModal()">
                <i class="fas fa-plus me-2"></i> NOVA CATEGORIA
            </button>
            <button id="btnSalvarTopo" class="btn btn-success fw-bold shadow-sm" onclick="salvarOrdem()" disabled>
                <i class="fas fa-save me-2"></i> SALVAR ORDEM
            </button>
        </div>
    </div>

    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#pills-live" type="button" onclick="mudouAba('live')">
                📺 Canais (<?= count($cats_live) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-movie" type="button" onclick="mudouAba('movie')">
                🎬 Filmes (<?= count($cats_movie) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-series" type="button" onclick="mudouAba('series')">
                🍿 Séries (<?= count($cats_series) ?>)
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        <div class="tab-pane fade show active" id="pills-live">
            <div id="list-live" class="sortable-list"><?php renderLista($cats_live); ?></div>
        </div>
        <div class="tab-pane fade" id="pills-movie">
            <div id="list-movie" class="sortable-list"><?php renderLista($cats_movie); ?></div>
        </div>
        <div class="tab-pane fade" id="pills-series">
            <div id="list-series" class="sortable-list"><?php renderLista($cats_series); ?></div>
        </div>
    </div>
</div>

<button id="btnSalvarFloat" class="btn btn-success btn-save-float fw-bold" onclick="salvarOrdem()">
    <i class="fas fa-save me-2"></i> SALVAR ORDEM
</button>

<div class="modal fade" id="modalAdd" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold"><i class="fas fa-folder-plus me-2"></i>Nova Categoria</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="formAddCat">
                    <div class="mb-3">
                        <label class="fw-bold mb-1">Nome da Categoria</label>
                        <input type="text" id="catNome" class="form-control" placeholder="Ex: Filmes de Ação" required>
                    </div>
                    <div class="mb-3">
                        <label class="fw-bold mb-1">Tipo</label>
                        <select id="catTipo" class="form-select">
                            <option value="live">📺 Canais (Live)</option>
                            <option value="movie">🎬 Filmes (Movie)</option>
                            <option value="series">🍿 Séries (Series)</option>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success fw-bold" onclick="adicionarCategoria()">Salvar</button>
            </div>
        </div>
    </div>
</div>

<?php
// Função auxiliar para renderizar HTML das listas
function renderLista($categorias) {
    if(empty($categorias)) {
        echo "<div class='text-center py-5 text-muted'>Nenhuma categoria encontrada neste grupo.</div>";
        return;
    }
    foreach($categorias as $c) {
        echo '
        <div class="sortable-item" data-id="'.$c['id'].'">
            <i class="fas fa-grip-vertical handle fa-lg"></i>
            <span class="fw-bold text-dark flex-grow-1">'.$c['category_name'].'</span>
            <small class="text-muted me-3">ID: '.$c['id'].'</small>
            
            <button class="btn-del-cat" onclick="excluirCategoria('.$c['id'].', \''.addslashes($c['category_name']).'\')" title="Excluir">
                <i class="fas fa-trash"></i>
            </button>
        </div>';
    }
}
?>

<script>
    var abaAtiva = 'live';
    
    function mudouAba(aba) {
        abaAtiva = aba;
    }

    // Inicializa Sortable
    ['list-live', 'list-movie', 'list-series'].forEach(id => {
        var el = document.getElementById(id);
        if(el){
            new Sortable(el, {
                animation: 150,
                handle: '.handle',
                ghostClass: 'sortable-ghost',
                onEnd: function() {
                    document.getElementById('btnSalvarTopo').disabled = false;
                    document.getElementById('btnSalvarFloat').style.display = 'block';
                }
            });
        }
    });

    // --- FUNÇÕES AJAX ---

    function salvarOrdem() {
        var listaID = 'list-' + abaAtiva;
        var container = document.getElementById(listaID);
        var itens = container.getElementsByClassName('sortable-item');
        var ordemArray = [];

        for (var i = 0; i < itens.length; i++) {
            ordemArray.push(itens[i].getAttribute('data-id'));
        }

        var btn = document.getElementById('btnSalvarTopo');
        var txtOriginal = btn.innerHTML;
        btn.innerHTML = 'Salvando...'; btn.disabled = true;

        $.post('organizar_categorias.php', {
            action: 'salvar_ordem',
            ordem: ordemArray
        }, function(res) {
            if(res.trim() == 'sucesso') {
                btn.innerHTML = 'Salvo!';
                setTimeout(() => { 
                    btn.innerHTML = txtOriginal; 
                    document.getElementById('btnSalvarFloat').style.display = 'none';
                }, 1500);
            } else {
                alert('Erro: ' + res);
                btn.innerHTML = txtOriginal; btn.disabled = false;
            }
        });
    }

    function prepararModal() {
        // Seleciona automaticamente o tipo baseado na aba que o user está vendo
        document.getElementById('catTipo').value = abaAtiva;
        document.getElementById('catNome').value = '';
        setTimeout(() => { document.getElementById('catNome').focus(); }, 500);
    }

    function adicionarCategoria() {
        var nome = document.getElementById('catNome').value;
        var tipo = document.getElementById('catTipo').value;

        if(!nome) { alert("Digite o nome da categoria."); return; }

        $.post('organizar_categorias.php', {
            action: 'adicionar_categoria',
            nome: nome,
            tipo: tipo
        }, function(res) {
            if(res.trim() == 'sucesso') {
                location.reload(); // Recarrega para mostrar a nova categoria
            } else {
                alert('Erro ao adicionar: ' + res);
            }
        });
    }

    function excluirCategoria(id, nome) {
        if(confirm('Tem certeza que deseja EXCLUIR a categoria: "' + nome + '"?\n\nIsso não apaga os canais, mas eles ficarão sem categoria.')) {
            $.post('organizar_categorias.php', {
                action: 'excluir_categoria',
                id: id
            }, function(res) {
                if(res.trim() == 'sucesso') {
                    // Remove visualmente ou recarrega
                    // Recarregar é mais seguro para garantir sincronia
                    location.reload();
                } else {
                    alert('Erro ao excluir: ' + res);
                }
            });
        }
    }
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
