<?php
// organizar_categorias.php - VERSÃO CORRIGIDA E ESTÁVEL

// O arquivo de configuração PRECISA vir primeiro
require 'config.php'; 

// Segurança: Apenas Admin
$grupo = $_SESSION['group_id'] ?? 0;
// NÃO SAI AQUI, pois o AJAX precisa ser processado antes

// ====================================================================
// --- SALVAR ORDEM (AJAX) - BLOCO MOVIDO PARA O TOPO ABSOLUTO ---
// ====================================================================
if (isset($_POST['action']) && $_POST['action'] == 'salvar_ordem') {
    // Garante que nenhuma saída HTML (como warnings) seja enviada
    if (ob_get_length()) ob_clean(); 
    
    // Verifica a segurança do usuário novamente
    if ($grupo != 1) { 
        echo "erro: Acesso negado. Apenas administradores podem reordenar."; 
        exit;
    }
    
    $ordem = $_POST['ordem']; // Array com IDs na nova sequência
    
    if (is_array($ordem)) {
        $sql = "UPDATE streams_categories SET cat_order = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        
        $pdo->beginTransaction(); // Inicia transação para garantir que tudo seja salvo
        
        try {
            foreach ($ordem as $posicao => $id_cat) {
                // A posição no array vira o novo cat_order (0, 1, 2...)
                $stmt->execute([$posicao, $id_cat]);
            }
            $pdo->commit(); // Confirma as alterações
            echo "sucesso";
        } catch (Exception $e) {
            $pdo->rollBack(); // Volta ao estado anterior em caso de erro
            echo "erro: Falha no banco de dados. " . $e->getMessage();
        }
        
    } else {
         echo "erro: Dados de ordem inválidos.";
    }
    exit; // <--- OBRIGATÓRIO: Termina o script aqui para o AJAX
}
// ====================================================================

// Sai se não for Admin APÓS o AJAX ter sido verificado
if ($grupo != 1) { echo "<script>window.location='index.php';</script>"; exit; }

// --- CARREGA O HEADER PARA O RESTO DA PÁGINA ---
require 'header.php';

// --- BUSCAR CATEGORIAS (Bloco de listagem) ---
// Ordena por cat_order para mostrar como está hoje
$sql = "SELECT id, category_name, category_type FROM streams_categories ORDER BY cat_order ASC";
$todas = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

$cats_live = [];
$cats_movie = [];
$cats_series = [];

foreach($todas as $c) {
    $tipo = strtolower($c['category_type']);
    if($tipo == 'live') { $cats_live[] = $c; }
    elseif($tipo == 'movie') { $cats_movie[] = $c; }
    elseif($tipo == 'series') { $cats_series[] = $c; }
}
?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/Sortable/1.15.0/Sortable.min.js"></script>

<style>
    .k-card { background: #fff; border-radius: 12px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); border: none; overflow: hidden; margin-bottom: 20px; }
    
    /* Item da Lista */
    .sortable-list { list-style: none; padding: 0; margin: 0; }
    .sortable-item {
        background: #fff;
        border: 1px solid #eee;
        padding: 15px;
        margin-bottom: 8px;
        border-radius: 8px;
        cursor: grab;
        display: flex;
        align-items: center;
        transition: transform 0.2s, box-shadow 0.2s;
    }
    .sortable-item:hover { border-color: #0d6efd; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
    .sortable-item:active { cursor: grabbing; background: #f8f9fa; }
    
    /* Classe adicionada enquanto arrasta (ghost) */
    .sortable-ghost { opacity: 0.4; background: #cce5ff; border: 2px dashed #0d6efd; }
    
    .handle { color: #ccc; margin-right: 15px; cursor: grab; }
    .sortable-item:hover .handle { color: #0d6efd; }

    /* Abas */
    .nav-pills .nav-link { border-radius: 50px; padding: 10px 25px; font-weight: bold; color: #555; background: #fff; border: 1px solid #eee; margin-right: 10px; }
    .nav-pills .nav-link.active { background-color: #0d6efd; color: #fff; border-color: #0d6efd; }
    
    /* Botão Flutuante Salvar (Mobile Friendly) */
    .btn-save-float {
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 1000;
        border-radius: 50px;
        padding: 15px 30px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.3);
        display: none; /* Aparece só quando mexer */
    }
</style>

<div class="container-fluid pb-5">
    
    <div class="d-flex justify-content-between align-items-center mb-4 mt-2">
        <div>
            <h4 class="fw-bold mb-0 text-dark">Organizador de Categorias</h4>
            <small class="text-muted">Arraste para reordenar e clique em Salvar</small>
        </div>
        <button id="btnSalvarTopo" class="btn btn-success fw-bold px-4 shadow-sm" onclick="salvarOrdem()" disabled>
            <i class="fas fa-save me-2"></i> SALVAR MUDANÇAS
        </button>
    </div>

    <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="pill" data-bs-target="#pills-live" type="button" onclick="mudouAba('live')">
                📺 Canais (<?= count($cats_live) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-movie" type="button" onclick="mudouAba('movie')">
                🎬 Filmes (<?= count($cats_movie) ?>)
            </button>
        </li>
        <li class="nav-item">
            <button class="nav-link" data-bs-toggle="pill" data-bs-target="#pills-series" type="button" onclick="mudouAba('series')">
                🍿 Séries (<?= count($cats_series) ?>)
            </button>
        </li>
    </ul>

    <div class="tab-content" id="pills-tabContent">
        
        <div class="tab-pane fade show active" id="pills-live">
            <div id="list-live" class="sortable-list">
                <?php renderLista($cats_live); ?>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-movie">
            <div id="list-movie" class="sortable-list">
                <?php renderLista($cats_movie); ?>
            </div>
        </div>

        <div class="tab-pane fade" id="pills-series">
            <div id="list-series" class="sortable-list">
                <?php renderLista($cats_series); ?>
            </div>
        </div>

    </div>
</div>

<button id="btnSalvarFloat" class="btn btn-success btn-save-float fw-bold" onclick="salvarOrdem()">
    <i class="fas fa-save me-2"></i> SALVAR ORDEM
</button>

<?php
function renderLista($categorias) {
    if(empty($categorias)) {
        echo "<div class='text-center py-5 text-muted'>Nenhuma categoria encontrada.</div>";
        return;
    }
    foreach($categorias as $c) {
        echo '
        <div class="sortable-item" data-id="'.$c['id'].'">
            <i class="fas fa-grip-vertical handle fa-lg"></i>
            <span class="fw-bold text-dark">'.$c['category_name'].'</span>
            <small class="ms-auto text-muted">ID: '.$c['id'].'</small>
        </div>';
    }
}
?>

<script>
    // Variável para saber qual aba está ativa
    var abaAtiva = 'live';
    
    function mudouAba(aba) {
        abaAtiva = aba;
    }

    // Inicializa o Sortable para as 3 listas
    ['list-live', 'list-movie', 'list-series'].forEach(id => {
        var el = document.getElementById(id);
        if(el){
            new Sortable(el, {
                animation: 150,
                handle: '.handle', // Só arrasta se pegar no ícone
                ghostClass: 'sortable-ghost',
                onEnd: function() {
                    // Ativa os botões de salvar quando houver mudança
                    document.getElementById('btnSalvarTopo').disabled = false;
                    document.getElementById('btnSalvarFloat').style.display = 'block';
                }
            });
        }
    });

    function salvarOrdem() {
        var listaID = 'list-' + abaAtiva;
        var container = document.getElementById(listaID);
        var itens = container.getElementsByClassName('sortable-item');
        var ordemArray = [];

        // Captura os IDs na nova ordem
        for (var i = 0; i < itens.length; i++) {
            ordemArray.push(itens[i].getAttribute('data-id'));
        }

        // Feedback Visual
        var btnTopo = document.getElementById('btnSalvarTopo');
        var btnFloat = document.getElementById('btnSalvarFloat');
        var textoOriginal = btnTopo.innerHTML;
        
        btnTopo.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Salvando...';
        btnTopo.disabled = true;

        // Envia via AJAX
        $.post('organizar_categorias.php', {
            action: 'salvar_ordem',
            ordem: ordemArray
        }, function(response) {
            // Verifica se a resposta contém "sucesso" (ignorando espaços ou quebras de linha)
            if(response.trim() == 'sucesso') {
                // Sucesso
                btnTopo.innerHTML = '<i class="fas fa-check me-2"></i> Salvo!';
                btnTopo.classList.remove('btn-success');
                btnTopo.classList.add('btn-dark');
                
                setTimeout(function(){
                    btnTopo.innerHTML = textoOriginal;
                    btnTopo.classList.add('btn-success');
                    btnTopo.classList.remove('btn-dark');
                    btnTopo.disabled = true; // Desabilita até próxima mexida
                    btnFloat.style.display = 'none';
                }, 2000);
            } else {
                // Erro: Mostra o erro do PHP na tela
                alert('Erro ao salvar. Verifique o console do navegador ou o log do servidor. Resposta do servidor: ' + response.trim());
                btnTopo.innerHTML = textoOriginal;
                btnTopo.disabled = false;
            }
        });
    }
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
