<?php
// play.php - VERSÃO HÍBRIDA (Compatibilidade Máxima)
// Foca em resolver APENAS o que trava o player, sem estragar o link do servidor.

// 1. Limpa qualquer lixo de memória
while (ob_get_level()) { ob_end_clean(); }

// 2. Headers essenciais para enganar o Player
header("Access-Control-Allow-Origin: *");
header("Connection: close");
header("Content-Type: video/mp4"); // Diz pro player que é vídeo antes mesmo de redirecionar

// --- CONEXÃO BANCO ---
$host = 'localhost';
$db   = 'xui'; 
$user = 'banco_xuione'; 
$pass = 'chocolate'; 

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (Exception $e) { http_response_code(500); die(); }

// 3. Pega ID
$id = (int)($_GET['id'] ?? 0);
if ($id === 0 && preg_match('/\/(\d+)\./', $_SERVER['REQUEST_URI'], $matches)) {
    $id = (int)$matches[1];
}
if ($id === 0) { http_response_code(404); die(); }

// 4. Busca link
$stmt = $pdo->prepare("SELECT stream_source FROM streams WHERE id = ? LIMIT 1");
$stmt->execute([$id]);
$source = $stmt->fetchColumn();

if (!$source) { http_response_code(404); die(); }

// --- TRATAMENTO INTELIGENTE ---

$link = "";

// Limpa JSON ou Arrays
$decoded = json_decode($source, true);
if (is_array($decoded) && isset($decoded[0])) {
    $link = $decoded[0];
} else {
    $clean = str_replace(['[', ']', '"'], '', $source);
    $clean = str_replace('\\', '/', $clean); // Corrige barras invertidas
    $parts = explode(',', $clean);
    $link = trim($parts[0]);
}

$link = trim($link);
if (empty($link)) { http_response_code(404); die(); }

// 1. PREVINE DUPLA CODIFICAÇÃO (O erro mais comum)
// Se o link já estiver como "Esquadrao%20Implacavel", o urldecode volta para o normal.
$link = urldecode($link);

// 2. CODIFICAÇÃO PARCIAL (A Mágica)
// Codificamos APENAS espaços e caracteres perigosos, mas DEIXAMOS OS PARÊNTESES.
// Navegadores e Players modernos preferem assim.
$mapa_seguro = [
    ' ' => '%20',
    '[' => '%5B',
    ']' => '%5D',
    '"' => '%22',
    "'" => '%27',
    '+' => '%2B',
    // NÃO COLOCAMOS ( nem ) AQUI. Deixamos eles originais.
];

// Aplica a correção segura
$link = strtr($link, $mapa_seguro);

// 3. CHECAGEM DE PROTOCOLO
// Se o link original era HTTPS, mantemos. Se o player reclamar, ele tenta HTTP sozinho.
if (strpos($link, 'http') !== 0) {
    $link = "http://" . $link;
}

// 4. ENVIA O REDIRECIONAMENTO 302 (Found)
// Usamos 302 porque é temporário e força o player a baixar o cabeçalho de novo
header("Location: " . $link, true, 302);
exit;
?>