<?php
require_once 'config.php';
header('Content-Type: application/json');

$nome = $_POST['nome'] ?? '';
$link = $_POST['link'] ?? '';
$cat_m3u_nome = $_POST['cat_m3u'] ?? ''; 
$api_key = $_POST['api_key'] ?? '';

if (!$nome || !$link || !$cat_m3u_nome) {
    echo json_encode(['status' => 'error', 'message' => 'Dados incompletos']);
    exit;
}

try {
    // 1. VERIFICAR OU CRIAR CATEGORIA
    $stmt_cat = $pdo->prepare("SELECT id FROM streams_categories WHERE category_name = ? LIMIT 1");
    $stmt_cat->execute([$cat_m3u_nome]);
    $categoria = $stmt_cat->fetch();

    if ($categoria) {
        $cat_id_final = $categoria['id'];
    } else {
        $ins_cat = $pdo->prepare("INSERT INTO streams_categories (category_name, category_type) VALUES (?, 'movie')");
        $ins_cat->execute([$cat_m3u_nome]);
        $cat_id_final = $pdo->lastInsertId();
    }

    // 2. VERIFICAR DUPLICIDADE
    $stmt_check = $pdo->prepare("SELECT id FROM streams WHERE stream_source = ? LIMIT 1");
    $stmt_check->execute([$link]);
    if ($stmt_check->fetch()) {
        echo json_encode(['status' => 'exists']);
        exit;
    }

    // 3. TMDB
    $clean_name = preg_replace('/[^a-zA-Z0-9 ]/', '', $nome);
    $url = "https://api.themoviedb.org/3/search/movie?api_key=$api_key&language=pt-BR&query=" . urlencode($clean_name);
    $res = @file_get_contents($url);
    $movie_data = $res ? json_decode($res, true)['results'][0] ?? null : null;

    $capa = $movie_data ? "https://image.tmdb.org/t/p/w500" . $movie_data['poster_path'] : "";
    $sinopse = $movie_data ? $movie_data['overview'] : "Importado automaticamente.";

    // 4. INSERÇÃO COM CAMPOS DE VISIBILIDADE (Ajustado para XUI)
    // Adicionamos 'stream_all' = 1 e garantimos que o 'added' seja o timestamp atual
    $sql = "INSERT INTO streams (
                type, 
                category_id, 
                stream_display_name, 
                stream_source, 
                stream_icon, 
                notes, 
                added,
                read_native,
                stream_all
            ) VALUES (2, ?, ?, ?, ?, ?, ?, 1, 1)";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        '["'.$cat_id_final.'"]',
        $nome,
        $link,
        $capa,
        $sinopse,
        time()
    ]);

    echo json_encode(['status' => 'success', 'tmdb' => (bool)$movie_data]);

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}