<?php
// Arquivo: processar_lista.php
// Versão: 6.0 "VLC Mode" - Simula um Player real para enganar o Firewall
require 'config.php';
session_start();

// 1. Verifica Permissão
if (!isset($_SESSION['group_id']) || $_SESSION['group_id'] != 1) {
    echo json_encode(['erro' => 'Acesso negado.']);
    exit;
}

set_time_limit(0); 
ini_set('memory_limit', '-1');
error_reporting(0);

// --- FUNÇÃO DE DOWNLOAD QUE IMITA O VLC ---
function baixarLinkVLC($url) {
    // A. LIMPEZA DA URL (Corrige o erro &amp;)
    $url = trim($url);
    $url = htmlspecialchars_decode($url); // Converte &amp; para &
    $url = str_replace(' ', '%20', $url); // Remove espaços

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
    
    // B. SEGURANÇA SSL (Ignora erros de certificado)
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    
    // C. O SEGREDO: User-Agent do VLC (Engana o firewall)
    // Muitos servidores bloqueiam "Mozilla" (Navegador), mas aceitam "VLC"
    curl_setopt($ch, CURLOPT_USERAGENT, 'VLC/3.0.18 LibVLC/3.0.18');
    
    // D. TEMPO
    curl_setopt($ch, CURLOPT_TIMEOUT, 180);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);

    $data = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $erro = curl_error($ch);
    curl_close($ch);

    // E. TENTATIVA SECUNDÁRIA (Se falhar como VLC, tenta como Navegador)
    if (empty($data) || $http_code >= 400) {
        $ch2 = curl_init();
        curl_setopt($ch2, CURLOPT_URL, $url);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch2, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'); // Tenta como Chrome
        $data = curl_exec($ch2);
        curl_close($ch2);
    }

    // F. VERIFICAÇÃO FINAL
    if (empty($data) || strlen($data) < 50) {
        return ['sucesso' => false, 'msg' => "O servidor conectou mas não enviou dados. Possível bloqueio de IP ou Lista Vazia."];
    }

    return ['sucesso' => true, 'dados' => $data];
}

$conteudo = "";

// 2. RECEBE O CONTEÚDO
if (!empty($_FILES['file_m3u']['tmp_name'])) {
    $conteudo = file_get_contents($_FILES['file_m3u']['tmp_name']);
} 
elseif (!empty($_POST['url_m3u'])) {
    $resultado = baixarLinkVLC($_POST['url_m3u']);
    if (!$resultado['sucesso']) {
        echo json_encode(['erro' => $resultado['msg']]);
        exit;
    }
    $conteudo = $resultado['dados'];
} else {
    echo json_encode(['erro' => 'Nada enviado.']);
    exit;
}

// 3. PROCESSAMENTO (PARSER M3U)
$conteudo = str_replace(["\r\n", "\r"], "\n", $conteudo);
$linhas = explode("\n", $conteudo);

$categorias_final = [];
$item_temp = [];

// Validação Mínima
if (count($linhas) < 2) {
    echo json_encode(['erro' => 'O arquivo baixado não parece ser uma lista M3U válida (muito curto).']);
    exit;
}

foreach ($linhas as $linha) {
    $linha = trim($linha);
    if (empty($linha)) continue;

    if (stripos($linha, '#EXTINF') === 0) {
        // Categoria
        $categoria = 'SEM CATEGORIA';
        if (preg_match('/group-title=["\'](.*?)["\']/', $linha, $m)) {
            $categoria = $m[1];
        }

        // Logo
        $logo = '';
        if (preg_match('/tvg-logo=["\'](.*?)["\']/', $linha, $m)) {
            $logo = $m[1];
        }

        // Nome
        $partes = explode(',', $linha);
        $nome = end($partes);

        $item_temp = ['name' => trim($nome), 'logo' => trim($logo), 'cat' => trim($categoria)];
    }
    elseif (strpos($linha, '#') !== 0 && !empty($item_temp)) {
        $url_stream = $linha;
        $cat_nome = $item_temp['cat'];

        // Tipo (VOD/LIVE)
        $tipo = 'LIVE';
        $ext = strtolower(pathinfo(parse_url($url_stream, PHP_URL_PATH), PATHINFO_EXTENSION));
        
        if (in_array($ext, ['mp4', 'mkv', 'avi', 'mov'])) $tipo = 'VOD';
        if (stripos($cat_nome, 'FILME') !== false || stripos($cat_nome, 'MOVIE') !== false || stripos($cat_nome, 'SERIE') !== false) {
            $tipo = 'VOD';
        }

        $categorias_final[$cat_nome][] = [
            'name' => $item_temp['name'],
            'url'  => $url_stream,
            'logo' => $item_temp['logo'],
            'type' => $tipo
        ];
        $item_temp = [];
    }
}

if (empty($categorias_final)) {
    echo json_encode(['erro' => 'Lista baixada, mas nenhum canal foi identificado. Verifique o formato M3U.']);
    exit;
}

// 4. SALVA TEMP
$nome_arquivo_temp = 'temp_import_' . time() . '.json';
if (file_put_contents($nome_arquivo_temp, json_encode($categorias_final, JSON_PRETTY_PRINT))) {
    $resumo = [];
    foreach ($categorias_final as $cat => $itens) {
        $resumo[$cat] = ['qtd' => count($itens), 'tipo' => $itens[0]['type']];
    }
    echo json_encode(['sucesso' => true, 'categorias' => $resumo, 'temp_file' => $nome_arquivo_temp]);
} else {
    echo json_encode(['erro' => 'Erro ao salvar arquivo temporário.']);
}
?>
