<?php
// processar_lista.php - CORRIGIDO PARA DETECTAR SÉRIES PELA CATEGORIA
session_start();
ini_set('memory_limit', '1024M');
set_time_limit(300);

// Verifica Admin
if (($_SESSION['group_id'] ?? 0) != 1) exit(json_encode(['erro' => 'Acesso negado']));

$conteudo = "";

// 1. Receber M3U
if (!empty($_FILES['file_m3u']['tmp_name'])) {
    $conteudo = file_get_contents($_FILES['file_m3u']['tmp_name']);
} elseif (!empty($_POST['url_m3u'])) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $_POST['url_m3u']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    $conteudo = curl_exec($ch);
    curl_close($ch);
} else {
    exit(json_encode(['erro' => 'Nenhum arquivo ou link fornecido.']));
}

if (empty($conteudo)) exit(json_encode(['erro' => 'Arquivo vazio ou inválido.']));

// 2. Processar
$conteudo = str_replace("\r", "", $conteudo);
$linhas = explode("\n", $conteudo);
$categorias = [];
$itens_temp = [];

foreach ($linhas as $index => $linha) {
    if (strpos($linha, '#EXTINF') === 0) {
        
        // Pega Categoria
        preg_match('/group-title="([^"]+)"/', $linha, $matches);
        $cat = isset($matches[1]) ? trim($matches[1]) : 'SEM CATEGORIA';
        
        // Pega Nome e Logo
        preg_match('/tvg-name="([^"]+)"/', $linha, $nomeMatch);
        preg_match('/tvg-logo="([^"]+)"/', $linha, $logoMatch);
        $nomeExplode = explode(',', $linha);
        $nome = isset($nomeMatch[1]) ? $nomeMatch[1] : end($nomeExplode);
        $nome = trim($nome);
        $logo = isset($logoMatch[1]) ? $logoMatch[1] : '';

        // Pega Link
        $link = isset($linhas[$index+1]) ? trim($linhas[$index+1]) : '';

        // --- LÓGICA DE DETECÇÃO DE TIPO (CORRIGIDA) ---
        $tipo = 'LIVE'; // Padrão
        
        // 1. Se tem extensão de vídeo, é VOD ou SÉRIE
        if (preg_match('/\.(mkv|mp4|avi|mov|ts)$/i', $link)) {
            $tipo = 'VOD';
        }

        // 2. Se a CATEGORIA tem "SERIE" ou "SERIES", força SÉRIE
        if (stripos($cat, 'SERIE') !== false || stripos($cat, 'SÉRIE') !== false) {
            $tipo = 'SERIES';
        }
        
        // 3. Se o NOME tem S01E01, força SÉRIE (mesmo se categoria não disser)
        if (preg_match('/S\d+E\d+/i', $nome)) {
            $tipo = 'SERIES';
        }

        // Contabiliza
        if (!isset($categorias[$cat])) {
            $categorias[$cat] = ['qtd' => 0, 'tipo' => $tipo];
        }
        $categorias[$cat]['qtd']++;

        $itens_temp[] = [
            'cat' => $cat,
            'nome' => $nome,
            'logo' => $logo,
            'link' => $link,
            'tipo' => $tipo
        ];
    }
}

// Salva Temp
if (!is_dir('uploads')) { mkdir('uploads', 0777, true); }
$nome_temp = 'temp_' . time() . '.json';
file_put_contents('uploads/' . $nome_temp, json_encode($itens_temp));

echo json_encode(['categorias' => $categorias, 'temp_file' => $nome_temp]);
?>