<?php
// processar_tmdb.php - ATUALIZADO
require 'config.php';

// Configurações para evitar travamentos
set_time_limit(0); 
ini_set('memory_limit', '1024M');
header('Content-Type: application/json');

// --- CONFIGURAÇÃO ---
$api_key = 'f99aa9ae1fe7619969cc7db0938c1ae5'; // <--- SUA CHAVE
$lang = 'pt-BR';
$limite_por_vez = 50; // Processa 50 por vez

$tipo = $_POST['tipo'] ?? 'movies';

// Função de Log
function logMsg($msg, $classe = 'text-white') {
    $linha = "<div class='$classe'>[" . date('H:i:s') . "] $msg</div>\n";
    file_put_contents('log_tmdb.txt', $linha, FILE_APPEND);
}

if (isset($_POST['limpar_log']) && $_POST['limpar_log'] == '1') {
    file_put_contents('log_tmdb.txt', "");
}

function limparNome($nome) {
    $nome = preg_replace('/\.(mp4|mkv|avi|ts|m3u8)$/i', '', $nome);
    $lixo = ['/FHD/i', '/HD/i', '/4K/i', '/1080p/i', '/720p/i', '/DUBLADO/i', '/LEGENDADO/i', '/S\d+E\d+/i', '/\d+x\d+/i'];
    $nome = preg_replace($lixo, '', $nome);
    $nome = str_replace(['.', '_', '-', '(', ')', '[', ']', '{', '}'], ' ', $nome);
    return trim($nome);
}

function buscarTMDB($titulo, $tipo_busca, $key, $lang) {
    $titulo_url = urlencode($titulo);
    $url = "https://api.themoviedb.org/3/search/$tipo_busca?api_key=$key&query=$titulo_url&language=$lang&page=1";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $res = curl_exec($ch);
    curl_close($ch);
    
    $json = json_decode($res, true);
    return !empty($json['results'][0]) ? $json['results'][0] : false;
}

$atualizados = 0;

try {
    // FILMES
    if ($tipo == 'movies') {
        $sql = "SELECT id, stream_display_name FROM streams WHERE type = 2 AND (stream_icon IS NULL OR stream_icon = '' OR stream_icon LIKE '%via.placeholder%') LIMIT $limite_por_vez";
        $stmt = $pdo->query($sql);
        $itens = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($itens as $filme) {
            $nome_limpo = limparNome($filme['stream_display_name']);
            $dados = buscarTMDB($nome_limpo, 'movie', $api_key, $lang);

            if ($dados) {
                $capa = "https://image.tmdb.org/t/p/w600_and_h900_bestv2" . $dados['poster_path'];
                $nota = $dados['vote_average'];
                $pdo->prepare("UPDATE streams SET stream_icon = ?, rating = ? WHERE id = ?")->execute([$capa, $nota, $filme['id']]);
                logMsg("Filme OK: <b>{$filme['stream_display_name']}</b>", "text-success");
                $atualizados++;
            } else {
                $pdo->prepare("UPDATE streams SET stream_icon = 'https://via.placeholder.com/600x900?text=Sem+Capa' WHERE id = ?")->execute([$filme['id']]);
                logMsg("Não achou: $nome_limpo", "text-secondary");
            }
            usleep(100000); // 0.1s pausa
        }

    } 
    // SÉRIES (Apenas a casca, ignora episódios)
    else {
        $sql = "SELECT id, title FROM streams_series WHERE (cover IS NULL OR cover = '' OR cover LIKE '%via.placeholder%') OR (plot IS NULL OR plot = '') LIMIT $limite_por_vez";
        $stmt = $pdo->query($sql);
        $itens = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($itens as $serie) {
            $nome_limpo = limparNome($serie['title']);
            $dados = buscarTMDB($nome_limpo, 'tv', $api_key, $lang);

            if ($dados) {
                $capa = "https://image.tmdb.org/t/p/w600_and_h900_bestv2" . $dados['poster_path'];
                $backdrop = "https://image.tmdb.org/t/p/original" . $dados['backdrop_path'];
                $plot = $dados['overview'];
                $nota = $dados['vote_average'];
                $release = $dados['first_air_date'];

                $pdo->prepare("UPDATE streams_series SET cover = ?, cover_big = ?, plot = ?, rating = ?, release_date = ?, backdrop_path = ? WHERE id = ?")
                    ->execute([$capa, $capa, $plot, $nota, $release, $backdrop, $serie['id']]);

                logMsg("Série OK: <b>{$serie['title']}</b>", "text-success");
                $atualizados++;
            } else {
                 $pdo->prepare("UPDATE streams_series SET plot = 'Sinopse indisponível', cover = 'https://via.placeholder.com/600x900?text=Sem+Capa' WHERE id = ?")->execute([$serie['id']]);
                 logMsg("Não achou: $nome_limpo", "text-secondary");
            }
            usleep(100000); 
        }
    }

    echo json_encode([
        'status' => 'ok', 
        'qtd_lote' => count($itens), 
        'restantes' => count($itens) > 0
    ]);

} catch (Exception $e) {
    logMsg("ERRO: " . $e->getMessage(), "text-danger");
    echo json_encode(['status' => 'erro']);
}
?>