<?php 
require 'config.php'; 
require 'header.php'; 

// --- SEGURANÇA ---
// Agora Admin e Revendedores (Grupo 2) podem acessar. Clientes finais não.
// Vamos supor que clientes finais não tenham acesso a essa pagina.
$my_id = $_SESSION['user_id'];
$is_admin = ($_SESSION['group_id'] == 1);

// Busca créditos atuais do usuário logado para validação
$stmt = $pdo->prepare("SELECT credits FROM users WHERE id = ?");
$stmt->execute([$my_id]);
$meus_creditos = (float)$stmt->fetchColumn();

// --- 1. TRANSFERÊNCIA DE CRÉDITOS (A Lógica Mágica) ---
if(isset($_POST['add_credits'])) {
    $id_destino = (int)$_POST['id_rev'];
    $qtd = (float)$_POST['amount'];

    if($qtd <= 0) {
        echo "<script>alert('Quantidade inválida!'); window.location='revendedores.php';</script>";
        exit;
    }

    // Se NÃO for Admin, precisa ter saldo para transferir
    if(!$is_admin) {
        if($meus_creditos < $qtd) {
            echo "<script>alert('ERRO: Você tem apenas $meus_creditos créditos. Não pode enviar $qtd!'); window.location='revendedores.php';</script>";
            exit;
        }
        
        // 1. Desconta de mim
        $pdo->prepare("UPDATE users SET credits = credits - ? WHERE id = ?")->execute([$qtd, $my_id]);
    }

    // 2. Adiciona no Sub-Revendedor
    $pdo->prepare("UPDATE users SET credits = credits + ? WHERE id = ?")->execute([$qtd, $id_destino]);
    
    echo "<script>alert('Créditos transferidos com sucesso!'); window.location='revendedores.php';</script>";
}

// --- 2. CRIAR SUB-REVENDEDOR ---
if(isset($_POST['new_rev'])) {
    $user = $_POST['username'];
    $pass = $_POST['password']; 
    $email = $_POST['email'];
    
    $check = $pdo->prepare("SELECT id FROM users WHERE username = ?");
    $check->execute([$user]);
    
    if($check->rowCount() > 0){
        echo "<script>alert('Usuário já existe!');</script>";
    } else {
        // owner_id = QUEM ESTÁ CRIANDO (O Admin ou o Revendedor Logado)
        // member_group_id = 2 (Sempre revendedor)
        $sql = "INSERT INTO users (username, password, email, member_group_id, credits, owner_id, date_registered, status) 
                VALUES (?, ?, ?, 2, 0, ?, UNIX_TIMESTAMP(), 1)";
        $pdo->prepare($sql)->execute([$user, $pass, $email, $my_id]);
        echo "<script>window.location='revendedores.php';</script>";
    }
}

// --- 3. EDITAR ---
if(isset($_POST['edit_rev'])) {
    $id = (int)$_POST['id_rev'];
    // Segurança: Só edita se for o dono ou admin
    $sql_check = $is_admin ? "SELECT id FROM users WHERE id=$id" : "SELECT id FROM users WHERE id=$id AND owner_id=$my_id";
    if($pdo->query($sql_check)->rowCount() > 0) {
        $pdo->prepare("UPDATE users SET password=?, email=?, status=? WHERE id=?")
            ->execute([$_POST['password'], $_POST['email'], (int)$_POST['status'], $id]);
    }
    echo "<script>window.location='revendedores.php';</script>";
}

// --- 4. EXCLUIR ---
if(isset($_GET['del'])) {
    $id = (int)$_GET['del'];
    // Segurança: Só apaga se for dono ou admin
    $sql = "DELETE FROM users WHERE id = $id AND member_group_id != 1";
    if(!$is_admin) $sql .= " AND owner_id = $my_id";
    
    $pdo->query($sql);
    echo "<script>window.location='revendedores.php';</script>";
}

// --- LISTAGEM INTELIGENTE ---
// Se Admin: Vê todos (menos a si mesmo, ID 1)
// Se Revenda: Vê apenas quem ELE criou (owner_id = $my_id)
if($is_admin) {
    $sql_lista = "SELECT * FROM users WHERE member_group_id != 1 ORDER BY id DESC";
} else {
    $sql_lista = "SELECT * FROM users WHERE owner_id = $my_id ORDER BY id DESC";
}
$revs = $pdo->query($sql_lista)->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4 mt-2">
        <div>
            <?php if($is_admin): ?>
                <h4 class="fw-bold mb-0 text-dark">Gerenciar Revendedores</h4>
                <small class="text-warning fw-bold">Modo Administrador (Total)</small>
            <?php else: ?>
                <h4 class="fw-bold mb-0 text-dark">Minha Equipe</h4>
                <small class="text-muted">Sub-revendedores criados por você</small>
                <div class="mt-1 text-success fw-bold small"><i class="fas fa-wallet"></i> Seu Saldo: <?= $meus_creditos ?></div>
            <?php endif; ?>
        </div>
        <button class="btn btn-primary px-4 py-2 rounded-pill shadow-sm fw-bold" data-bs-toggle="modal" data-bs-target="#modalNew">
            <i class="fas fa-plus me-2"></i> Novo Revendedor
        </button>
    </div>

    <div class="card border-0 shadow-sm" style="border-radius: 12px; overflow: hidden;">
        <div class="table-responsive">
            <table class="table table-hover mb-0 align-middle">
                <thead class="bg-light">
                    <tr>
                        <th class="ps-4">Usuário</th>
                        <th>Contato</th>
                        <th>Saldo</th>
                        <th>Status</th>
                        <?php if($is_admin): ?><th>Dono (ID)</th><?php endif; ?>
                        <th class="text-end pe-4">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($revs) == 0): ?>
                        <tr><td colspan="6" class="text-center py-4 text-muted">Nenhum revendedor encontrado na sua equipe.</td></tr>
                    <?php endif; ?>

                    <?php foreach($revs as $r): 
                        $status_badge = ($r['status'] == 1) ? '<span class="badge bg-success">Ativo</span>' : '<span class="badge bg-danger">Bloqueado</span>';
                    ?>
                    <tr>
                        <td class="ps-4">
                            <div class="d-flex align-items-center">
                                <div class="bg-dark rounded-circle p-2 me-2 text-white"><i class="fas fa-user-tie"></i></div>
                                <div>
                                    <span class="fw-bold d-block text-dark"><?= $r['username'] ?></span>
                                    <small class="text-muted" style="font-size:0.75rem">Senha: <?= $r['password'] ?></small>
                                </div>
                            </div>
                        </td>
                        <td class="text-muted small"><?= $r['email'] ? $r['email'] : '-' ?></td>
                        <td>
                            <span class="badge bg-success rounded-pill fs-6"><i class="fas fa-coins me-1"></i> <?= $r['credits'] ?></span>
                        </td>
                        <td><?= $status_badge ?></td>
                        
                        <?php if($is_admin): ?>
                            <td><span class="badge bg-light text-dark border">ID: <?= $r['owner_id'] ?></span></td>
                        <?php endif; ?>

                        <td class="text-end pe-4">
                            <button class="btn btn-sm btn-warning fw-bold text-dark me-1" data-bs-toggle="modal" data-bs-target="#modalCred<?= $r['id'] ?>" title="Transferir Crédito">
                                <i class="fas fa-exchange-alt"></i> $
                            </button>
                            <button class="btn btn-sm btn-info text-white me-1" data-bs-toggle="modal" data-bs-target="#modalEdit<?= $r['id'] ?>" title="Editar">
                                <i class="fas fa-pen"></i>
                            </button>
                            <a href="?del=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('ATENÇÃO: Excluir este revendedor apagará o acesso dele. Confirmar?')" title="Excluir">
                                <i class="fas fa-trash"></i>
                            </a>
                        </td>
                    </tr>

                    <div class="modal fade" id="modalCred<?= $r['id'] ?>">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header bg-warning">
                                    <h5 class="modal-title">Transferir Créditos</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <form method="POST">
                                    <div class="modal-body">
                                        <input type="hidden" name="add_credits" value="1">
                                        <input type="hidden" name="id_rev" value="<?= $r['id'] ?>">
                                        
                                        <div class="alert alert-secondary text-center">
                                            <small class="d-block text-muted">DESTINATÁRIO</small>
                                            <strong class="fs-5"><?= $r['username'] ?></strong>
                                        </div>

                                        <?php if(!$is_admin): ?>
                                            <div class="d-flex justify-content-between mb-2 small fw-bold">
                                                <span>Seu Saldo:</span>
                                                <span class="text-success"><?= $meus_creditos ?></span>
                                            </div>
                                        <?php endif; ?>

                                        <label class="fw-bold">Quantidade a enviar</label>
                                        <input type="number" name="amount" class="form-control form-control-lg text-center fw-bold text-success" placeholder="0" required>
                                        
                                        <?php if(!$is_admin): ?>
                                            <small class="text-danger d-block mt-2">* Será descontado do seu saldo.</small>
                                        <?php else: ?>
                                            <small class="text-primary d-block mt-2">* Admin gera créditos ilimitados.</small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="modal-footer"><button class="btn btn-warning w-100 fw-bold">Confirmar Transferência</button></div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="modalEdit<?= $r['id'] ?>">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header bg-info text-white">
                                    <h5 class="modal-title">Editar: <?= $r['username'] ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <form method="POST">
                                    <div class="modal-body">
                                        <input type="hidden" name="edit_rev" value="1">
                                        <input type="hidden" name="id_rev" value="<?= $r['id'] ?>">
                                        
                                        <div class="mb-3">
                                            <label>Nova Senha</label>
                                            <input type="text" name="password" class="form-control" value="<?= $r['password'] ?>" required>
                                        </div>
                                        <div class="mb-3">
                                            <label>Email</label>
                                            <input type="email" name="email" class="form-control" value="<?= $r['email'] ?>">
                                        </div>
                                        <div class="mb-3">
                                            <label>Status</label>
                                            <select name="status" class="form-select">
                                                <option value="1" <?= $r['status'] == 1 ? 'selected' : '' ?>>Ativo</option>
                                                <option value="0" <?= $r['status'] == 0 ? 'selected' : '' ?>>Bloqueado</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="modal-footer"><button class="btn btn-info text-white w-100 fw-bold">Salvar Alterações</button></div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalNew">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">Criar Sub-Revenda</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="new_rev" value="1">
                    
                    <div class="mb-3"><label>Usuário</label><input type="text" name="username" class="form-control" required></div>
                    <div class="mb-3"><label>Senha</label><input type="text" name="password" class="form-control" required></div>
                    <div class="mb-3"><label>Email (Opcional)</label><input type="email" name="email" class="form-control"></div>
                    
                    <div class="alert alert-light border small text-muted">
                        <i class="fas fa-info-circle"></i> O novo revendedor começará com 0 créditos. Use o botão <b>$</b> na tabela para enviar saldo a ele.
                    </div>
                </div>
                <div class="modal-footer"><button class="btn btn-primary w-100 fw-bold">Criar Conta</button></div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
