<?php
require 'config.php';
verificar_login();

if ($_POST['acao'] == 'criar_usuario') {
    // --- CRIAR USUÁRIO ---
    $exp = strtotime($_POST['validade']);
    $sql = "INSERT INTO `lines` (member_id, username, password, exp_date, max_connections, created_at, is_mag, is_e2, admin_enabled, enabled) 
            VALUES (1, ?, ?, ?, 1, UNIX_TIMESTAMP(), 0, 0, 1, 1)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$_POST['user'], $_POST['pass'], $exp]);
    header("Location: index.php?msg=user_ok");
}

if ($_POST['acao'] == 'criar_stream') {
    // --- CRIAR FILME OU CANAL ---
    // Baseado na tabela streams
    
    $tipo = (int)$_POST['tipo']; // 1 = Live, 2 = Movie
    $nome = $_POST['nome'];
    
    // O Xtream salva o link como um Array JSON ["http..."]
    $source = json_encode([$_POST['link']]); 
    
    // A categoria também costuma ser salva como JSON em versões mais novas
    $cat_id = json_encode([(int)$_POST['categoria_id']]); 

    // Extensão do arquivo (para filmes)
    $extensao = pathinfo($_POST['link'], PATHINFO_EXTENSION);
    if(!$extensao) $extensao = 'mp4'; // Padrão se não achar

    $sql = "INSERT INTO streams (
        type, category_id, stream_display_name, stream_source, 
        direct_source, target_container, added, stream_icon
    ) VALUES (
        :type, :cat, :nome, :source, 
        1, :container, UNIX_TIMESTAMP(), ''
    )";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':type' => $tipo,
        ':cat' => $cat_id, // Se der erro de categoria, troque $cat_id por $_POST['categoria_id'] direto
        ':nome' => $nome,
        ':source' => $source,
        ':container' => $extensao
    ]);
    
    // NOTA: Em alguns painéis, você precisa adicionar também na tabela streams_sys.
    // O código abaixo pega o ID do stream recém criado e tenta linkar ao servidor ID 1.
    $novo_id = $pdo->lastInsertId();
    try {
        $pdo->query("INSERT INTO streams_sys (stream_id, server_id, on_demand) VALUES ($novo_id, 1, 0)");
    } catch (Exception $e) {
        // Ignora erro se já existir trigger
    }

    header("Location: index.php?msg=stream_ok");
}
?>