<?php
// scanner.php - Verifica se o link do fornecedor está vivo
ini_set('display_errors', 1);
error_reporting(E_ALL);

// CONEXÃO DIRETA
$host = 'localhost';
$db   = 'geanrober_xuione'; 
$user = 'geanrober_xuione'; 
$pass = 'Jean#909110'; 

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
} catch (Exception $e) { die("Erro de Banco"); }

$id = $_GET['id'] ?? 0;
if ($id == 0) die("<h1>Digite o ID na URL. Ex: scanner.php?id=999</h1>");

// Busca Link
$stmt = $pdo->prepare("SELECT stream_source FROM streams WHERE id = ?");
$stmt->execute([$id]);
$source = $stmt->fetchColumn();

if (!$source) die("ID não existe.");

// Limpa Link
$link = "";
$decoded = json_decode($source, true);
if (is_array($decoded) && isset($decoded[0])) { $link = $decoded[0]; } 
else { $link = str_replace(['[', ']', '"', '\\'], '', $source); }

// Corrige espaços
$link = trim($link);
$link = str_replace(' ', '%20', $link);
if (strpos($link, 'http') !== 0) $link = "http://" . $link;

echo "<h2>Análise do ID: $id</h2>";
echo "<b>Tentando acessar:</b> $link<br><br>";

// Tenta verificar o status do link (CURL)
$ch = curl_init($link);
curl_setopt($ch, CURLOPT_NOBODY, true); // Só pega o cabeçalho, não baixa o vídeo
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "STATUS DO SERVIDOR: ";

if ($httpCode >= 200 && $httpCode < 400) {
    echo "<span style='color:green; font-weight:bold; font-size:20px'>ONLINE ($httpCode)</span>";
    echo "<p>O link está vivo! Se não abre no painel, é problema de formato ou HTTPS.</p>";
} else {
    echo "<span style='color:red; font-weight:bold; font-size:20px'>OFFLINE / MORTO ($httpCode)</span>";
    echo "<p><b>O link caiu.</b> Não adianta mexer no código. Você precisa trocar o link do filme no painel.</p>";
    if ($httpCode == 0) echo "(Servidor não respondeu ou Time-out)";
    if ($httpCode == 404) echo "(Arquivo não encontrado)";
}
?>