<?php 
require 'config.php'; 
require 'header.php'; 

// --- CONFIGURAÇÃO TMDB ---
$tmdb_key = 'f99aa9ae1fe7619969cc7db0938c1ae5'; // <--- COLOQUE SUA CHAVE AQUI SE AINDA NÃO COLOCOU

// --- DETECTAR URL ---
$protocolo = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https://" : "http://";
$servidor_dns = $protocolo . $_SERVER['HTTP_HOST']; 

// --- FUNÇÃO AUXILIAR: PEGAR CATEGORIAS ---
function getSeriesCategories($pdo) {
    // Busca categorias do tipo 'series'
    return $pdo->query("SELECT id, category_name FROM streams_categories WHERE category_type = 'series' ORDER BY category_name ASC")->fetchAll(PDO::FETCH_ASSOC);
}
$categorias = getSeriesCategories($pdo);

// --- 1. ADICIONAR SÉRIE (COM TMDB) ---
if(isset($_POST['add_serie'])) {
    // Formata categoria como JSON array ex: "[54]" (Padrão Xtream)
    $cat_id = json_encode([(string)$_POST['category_id']]); 
    
    // Dados Iniciais
    $tmdb_id = $_POST['tmdb_id'] ?? '';
    $nome = $_POST['nome_manual'];
    $capa = "";
    $plot = "";
    $release = "";
    $rating = 0;
    $director = "";
    $genre = "";
    $cast = "";
    $backdrop = "";

    // LÓGICA DE BUSCA AUTOMÁTICA (TMDB)
    if(!empty($tmdb_key)) {
        
        // CENÁRIO A: Tem nome mas não tem ID. Busca ID pelo nome.
        if(empty($tmdb_id) && !empty($nome)) {
            $search_url = "https://api.themoviedb.org/3/search/tv?api_key=$tmdb_key&query=" . urlencode($nome) . "&language=pt-BR";
            $json_search = @file_get_contents($search_url);
            
            if($json_search) {
                $data_search = json_decode($json_search, true);
                if(!empty($data_search['results'][0])) {
                    $tmdb_id = $data_search['results'][0]['id'];
                }
            }
        }

        // CENÁRIO B: Busca detalhes pelo ID
        if(!empty($tmdb_id)) {
            $url = "https://api.themoviedb.org/3/tv/$tmdb_id?api_key=$tmdb_key&language=pt-BR";
            $json = @file_get_contents($url);
            
            if($json) {
                $data = json_decode($json, true);
                $nome = $data['name']; // Nome Oficial da Série
                $capa = "https://image.tmdb.org/t/p/w600_and_h900_bestv2" . $data['poster_path'];
                $backdrop = "https://image.tmdb.org/t/p/original" . $data['backdrop_path'];
                $plot = $data['overview'];
                $release = $data['first_air_date']; // Data de estreia
                $rating = $data['vote_average'];
                
                // Gêneros
                $genres_arr = [];
                if(isset($data['genres'])) {
                    foreach($data['genres'] as $g) { $genres_arr[] = $g['name']; }
                }
                $genre = implode(', ', $genres_arr);
            }
        }
    }

    if(empty($nome)) {
        echo "<script>alert('Erro: Nome da série é obrigatório!');</script>";
    } else {
        // CORREÇÃO: Tabela streams_series e coluna release_date
        $sql = "INSERT INTO streams_series (title, category_id, cover, cover_big, plot, release_date, rating, genre, backdrop_path, last_modified) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, UNIX_TIMESTAMP())";
        
        $pdo->prepare($sql)->execute([$nome, $cat_id, $capa, $capa, $plot, $release, $rating, $genre, $backdrop]);
        echo "<script>window.location='series.php';</script>";
    }
}

// --- 2. DELETAR ---
if(isset($_GET['del'])) {
    $id = (int)$_GET['del'];
    // CORREÇÃO: Tabela streams_series
    $pdo->query("DELETE FROM streams_series WHERE id = $id");
    // Opcional: Apagar episódios vinculados
    $pdo->query("DELETE FROM streams_episodes WHERE series_id = $id");
    echo "<script>window.location='series.php';</script>";
}

// --- PAGINAÇÃO E BUSCA ---
$busca = $_GET['busca'] ?? '';
$filtro_cat = $_GET['categoria'] ?? ''; // <--- NOVO: Captura Categoria
$pagina = $_GET['pagina'] ?? 1;

// --- ALTERAÇÃO AQUI: Captura o limite do seletor ---
$limite = isset($_GET['limite']) ? (int)$_GET['limite'] : 50; 
if($limite < 1) $limite = 50; 
// --------------------------------------------------

$inicio = ($pagina - 1) * $limite;

// CORREÇÃO: Tabela streams_series
$sql_base = "FROM streams_series WHERE 1=1";
if($busca) $sql_base .= " AND title LIKE :busca";
if($filtro_cat) $sql_base .= " AND category_id LIKE :cat_filter"; // <--- NOVO: Filtro SQL

$stmt_count = $pdo->prepare("SELECT count(*) $sql_base");
if($busca) $stmt_count->bindValue(':busca', "%$busca%");
if($filtro_cat) $stmt_count->bindValue(':cat_filter', "%$filtro_cat%"); // <--- NOVO: Bind SQL
$stmt_count->execute();
$total_registros = $stmt_count->fetchColumn();
$total_paginas = ceil($total_registros / $limite);

// CORREÇÃO: Coluna release_date
$sql = "SELECT id, title, cover, plot, category_id, rating, release_date $sql_base ORDER BY id DESC LIMIT $inicio, $limite";
$stmt = $pdo->prepare($sql);
if($busca) $stmt->bindValue(':busca', "%$busca%");
if($filtro_cat) $stmt->bindValue(':cat_filter', "%$filtro_cat%"); // <--- NOVO: Bind SQL
$stmt->execute();
$series = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
    /* Card da Série */
    .serie-card {
        border: none;
        border-radius: 12px;
        background: #fff;
        box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        overflow: hidden;
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    .serie-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.15);
    }

    /* Imagem da Capa */
    .serie-cover-wrapper {
        position: relative;
        padding-top: 150%; /* Aspect Ratio 2:3 (Padrão Poster) */
        overflow: hidden;
        background: #eee;
    }

    .serie-cover {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .serie-card:hover .serie-cover {
        transform: scale(1.05);
    }

    /* Badge de Nota */
    .rating-badge {
        position: absolute;
        top: 10px;
        right: 10px;
        background: rgba(0,0,0,0.7);
        color: #ffc107;
        padding: 4px 8px;
        border-radius: 6px;
        font-weight: 700;
        font-size: 0.8rem;
        backdrop-filter: blur(2px);
    }

    /* Corpo do Card */
    .serie-body {
        padding: 15px;
        flex-grow: 1;
        display: flex;
        flex-direction: column;
    }

    .serie-title {
        font-weight: 700;
        color: #343a40;
        font-size: 0.95rem;
        margin-bottom: 5px;
        line-height: 1.3;
        display: -webkit-box;
        -webkit-line-clamp: 2; /* Limita a 2 linhas */
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    .serie-cat {
        font-size: 0.75rem;
        color: #6c757d;
        margin-bottom: 10px;
        display: block;
    }

    /* Botões de Ação */
    .action-buttons {
        margin-top: auto;
        display: flex;
        gap: 5px;
        border-top: 1px solid #f1f1f1;
        padding-top: 10px;
    }

    .btn-action {
        flex: 1;
        border: none;
        padding: 6px;
        border-radius: 6px;
        font-size: 0.8rem;
        transition: 0.2s;
    }

    .btn-edit-serie { background-color: #fff3cd; color: #ffc107; }
    .btn-edit-serie:hover { background-color: #ffecb5; color: #e0a800; }
    
    .btn-del-serie { background-color: #f8d7da; color: #dc3545; }
    .btn-del-serie:hover { background-color: #f5c2c7; color: #b02a37; }

    .search-box { border-radius: 30px; padding-left: 20px; border: 1px solid #dee2e6; box-shadow: 0 2px 5px rgba(0,0,0,0.03); }
</style>

<div class="container-fluid">

    <div class="row align-items-center mb-4 mt-2">
        <div class="col-md-6">
            <h4 class="fw-bold mb-0 text-dark"><i class="fas fa-tv me-2 text-purple" style="color: #6f42c1;"></i>Séries</h4>
            <small class="text-muted">Gerencie suas séries e capas</small>
        </div>
        <div class="col-md-6 text-end">
            <button class="btn btn-warning px-4 py-2 rounded-pill shadow-sm fw-bold text-dark" data-bs-toggle="modal" data-bs-target="#modalAdd">
                <i class="fas fa-plus me-2"></i> Nova Série
            </button>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-6"> <form class="d-flex">
                <select name="limite" class="form-select bg-light me-2" style="max-width: 80px;" onchange="this.form.submit()">
                    <?php 
                    $opcoes = [10, 20, 50, 100, 200, 500, 1000, 2000, 3000, 5000];
                    foreach($opcoes as $op) {
                        $selected = ($limite == $op) ? 'selected' : '';
                        echo "<option value='$op' $selected>$op</option>";
                    }
                    ?>
                </select>

                <select name="categoria" class="form-select bg-white me-2" style="max-width: 200px;" onchange="this.form.submit()">
                    <option value="">Todas Categorias</option>
                    <?php foreach($categorias as $cat): 
                        $selCat = ($filtro_cat == $cat['id']) ? 'selected' : '';
                    ?>
                        <option value="<?= $cat['id'] ?>" <?= $selCat ?>><?= $cat['category_name'] ?></option>
                    <?php endforeach; ?>
                </select>
                <input type="text" name="busca" class="form-control search-box" placeholder="Pesquisar série..." value="<?= $busca ?>">
                <button class="btn btn-dark rounded-pill ms-2 px-3"><i class="fas fa-search"></i></button>
            </form>
        </div>
    </div>

    <div class="row g-3">
        <?php foreach($series as $s): 
            $cat_clean = trim(str_replace(['"', '[', ']'], '', $s['category_id']));
            $nota = $s['rating'] > 0 ? number_format($s['rating'], 1) : '-';
        ?>
        <div class="col-xl-2 col-lg-3 col-md-4 col-6">
            <div class="serie-card">
                
                <div class="serie-cover-wrapper">
                    <img src="<?= $s['cover'] ?>" class="serie-cover" onerror="this.src='https://via.placeholder.com/200x300?text=Sem+Capa'">
                    <div class="rating-badge"><i class="fas fa-star me-1"></i><?= $nota ?></div>
                </div>

                <div class="serie-body">
                    <h6 class="serie-title" title="<?= $s['title'] ?>"><?= $s['title'] ?></h6>
                    <span class="serie-cat badge bg-light text-dark border w-auto align-self-start">ID Cat: <?= $cat_clean ?></span>
                    
                    <div class="action-buttons">
                        <a href="editar_serie.php?id=<?= $s['id'] ?>" class="btn-action btn-edit-serie text-center text-decoration-none">
                            <i class="fas fa-pen"></i>
                        </a>
                        <a href="?del=<?= $s['id'] ?>" class="btn-action btn-del-serie text-center text-decoration-none" onclick="return confirm('ATENÇÃO: Apagar a série apaga os episódios vinculados. Deseja continuar?')">
                            <i class="fas fa-trash"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    
    <?php if($total_paginas > 1): ?>
    <div class="d-flex justify-content-center py-4">
        <nav>
            <ul class="pagination pagination-sm mb-0 shadow-sm">
                <?php if($pagina > 1): ?>
                    <li class="page-item"><a class="page-link border-0 text-dark" href="?pagina=<?= $pagina-1 ?>&busca=<?= $busca ?>&limite=<?= $limite ?>&categoria=<?= $filtro_cat ?>"><i class="fas fa-chevron-left"></i></a></li>
                <?php endif; ?>
                <li class="page-item disabled"><span class="page-link border-0 fw-bold bg-white"><?= $pagina ?> / <?= $total_paginas ?></span></li>
                <?php if($pagina < $total_paginas): ?>
                    <li class="page-item"><a class="page-link border-0 text-dark" href="?pagina=<?= $pagina+1 ?>&busca=<?= $busca ?>&limite=<?= $limite ?>&categoria=<?= $filtro_cat ?>"><i class="fas fa-chevron-right"></i></a></li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
    <?php endif; ?>

</div>

<div class="modal fade" id="modalAdd">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-purple-subtle text-dark border-0" style="background-color: #e2d9f3;">
                <h5 class="modal-title fw-bold"><i class="fas fa-tv me-2" style="color: #6f42c1;"></i>Nova Série</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="add_serie" value="1">
                    
                    <ul class="nav nav-tabs mb-3" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active fw-bold text-dark" id="tmdb-tab" data-bs-toggle="tab" data-bs-target="#tmdb-pane" type="button">
                                <i class="fas fa-magic me-2 text-primary"></i>Automático (TMDB)
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link fw-bold text-muted" id="manual-tab" data-bs-toggle="tab" data-bs-target="#manual-pane" type="button">
                                <i class="fas fa-keyboard me-2"></i>Manual
                            </button>
                        </li>
                    </ul>

                    <div class="tab-content" id="myTabContent">
                        
                        <div class="tab-pane fade show active" id="tmdb-pane">
                            <div class="alert alert-info border-0 small">
                                <i class="fas fa-info-circle me-1"></i> Digite o nome ou ID. Buscaremos capas, sinopse e nota.
                            </div>
                            <div class="row">
                                <div class="col-md-8 mb-3">
                                    <label class="form-label small fw-bold text-muted">NOME DA SÉRIE</label>
                                    <input type="text" name="nome_manual" class="form-control" placeholder="Ex: Breaking Bad">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label small fw-bold text-muted">ID TMDB (Opcional)</label>
                                    <input type="text" name="tmdb_id" class="form-control" placeholder="Ex: 1396">
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="manual-pane">
                            <div class="alert alert-warning border-0 small">
                                <i class="fas fa-exclamation-triangle me-1"></i> Para cadastro 100% manual, use a opção "Editar" após criar.
                            </div>
                        </div>
                    </div>

                    <div class="mt-3">
                        <label class="form-label small fw-bold text-muted">CATEGORIA</label>
                        <select name="category_id" class="form-select" required>
                            <option value="">Selecione uma categoria...</option>
                            <?php foreach($categorias as $cat): ?>
                                <option value="<?= $cat['id'] ?>"><?= $cat['category_name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                </div>
                <div class="modal-footer border-0 bg-light">
                    <button type="button" class="btn btn-link text-muted text-decoration-none" data-bs-dismiss="modal">Cancelar</button>
                    <button class="btn btn-dark px-4 fw-bold shadow-sm" style="background-color: #6f42c1; border: none;">Salvar Série</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
