<?php
// ssiptv.php - Menu Interativo com Imagens Locais (img folder)
require 'config.php';

// Coleta dados da URL
$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$action   = $_GET['action']   ?? 'home';
$cat_id   = $_GET['cat_id']   ?? 0;

// Verifica Login Simples
$user = null;
if ($username && $password) {
    $stmt = $pdo->prepare("SELECT id, exp_date, enabled FROM `lines` WHERE username = :u AND password = :p LIMIT 1");
    $stmt->execute(['u' => $username, 'p' => $password]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}

// Se não logar, mostra tela de erro
if (!$user || $user['enabled'] == 0 || $user['exp_date'] < time()) {
    die("
    <body style='background:#111; color:#fff; font-family:sans-serif; display:flex; align-items:center; justify-content:center; height:100vh;'>
        <div style='text-align:center;'>
            <h1 style='color:#e50914'>ACESSO NEGADO</h1>
            <p>Verifique seu usuário e senha ou a validade da conta.</p>
        </div>
    </body>");
}

// Configuração de Streaming (Ajuste a porta se necessário, ex: :80 ou :8080)
$dns_streaming = "http://" . $_SERVER['HTTP_HOST'] . ":80"; 

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Web TV Player</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/hls.js@latest"></script>
    <style>
        body { background-color: #0f0f0f; color: #e0e0e0; font-family: 'Segoe UI', sans-serif; }
        a { text-decoration: none; color: inherit; }
        
        /* HEADER */
        .header { background: #1f1f1f; padding: 15px; border-bottom: 2px solid #e50914; display:flex; justify-content:space-between; align-items:center;}
        .logo { color: #e50914; font-weight: bold; font-size: 1.5rem; text-transform: uppercase; letter-spacing: 2px;}
        
        /* MENU PRINCIPAL (HOME) */
        .main-menu .card {
            background: #1f1f1f; border: 1px solid #333; transition: transform 0.3s, border-color 0.3s; cursor: pointer;
            text-align: center; padding: 30px; border-radius: 15px; margin-bottom: 20px; height: 100%;
            display: flex; align-items: center; justify-content: center; flex-direction: column;
        }
        .main-menu .card:hover, .main-menu .card:focus { 
            transform: scale(1.05); 
            background: #252525; 
            border-color: #e50914;
            box-shadow: 0 0 20px rgba(229, 9, 20, 0.4); 
        }
        
        /* IMAGENS LOCAIS DO MENU */
        .menu-img {
            width: 100px;
            height: 100px;
            object-fit: contain;
            margin-bottom: 15px;
            filter: drop-shadow(0 0 5px rgba(0,0,0,0.5));
        }
        
        .main-menu h3 { font-size: 1.3rem; margin: 0; font-weight: 600; color: #fff; }

        /* LISTAS E CATEGORIAS */
        .list-group-item { background: #1f1f1f; color: #bbb; border: 1px solid #333; font-size: 1.1rem; padding: 15px; }
        .list-group-item:hover { background: #e50914; color: #fff; border-color: #e50914; padding-left: 25px; transition: 0.2s; }
        
        .btn-back { background: #333; color: #fff; border: none; padding: 8px 20px; border-radius: 50px; font-weight: bold; transition: 0.2s; }
        .btn-back:hover { background: #e50914; }

        /* GRADE DE CANAIS/FILMES */
        .channel-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(130px, 1fr)); gap: 20px; padding: 15px; }
        .channel-item { 
            background: #1f1f1f; border-radius: 8px; padding: 10px; text-align: center; cursor: pointer; transition: 0.2s; 
            border: 1px solid transparent;
        }
        .channel-item:hover { background: #333; transform: translateY(-5px); border-color: #e50914; }
        .channel-icon { width: 100%; height: 80px; object-fit: contain; margin-bottom: 8px; }
        .movie-poster { width: 100%; height: 160px; object-fit: cover; border-radius: 5px; margin-bottom: 8px; }
        .channel-name { font-size: 0.85rem; color: #ccc; overflow: hidden; white-space: nowrap; text-overflow: ellipsis; }

        /* PLAYER */
        #playerModal { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: #000; z-index: 9999; display: none; align-items: center; justify-content: center; }
        #videoContainer { width: 100%; max-width: 1200px; position: relative; }
        video { width: 100%; height: auto; max-height: 90vh; background: #000; box-shadow: 0 0 50px rgba(0,0,0,0.8); }
        .close-player { 
            position: absolute; top: 20px; right: 20px; color: #fff; font-size: 2rem; cursor: pointer; z-index: 10000; 
            background: rgba(229, 9, 20, 0.8); width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; border-radius: 50%;
        }
    </style>
</head>
<body>

<div class="header">
    <div class="logo">TOP IPTV</div>
    <div>
        <?php if($action != 'home'): ?>
            <a href="?username=<?= $username ?>&password=<?= $password ?>" class="btn-back"><i class="fas fa-arrow-left me-2"></i> Voltar</a>
        <?php else: ?>
            <span class="badge bg-secondary">v2.0</span>
        <?php endif; ?>
    </div>
</div>

<div class="container py-4">

    <?php if ($action == 'home'): ?>
    <div class="row main-menu justify-content-center mt-5">
        
        <div class="col-md-4 col-12 mb-4">
            <a href="?username=<?= $username ?>&password=<?= $password ?>&action=live_cats">
                <div class="card">
                    <img src="img/live.png" class="menu-img" onerror="this.src='https://cdn-icons-png.flaticon.com/512/3658/3658959.png'">
                    <h3>TV AO VIVO</h3>
                </div>
            </a>
        </div>

        <div class="col-md-4 col-12 mb-4">
            <a href="?username=<?= $username ?>&password=<?= $password ?>&action=movie_cats">
                <div class="card">
                    <img src="img/movie.png" class="menu-img" onerror="this.src='https://cdn-icons-png.flaticon.com/512/4221/4221484.png'">
                    <h3>FILMES</h3>
                </div>
            </a>
        </div>

        <div class="col-md-4 col-12 mb-4">
            <a href="?username=<?= $username ?>&password=<?= $password ?>&action=series_cats">
                <div class="card">
                    <img src="img/series.png" class="menu-img" onerror="this.src='https://cdn-icons-png.flaticon.com/512/3163/3163508.png'">
                    <h3>SÉRIES</h3>
                </div>
            </a>
        </div>
    </div>
    
    <?php elseif ($action == 'live_cats'): ?>
        <h4 class="mb-4 border-start border-4 border-danger ps-3">Categorias de Canais</h4>
        <div class="list-group">
            <?php
            $cats = $pdo->query("SELECT id, category_name FROM streams_categories WHERE category_type='live' ORDER BY cat_order ASC")->fetchAll();
            foreach($cats as $c):
            ?>
            <a href="?username=<?= $username ?>&password=<?= $password ?>&action=live_list&cat_id=<?= $c['id'] ?>" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                <?= $c['category_name'] ?>
                <i class="fas fa-chevron-right text-muted"></i>
            </a>
            <?php endforeach; ?>
        </div>

    <?php elseif ($action == 'live_list'): ?>
        <h4 class="mb-4 border-start border-4 border-danger ps-3">Lista de Canais</h4>
        <div class="channel-grid">
            <?php
            $stmt = $pdo->prepare("SELECT id, stream_display_name, stream_icon FROM streams WHERE type=1 AND category_id = ? ORDER BY id ASC");
            $stmt->execute([$cat_id]);
            while($s = $stmt->fetch(PDO::FETCH_ASSOC)):
                $icon = $s['stream_icon'] ? $s['stream_icon'] : 'img/live.png';
                // Link direto para stream .ts (suportado nativamente por muitos players de TV)
                $stream_url = "{$dns_streaming}/live/{$username}/{$password}/{$s['id']}.ts";
            ?>
            <div class="channel-item" onclick="playChannel('<?= $stream_url ?>')">
                <img src="<?= $icon ?>" class="channel-icon" onerror="this.src='img/live.png'">
                <div class="channel-name"><?= $s['stream_display_name'] ?></div>
            </div>
            <?php endwhile; ?>
        </div>

    <?php elseif ($action == 'movie_cats'): ?>
        <h4 class="mb-4 border-start border-4 border-danger ps-3">Categorias de Filmes</h4>
        <div class="list-group">
            <?php
            $cats = $pdo->query("SELECT id, category_name FROM streams_categories WHERE category_type='movie' ORDER BY cat_order ASC")->fetchAll();
            foreach($cats as $c):
            ?>
            <a href="?username=<?= $username ?>&password=<?= $password ?>&action=movie_list&cat_id=<?= $c['id'] ?>" class="list-group-item list-group-item-action d-flex justify-content-between">
                <?= $c['category_name'] ?>
                <i class="fas fa-chevron-right text-muted"></i>
            </a>
            <?php endforeach; ?>
        </div>

    <?php elseif ($action == 'movie_list'): ?>
        <h4 class="mb-4 border-start border-4 border-danger ps-3">Filmes</h4>
        <div class="channel-grid">
            <?php
            $stmt = $pdo->prepare("SELECT id, stream_display_name, stream_icon, target_container FROM streams WHERE type=2 AND category_id = ? ORDER BY added DESC");
            $stmt->execute([$cat_id]);
            while($s = $stmt->fetch(PDO::FETCH_ASSOC)):
                $icon = $s['stream_icon'] ? $s['stream_icon'] : 'img/movie.png';
                $ext = isset($s['target_container']) ? '.' . pathinfo($s['target_container'], PATHINFO_EXTENSION) : '.mp4';
                $stream_url = "{$dns_streaming}/movie/{$username}/{$password}/{$s['id']}{$ext}";
            ?>
            <div class="channel-item" onclick="playChannel('<?= $stream_url ?>')">
                <img src="<?= $icon ?>" class="movie-poster" onerror="this.src='img/movie.png'">
                <div class="channel-name mt-2"><?= $s['stream_display_name'] ?></div>
            </div>
            <?php endwhile; ?>
        </div>
    
    <?php elseif ($action == 'series_cats'): ?>
        <div class="text-center mt-5">
            <img src="img/series.png" width="100" style="opacity:0.5">
            <h4 class="mt-3 text-muted">Módulo de Séries em Manutenção</h4>
            <p>Por favor, utilize o aplicativo para assistir séries.</p>
            <a href="?username=<?= $username ?>&password=<?= $password ?>" class="btn btn-back mt-3">Voltar</a>
        </div>

    <?php endif; ?>

</div>

<div id="playerModal">
    <div class="close-player" onclick="closePlayer()">&times;</div>
    <div id="videoContainer">
        <video id="videoPlayer" controls autoplay></video>
    </div>
</div>

<script>
    function playChannel(url) {
        var modal = document.getElementById('playerModal');
        var video = document.getElementById('videoPlayer');
        
        modal.style.display = 'flex';
        
        // Suporte a HLS (.m3u8) se necessário, mas .ts roda nativo na maioria
        if (Hls.isSupported() && url.includes('.m3u8')) {
            var hls = new Hls();
            hls.loadSource(url);
            hls.attachMedia(video);
            hls.on(Hls.Events.MANIFEST_PARSED, function() {
                video.play();
            });
        } else {
            video.src = url;
            video.play();
        }
    }

    function closePlayer() {
        var modal = document.getElementById('playerModal');
        var video = document.getElementById('videoPlayer');
        video.pause();
        video.src = "";
        modal.style.display = 'none';
    }
</script>

</body>
</html>
