<?php
// teste.php - Diagnóstico de Banco de Dados
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Diagnóstico do Painel</h1>";

// 1. Tenta carregar config
if (!file_exists('config.php')) {
    die("<h3 style='color:red'>ERRO: config.php não encontrado!</h3>");
}
require_once 'config.php';
echo "<p style='color:green'>✔ config.php carregado.</p>";

// 2. Testa conexão PDO
if (!isset($pdo)) {
    die("<h3 style='color:red'>ERRO: Variável \$pdo não existe. Verifique o config.php</h3>");
}
echo "<p style='color:green'>✔ Conexão PDO ativa.</p>";

// 3. Testa Tabela de Usuários (Lines vs Users)
try {
    $stmt = $pdo->query("SELECT count(*) FROM `lines`");
    $count = $stmt->fetchColumn();
    echo "<p style='color:green'>✔ Tabela 'lines' encontrada (XUI/Xtream). Total usuários: $count</p>";
} catch (Exception $e) {
    echo "<p style='color:red'>✖ Tabela 'lines' falhou: " . $e->getMessage() . "</p>";
    echo "<p>Tentando tabela 'users'...</p>";
    try {
        $stmt = $pdo->query("SELECT count(*) FROM `users`");
        echo "<p style='color:green'>✔ Tabela 'users' encontrada.</p>";
    } catch (Exception $ex) {
        echo "<p style='color:red'>✖ Tabela 'users' também falhou.</p>";
    }
}

// 4. Testa Categorias (Onde costuma dar erro no SSIPTV)
echo "<h3>Testando Categorias LIVE:</h3>";
try {
    // Tenta pegar categorias tipo 'live' ou tipo 1
    $sql = "SELECT id, category_name FROM streams_categories WHERE category_type = 'live' OR category_type = '1' LIMIT 5";
    $stmt = $pdo->query($sql);
    $cats = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($cats) > 0) {
        echo "<p style='color:green'>✔ Sucesso! Encontrei " . count($cats) . " categorias.</p>";
        foreach($cats as $c) {
            echo " - ID: " . $c['id'] . " | Nome: " . $c['category_name'] . "<br>";
        }
    } else {
        echo "<p style='color:orange'>⚠ A consulta rodou, mas retornou 0 categorias. Verifique se existem categorias 'live'.</p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red'>✖ ERRO CRÍTICO NAS CATEGORIAS: " . $e->getMessage() . "</p>";
}

echo "<h3>Fim do teste.</h3>";
?>
