<?php 
require 'config.php'; 
require 'header.php'; 

// --- CONFIGURAÇÕES DE DNS AUTOMÁTICO ---
$protocolo = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https://" : "http://";
$dns_painel = $protocolo . $_SERVER['HTTP_HOST']; 
$porta_streaming = ":8080"; 
$dns_link = $dns_painel . $porta_streaming;

$my_id = $_SESSION['user_id'];
$is_admin = ($_SESSION['group_id'] == 1);

// --- BUSCAR BOUQUETS (PACOTES) ---
$lista_bouquets = $pdo->query("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name ASC")->fetchAll(PDO::FETCH_ASSOC);

// --- FUNÇÕES AUXILIARES ---
function processarCredito($pdo, $user_id, $is_admin) {
    if($is_admin) return true; 
    $stmt = $pdo->prepare("SELECT credits FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $c = (float)$stmt->fetchColumn();
    if($c < 1) return false;
    $pdo->prepare("UPDATE users SET credits = credits - 1 WHERE id = ?")->execute([$user_id]);
    return true;
}

function gerarCodigo($tamanho = 6) {
    return substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyz"), 0, $tamanho);
}

// --- FILTROS (GET) ---
$busca_texto = $_GET['busca'] ?? '';
$filtro_status = $_GET['status'] ?? 'todos'; 
$filtro_revenda = $_GET['revenda'] ?? ''; 

// --- 1. BLOQUEAR / DESBLOQUEAR RÁPIDO ---
if(isset($_GET['toggle_status'])) {
    $id = (int)$_GET['toggle_status'];
    $status_atual = (int)$_GET['current']; // 1 = Ativo, 0 = Bloqueado
    $novo_status = ($status_atual == 1) ? 0 : 1;
    
    $sql = "UPDATE `lines` SET enabled = ? WHERE id = ?";
    if(!$is_admin) $sql .= " AND member_id = $my_id"; 
    
    $pdo->prepare($sql)->execute([$novo_status, $id]);
    echo "<script>window.location='testes.php';</script>";
    exit;
}

// --- 2. RENOVAR (TORNAR CLIENTE) ---
if(isset($_POST['renew_test'])) {
    $id = (int)$_POST['id_test'];
    if(!processarCredito($pdo, $my_id, $is_admin)) {
        echo "<script>alert('ERRO: Sem créditos para renovar!'); window.location='testes.php';</script>"; exit;
    }
    $novo_vencimento = time() + (30 * 86400); 
    $sql = "UPDATE `lines` SET is_trial = 0, exp_date = ?, enabled = 1 WHERE id = ?";
    if(!$is_admin) $sql .= " AND member_id = $my_id";
    $pdo->prepare($sql)->execute([$novo_vencimento, $id]);
    echo "<script>alert('Teste convertido em Cliente com sucesso!'); window.location='clientes.php';</script>";
}

// --- 3. EDITAR TESTE ---
if(isset($_POST['edit_test'])) {
    $id = (int)$_POST['id_test'];
    
    $pacote_id = (int)$_POST['pacote_selecionado'];
    $bouquet_formatado = "[" . $pacote_id . "]";

    $sql_check = "SELECT exp_date FROM `lines` WHERE id = $id";
    if(!$is_admin) $sql_check .= " AND member_id = $my_id";
    
    if($pdo->query($sql_check)->rowCount() > 0) {
        $horas_add = (int)$_POST['extend_time'];
        $pass = $_POST['pass'];
        $status_edit = (int)$_POST['status_teste']; 
        
        $atual = $pdo->query("SELECT exp_date FROM `lines` WHERE id = $id")->fetchColumn();
        $base = ($atual > time()) ? $atual : time();
        $novo_vencimento = ($horas_add > 0) ? $base + ($horas_add * 3600) : $atual;

        $pdo->prepare("UPDATE `lines` SET password = ?, exp_date = ?, bouquet = ?, package_id = ?, enabled = ? WHERE id = ?")
            ->execute([$pass, $novo_vencimento, $bouquet_formatado, $pacote_id, $status_edit, $id]);
    }
    echo "<script>window.location='testes.php';</script>";
}

// --- 4. CRIAR TESTE ---
if(isset($_POST['add_test'])) {
    $horas = (int)$_POST['duracao'];
    $user = !empty($_POST['user']) ? $_POST['user'] : "teste" . gerarCodigo(4);
    $pass = !empty($_POST['pass']) ? $_POST['pass'] : gerarCodigo(6);
    $exp = time() + ($horas * 3600);
    
    $pacote_id = (int)$_POST['pacote_selecionado'];
    $bouquet_formatado = "[" . $pacote_id . "]";
    
    $check = $pdo->prepare("SELECT id FROM `lines` WHERE username = ?");
    $check->execute([$user]);
    
    if($check->rowCount() > 0){
        echo "<script>alert('Usuário já existe!');</script>";
    } else {
        $sql = "INSERT INTO `lines` (member_id, username, password, exp_date, max_connections, created_at, admin_enabled, enabled, is_trial, bouquet, package_id) 
                VALUES (?, ?, ?, ?, 1, UNIX_TIMESTAMP(), 1, 1, 1, ?, ?)";
        $pdo->prepare($sql)->execute([$my_id, $user, $pass, $exp, $bouquet_formatado, $pacote_id]);
        
        $novo_id = $pdo->lastInsertId();
        echo "<script>window.location='testes.php?created=$novo_id';</script>";
        exit;
    }
}

// --- 5. DELETAR ---
if(isset($_GET['del'])) {
    $id = (int)$_GET['del'];
    $sql = "DELETE FROM `lines` WHERE id = $id";
    if(!$is_admin) $sql .= " AND member_id = $my_id";
    $pdo->query($sql);
    echo "<script>window.location='testes.php';</script>";
}

// --- CONSULTA LISTAGEM ---
$sql_lista = "SELECT L.*, U.username as dono_nome, B.bouquet_name 
              FROM `lines` L 
              LEFT JOIN users U ON L.member_id = U.id 
              LEFT JOIN bouquets B ON L.package_id = B.id 
              WHERE L.is_trial = 1 ";

if(!$is_admin) { $sql_lista .= " AND L.member_id = $my_id "; }
if($is_admin && !empty($filtro_revenda)) { $sql_lista .= " AND L.member_id = " . (int)$filtro_revenda . " "; }
if(!empty($busca_texto)) { $sql_lista .= " AND L.username LIKE '%$busca_texto%' "; }

$agora = time();
if($filtro_status == 'ativos') { $sql_lista .= " AND L.exp_date > $agora AND L.enabled = 1 "; } 
elseif($filtro_status == 'vencidos') { $sql_lista .= " AND L.exp_date <= $agora "; } 
elseif($filtro_status == 'bloqueados') { $sql_lista .= " AND L.enabled = 0 "; }

$sql_lista .= "ORDER BY L.id DESC LIMIT 50";
$tests = $pdo->query($sql_lista)->fetchAll(PDO::FETCH_ASSOC);

// --- LISTA REVENDEDORES ---
$lista_revendedores = [];
if($is_admin) {
    $lista_revendedores = $pdo->query("SELECT id, username FROM users WHERE member_group_id != 1")->fetchAll(PDO::FETCH_ASSOC);
}

// --- MODAL AUTOMÁTICO ---
$show_created_modal = false;
$id_created = 0;
if(isset($_GET['created'])) {
    $show_created_modal = true;
    $id_created = (int)$_GET['created'];
}
?>

<div class="container-fluid">

    <div class="d-md-flex justify-content-between align-items-center mb-4 mt-2">
        <div>
            <h4 class="fw-bold mb-0 text-dark">Gerenciar Testes</h4>
            <small class="text-muted">Total: <b><?= count($tests) ?></b></small>
        </div>
        <div class="mt-3 mt-md-0">
            <button class="btn btn-success px-4 py-2 rounded-pill shadow-sm fw-bold" data-bs-toggle="modal" data-bs-target="#modalTest">
                <i class="fas fa-stopwatch me-2"></i> Criar Teste Rápido
            </button>
        </div>
    </div>

    <div class="card border-0 shadow-sm mb-4" style="border-radius: 12px; background: #f8f9fa;">
        <div class="card-body py-3">
            <form method="GET" class="row g-2 align-items-center">
                <div class="col-md-3">
                    <div class="input-group">
                        <span class="input-group-text bg-white border-end-0"><i class="fas fa-search text-muted"></i></span>
                        <input type="text" name="busca" class="form-control border-start-0 ps-0" placeholder="Buscar usuário..." value="<?= $busca_texto ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select" onchange="this.form.submit()">
                        <option value="todos" <?= $filtro_status == 'todos' ? 'selected' : '' ?>>Todos os Status</option>
                        <option value="ativos" <?= $filtro_status == 'ativos' ? 'selected' : '' ?>>⏳ Em andamento</option>
                        <option value="vencidos" <?= $filtro_status == 'vencidos' ? 'selected' : '' ?>>⏰ Vencidos</option>
                        <option value="bloqueados" <?= $filtro_status == 'bloqueados' ? 'selected' : '' ?>>🚫 Bloqueados</option>
                    </select>
                </div>
                <?php if($is_admin): ?>
                <div class="col-md-3">
                    <select name="revenda" class="form-select" onchange="this.form.submit()">
                        <option value="">Todos os Revendedores</option>
                        <?php foreach($lista_revendedores as $r): ?>
                            <option value="<?= $r['id'] ?>" <?= $filtro_revenda == $r['id'] ? 'selected' : '' ?>>
                                👤 <?= $r['username'] ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?php endif; ?>
                <div class="col-md-auto">
                    <a href="testes.php" class="btn btn-outline-secondary w-100" title="Limpar Filtros"><i class="fas fa-eraser"></i></a>
                </div>
            </form>
        </div>
    </div>

    <div class="card border-0 shadow-sm" style="border-radius: 12px; overflow: hidden;">
        <div class="table-responsive">
            <table class="table mb-0 table-hover align-middle">
                <thead class="bg-light">
                    <tr>
                        <th width="10%">Status</th>
                        <th width="20%">Usuário / Senha</th>
                        <th width="10%">Pacote</th>
                        <th width="20%">Expira em</th>
                        <th width="15%" class="text-center">Criado</th>
                        <th width="25%" class="text-end">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($tests) == 0): ?>
                        <tr><td colspan="6" class="text-center py-5 text-muted">Nenhum teste encontrado.</td></tr>
                    <?php endif; ?>

                    <?php foreach($tests as $t): 
                        $agora = time();
                        $restante = $t['exp_date'] - $agora;
                        $ativo = $restante > 0;
                        
                        if($t['enabled'] == 0) {
                            $tempo_texto = "BLOQUEADO";
                            $classe_tempo = "badge bg-secondary rounded-pill";
                        } elseif(!$ativo) {
                            $tempo_texto = "EXPIRADO";
                            $classe_tempo = "badge bg-danger rounded-pill";
                        } else {
                            $horas = floor($restante / 3600);
                            $minutos = floor(($restante % 3600) / 60);
                            $tempo_texto = "Restam {$horas}h {$minutos}m";
                            $classe_tempo = "badge bg-success rounded-pill";
                        }

                        $vencimento_fmt = date('d/m/Y H:i', $t['exp_date']);
                        $nome_pacote = $t['bouquet_name'] ?? 'Padrão';
                        
                        // --- MENSAGEM DO WHATSAPP OTIMIZADA (IGUAL CLIENTES.PHP) ---
                        $msg  = "╭──🔥 Teste Gerado com Sucesso\n";
                        $msg .= "├\n";
                        $msg .= "├● 💻 *Usuário* ➤ {$t['username']}\n";
                        $msg .= "├● 🔑 *Senha* : {$t['password']}\n";
                        $msg .= "├● 📦 *Pacote* : {$nome_pacote}\n";
                        $msg .= "├● 🕓 *Vence*: {$vencimento_fmt}\n";
                        $msg .= "╰──\n";
                        $msg .= "-----------------------------\n";
                        $msg .= "╭──🔗 *LINKS DE ACESSO*\n";
                        $msg .= "├\n";
                        $msg .= "├● 📺 *SSIPTV / WEB PLAYER (Menu Interativo):*\n";
                        $msg .= "├ {$dns_painel}/ssiptv.php?username={$t['username']}&password={$t['password']}\n";
                        $msg .= "├\n";
                        $msg .= "├● 📄 *Lista M3U (Para Apps Comuns):*\n";
                        $msg .= "├ {$dns_link}/playlist/{$t['username']}/{$t['password']}/m3u_plus\n";
                        $msg .= "├\n";
                        $msg .= "├● 📡 *Link SSIPTV (Direto):*\n";
                        $msg .= "├ {$dns_link}/playlist/{$t['username']}/{$t['password']}/m3u_plus?output=ts\n";
                        $msg .= "╰──\n";
                        $msg .= "-----------------------------\n";
                        $msg .= "✅ *Área do cliente:* {$dns_painel}/cliente\n\n";
                        $msg .= "ATT: TOP IPTV";
                        
                        $link_zap = "https://wa.me/?text=" . urlencode($msg);
                    ?>
                    <tr>
                        <td><span class="<?= $classe_tempo ?>" style="font-size: 0.7rem"><?= $tempo_texto ?></span></td>
                        <td>
                            <div class="fw-bold text-dark"><?= $t['username'] ?></div>
                            <?php if($is_admin && isset($t['dono_nome'])): ?>
                                <small class="text-muted" style="font-size: 0.7rem;"><i class="fas fa-user-tie"></i> <?= $t['dono_nome'] ?></small>
                            <?php endif; ?>
                            <div class="text-muted small font-monospace"><?= $t['password'] ?></div>
                        </td>
                        <td><small class="badge bg-light text-dark border"><?= $nome_pacote ?></small></td>
                        <td>
                            <small class="text-muted d-block">Vence dia:</small>
                            <span class="fw-bold text-dark"><?= date('d/m H:i', $t['exp_date']) ?></span>
                        </td>
                        <td class="text-center text-muted small">
                            <?= date('d/m H:i', $t['created_at']) ?>
                        </td>
                        <td class="text-end">
                            <?php if($t['enabled'] == 1): ?>
                                <a href="?toggle_status=<?= $t['id'] ?>&current=1" class="btn btn-sm btn-outline-secondary" title="Bloquear"><i class="fas fa-ban"></i></a>
                            <?php else: ?>
                                <a href="?toggle_status=<?= $t['id'] ?>&current=0" class="btn btn-sm btn-success" title="Desbloquear"><i class="fas fa-check"></i></a>
                            <?php endif; ?>

                            <button class="btn btn-sm btn-success text-white" data-bs-toggle="modal" data-bs-target="#renew<?= $t['id'] ?>" title="Virar Cliente"><i class="fas fa-exchange-alt"></i></button>
                            <button class="btn btn-sm btn-info text-white" data-bs-toggle="modal" data-bs-target="#info<?= $t['id'] ?>" title="Ver Dados"><i class="fas fa-eye"></i></button>
                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#edit<?= $t['id'] ?>" title="Editar"><i class="fas fa-pen"></i></button>
                            <a href="?del=<?= $t['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Apagar teste?')" title="Excluir"><i class="fas fa-trash"></i></a>
                        </td>
                    </tr>

                    <div class="modal fade" id="info<?= $t['id'] ?>" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content border-0 shadow-lg">
                                <div class="modal-header bg-dark text-white border-0">
                                    <h5 class="modal-title fw-bold"><i class="fas fa-share-alt me-2"></i>Dados do Teste</h5>
                                    <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body bg-light">
                                    <textarea class="form-control mb-3 shadow-sm" id="msg<?= $t['id'] ?>" rows="15" style="font-size: 0.85rem; font-family: monospace; background: #fff;" readonly><?= $msg ?></textarea>
                                    <div class="row g-2">
                                        <div class="col-6"><button class="btn btn-secondary w-100 fw-bold py-2" onclick="copiarTexto('msg<?= $t['id'] ?>')"><i class="fas fa-copy me-2"></i>Copiar</button></div>
                                        <div class="col-6"><a href="<?= $link_zap ?>" target="_blank" class="btn btn-success w-100 fw-bold py-2"><i class="fab fa-whatsapp me-2"></i>Enviar Zap</a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="renew<?= $t['id'] ?>" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header bg-success text-white">
                                    <h5 class="modal-title fw-bold">Tornar Cliente</h5>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                                </div>
                                <form method="POST">
                                    <div class="modal-body text-center">
                                        <input type="hidden" name="renew_test" value="1">
                                        <input type="hidden" name="id_test" value="<?= $t['id'] ?>">
                                        <p class="mb-2">Transformar <b><?= $t['username'] ?></b> em cliente?</p>
                                        <div class="alert alert-warning mt-3 py-2">
                                            <small class="fw-bold text-danger"><i class="fas fa-coins"></i> Custo: 1 Crédito</small>
                                        </div>
                                    </div>
                                    <div class="modal-footer"><button class="btn btn-success w-100 fw-bold">Confirmar</button></div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="modal fade" id="edit<?= $t['id'] ?>" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content border-0 shadow">
                                <div class="modal-header bg-warning-subtle border-0">
                                    <h6 class="modal-title fw-bold text-dark">Editar Teste</h6>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <form method="POST">
                                    <div class="modal-body">
                                        <input type="hidden" name="edit_test" value="1">
                                        <input type="hidden" name="id_test" value="<?= $t['id'] ?>">
                                        
                                        <div class="mb-3">
                                            <label class="form-label small fw-bold text-muted">SENHA</label>
                                            <input type="text" name="pass" class="form-control" value="<?= $t['password'] ?>" required>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label class="form-label small fw-bold text-primary">PACOTE</label>
                                            <select name="pacote_selecionado" class="form-select border-primary" required>
                                                <?php foreach($lista_bouquets as $bq): ?>
                                                    <option value="<?= $bq['id'] ?>" <?= $t['package_id'] == $bq['id'] ? 'selected' : '' ?>>
                                                        📦 <?= $bq['bouquet_name'] ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label small fw-bold text-muted">STATUS</label>
                                            <select name="status_teste" class="form-select">
                                                <option value="1" <?= $t['enabled'] == 1 ? 'selected' : '' ?>>✅ Ativo</option>
                                                <option value="0" <?= $t['enabled'] == 0 ? 'selected' : '' ?>>🚫 Bloqueado</option>
                                            </select>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label small fw-bold text-muted">MAIS TEMPO</label>
                                            <select name="extend_time" class="form-select">
                                                <option value="0">Manter atual</option>
                                                <option value="1">+ 1 Hora</option>
                                                <option value="2">+ 2 Horas</option>
                                                <option value="24">+ 24 Horas</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="modal-footer border-0">
                                        <button type="submit" class="btn btn-warning fw-bold w-100">Salvar</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="modalTest">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-success text-white border-0">
                <h5 class="modal-title fw-bold"><i class="fas fa-stopwatch me-2"></i>Novo Teste</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="add_test" value="1">
                    
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label small fw-bold text-muted">USUÁRIO (Opcional)</label>
                            <input type="text" name="user" class="form-control" placeholder="Gerar auto...">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label small fw-bold text-muted">SENHA (Opcional)</label>
                            <input type="text" name="pass" class="form-control" placeholder="Gerar auto...">
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-primary">SELECIONE O PACOTE</label>
                        <select name="pacote_selecionado" class="form-select border-primary" required>
                            <?php foreach($lista_bouquets as $bq): ?>
                                <option value="<?= $bq['id'] ?>">📦 <?= $bq['bouquet_name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label small fw-bold text-muted">DURAÇÃO</label>
                        <select name="duracao" class="form-select form-select-lg fw-bold text-success">
                            <option value="2" selected>2 Horas</option>
                            <option value="3">3 Horas</option>
                            <option value="6">6 Horas</option>
                            <option value="24">24 Horas</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer border-0 bg-light">
                    <button class="btn btn-success px-4 fw-bold shadow-sm w-100">Gerar Teste</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php if($show_created_modal && $id_created > 0): ?>
<script>
    document.addEventListener("DOMContentLoaded", function(){
        var modalId = 'info' + <?= $id_created ?>;
        var myModal = new bootstrap.Modal(document.getElementById(modalId));
        myModal.show();
        window.history.replaceState({}, document.title, window.location.pathname);
    });
</script>
<?php endif; ?>

<script>
function copiarTexto(id) {
    var copyText = document.getElementById(id);
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    navigator.clipboard.writeText(copyText.value).then(() => { alert("Copiado!"); });
}
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
