<?php
// tmdb_helper.php
define('TMDB_API_KEY', 'f99aa9ae1fe7619969cc7db0938c1ae5'); // <--- COLOQUE SUA CHAVE AQUI
define('TMDB_LANG', 'pt-BR');

function buscarTMDB($titulo, $tipo = 'movie') {
    // Limpa o nome (remove anos, qualidades, etc para melhorar a busca)
    $clean_title = preg_replace('/(\(|\[).*(\)|\])| \d{4} .*/', '', $titulo);
    $url = "https://api.themoviedb.org/3/search/{$tipo}?api_key=" . TMDB_API_KEY . "&query=" . urlencode($clean_title) . "&language=" . TMDB_LANG;
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $json = curl_exec($ch);
    curl_close($ch);
    
    $data = json_decode($json, true);
    
    if (!empty($data['results'][0])) {
        $r = $data['results'][0];
        return [
            'titulo' => $r['title'] ?? $r['name'],
            'sinopse' => $r['overview'],
            'capa' => $r['poster_path'] ? "https://image.tmdb.org/t/p/w500" . $r['poster_path'] : '',
            'backdrop' => $r['backdrop_path'] ? "https://image.tmdb.org/t/p/w780" . $r['backdrop_path'] : '',
            'ano' => substr($r['release_date'] ?? $r['first_air_date'] ?? '', 0, 4),
            'rating' => $r['vote_average']
        ];
    }
    return null; // Não achou
}
?>
