<?php
require 'config.php';
require 'header.php';

// Apenas Admin
$grupo = $_SESSION['group_id'] ?? 0;
if ($grupo != 1) { echo "<script>window.location='index.php';</script>"; exit; }

// Aumenta o tempo limite do PHP para processar listas grandes
set_time_limit(0); 
ini_set('memory_limit', '1024M');

$mensagem = "";
$log_visual = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $tipo = $_POST['tipo_conteudo']; // 1=Live, 2=Movie
    $busca = trim($_POST['dns_antigo']);
    $troca = trim($_POST['dns_novo']);

    if (!empty($busca) && !empty($troca)) {
        try {
            // 1. Busca TODOS os itens desse tipo (sem filtro WHERE para garantir que nada escape)
            $sql = "SELECT id, stream_display_name, stream_source FROM streams WHERE type = :tipo";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([':tipo' => $tipo]);
            
            $total_analisado = 0;
            $total_alterado = 0;
            
            $pdo->beginTransaction();

            while ($item = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $total_analisado++;
                $id = $item['id'];
                $nome = $item['stream_display_name'];
                $source_original = $item['stream_source']; // Ex: ["http:\/\/velho.com\/..."]
                
                // Decodifica o JSON para texto limpo
                $dados = json_decode($source_original, true);
                
                // Se não for array (link antigo ou erro), transforma em array
                if (!is_array($dados)) {
                    $dados = [$source_original];
                }

                $mudou = false;
                $novo_array = [];

                // Varre os links dentro do canal (as vezes tem mais de um)
                foreach ($dados as $link) {
                    // Verifica se o link contém o texto antigo
                    if (strpos($link, $busca) !== false) {
                        // FAZ A TROCA
                        $novo_link = str_replace($busca, $troca, $link);
                        $novo_array[] = $novo_link;
                        $mudou = true;
                    } else {
                        $novo_array[] = $link;
                    }
                }

                // Se houve alteração, salva no banco
                if ($mudou) {
                    // Recodifica para o formato JSON do Xtream (com as barras \/ certinhas)
                    $source_final = json_encode($novo_array, JSON_UNESCAPED_SLASHES); 
                    // Nota: Xtream as vezes usa escaped slashes, as vezes não. 
                    // O mais seguro é json_encode normal, mas vamos garantir o update.
                    
                    // UPDATE
                    $up = $pdo->prepare("UPDATE streams SET stream_source = ? WHERE id = ?");
                    $up->execute([json_encode($novo_array), $id]);
                    
                    $total_alterado++;
                    
                    // Guarda os 5 primeiros para mostrar no log
                    if ($total_alterado <= 5) {
                        $log_visual .= "<li><b>$nome</b>: Trocado!</li>";
                    }
                }
            }

            $pdo->commit();

            if ($total_alterado > 0) {
                $mensagem = "<div class='alert alert-success fw-bold p-4 text-center'>
                                <h3><i class='fas fa-check-circle'></i> SUCESSO!</h3>
                                <p>Varredura completa em $total_analisado itens.<br>
                                <b>$total_alterado links foram atualizados.</b></p>
                                <hr>
                                <div class='text-start small'>Exemplos:<br><ul>$log_visual</ul></div>
                             </div>";
            } else {
                $mensagem = "<div class='alert alert-warning fw-bold p-4 text-center'>
                                <h3><i class='fas fa-search'></i> Nada mudou...</h3>
                                <p>O sistema analisou $total_analisado itens, mas não encontrou o texto: <br>
                                <code class='bg-dark text-white px-2 py-1'>$busca</code></p>
                                <p>Verifique espaços, http/https ou porta.</p>
                             </div>";
            }

        } catch (Exception $e) {
            $pdo->rollBack();
            $mensagem = "<div class='alert alert-danger'>Erro no sistema: " . $e->getMessage() . "</div>";
        }
    } else {
        $mensagem = "<div class='alert alert-danger'>Preencha os dois campos de DNS!</div>";
    }
}

// --- ESPIÃO (Para ajudar a copiar) ---
$exemplo = $pdo->query("SELECT stream_source FROM streams WHERE type = 1 LIMIT 1")->fetchColumn();
// Limpa visualmente para o usuário copiar fácil
$exemplo_limpo = str_replace(['["', '"]', '\/'], ['', '', '/'], $exemplo);
?>

<div class="container-fluid">
    <div class="row justify-content-center mt-4">
        <div class="col-md-8">
            
            <div class="card shadow-lg border-0 rounded-3">
                <div class="card-header bg-primary text-white p-3 fw-bold">
                    <i class="fas fa-magic me-2"></i> Alterador de DNS Automático (Força Bruta)
                </div>
                <div class="card-body p-4">
                    
                    <?= $mensagem ?>

                    <div class="alert alert-info d-flex align-items-center">
                        <i class="fas fa-info-circle fa-2x me-3"></i>
                        <div>
                            <strong>Como usar:</strong> Copie uma parte única do link antigo (ex: <code>http://servidor.com</code>) e coloque o novo. O sistema vai varrer todo o banco e trocar onde encontrar.
                        </div>
                    </div>

                    <form method="POST" onsubmit="return confirm('Tem certeza? Isso vai processar todos os canais/filmes.');">
                        
                        <div class="mb-4 text-center">
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="tipo_conteudo" value="1" checked id="opt1">
                                <label class="form-check-label fw-bold" for="opt1">📺 Canais (Live)</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="tipo_conteudo" value="2" id="opt2">
                                <label class="form-check-label fw-bold" for="opt2">🎬 Filmes (VOD)</label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="fw-bold text-danger">DNS ANTIGO (Texto para buscar)</label>
                            <input type="text" name="dns_antigo" class="form-control form-control-lg" placeholder="Ex: http://velho.com:80" required>
                            <small class="text-muted">Exemplo encontrado no seu banco: <code><?= htmlspecialchars(substr($exemplo_limpo, 0, 50)) ?>...</code></small>
                        </div>

                        <div class="mb-4">
                            <label class="fw-bold text-success">DNS NOVO (Texto para substituir)</label>
                            <input type="text" name="dns_novo" class="form-control form-control-lg" placeholder="Ex: http://novo.com:8080" required>
                        </div>

                        <button type="submit" class="btn btn-success w-100 py-3 fw-bold shadow">
                            <i class="fas fa-sync-alt me-2"></i> INICIAR TROCA EM MASSA
                        </button>
                    </form>

                </div>
            </div>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body></html>
