<?php
session_start();
include '../conexao.php';

if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header('Location: painel_adm.php');
    exit;
}

$erro = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $erro = 'Por favor, preencha o usuário e a senha.';
    } else {
        $stmt = $conexao->prepare("SELECT id, password FROM usuarios WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $stmt->bind_result($id, $hash_senha);
            $stmt->fetch();

            if (password_verify($password, $hash_senha)) {
                session_regenerate_id();
                $_SESSION['loggedin'] = true;
                $_SESSION['user_id'] = $id;
                $_SESSION['username'] = $username;
                
                $host  = $_SERVER['HTTP_HOST'];
                $uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
                header("Location: http://$host$uri/painel_adm.php");
                exit;

            } else {
                $erro = 'Usuário ou senha inválidos!';
            }
        } else {
            $erro = 'Usuário ou senha inválidos!';
        }
        $stmt->close();
    }
}
$conexao->close();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Painel Administrativo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

    <style>
        :root { --primary-color: #6f42c1; --secondary-color: #0d6efd; }
        body { font-family: 'Poppins', sans-serif; display: flex; justify-content: center; align-items: center; min-height: 100vh; background: linear-gradient(45deg, var(--primary-color), var(--secondary-color)); background-size: 400% 400%; animation: gradientBG 15s ease infinite; color: #fff; }
        @keyframes gradientBG { 0% { background-position: 0% 50%; } 50% { background-position: 100% 50%; } 100% { background-position: 0% 50%; } }
        .login-container { width: 100%; max-width: 420px; }
        .login-card { background: rgba(255, 255, 255, 0.1); border-radius: 16px; box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1); backdrop-filter: blur(10px); -webkit-backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.3); padding: 2.5rem; }
        .login-card h1 { font-weight: 600; margin-bottom: 1.5rem; text-align: center; }
        .input-group-custom { position: relative; }
        .form-control-custom { background: transparent; border: none; border-bottom: 2px solid rgba(255, 255, 255, 0.5); border-radius: 0; color: #fff; padding-left: 2.5rem; transition: border-color 0.3s; }
        .form-control-custom:focus { background: transparent; box-shadow: none; border-bottom-color: #fff; color: #fff; }
        .form-control-custom::placeholder { color: rgba(255, 255, 255, 0.7); }
        .input-group-custom .icon { position: absolute; left: 0.75rem; top: 50%; transform: translateY(-50%); color: rgba(255, 255, 255, 0.7); }
        .btn-custom { background: linear-gradient(45deg, var(--secondary-color), var(--primary-color)); border: none; padding: 0.75rem; font-weight: 500; border-radius: 8px; transition: transform 0.2s, box-shadow 0.2s; background-size: 200% auto; }
        .btn-custom:hover { transform: translateY(-2px); box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2); background-position: right center; }
        .alert { background: rgba(255, 255, 255, 0.2); border: 1px solid rgba(255, 255, 255, 0.4); color: #fff; }
        .alert-danger { background: rgba(220, 53, 69, 0.4); }
        .alert-success { background: rgba(25, 135, 84, 0.4); }
    </style>
</head>
<body>
    <div class="container login-container">
        <div class="login-card">
            <h1>Painel Admin</h1>
            
            <?php if (!empty($erro)): ?>
                <div class="alert alert-danger text-center"><?php echo $erro; ?></div>
            <?php endif; ?>
            <?php if (isset($_GET['status']) && $_GET['status'] == 'logout'): ?>
                <div class="alert alert-success text-center">Você saiu com sucesso.</div>
            <?php endif; ?>
            <?php if (isset($_GET['status']) && $_GET['status'] == 'credentials_changed'): ?>
                 <div class="alert alert-success text-center">Dados alterados! Faça login novamente.</div>
            <?php endif; ?>

            <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="POST" class="mt-4">
                <div class="mb-4 input-group-custom">
                    <i class="fas fa-user icon"></i>
                    <input type="text" class="form-control form-control-custom" id="username" name="username" placeholder="Usuário" required>
                </div>
                <div class="mb-4 input-group-custom">
                    <i class="fas fa-lock icon"></i>
                    <input type="password" class="form-control form-control-custom" id="password" name="password" placeholder="Senha" required>
                </div>
                <button type="submit" class="btn btn-light w-100 btn-custom">Entrar</button>
            </form>
        </div>
    </div>
</body>
</html>