<?php
// O CÓDIGO COMPLETO E FINAL PARA O painel_adm.php
// Substitua todo o seu arquivo por este.

session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: login.php');
    exit;
}

include '../conexao.php';

$mensagem = '';
$mensagem_credenciais = '';
$aba_ativa = 'apps';

// --- LÓGICA PARA ALTERAR USUÁRIO E/OU SENHA ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['form_type']) && $_POST['form_type'] == 'change_credentials') {
    // (A lógica de alterar credenciais continua a mesma)
    $aba_ativa = 'credenciais'; $senha_atual = $_POST['senha_atual'] ?? ''; $novo_username = trim($_POST['novo_username'] ?? ''); $nova_senha = $_POST['nova_senha'] ?? ''; $confirma_senha = $_POST['confirma_senha'] ?? '';
    $user_id = $_SESSION['user_id']; $current_username = $_SESSION['username'];
    if (empty($senha_atual)) { $mensagem_credenciais = "<div class='alert alert-danger'>A senha atual é obrigatória.</div>"; }
    elseif (empty($novo_username) && empty($nova_senha)) { $mensagem_credenciais = "<div class='alert alert-info'>Nenhuma alteração solicitada.</div>"; }
    else {
        $stmt = $conexao->prepare("SELECT password FROM usuarios WHERE id = ?"); $stmt->bind_param("i", $user_id); $stmt->execute(); $stmt->bind_result($hash_senha_atual); $stmt->fetch(); $stmt->close();
        if (password_verify($senha_atual, $hash_senha_atual)) {
            $updates = []; $params = []; $types = ''; $error = false;
            if (!empty($novo_username) && $novo_username !== $current_username) {
                $stmt_check = $conexao->prepare("SELECT id FROM usuarios WHERE username = ?"); $stmt_check->bind_param("s", $novo_username); $stmt_check->execute(); $stmt_check->store_result();
                if ($stmt_check->num_rows > 0) { $mensagem_credenciais = "<div class='alert alert-danger'>Erro: O nome de usuário '{$novo_username}' já está em uso.</div>"; $error = true; }
                else { $updates[] = "username = ?"; $params[] = $novo_username; $types .= 's'; }
                $stmt_check->close();
            }
            if (!$error && !empty($nova_senha)) {
                if (strlen($nova_senha) < 8) { $mensagem_credenciais = "<div class='alert alert-danger'>A nova senha deve ter pelo menos 8 caracteres.</div>"; $error = true; }
                elseif ($nova_senha !== $confirma_senha) { $mensagem_credenciais = "<div class='alert alert-danger'>A nova senha e a confirmação não coincidem.</div>"; $error = true; }
                else { $novo_hash = password_hash($nova_senha, PASSWORD_DEFAULT); $updates[] = "password = ?"; $params[] = $novo_hash; $types .= 's'; }
            }
            if (!$error && !empty($updates)) {
                $sql = "UPDATE usuarios SET " . implode(', ', $updates) . " WHERE id = ?"; $params[] = $user_id; $types .= 'i';
                $stmt_update = $conexao->prepare($sql); $stmt_update->bind_param($types, ...$params);
                if ($stmt_update->execute()) { session_destroy(); header("Location: login.php?status=credentials_changed"); exit; }
                else { $mensagem_credenciais = "<div class='alert alert-danger'>Erro ao atualizar os dados.</div>"; }
                $stmt_update->close();
            }
        } else { $mensagem_credenciais = "<div class='alert alert-danger'>A senha atual está incorreta.</div>"; }
    }
}

// --- LÓGICA DE GERENCIAMENTO DE APPS ---
function processar_upload($file_input_name, $upload_dir, $allowed_types, $prefix) {
    if (isset($_FILES[$file_input_name]) && $_FILES[$file_input_name]['error'] == 0) {
        $arquivo_tmp = $_FILES[$file_input_name]['tmp_name'];
        $nome_original = basename($_FILES[$file_input_name]['name']);
        $extensao = strtolower(pathinfo($nome_original, PATHINFO_EXTENSION));
        if (!in_array($extensao, $allowed_types)) {
            return ['sucesso' => false, 'erro' => "Erro: Tipo de arquivo não permitido para ($nome_original)."];
        }
        $novo_nome = $prefix . uniqid() . '.' . $extensao;
        $caminho_final = $upload_dir . $novo_nome;
        if (move_uploaded_file($arquivo_tmp, $caminho_final)) {
            return ['sucesso' => true, 'caminho' => $caminho_final];
        } else {
            return ['sucesso' => false, 'erro' => 'Erro ao mover o arquivo enviado.'];
        }
    }
    return ['sucesso' => true, 'caminho' => null];
}

$app_id = null; $nome = ''; $descricao = ''; $versao = ''; $link_download = ''; $url_icone = ''; $editando = false;

if (isset($_GET['editar'])) { $editando = true; $aba_ativa = 'apps'; $app_id = (int)$_GET['editar']; $stmt = $conexao->prepare("SELECT * FROM aplicativos WHERE id = ?"); $stmt->bind_param("i", $app_id); $stmt->execute(); $resultado = $stmt->get_result(); if ($resultado->num_rows > 0) { $app = $resultado->fetch_assoc(); $nome = $app['nome']; $descricao = $app['descricao']; $versao = $app['versao']; $link_download = $app['link_download']; $url_icone = $app['url_icone']; } $stmt->close(); }
if (isset($_GET['excluir'])) { $app_id_excluir = (int)$_GET['excluir']; $stmt = $conexao->prepare("DELETE FROM aplicativos WHERE id = ?"); $stmt->bind_param("i", $app_id_excluir); $stmt->execute(); $stmt->close(); header("Location: painel_adm.php?msg=excluido"); exit(); }
if (isset($_GET['msg'])) { if ($_GET['msg'] == 'excluido') { $mensagem = "<div class='alert alert-success'>Aplicativo excluído com sucesso!</div>"; } if ($_GET['msg'] == 'sucesso') { $mensagem = "<div class='alert alert-success'>Operação realizada com sucesso!</div>"; } }

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['form_type']) && $_POST['form_type'] == 'manage_app') {
    $aba_ativa = 'apps';
    if (empty($_POST) && isset($_SERVER['CONTENT_LENGTH']) && $_SERVER['CONTENT_LENGTH'] > 0) { $postMaxSize = ini_get('post_max_size'); $mensagem = "<div class='alert alert-danger'>ERRO CRÍTICO: Envio excede o limite do servidor de <strong>{$postMaxSize}</strong>.</div>"; }
    else {
        $nome = $_POST['nome'] ?? ''; $descricao = $_POST['descricao'] ?? ''; $versao = $_POST['versao'] ?? ''; $id_app_post = $_POST['id'] ?? null; $tipo_icone = $_POST['tipo_icone'] ?? 'link'; $tipo_app = $_POST['tipo_app'] ?? 'link'; $caminho_icone_final = $_POST['url_icone_link'] ?? ''; $caminho_app_final = $_POST['link_download_link'] ?? ''; $erro_upload = '';
        if (isset($_FILES['link_download_arquivo']['error']) && $_FILES['link_download_arquivo']['error'] === UPLOAD_ERR_INI_SIZE) { $uploadMax = ini_get('upload_max_filesize'); $erro_upload = "Erro: O arquivo APK excede o limite do servidor de <strong>{$uploadMax}</strong>."; }
        if (isset($_FILES['url_icone_arquivo']['error']) && $_FILES['url_icone_arquivo']['error'] === UPLOAD_ERR_INI_SIZE) { $uploadMax = ini_get('upload_max_filesize'); $erro_upload = "Erro: O ícone excede o limite do servidor de <strong>{$uploadMax}</strong>."; }
        if (!empty($erro_upload)) { $mensagem = "<div class='alert alert-danger'>{$erro_upload}</div>"; }
        elseif (empty($nome) || empty($descricao) || empty($versao)) { $mensagem = "<div class='alert alert-danger'>Erro: Nome, Descrição e Versão são obrigatórios.</div>"; }
        else {
            if ($tipo_icone == 'arquivo' && !empty($_FILES['url_icone_arquivo']['name'])) {
                // LINHA 1 DA CORREÇÃO
                $resultado_upload_icone = processar_upload('url_icone_arquivo', '../uploads/', ['jpg', 'jpeg', 'png', 'gif', 'webp'], 'icone_');
                if ($resultado_upload_icone['sucesso']) { if ($resultado_upload_icone['caminho'] !== null) { $caminho_icone_final = str_replace('../', '', $resultado_upload_icone['caminho']); } } else { $erro_upload = $resultado_upload_icone['erro']; }
            }
            if (empty($erro_upload) && $tipo_app == 'arquivo' && !empty($_FILES['link_download_arquivo']['name'])) {
                // LINHA 2 DA CORREÇÃO
                $resultado_upload_app = processar_upload('link_download_arquivo', '../uploads/', ['apk', 'zip', 'exe', 'msi', 'dmg'], 'app_');
                if ($resultado_upload_app['sucesso']) { if ($resultado_upload_app['caminho'] !== null) { $caminho_app_final = str_replace('../', '', $resultado_upload_app['caminho']); } } else { $erro_upload = $resultado_upload_app['erro']; }
            }
            if (empty($erro_upload)) {
                if (!empty($id_app_post)) { $stmt = $conexao->prepare("UPDATE aplicativos SET nome=?, descricao=?, versao=?, link_download=?, url_icone=? WHERE id=?"); $stmt->bind_param("sssssi", $nome, $descricao, $versao, $caminho_app_final, $caminho_icone_final, $id_app_post); }
                else { $stmt = $conexao->prepare("INSERT INTO aplicativos (nome, descricao, versao, link_download, url_icone) VALUES (?, ?, ?, ?, ?)"); $stmt->bind_param("sssss", $nome, $descricao, $versao, $caminho_app_final, $caminho_icone_final); }
                if ($stmt->execute()) { header("Location: painel_adm.php?msg=sucesso"); exit(); }
                else { $mensagem = "<div class='alert alert-danger'>Erro no banco de dados: " . $stmt->error . "</div>"; }
                $stmt->close();
            } else { $mensagem = "<div class='alert alert-danger'>" . $erro_upload . "</div>"; }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light"> 
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>Painel Administrativo - Loja de Apps</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>:root { --body-bg: #f0f2f5; --container-bg: #ffffff; --text-color: #212529; --border-color: #dee2e6; --table-header-bg: #212529; --table-header-color: #ffffff; } [data-bs-theme="dark"] { --body-bg: #121212; --container-bg: #1e1e1e; --text-color: #e0e0e0; --border-color: #444; --table-header-bg: #343a40; --table-header-color: #ffffff; } [data-bs-theme="dark"] .card, [data-bs-theme="dark"] .form-control, [data-bs-theme="dark"] .table { background-color: #2a2a2a; color: var(--text-color); border-color: var(--border-color); } [data-bs-theme="dark"] .form-control::placeholder { color: #888; } [data-bs-theme="dark"] .form-control:focus { background-color: #2a2a2a; color: var(--text-color); border-color: #80bdff; box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25); } [data-bs-theme="dark"] .text-primary { color: #80bdff !important; } [data-bs-theme="dark"] .table-striped>tbody>tr:nth-of-type(odd)>* { background-color: #333; } body { background-color: var(--body-bg); color: var(--text-color); transition: background-color 0.3s, color 0.3s; } .container { background-color: var(--container-bg); padding: 30px; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); margin-top: 30px; } .tab-content .tab-pane { display: none; } .tab-content .tab-pane.active { display: block; } .theme-toggle { cursor: pointer; font-size: 1.25rem; }</style>
</head>
<body>
    <div class="container">
        <div class="d-flex justify-content-between align-items-center mb-4"><h1 class="text-primary mb-0"><i class="fas fa-cogs me-2"></i>Painel Administrativo</h1><div class="d-flex align-items-center"><div id="theme-toggler" class="theme-toggle me-3" title="Alterar tema"><i class="fas fa-moon"></i></div><a href="logout.php" class="btn btn-danger"><i class="fas fa-sign-out-alt me-1"></i>Sair</a></div></div>
        <ul class="nav nav-tabs mb-4" id="adminTab" role="tablist"><li class="nav-item" role="presentation"><button class="nav-link <?php echo ($aba_ativa == 'apps') ? 'active' : ''; ?>" id="apps-tab" data-bs-toggle="tab" data-bs-target="#apps-tab-pane" type="button" role="tab"><i class="fas fa-mobile-alt me-1"></i> Gerenciar Aplicativos</button></li><li class="nav-item" role="presentation"><button class="nav-link <?php echo ($aba_ativa == 'credenciais') ? 'active' : ''; ?>" id="credenciais-tab" data-bs-toggle="tab" data-bs-target="#credenciais-tab-pane" type="button" role="tab"><i class="fas fa-user-shield me-1"></i> Alterar Usuário/Senha</button></li></ul>
        <div class="tab-content" id="adminTabContent">
            <div class="tab-pane fade <?php echo ($aba_ativa == 'apps') ? 'show active' : ''; ?>" id="apps-tab-pane" role="tabpanel" aria-labelledby="apps-tab" tabindex="0">
                <?php echo $mensagem; ?>
                <div class="card mb-4 border-primary"><div class="card-header bg-primary text-white"><h2 class="h5 mb-0"><i class="fas fa-<?php echo $editando ? 'edit' : 'plus-circle'; ?> me-2"></i><?php echo $editando ? 'Editar App' : 'Adicionar App'; ?></h2></div><div class="card-body"><form action="painel_adm.php" method="POST" enctype="multipart/form-data"><input type="hidden" name="form_type" value="manage_app"><input type="hidden" name="id" value="<?php echo htmlspecialchars((string)$app_id); ?>"><div class="mb-3"><label for="nome" class="form-label">Nome:</label><input type="text" class="form-control" id="nome" name="nome" value="<?php echo htmlspecialchars($nome); ?>" required></div><div class="mb-3"><label for="descricao" class="form-label">Descrição:</label><textarea class="form-control" id="descricao" name="descricao" rows="4" required><?php echo htmlspecialchars($descricao); ?></textarea></div><div class="mb-3"><label for="versao" class="form-label">Versão:</label><input type="text" class="form-control" id="versao" name="versao" value="<?php echo htmlspecialchars($versao); ?>" required></div><hr><div class="mb-3 p-3 border rounded"><label class="form-label fw-bold">Ícone</label><div class="form-check"><input class="form-check-input" type="radio" name="tipo_icone" id="icone_link" value="link" checked><label class="form-check-label" for="icone_link">URL</label></div><div class="form-check"><input class="form-check-input" type="radio" name="tipo_icone" id="icone_arquivo" value="arquivo"><label class="form-check-label" for="icone_arquivo">Upload</label></div><input type="url" class="form-control mt-2" name="url_icone_link" placeholder="https://exemplo.com/icone.png" value="<?php echo htmlspecialchars($url_icone); ?>"><input type="file" class="form-control mt-2" name="url_icone_arquivo" accept="image/*" style="display: none;"></div><div class="mb-3 p-3 border rounded"><label class="form-label fw-bold">Arquivo</label><div class="form-check"><input class="form-check-input" type="radio" name="tipo_app" id="app_link" value="link" checked><label class="form-check-label" for="app_link">URL</label></div><div class="form-check"><input class="form-check-input" type="radio" name="tipo_app" id="app_arquivo" value="arquivo"><label class="form-check-label" for="app_arquivo">Upload</label></div><input type="url" class="form-control mt-2" name="link_download_link" placeholder="https://exemplo.com/app.apk" value="<?php echo htmlspecialchars($link_download); ?>"><input type="file" class="form-control mt-2" name="link_download_arquivo" style="display: none;"></div><button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i>Salvar App</button><?php if ($editando): ?><a href="painel_adm.php" class="btn btn-secondary"><i class="fas fa-times-circle me-1"></i>Cancelar Edição</a><?php endif; ?></form></div></div>
                <h2 class="mt-5 mb-3 text-primary"><i class="fas fa-list me-2"></i>Aplicativos Cadastrados</h2>
                <div class="table-responsive"><table class="table table-striped table-hover align-middle"><thead class="table-dark"><tr><th>Ícone</th><th>Nome</th><th>Versão</th><th>Ações</th></tr></thead><tbody><?php $resultado_lista = $conexao->query("SELECT id, nome, versao, url_icone FROM aplicativos ORDER BY nome ASC"); if ($resultado_lista->num_rows > 0) { while ($app = $resultado_lista->fetch_assoc()) { echo "<tr>"; echo "<td><img src='../" . htmlspecialchars($app['url_icone']) . "' class='img-fluid' alt='Ícone' style='width: 40px; height: 40px; border-radius: 5px;'></td>"; echo "<td>" . htmlspecialchars($app['nome']) . "</td>"; echo "<td>" . htmlspecialchars($app['versao']) . "</td>"; echo "<td> <a href='painel_adm.php?editar=" . $app['id'] . "' class='btn btn-warning btn-sm' title='Editar'><i class='fas fa-edit'></i></a> <a href='painel_adm.php?excluir=" . $app['id'] . "' class='btn btn-danger btn-sm' title='Excluir' onclick='return confirm(\"Tem certeza?\");'><i class='fas fa-trash-alt'></i></a> </td>"; echo "</tr>"; } } else { echo "<tr><td colspan='4' class='text-center'>Nenhum aplicativo cadastrado.</td></tr>"; } ?></tbody></table></div>
            </div>
            <div class="tab-pane fade <?php echo ($aba_ativa == 'credenciais') ? 'show active' : ''; ?>" id="credenciais-tab-pane" role="tabpanel" aria-labelledby="credenciais-tab" tabindex="0">
                <div class="card mb-4 border-warning"><div class="card-header bg-warning text-dark"><h2 class="h5 mb-0"><i class="fas fa-user-edit me-2"></i>Alterar Nome de Usuário e Senha</h2></div><div class="card-body"><?php echo $mensagem_credenciais; ?><form action="painel_adm.php" method="POST"><input type="hidden" name="form_type" value="change_credentials"><div class="mb-3"><label for="novo_username" class="form-label">Novo Nome de Usuário:</label><input type="text" class="form-control" id="novo_username" name="novo_username" value="<?php echo htmlspecialchars($_SESSION['username']); ?>" required><div class="form-text">Deixe como está para não alterar o nome de usuário.</div></div><hr><div class="mb-3"><label for="nova_senha" class="form-label">Nova Senha:</label><input type="password" class="form-control" id="nova_senha" name="nova_senha"><div class="form-text">Deixe em branco para não alterar a senha. Mínimo 8 caracteres.</div></div><div class="mb-3"><label for="confirma_senha" class="form-label">Confirmar Nova Senha:</label><input type="password" class="form-control" id="confirma_senha" name="confirma_senha"></div><hr class="my-4"><div class="mb-3 bg-light p-3 rounded"><label for="senha_atual" class="form-label fw-bold">Sua Senha Atual:</label><input type="password" class="form-control" id="senha_atual" name="senha_atual" required><div class="form-text text-danger">É obrigatório confirmar sua senha atual para fazer qualquer alteração.</div></div><button type="submit" class="btn btn-warning"><i class="fas fa-save me-1"></i>Salvar Alterações</button></form></div></div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const themeToggler = document.getElementById('theme-toggler'); const themeIcon = themeToggler.querySelector('i'); const htmlEl = document.documentElement; const applyTheme = (theme) => { htmlEl.setAttribute('data-bs-theme', theme); themeIcon.className = theme === 'dark' ? 'fas fa-sun' : 'fas fa-moon'; }; const storedTheme = localStorage.getItem('theme'); const systemPrefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches; const currentTheme = storedTheme ? storedTheme : (systemPrefersDark ? 'dark' : 'light'); applyTheme(currentTheme); themeToggler.addEventListener('click', () => { const newTheme = htmlEl.getAttribute('data-bs-theme') === 'dark' ? 'light' : 'dark'; localStorage.setItem('theme', newTheme); applyTheme(newTheme); });
            function setupRadioLogic(radioName, linkInputName, fileInputName) { const radios = document.querySelectorAll(`input[name="${radioName}"]`); const linkInput = document.querySelector(`input[name="${linkInputName}"]`); const fileInput = document.querySelector(`input[name="${fileInputName}"]`); function toggleInputs() { const isLinkSelected = document.querySelector(`input[name="${radioName}"]:checked`).value === 'link'; linkInput.style.display = isLinkSelected ? 'block' : 'none'; fileInput.style.display = isLinkSelected ? 'none' : 'block'; linkInput.disabled = !isLinkSelected; fileInput.disabled = isLinkSelected; } radios.forEach(radio => radio.addEventListener('change', toggleInputs)); toggleInputs(); } 
            setupRadioLogic('tipo_icone', 'url_icone_link', 'url_icone_arquivo'); 
            setupRadioLogic('tipo_app', 'link_download_link', 'link_download_arquivo');
        });
    </script>
</body>
</html>
<?php
$conexao->close();
?>