<?php
// A LINHA MAIS IMPORTANTE: Inclui a conexão com o banco de dados.
include 'conexao.php';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Minha Loja de Aplicativos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        body { background-color: #e9ecef; }
        .navbar { background-color: #0d6efd !important; }
        .navbar-brand, .nav-link { color: white !important; }
        .hero-section {
            background: linear-gradient(45deg, #0d6efd, #6f42c1);
            color: white;
            padding: 80px 0;
            text-align: center;
            margin-bottom: 40px;
        }
        .app-card-wrapper {
            margin-bottom: 30px;
        }
        .app-card { 
            background: #ffffff; 
            border-radius: 10px; 
            box-shadow: 0 4px 10px rgba(0,0,0,0.1); 
            padding: 20px; 
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        .app-icon { 
            width: 100px; 
            height: 100px; 
            object-fit: cover; 
            border-radius: 15px; 
            margin: 0 auto 15px auto;
            border: 2px solid #0d6efd;
            box-shadow: 0 0 8px rgba(13, 110, 253, 0.5);
        }
        .app-info h3 { 
            color: #0d6efd; 
            font-weight: bold; 
            margin-bottom: 10px; 
        }
        .app-info p { 
            color: #6c757d; 
            font-size: 0.9em; 
            flex-grow: 1;
        }
        .btn-download {
            margin-top: 15px;
            width: 100%;
        }
    </style>
</head>
<body>

    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php"><i class="fas fa-mobile-alt me-2"></i>Minha Loja de Apps</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#"><i class="fas fa-info-circle me-1"></i>Sobre</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <header class="hero-section">
        <div class="container">
            <h1 class="display-4 mb-3"><i class="fas fa-rocket me-3"></i>Descubra Seus Próximos Apps Favoritos</h1>
            <p class="lead">Explore nossa coleção de aplicativos incríveis para todas as suas necessidades.</p>
            <a href="#apps-list" class="btn btn-light btn-lg mt-3"><i class="fas fa-arrow-down me-2"></i>Ver Aplicativos</a>
        </div>
    </header>

    <div class="container" id="apps-list">
        <h2 class="text-center mb-5 text-primary">Aplicativos Recentes</h2>
        <div class="row">
            <?php
            $resultado = $conexao->query("SELECT * FROM aplicativos ORDER BY data_adicao DESC");

            if ($resultado && $resultado->num_rows > 0) {
                while($app = $resultado->fetch_assoc()) {
            ?>
                <div class="col-md-4 col-sm-6 app-card-wrapper">
                    <div class="app-card text-center">
                        <img src="<?php echo htmlspecialchars($app['url_icone']); ?>" class="app-icon" alt="Ícone de <?php echo htmlspecialchars($app['nome']); ?>">
                        <div class="app-info">
                            <h3><?php echo htmlspecialchars($app['nome']); ?></h3>
                            <p class="text-muted mb-2">Versão <?php echo htmlspecialchars($app['versao']); ?></p>
                            <p><?php echo nl2br(htmlspecialchars($app['descricao'])); ?></p>
                            <a href="<?php echo htmlspecialchars($app['link_download']); ?>" class="btn btn-primary btn-lg btn-download" target="_blank">
                                <i class="fas fa-download me-2"></i>Download
                            </a>
                        </div>
                    </div>
                </div>
            <?php
                }
            } else {
                echo "<div class='col-12'><p class='alert alert-info text-center'>Nenhum aplicativo disponível no momento. Volte em breve!</p></div>";
            }
            ?>
        </div>
    </div>

    <footer class="bg-dark text-white text-center py-4 mt-5">
        <div class="container">
            <p>&copy; <?php echo date("Y"); ?> Minha Loja de Apps. Todos os direitos reservados.</p>
            <div class="social-icons">
                <a href="#" class="text-white mx-2"><i class="fab fa-facebook-f"></i></a>
                <a href="#" class="text-white mx-2"><i class="fab fa-twitter"></i></a>
                <a href="#" class="text-white mx-2"><i class="fab fa-instagram"></i></a>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>
<?php
// Fecha a conexão com o banco de dados no final do script
if (isset($conexao)) {
    $conexao->close();
}
?>