<?php
session_start();
require_once 'conexao.php';

// Verificação de segurança
if (!isset($_SESSION['logado'])) { 
    // header("Location: login.php"); exit; 
}

$msg = "";
$msg_tipo = "";
$texto_zap = "";

// --- 1. FUNÇÕES AUXILIARES ---
function limpar($dado) {
    if (!$dado) return "";
    $d = json_decode('"'.$dado.'"');
    if($d) $dado = $d;
    return strip_tags(str_replace(['\\', "\r", "\n", "\t"], ' ', $dado));
}

function dataISO($data) {
    if (!$data) return date('Y-m-d');
    if (strpos($data, '/') !== false) {
        $d = DateTime::createFromFormat('d/m/Y', substr($data, 0, 10));
        return $d ? $d->format('Y-m-d') : date('Y-m-d');
    }
    return substr($data, 0, 10);
}

// --- 2. BUSCAR PERFIS E ÍCONES (Do banco GERAL) ---
$lista_perfis = [];
$mapa_perfis = []; 

try {
    $sql_p = "SELECT p.id, p.nome, p.url, p.porta, i.img 
              FROM perfil p 
              LEFT JOIN perfil_icone i ON p.imagem = i.id 
              WHERE (p.bloqueado IS NULL OR p.bloqueado != 'sim') 
              ORDER BY p.nome ASC";
    
    $stmt_p = $connGeral->query($sql_p);
    $lista_perfis = $stmt_p->fetchAll(PDO::FETCH_ASSOC);

    // Cria mapa para acesso rápido na tabela
    foreach ($lista_perfis as $lp) {
        $mapa_perfis[$lp['id']] = [
            'nome'  => $lp['nome'],
            'img'   => $lp['img'],
            'url'   => $lp['url'],
            'porta' => $lp['porta']
        ];
    }

} catch (Exception $e) { }

// --- 3. PROCESSAMENTO (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $acao = $_POST['acao'];
        $id_user = $_POST['id_user'] ?? 0;

        // CRIAR NOVO USUÁRIO
        if ($acao === 'criar') {
            $check = $connUser->prepare("SELECT id FROM usuario WHERE usuario = ?");
            $check->execute([$_POST['usuario']]);
            
            if($check->rowCount() > 0){
                $msg = "Este usuário já existe!"; $msg_tipo = "warning";
            } else {
                $perfil_selecionado = $_POST['perfil_id'] ?? 0;
                $conexoes = $_POST['conexao'];

                // INSERE NO BANCO
                $sql = "INSERT INTO usuario (CadUser, nome, usuario, senha, conexao, data_premio, id_perfil, bloqueado, data_cadastro) 
                        VALUES (?,?,?,?,?,?,?, 'nao', NOW())";
                
                $connUser->prepare($sql)->execute([
                    $_SESSION['usuario'] ?? 'Admin', 
                    $_POST['nome'], 
                    $_POST['usuario'], 
                    $_POST['senha'], 
                    $conexoes, 
                    $_POST['vencimento'],
                    $perfil_selecionado
                ]);
                
                // --- GERAR MENSAGEM COMPLETA DO WHATSAPP ---
                $data_br = date('d/m/Y', strtotime($_POST['vencimento']));
                
                // Busca dados do perfil selecionado para a mensagem
                $url_perfil = "Consulte";
                $porta_perfil = "80";
                
                if (isset($mapa_perfis[$perfil_selecionado])) {
                    $url_perfil = $mapa_perfis[$perfil_selecionado]['url'];
                    $porta_perfil = $mapa_perfis[$perfil_selecionado]['porta'];
                }

                $texto_zap = "*✅ Conta Criada com Sucesso!*\n\n";
                $texto_zap .= "👤 *Usuário:* {$_POST['usuario']}\n";
                $texto_zap .= "🔑 *Senha:* {$_POST['senha']}\n";
                $texto_zap .= "📅 *Vencimento:* $data_br\n";
                $texto_zap .= "📺 *Telas:* $conexoes\n\n";
                $texto_zap .= "🌐 *URL/DNS:* $url_perfil\n";
                $texto_zap .= "🔌 *Porta:* $porta_perfil\n\n";
                $texto_zap .= "Obrigado pela preferência!";
                
                $msg = "Criado com sucesso!"; $msg_tipo = "success";
            }
        }

        // EDITAR USUÁRIO
        if ($acao === 'editar') {
            $perfil_edit = $_POST['perfil_id'] ?? 0;
            
            $connUser->prepare("UPDATE usuario SET nome=?, usuario=?, senha=?, conexao=?, data_premio=?, id_perfil=? WHERE id=?")
                     ->execute([$_POST['nome'], $_POST['usuario'], $_POST['senha'], $_POST['conexao'], $_POST['vencimento_edit'], $perfil_edit, $id_user]);
            
            // Mensagem simples na edição (opcional)
            $data_br = date('d/m/Y', strtotime($_POST['vencimento_edit']));
            $texto_zap = "*Dados Atualizados!*\n\n👤 User: {$_POST['usuario']}\n🔑 Senha: {$_POST['senha']}\n📅 Vence: $data_br";
            
            $msg = "Atualizado!"; $msg_tipo = "primary";
        }

        // RENOVAR
        if ($acao === 'renovar') {
            $tipo = $_POST['tipo_renovacao'];
            $atual = $connUser->query("SELECT data_premio, usuario, senha FROM usuario WHERE id=$id_user")->fetch();
            $base = dataISO($atual['data_premio']);
            $hoje = date('Y-m-d');
            $inicio = ($base < $hoje) ? $hoje : $base;

            if ($tipo == 'manual') $nova = $_POST['nova_data_manual'];
            else {
                $meses = (int)$_POST['qtd_meses'];
                $nova = date('Y-m-d', strtotime("+$meses months", strtotime($inicio)));
            }
            $connUser->prepare("UPDATE usuario SET data_premio=?, bloqueado='nao' WHERE id=?")->execute([$nova, $id_user]);
            
            $exibir = date('d/m/Y', strtotime($nova));
            $texto_zap = "*Renovado com Sucesso!*\n\n👤 User: {$atual['usuario']}\n🔑 Senha: {$atual['senha']}\n📅 Novo Vencimento: $exibir";
            $msg = "Renovado até $exibir"; $msg_tipo = "success";
        }

        // BLOQUEAR / EXCLUIR
        if ($acao === 'bloquear_toggle') {
            $novo = ($_POST['status_atual'] == 'sim') ? 'nao' : 'sim';
            $connUser->prepare("UPDATE usuario SET bloqueado=? WHERE id=?")->execute([$novo, $id_user]);
            $msg = "Status alterado!"; $msg_tipo = "info";
        }
        if ($acao === 'excluir') {
            $connUser->prepare("DELETE FROM usuario WHERE id=?")->execute([$id_user]);
            $msg = "Deletado."; $msg_tipo = "danger";
        }

    } catch (Exception $e) { $msg = "Erro: ".$e->getMessage(); $msg_tipo = "danger"; }
}

// --- 4. LISTAGEM ---
$termo = $_GET['busca'] ?? '';
$sql = "SELECT * FROM usuario WHERE 1=1";
$params = [];
if ($termo) { $sql .= " AND (nome LIKE :t OR usuario LIKE :t)"; $params[':t'] = "%$termo%"; }
$sql .= " ORDER BY id DESC LIMIT 50";

try {
    $stmt = $connUser->prepare($sql);
    $stmt->execute($params);
    $usuarios = $stmt->fetchAll();
} catch(Exception $e) { $usuarios = []; }
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clientes | Painel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background: #151521; color: #e0e0e0; font-family: 'Segoe UI', sans-serif; padding-bottom: 80px; }
        .sidebar { width: 260px; height: 100vh; position: fixed; top: 0; left: 0; background: #1e1e2d; padding: 20px; z-index: 1000; border-right: 1px solid #333; transition: 0.3s; }
        .main-content { margin-left: 260px; padding: 25px; transition: 0.3s; }
        .table-dark { background: #1e1e2d; --bs-table-bg: #1e1e2d; color: #fff; }
        .table-dark td { border-color: #333; vertical-align: middle; }
        .card-custom { background: #1e1e2d; border: 1px solid #333; }
        .form-control, .form-select { background: #2b2b40; border: 1px solid #444; color: #fff; }
        .form-control:focus { background: #32324a; border-color: #7367f0; color: #fff; }
        
        /* ÍCONES */
        .perfil-icon-sm { width: 35px; height: 35px; object-fit: contain; border-radius: 50%; background: #fff; padding: 2px; }
        .perfil-text-only { font-size: 0.8rem; font-weight: bold; color: #0dcaf0; background: rgba(13, 202, 240, 0.1); padding: 2px 8px; border-radius: 12px; }
        
        /* SELEÇÃO NO MODAL */
        .radio-perfil { display: none; }
        .label-perfil { display: flex; align-items: center; gap: 10px; padding: 10px; border: 1px solid #444; border-radius: 8px; cursor: pointer; transition: 0.2s; background: #2b2b40; }
        .label-perfil:hover { background: #3b3b55; }
        .radio-perfil:checked + .label-perfil { border-color: #7367f0; background: rgba(115, 103, 240, 0.2); }
        .perfil-img-select { width: 30px; height: 30px; object-fit: contain; }

        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); } .sidebar.show { transform: translateX(0); }
            .main-content { margin-left: 0; padding: 15px; }
        }
        .overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 999; } .overlay.show { display: block; }
    </style>
</head>
<body>

<div class="overlay" id="overlay" onclick="toggleMenu()"></div>

<div class="modal fade" id="modalZap" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-dark border-success">
            <div class="modal-header border-0"><h5 class="modal-title text-success w-100 text-center">Sucesso!</h5></div>
            <div class="modal-body">
                <textarea id="textoZapArea" class="form-control" rows="8" style="background:#111; color:#0f0; border:1px solid #333; font-family: monospace;"><?= $texto_zap ?></textarea>
            </div>
            <div class="modal-footer border-0 justify-content-center">
                <button onclick="copiarTexto()" class="btn btn-outline-light">Copiar</button>
                <button onclick="enviarZap()" class="btn btn-success"><i class="fab fa-whatsapp"></i> WhatsApp</button>
                <button data-bs-dismiss="modal" class="btn btn-secondary">Fechar</button>
            </div>
        </div>
    </div>
</div>

<nav class="sidebar" id="sidebar">
    <h4 class="mb-5 fw-bold ps-2 text-white">Painel v3.0</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="btn btn-dark text-start border-0 py-2 text-white-50"><i class="fas fa-home me-2"></i> Dashboard</a>
        <a href="clientes.php" class="btn btn-primary text-start border-0 py-2"><i class="fas fa-users me-2"></i> Clientes</a>
        <button onclick="abrirModalCriar()" class="btn btn-dark text-start border-0 py-2 text-success"><i class="fas fa-plus-circle me-2"></i> Novo Cliente</button>
        <a href="sair.php" class="btn btn-dark text-start border-0 py-2 mt-5 text-danger"><i class="fas fa-sign-out-alt me-2"></i> Sair</a>
    </div>
</nav>

<main class="main-content">
    <button class="btn btn-dark d-md-none mb-3" onclick="toggleMenu()"><i class="fas fa-bars"></i></button>

    <?php if($msg): ?>
        <div class="alert alert-<?= $msg_tipo ?> alert-dismissible fade show"><?= $msg ?><button class="btn-close btn-close-white" data-bs-dismiss="alert"></button></div>
    <?php endif; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold">Gerenciar Clientes</h3>
        <button onclick="abrirModalCriar()" class="btn btn-success fw-bold"><i class="fas fa-user-plus me-2"></i> Novo Cliente</button>
    </div>

    <div class="card card-custom mb-4 p-3">
        <form method="GET" class="row g-2">
            <div class="col-md-10">
                <input type="text" name="busca" class="form-control" placeholder="Buscar..." value="<?= htmlspecialchars($termo) ?>">
            </div>
            <div class="col-md-2">
                <button class="btn btn-primary w-100">Filtrar</button>
            </div>
        </form>
    </div>

    <div class="card card-custom">
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0">
                <thead>
                    <tr class="text-secondary small text-uppercase">
                        <th class="ps-3">Cliente</th>
                        <th>Perfil</th>
                        <th>Vencimento</th>
                        <th>Status</th>
                        <th class="text-end pe-3">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($usuarios) > 0): ?>
                        <?php foreach($usuarios as $u): 
                            $nome = limpar($u['nome']);
                            $venc = dataISO($u['data_premio']);
                            $hoje = date('Y-m-d');
                            $bloqueado = ($u['bloqueado'] == 'sim');
                            $vencido = ($venc < $hoje);
                            
                            $stClass = $bloqueado ? 'bg-danger' : ($vencido ? 'bg-warning text-dark' : 'bg-success');
                            $stTxt = $bloqueado ? 'Bloqueado' : ($vencido ? 'Vencido' : 'Ativo');

                            // LÓGICA DO ÍCONE INTELIGENTE
                            $pid = $u['id_perfil'] ?? 0;
                            $icone_html = '<span class="text-muted small">---</span>'; // Padrão vazio

                            if (isset($mapa_perfis[$pid])) {
                                $p_dados = $mapa_perfis[$pid];
                                if (!empty($p_dados['img'])) {
                                    // Se tem imagem, mostra imagem
                                    $caminho = "assets/img/icones/" . $p_dados['img'];
                                    // Adicionamos 'onerror' para mostrar texto se a imagem quebrar
                                    $icone_html = "<img src='$caminho' class='perfil-icon-sm' alt='{$p_dados['nome']}' onerror=\"this.style.display='none'; this.nextElementSibling.style.display='inline-block'\"> <span class='perfil-text-only' style='display:none'>{$p_dados['nome']}</span>";
                                } else {
                                    // Se não tem imagem, mostra nome
                                    $icone_html = "<span class='perfil-text-only'>{$p_dados['nome']}</span>";
                                }
                            }
                        ?>
                        <tr>
                            <td class="ps-3">
                                <div class="fw-bold"><?= $nome ?></div>
                                <div class="text-white-50 small"><?= $u['usuario'] ?></div>
                            </td>
                            <td>
                                <?= $icone_html ?>
                            </td>
                            <td><?= date('d/m/Y', strtotime($venc)) ?></td>
                            <td><span class="badge <?= $stClass ?>"><?= $stTxt ?></span></td>
                            <td class="text-end pe-3">
                                <button onclick="abrirRenovar(<?= $u['id'] ?>, '<?= $nome ?>')" class="btn btn-sm btn-success rounded-circle me-1"><i class="fas fa-calendar-plus"></i></button>
                                <button onclick='abrirEditar(<?= json_encode($u) ?>)' class="btn btn-sm btn-info rounded-circle me-1"><i class="fas fa-pen text-white"></i></button>
                                <form method="POST" class="d-inline">
                                    <input type="hidden" name="acao" value="bloquear_toggle">
                                    <input type="hidden" name="id_user" value="<?= $u['id'] ?>">
                                    <input type="hidden" name="status_atual" value="<?= $u['bloqueado'] ?>">
                                    <button class="btn btn-sm <?= $bloqueado?'btn-secondary':'btn-warning' ?> rounded-circle me-1"><i class="fas <?= $bloqueado?'fa-lock-open':'fa-lock' ?>"></i></button>
                                </form>
                                <button onclick="confirmarExclusao(<?= $u['id'] ?>)" class="btn btn-sm btn-danger rounded-circle"><i class="fas fa-trash"></i></button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="5" class="text-center py-4 text-muted">Nenhum cliente encontrado.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<div class="modal fade" id="modalCriar" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content bg-dark border-secondary">
            <div class="modal-header border-secondary bg-success text-white">
                <h5 class="modal-title fw-bold"><i class="fas fa-user-plus me-2"></i> Novo Cliente</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <input type="hidden" name="acao" value="criar">
                <div class="modal-body p-4">
                    <div class="mb-3"><label>Nome Completo</label><input type="text" name="nome" class="form-control" required></div>
                    <div class="row g-3 mb-4">
                        <div class="col-6"><label>Usuário</label><input type="text" name="usuario" class="form-control" required></div>
                        <div class="col-6"><label>Senha</label><input type="text" name="senha" class="form-control" value="<?= rand(1000,9999) ?>" required></div>
                        <div class="col-6"><label>Vencimento</label><input type="date" name="vencimento" class="form-control" value="<?= date('Y-m-d', strtotime('+30 days')) ?>"></div>
                        <div class="col-6"><label>Conexões</label><input type="number" name="conexao" class="form-control" value="1"></div>
                    </div>

                    <h6 class="text-info border-bottom border-secondary pb-2 mb-3">Selecione o Perfil</h6>
                    <div class="row g-2" style="max-height: 200px; overflow-y: auto;">
                        <?php if(empty($lista_perfis)): ?>
                            <div class="col-12 text-muted">Nenhum perfil cadastrado. Vá em Admin > Perfis.</div>
                        <?php else: ?>
                            <?php foreach($lista_perfis as $idx => $p): 
                                $checked = ($idx === 0) ? 'checked' : ''; 
                                $img = !empty($p['img']) ? "assets/img/icones/{$p['img']}" : "assets/img/default.png";
                            ?>
                            <div class="col-12 col-md-6">
                                <input type="radio" name="perfil_id" id="criar_perf_<?= $p['id'] ?>" value="<?= $p['id'] ?>" class="radio-perfil" <?= $checked ?>>
                                <label for="criar_perf_<?= $p['id'] ?>" class="label-perfil">
                                    <img src="<?= $img ?>" class="perfil-img-select" onerror="this.style.display='none'">
                                    <span class="fw-bold text-white small"><?= $p['nome'] ?></span>
                                </label>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="submit" class="btn btn-success fw-bold px-4">Criar Cliente</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditar" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-dark border-secondary">
            <div class="modal-header border-secondary"><h5 class="modal-title">Editar</h5><button class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
            <form method="POST">
                <input type="hidden" name="acao" value="editar">
                <input type="hidden" name="id_user" id="edit_id">
                <div class="modal-body">
                    <div class="mb-2"><label>Nome</label><input type="text" name="nome" id="edit_nome" class="form-control"></div>
                    <div class="row g-2">
                        <div class="col-6"><label>Usuário</label><input type="text" name="usuario" id="edit_user" class="form-control"></div>
                        <div class="col-6"><label>Senha</label><input type="text" name="senha" id="edit_pass" class="form-control"></div>
                    </div>
                    <div class="mt-2"><label>Vencimento</label><input type="date" name="vencimento_edit" id="edit_venc" class="form-control"></div>
                    <div class="mt-2"><label>Conexões</label><input type="number" name="conexao" id="edit_con" class="form-control"></div>
                    
                    <div class="mt-3">
                        <label class="text-warning">Perfil de Acesso</label>
                        <select name="perfil_id" id="edit_perfil" class="form-select">
                            <option value="0">Sem Perfil (ou antigo)</option>
                            <?php foreach($lista_perfis as $p): ?>
                                <option value="<?= $p['id'] ?>"><?= $p['nome'] ?></option>
                            <?php endforeach; ?>
                        </select>
                        <small class="text-muted">Selecione o perfil correto se estiver vazio</small>
                    </div>
                </div>
                <div class="modal-footer border-secondary"><button class="btn btn-primary w-100">Salvar</button></div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalRenovar" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-dark border-secondary">
            <div class="modal-header border-secondary"><h5 class="modal-title">Renovar <span id="renov_nome" class="text-primary"></span></h5><button class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
            <form method="POST">
                <input type="hidden" name="acao" value="renovar">
                <input type="hidden" name="id_user" id="renov_id">
                <input type="hidden" name="tipo_renovacao" id="tipo_renovacao" value="meses">
                <input type="hidden" name="qtd_meses" id="qtd_meses" value="1">
                <div class="modal-body">
                    <div class="row g-2">
                        <div class="col-6"><button type="button" class="btn btn-renov p-3" onclick="setRenov('meses', 1)">+1 Mês</button></div>
                        <div class="col-6"><button type="button" class="btn btn-renov p-3" onclick="setRenov('meses', 3)">+3 Meses</button></div>
                    </div>
                    <a data-bs-toggle="collapse" href="#areaManual" class="d-block mt-3 text-muted small text-decoration-none text-center">Data manual &darr;</a>
                    <div class="collapse mt-2" id="areaManual">
                        <input type="date" name="nova_data_manual" id="data_manual" class="form-control" onchange="setRenov('manual',0)">
                    </div>
                </div>
                <button type="submit" id="btnSubmitRenov" class="d-none"></button>
            </form>
        </div>
    </div>
</div>

<form id="formExcluir" method="POST"><input type="hidden" name="acao" value="excluir"><input type="hidden" name="id_user" id="delete_id"></form>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function toggleMenu() { document.getElementById('sidebar').classList.toggle('show'); document.getElementById('overlay').classList.toggle('show'); }
    function formatInput(s) { if(!s)return''; if(!isNaN(s)&&s.length>8){return new Date(s*1000).toISOString().split('T')[0];} if(s.includes('/')){let p=s.split('/');if(p.length>=3)return p[2]+'-'+p[1]+'-'+p[0];} return s.substring(0,10); }

    function abrirModalCriar() { new bootstrap.Modal(document.getElementById('modalCriar')).show(); }

    function abrirEditar(u) {
        document.getElementById('edit_id').value = u.id;
        document.getElementById('edit_nome').value = u.nome.replace(/<[^>]*>?/gm, ''); 
        document.getElementById('edit_user').value = u.usuario;
        document.getElementById('edit_pass').value = u.senha;
        document.getElementById('edit_con').value = u.conexao;
        document.getElementById('edit_venc').value = formatInput(u.data_premio);
        
        // PREENCHE O PERFIL NO MODAL DE EDIÇÃO
        document.getElementById('edit_perfil').value = u.id_perfil || 0;
        
        new bootstrap.Modal(document.getElementById('modalEditar')).show();
    }

    function abrirRenovar(id, nome) {
        document.getElementById('renov_id').value = id;
        document.getElementById('renov_nome').innerText = nome.replace(/<[^>]*>?/gm, '');
        new bootstrap.Modal(document.getElementById('modalRenovar')).show();
    }

    function setRenov(tipo, valor) {
        document.getElementById('tipo_renovacao').value = tipo;
        if(tipo === 'meses') { document.getElementById('qtd_meses').value = valor; document.getElementById('btnSubmitRenov').click(); }
    }

    function confirmarExclusao(id) {
        if(confirm('Tem certeza?')) { document.getElementById('delete_id').value = id; document.getElementById('formExcluir').submit(); }
    }

    window.onload = function() {
        let texto = `<?= $texto_zap ?>`;
        if(texto.trim() !== "") new bootstrap.Modal(document.getElementById('modalZap')).show();
    }
    function copiarTexto() { document.getElementById("textoZapArea").select(); document.execCommand("copy"); alert("Copiado!"); }
    function enviarZap() { window.open("https://api.whatsapp.com/send?text=" + encodeURIComponent(document.getElementById("textoZapArea").value), '_blank'); }
</script>
</body>
</html>
