<?php
// Configuração de Fuso Horário (Importante para logs e vencimentos)
date_default_timezone_set('America/Sao_Paulo');

$host = 'localhost'; // Geralmente é localhost mesmo em hospedagem

// ---------------------------------------------------------
// 1. BANCO DE DADOS: GERAL (Configurações)
// ---------------------------------------------------------
$db_geral_nome = 'geanrober_painel_geral';
$db_geral_user = 'geanrober_painel_geral';
$db_geral_pass = 'Jean#909110';

// ---------------------------------------------------------
// 2. BANCO DE DADOS: ACESSOS (Logs e Monitoramento)
// ---------------------------------------------------------
$db_acessos_nome = 'geanrober_painel_acessos';
$db_acessos_user = 'geanrober_painel_acessos';
$db_acessos_pass = 'Jean#909110';

// ---------------------------------------------------------
// 3. BANCO DE DADOS: USER (Clientes e Revendas)
// ---------------------------------------------------------
$db_user_nome = 'geanrober_painel_user';
$db_user_user = 'geanrober_painel_user';
$db_user_pass = 'Jean#909110';


/**
 * Função genérica para conectar ao banco via PDO
 */
function conectarBanco($host, $db_nome, $db_user, $db_pass) {
    try {
        // DSN define o driver, host, nome do banco e charset
        $dsn = "mysql:host=$host;dbname=$db_nome;charset=utf8mb4";
        
        $opcoes = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, // Mostra erros de SQL
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC, // Traz dados como array associativo
            PDO::ATTR_EMULATE_PREPARES => false, // Segurança contra SQL Injection
        ];

        return new PDO($dsn, $db_user, $db_pass, $opcoes);

    } catch (PDOException $e) {
        // Em produção, não mostre o erro completo para o usuário, grave em log.
        // Mas para você configurar agora, vamos mostrar:
        die("Erro ao conectar no banco <b>$db_nome</b>: " . $e->getMessage());
    }
}

// ---------------------------------------------------------
// CRIAÇÃO DAS CONEXÕES GLOBAIS
// ---------------------------------------------------------

try {
    // Variável $connGeral -> Use para tabelas de configuração
    $connGeral = conectarBanco($host, $db_geral_nome, $db_geral_user, $db_geral_pass);

    // Variável $connAcessos -> Use para tabelas de logs
    $connAcessos = conectarBanco($host, $db_acessos_nome, $db_acessos_user, $db_acessos_pass);

    // Variável $connUser -> Use para tabela usuario, rev, teste
    $connUser = conectarBanco($host, $db_user_nome, $db_user_user, $db_user_pass);

} catch (Exception $e) {
    die("Erro Crítico: " . $e->getMessage());
}
?>
