<?php
session_start();
// Apenas Admin tem acesso
if (!isset($_SESSION['logado']) || $_SESSION['nivel'] !== 'admin') { 
    header("Location: index.php"); 
    exit; 
}

// Conecta ao arquivo central (que tem $connGeral)
require_once 'conexao.php';

$msg = "";
$msg_tipo = "";

// --- 1. SALVAR DADOS ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $senha   = trim($_POST['senha']);
        $deskeys = trim($_POST['deskeys']);
        $ip      = trim($_POST['ip']);
        $iplock  = $_POST['iplock']; // sim ou nao

        // Verifica se já existe a configuração (ID 1)
        $check = $connGeral->query("SELECT id FROM painel_config WHERE id = 1");
        
        if ($check->rowCount() > 0) {
            // Atualiza
            $sql = "UPDATE painel_config SET senha = ?, deskeys = ?, ip = ?, iplock = ? WHERE id = 1";
            $stmt = $connGeral->prepare($sql);
            $stmt->execute([$senha, $deskeys, $ip, $iplock]);
        } else {
            // Cria a primeira vez
            $sql = "INSERT INTO painel_config (id, senha, deskeys, ip, iplock) VALUES (1, ?, ?, ?, ?)";
            $stmt = $connGeral->prepare($sql);
            $stmt->execute([$senha, $deskeys, $ip, $iplock]);
        }

        $msg = "Configurações do Servidor atualizadas!";
        $msg_tipo = "success";

    } catch (PDOException $e) {
        $msg = "Erro ao salvar no Banco Geral: " . $e->getMessage();
        $msg_tipo = "danger";
    }
}

// --- 2. BUSCAR DADOS ---
try {
    $stmt = $connGeral->query("SELECT * FROM painel_config WHERE id = 1");
    $config = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erro de conexão com Banco Geral: " . $e->getMessage());
}

// Helper para selecionar o option correto
function selecionado($valor_banco, $valor_atual) {
    return ($valor_banco == $valor_atual) ? 'selected' : '';
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações do Servidor | Painel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --bg-body: #151521; --bg-card: #1e1e2d; --primary: #7367f0; }
        body { background: var(--bg-body); color: #fff; font-family: 'Segoe UI', sans-serif; }
        
        .sidebar { width: 260px; height: 100vh; position: fixed; background: #1e1e2d; padding: 20px; border-right: 1px solid #333; transition: 0.3s; z-index: 1000; }
        .main-content { margin-left: 260px; padding: 30px; transition: 0.3s; }

        /* Estilo dos Labels para visibilidade */
        .form-label { color: #ffffff !important; font-weight: 700; font-size: 0.95rem; margin-bottom: 5px; display: block; }
        .text-obs { color: #aaaaaa !important; font-size: 0.85rem; margin-top: 5px; }

        .card-custom { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.1); border-radius: 12px; padding: 25px; }
        .form-control, .form-select { background: #2b2b40 !important; border: 1px solid #444 !important; color: #fff !important; height: 45px; }
        .form-control:focus, .form-select:focus { border-color: var(--primary); box-shadow: none; }

        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); } .sidebar.show { transform: translateX(0); }
            .main-content { margin-left: 0; padding: 15px; } .mobile-toggle { display: block !important; }
        }
        .mobile-toggle { display: none; font-size: 1.5rem; color: #fff; background: none; border: none; margin-bottom: 20px; }
        .overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 999; }
        .overlay.show { display: block; }
        
        .nav-link { color: #a6a6b7; text-decoration: none; display: flex; align-items: center; gap: 10px; padding: 10px; border-radius: 8px; }
        .nav-link.active { background: var(--primary); color: #fff; }
    </style>
</head>
<body>

<div class="overlay" id="overlay" onclick="toggleMenu()"></div>

<nav class="sidebar" id="sidebar">
    <h4 class="mb-4 fw-bold text-white"><i class="fas fa-tv text-primary"></i> Painel v3.0</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="nav-link text-white"><i class="fas fa-home"></i> Dashboard</a>
        
        <div class="mt-2 mb-1 px-3 text-uppercase fw-bold text-light" style="font-size: 0.75rem; opacity: 0.7;">Administração</div>
        <a href="config_geral.php" class="nav-link active text-white"><i class="fas fa-cogs text-info"></i> Config. Servidor</a>
        <a href="permissoes_server.php" class="nav-link text-white"><i class="fas fa-server text-warning"></i> Permissões CSP</a>
        <a href="revendedores.php" class="nav-link text-white"><i class="fas fa-store"></i> Revendedores</a>
        <a href="configuracoes.php" class="nav-link text-white"><i class="fas fa-wallet"></i> Pagamentos</a>
        
        <div class="mb-2 border-bottom border-secondary opacity-50"></div>

        <a href="clientes.php" class="nav-link text-white"><i class="fas fa-users"></i> Clientes</a>
        <a href="sair.php" class="nav-link text-danger mt-4"><i class="fas fa-sign-out-alt"></i> Sair</a>
    </div>
</nav>

<main class="main-content">
    <button class="mobile-toggle" onclick="toggleMenu()"><i class="fas fa-bars"></i></button>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card card-custom">
                <h4 class="text-primary mb-4"><i class="fas fa-cogs me-2"></i> Configuração do Painel (Geral)</h4>
                
                <?php if($msg): ?>
                    <div class="alert alert-<?= $msg_tipo ?> alert-dismissible fade show">
                        <?= $msg ?> <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">Senha do Servidor</label>
                        <input type="text" name="senha" class="form-control" value="<?= $config['senha'] ?? '' ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">DesKeys (Chave de Criptografia)</label>
                        <input type="text" name="deskeys" class="form-control" value="<?= $config['deskeys'] ?? '' ?>" required>
                        <div class="text-obs">Geralmente: 0102030405060708091011121314</div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">IP / Host do Servidor</label>
                        <input type="text" name="ip" class="form-control" value="<?= $config['ip'] ?? '' ?>">
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Bloqueio de IP (IP Lock)</label>
                        <select name="iplock" class="form-select">
                            <option value="nao" <?= selecionado($config['iplock'] ?? '', 'nao') ?>>Não (Desativado)</option>
                            <option value="sim" <?= selecionado($config['iplock'] ?? '', 'sim') ?>>Sim (Ativado)</option>
                        </select>
                        <div class="text-obs">Se ativar, o sistema pode bloquear conexões de IPs desconhecidos.</div>
                    </div>

                    <div class="mt-4 border-top border-secondary pt-3">
                        <button type="submit" class="btn btn-info w-100 p-3 fw-bold text-white">
                            <i class="fas fa-save me-2"></i> Atualizar Configurações
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function toggleMenu() { document.getElementById('sidebar').classList.toggle('show'); document.getElementById('overlay').classList.toggle('show'); }
</script>
</body>
</html>
