<?php
session_start();
if (!isset($_SESSION['logado'])) { header("Location: index.php"); exit; }
require_once 'conexao.php'; // Usa $connGeral

$msg = ""; $msg_tipo = "";
$usuario_logado = $_SESSION['usuario']; 

// --- 1. INICIALIZAÇÃO (Garante que o usuário tenha config) ---
$tem_config = $connGeral->prepare("SELECT id FROM email_adicionar WHERE dono = ?");
$tem_config->execute([$usuario_logado]);

if ($tem_config->rowCount() == 0) {
    // Cria padrões
    $connGeral->prepare("INSERT INTO email_adicionar (servidor, dono) VALUES ('Meu Servidor TV', ?)")->execute([$usuario_logado]);
    $connGeral->prepare("INSERT INTO email_preferencias (DadosDeAcesso, Vencimento, Renovacao, dono) VALUES (1, 1, 1, ?)")->execute([$usuario_logado]);
    
    $msgs_padrao = [
        ['tipo' => 'novo_user', 'assunto' => 'Bem-vindo!', 'mensagem' => 'Olá {nome}, seu usuário é {usuario} e senha {senha}.'],
        ['tipo' => 'vencimento', 'assunto' => 'Sua fatura venceu', 'mensagem' => 'Olá {nome}, sua assinatura venceu em {vencimento}.'],
        ['tipo' => 'renovacao', 'assunto' => 'Obrigado por renovar', 'mensagem' => 'Sua conta foi renovada até {vencimento}.'],
        ['tipo' => 'teste_cs', 'assunto' => 'Seu Teste CS/IPTV', 'mensagem' => 'Olá, aqui está seu teste.\nLogin: {usuario}\nSenha: {senha}\nURL: {url}\nPorta: {porta}\nExpira em: {tempo} horas.']
    ];
    foreach($msgs_padrao as $mod) {
        $connGeral->prepare("INSERT INTO email_modelo (tipo, assunto, mensagem, dono) VALUES (?, ?, ?, ?)")
                  ->execute([$mod['tipo'], $mod['assunto'], $mod['mensagem'], $usuario_logado]);
    }
}

// --- 2. PROCESSAMENTO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $acao = $_POST['acao'];

        // SALVAR SMTP
        if ($acao === 'salvar_smtp') {
            $sql = "UPDATE email_adicionar SET servidor=?, email=?, usuario=?, senha=?, SMTPSecure=?, Host=?, Port=? WHERE dono=?";
            $connGeral->prepare($sql)->execute([
                $_POST['servidor'], $_POST['email'], $_POST['usuario_smtp'], 
                $_POST['senha_smtp'], $_POST['smtp_secure'], $_POST['host'], $_POST['port'], $usuario_logado
            ]);
            $msg = "Configuração SMTP salva!"; $msg_tipo = "success";
        }

        // SALVAR PREFERÊNCIAS
        if ($acao === 'salvar_pref') {
            $dados = isset($_POST['dados']) ? 1 : 0;
            $venc = isset($_POST['vencimento']) ? 1 : 0;
            $renov = isset($_POST['renovacao']) ? 1 : 0;
            $teste = isset($_POST['teste_auto']) ? 1 : 0;

            $connGeral->prepare("UPDATE email_preferencias SET DadosDeAcesso=?, Vencimento=?, Renovacao=? WHERE dono=?")
                      ->execute([$dados, $venc, $renov, $usuario_logado]);
            $msg = "Preferências atualizadas!"; $msg_tipo = "primary";
        }

        // SALVAR MODELO
        if ($acao === 'salvar_modelo') {
            $id_modelo = $_POST['id_modelo'];
            $assunto = $_POST['assunto'];
            $mensagem = $_POST['mensagem'];
            $connGeral->prepare("UPDATE email_modelo SET assunto=?, mensagem=? WHERE id=? AND dono=?")
                      ->execute([$assunto, $mensagem, $id_modelo, $usuario_logado]);
            $msg = "Modelo de texto salvo!"; $msg_tipo = "success";
        }

    } catch (Exception $e) { $msg = "Erro: " . $e->getMessage(); $msg_tipo = "danger"; }
}

// --- 3. BUSCAR DADOS ---
$smtp = $connGeral->prepare("SELECT * FROM email_adicionar WHERE dono = ?");
$smtp->execute([$usuario_logado]);
$smtp = $smtp->fetch(PDO::FETCH_ASSOC);

$pref = $connGeral->prepare("SELECT * FROM email_preferencias WHERE dono = ?");
$pref->execute([$usuario_logado]);
$pref = $pref->fetch(PDO::FETCH_ASSOC);

$modelos = $connGeral->prepare("SELECT * FROM email_modelo WHERE dono = ?");
$modelos->execute([$usuario_logado]);
$lista_modelos = $modelos->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurar E-mail</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        /* ESTILO GLOBAL ESCURO */
        :root { --bg-body: #151521; --bg-card: #1e1e2d; --primary: #7367f0; }
        body { background: var(--bg-body); color: #fff; font-family: 'Segoe UI', sans-serif; }
        
        .sidebar { width: 260px; height: 100vh; position: fixed; background: #1e1e2d; padding: 20px; border-right: 1px solid #333; z-index: 1000; }
        .main-content { margin-left: 260px; padding: 30px; }
        .card-custom { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.1); border-radius: 12px; }
        
        /* CORREÇÃO DE VISIBILIDADE (TEXTO BRANCO EM TUDO) */
        label, .form-label { color: #ffffff !important; font-weight: 600; margin-bottom: 5px; font-size: 0.95rem; }
        .form-check-label { color: #ffffff !important; }
        h5, h3 { color: #ffffff !important; }
        .text-muted { color: #bbbbbb !important; } /* Deixa o texto de ajuda mais claro */

        /* CAMPOS DE TEXTO */
        .form-control, .form-select { 
            background: #2b2b40 !important; 
            border: 1px solid #555 !important; 
            color: #ffffff !important; 
        }
        .form-control:focus, .form-select:focus { border-color: var(--primary) !important; box-shadow: 0 0 0 0.2rem rgba(115, 103, 240, 0.25); }
        .form-control::placeholder { color: #888 !important; }

        /* ABAS */
        .nav-tabs .nav-link { color: #aaa; border: none; font-weight: 500; }
        .nav-tabs .nav-link.active { background-color: var(--primary); color: white; border-radius: 5px; }
        .accordion-button { background: #2b2b40; color: #fff; font-weight: bold; }
        .accordion-button:not(.collapsed) { background: #4a4a6a; color: #fff; }
        
        @media (max-width: 768px) { .sidebar{display:none;} .main-content{margin-left:0;} }
    </style>
</head>
<body>

<nav class="sidebar">
    <h4 class="mb-4 fw-bold text-white"><i class="fas fa-tv text-primary"></i> Painel</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="btn btn-dark text-start border-0 py-2"><i class="fas fa-home me-2"></i> Dashboard</a>
        <?php if($_SESSION['nivel']=='admin'): ?>
            <a href="revendedores.php" class="btn btn-dark text-start border-0 py-2"><i class="fas fa-store me-2"></i> Revendas</a>
        <?php endif; ?>
        <a href="clientes.php" class="btn btn-dark text-start border-0 py-2"><i class="fas fa-users me-2"></i> Clientes</a>
        <a href="testes.php" class="btn btn-dark text-start border-0 py-2"><i class="fas fa-stopwatch me-2"></i> Testes</a>
        <a href="gerenciar_email.php" class="btn btn-primary text-start border-0 py-2"><i class="fas fa-envelope me-2"></i> Config. E-mail</a>
    </div>
</nav>

<main class="main-content">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold text-white">Configuração de E-mail</h3>
        <span class="badge bg-primary fs-6">Usuário: <?= $usuario_logado ?></span>
    </div>

    <?php if($msg): ?><div class="alert alert-<?= $msg_tipo ?> alert-dismissible fade show"><?= $msg ?><button class="btn-close btn-close-white" data-bs-dismiss="alert"></button></div><?php endif; ?>

    <div class="card card-custom p-4">
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#smtp"><i class="fas fa-server me-2"></i> SMTP (Envio)</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#pref"><i class="fas fa-toggle-on me-2"></i> Ativação</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#modelos"><i class="fas fa-pen-nib me-2"></i> Mensagens</button></li>
        </ul>

        <div class="tab-content pt-3">
            
            <div class="tab-pane fade show active" id="smtp">
                <form method="POST">
                    <input type="hidden" name="acao" value="salvar_smtp">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Nome de Exibição (Ex: Suporte TV)</label>
                            <input type="text" name="servidor" class="form-control" value="<?= $smtp['servidor'] ?? '' ?>" placeholder="Nome que aparece pro cliente">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">E-mail do Remetente</label>
                            <input type="email" name="email" class="form-control" value="<?= $smtp['email'] ?? '' ?>" placeholder="seuemail@exemplo.com">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Host SMTP (Ex: smtp.gmail.com)</label>
                            <input type="text" name="host" class="form-control" value="<?= $smtp['Host'] ?? '' ?>">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Porta</label>
                            <input type="number" name="port" class="form-control" value="<?= $smtp['Port'] ?? '587' ?>">
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Criptografia</label>
                            <select name="smtp_secure" class="form-select">
                                <option value="tls" <?= ($smtp['SMTPSecure']??'')=='tls'?'selected':'' ?>>TLS</option>
                                <option value="ssl" <?= ($smtp['SMTPSecure']??'')=='ssl'?'selected':'' ?>>SSL</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Usuário SMTP (Login)</label>
                            <input type="text" name="usuario_smtp" class="form-control" value="<?= $smtp['usuario'] ?? '' ?>">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Senha SMTP</label>
                            <input type="password" name="senha_smtp" class="form-control" value="<?= $smtp['senha'] ?? '' ?>">
                        </div>
                    </div>
                    <div class="mt-4 text-end"><button class="btn btn-success fw-bold px-4">Salvar Configurações SMTP</button></div>
                </form>
            </div>

            <div class="tab-pane fade" id="pref">
                <form method="POST">
                    <input type="hidden" name="acao" value="salvar_pref">
                    <h5 class="text-info mb-4 border-bottom border-secondary pb-2">Quando enviar e-mail?</h5>
                    
                    <div class="form-check form-switch mb-4">
                        <input class="form-check-input" type="checkbox" name="dados" id="chk1" <?= ($pref['DadosDeAcesso']??0)==1 ? 'checked' : '' ?>>
                        <label class="form-check-label fs-5" for="chk1">Ao Criar Usuário (Enviar Login/Senha)</label>
                    </div>
                    <div class="form-check form-switch mb-4">
                        <input class="form-check-input" type="checkbox" name="vencimento" id="chk2" <?= ($pref['Vencimento']??0)==1 ? 'checked' : '' ?>>
                        <label class="form-check-label fs-5" for="chk2">Aviso de Vencimento (3 dias antes)</label>
                    </div>
                    <div class="form-check form-switch mb-4">
                        <input class="form-check-input" type="checkbox" name="renovacao" id="chk3" <?= ($pref['Renovacao']??0)==1 ? 'checked' : '' ?>>
                        <label class="form-check-label fs-5" for="chk3">Confirmação de Renovação</label>
                    </div>
                    <div class="form-check form-switch mb-4">
                        <input class="form-check-input" type="checkbox" name="teste_auto" id="chk4" checked disabled>
                        <label class="form-check-label fs-5 text-warning" for="chk4">Envio de Teste CS/IPTV (Sempre Ativo)</label>
                    </div>

                    <div class="mt-4 text-end"><button class="btn btn-primary fw-bold px-4">Salvar Preferências</button></div>
                </form>
            </div>

            <div class="tab-pane fade" id="modelos">
                <div class="accordion" id="accModelos">
                    <?php if(empty($lista_modelos)): ?>
                        <div class="text-center p-3 text-white">Nenhum modelo. Recarregue a página para gerar os padrões.</div>
                    <?php else: ?>
                        <?php foreach($lista_modelos as $index => $m): 
                            $nome_tipo = match($m['tipo']) {
                                'teste_cs' => '🧪 E-mail de Teste (CS/IPTV)',
                                'novo_user' => '👤 Novo Cliente (Boas-vindas)',
                                'vencimento' => '📅 Aviso de Vencimento',
                                'renovacao' => '✅ Confirmação de Renovação',
                                default => ucfirst($m['tipo'])
                            };
                        ?>
                        <div class="accordion-item bg-dark border-secondary mb-2">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#mod<?= $m['id'] ?>">
                                    <?= $nome_tipo ?>
                                </button>
                            </h2>
                            <div id="mod<?= $m['id'] ?>" class="accordion-collapse collapse" data-bs-parent="#accModelos">
                                <div class="accordion-body bg-dark">
                                    <form method="POST">
                                        <input type="hidden" name="acao" value="salvar_modelo">
                                        <input type="hidden" name="id_modelo" value="<?= $m['id'] ?>">
                                        <div class="mb-3">
                                            <label class="form-label text-warning">Assunto do E-mail</label>
                                            <input type="text" name="assunto" class="form-control" value="<?= $m['assunto'] ?>">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label text-warning">Corpo da Mensagem (HTML)</label>
                                            <textarea name="mensagem" class="form-control font-monospace text-light" rows="6" style="background:#1a1a2e;"><?= $m['mensagem'] ?></textarea>
                                            <div class="mt-2 p-2 border border-secondary rounded bg-secondary bg-opacity-10">
                                                <small class="text-light fw-bold">Variáveis disponíveis:</small><br>
                                                <small class="text-muted">{nome}, {usuario}, {senha}, {vencimento}</small>
                                                <?php if($m['tipo'] == 'teste_cs'): ?>
                                                    <small class="text-info">, {url}, {porta}, {tempo}</small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <button class="btn btn-info btn-sm float-end fw-bold">Salvar Texto</button>
                                        <div class="clearfix"></div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
