<?php
// 1. SEGURANÇA E SESSÃO
session_start();
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    header("Location: login.php");
    exit;
}

// Conexão com Banco de Dados
require_once 'conexao.php';

// --- FUNÇÕES AUXILIARES ---
function limpar_dash($dado) {
    if (!$dado) return "";
    $d = json_decode('"'.$dado.'"');
    if($d) $dado = $d;
    $dado = strip_tags($dado);
    $dado = str_replace(['\\', "\r", "\n", "\t"], ' ', $dado);
    if (strlen($dado) > 25) return substr($dado, 0, 25) . "...";
    return $dado;
}

function dataISO_dash($data) {
    if (!$data) return date('Y-m-d');
    $data = trim($data);
    if (is_numeric($data) && strlen($data) > 8) return date('Y-m-d', $data);
    if (strpos($data, '/') !== false) {
        $d = DateTime::createFromFormat('d/m/Y', substr($data, 0, 10));
        return $d ? $d->format('Y-m-d') : date('Y-m-d');
    }
    return substr($data, 0, 10);
}

// --- LÓGICA DE DADOS ---
$total_clientes = 0;
$ativos = 0;
$vencidos = 0;
$faturamento = 0.00;
$lista_ultimos = []; 
$lista_proximos_vencimentos = [];
$lista_final_servidores = []; 

try {
    // 1. DADOS DOS CLIENTES
    if ($_SESSION['nivel'] === 'admin') {
        $sql = "SELECT * FROM usuario WHERE nome NOT LIKE '%Formas de Pagamento%' ORDER BY id DESC";
        $stmt = $connUser->query($sql);
    } else {
        $sql = "SELECT * FROM usuario WHERE CadUser = :user AND nome NOT LIKE '%Formas de Pagamento%' ORDER BY id DESC";
        $stmt = $connUser->prepare($sql);
        $stmt->execute([':user' => $_SESSION['usuario']]);
    }
    
    $todos_usuarios = $stmt->fetchAll();
    $hoje = date('Y-m-d');
    $limite_7_dias = date('Y-m-d', strtotime('+7 days'));

    foreach ($todos_usuarios as $u) {
        $nomeLimpo = limpar_dash($u['nome']);
        if (strlen($nomeLimpo) < 2) continue;

        $total_clientes++;
        $data_premio = dataISO_dash($u['data_premio']);
        $is_bloqueado = ($u['bloqueado'] == 'sim');
        $is_vencido = ($data_premio < $hoje);

        if (!$is_bloqueado) {
            if ($is_vencido) {
                $vencidos++;
            } else {
                $ativos++;
                $valor = str_replace(['R$', ' ', '.'], '', $u['ValorCobrado'] ?? '0');
                $valor = str_replace(',', '.', $valor);
                $faturamento += (float) $valor;
            }
        }

        // Vencimentos Próximos
        if (!$is_bloqueado && $data_premio >= $hoje && $data_premio <= $limite_7_dias) {
            $lista_proximos_vencimentos[] = [
                'nome' => $nomeLimpo,
                'usuario' => limpar_dash($u['usuario']),
                'data' => $data_premio,
                'dias_restantes' => (strtotime($data_premio) - strtotime($hoje)) / (60 * 60 * 24),
                'telefone' => $u['celular']
            ];
        }

        // Últimos Cadastros
        if (count($lista_ultimos) < 5) {
            $lista_ultimos[] = [
                'nome' => $nomeLimpo,
                'usuario' => limpar_dash($u['usuario']),
                'data' => $data_premio,
                'status' => $is_bloqueado ? 'bloqueado' : ($is_vencido ? 'vencido' : 'ativo')
            ];
        }
    }
    usort($lista_proximos_vencimentos, function($a, $b) { return strtotime($a['data']) - strtotime($b['data']); });

    // 2. BUSCA PERFIS DO SERVIDOR
    try {
        $sql_perfis = "SELECT nome, url, porta, tipo FROM perfil WHERE (bloqueado IS NULL OR bloqueado != 'sim')";
        $stmt_p = $connGeral->query($sql_perfis);
        $perfis = $stmt_p ? $stmt_p->fetchAll(PDO::FETCH_ASSOC) : [];

        $sql_mascaras = "SELECT m.nome, m.url, m.porta, p.tipo FROM mascaraurl m LEFT JOIN perfil p ON m.perfil = p.id WHERE (m.bloqueado IS NULL OR m.bloqueado != 'sim')";
        $stmt_m = $connGeral->query($sql_mascaras);
        $mascaras = $stmt_m ? $stmt_m->fetchAll(PDO::FETCH_ASSOC) : [];

        $lista_final_servidores = array_merge($perfis, $mascaras);
        usort($lista_final_servidores, function($a, $b) { return strcmp($a['nome'], $b['nome']); });
    } catch (Exception $e) { }

} catch (Exception $e) { die("Erro de Dados: " . $e->getMessage()); }
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard | Painel IPTV</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --sidebar-width: 260px; --bg-body: #151521; --bg-card: #1e1e2d; --primary: #7367f0; }
        body { background: var(--bg-body); color: #e0e0e0; font-family: 'Segoe UI', sans-serif; overflow-x: hidden; padding-bottom: 60px; }
        
        .sidebar { width: 260px; height: 100vh; position: fixed; top: 0; left: 0; background: #1e1e2d; padding: 20px; z-index: 1000; border-right: 1px solid #333; transition: 0.3s; }
        .main-content { margin-left: 260px; padding: 30px; transition: 0.3s; }
        
        .nav-link { color: #a6a6b7; padding: 12px; border-radius: 8px; margin-bottom: 5px; display: flex; align-items: center; gap: 10px; text-decoration: none; transition: 0.2s; }
        .nav-link:hover, .nav-link.active { background: var(--primary); color: #fff; }
        
        /* Submenu */
        .submenu-link { padding-left: 20px; font-size: 0.9rem; color: #b0b0c0; }
        .submenu-link:hover { color: #fff; background: rgba(255,255,255,0.05); }

        .stat-card { background: var(--bg-card); border-radius: 15px; padding: 25px; position: relative; overflow: hidden; box-shadow: 0 4px 20px rgba(0,0,0,0.2); border: 1px solid rgba(255,255,255,0.02); }
        .table-dark { background: var(--bg-card); --bs-table-bg: var(--bg-card); color: #fff; }
        .pag-btn { background: #2b2b40; border: 1px solid #444; color: #fff; padding: 5px 10px; border-radius: 5px; cursor: pointer; }
        
        .copy-click { cursor: pointer; color: #ffffff !important; font-weight: 500; transition: 0.2s; }
        .copy-click:hover { color: #0dcaf0 !important; text-shadow: 0 0 5px rgba(13, 202, 240, 0.5); }
        
        /* CORREÇÃO DE CORES DA TABELA */
        .table thead th { color: #ffffff !important; opacity: 0.8; font-weight: 600; }
        .table tbody td { color: #ffffff !important; }

        @media (max-width: 768px) { 
            .sidebar { transform: translateX(-100%); } .sidebar.show { transform: translateX(0); } 
            .main-content { margin-left: 0; padding: 15px; } .mobile-toggle { display: block !important; } 
        }
        .mobile-toggle { display: none; font-size: 1.5rem; color: #fff; background: none; border: none; margin-bottom: 20px; }
        .overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 999; }
        .overlay.show { display: block; }
    </style>
</head>
<body>

<div class="overlay" id="overlay" onclick="toggleMenu()"></div>

<nav class="sidebar" id="sidebar">
    <h4 class="mb-4 fw-bold text-white"><i class="fas fa-tv text-primary"></i> Painel v3.0</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="nav-link active"><i class="fas fa-home"></i> Dashboard</a>
        
        <?php if ($_SESSION['nivel'] === 'admin'): ?>
            <div class="mt-2 mb-1 px-3 text-uppercase fw-bold text-light" style="font-size: 0.75rem; opacity: 0.7;">Administração</div>
            
            <a class="nav-link text-white d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#submenuPainel" role="button" aria-expanded="false">
                <span><i class="fas fa-sliders-h text-info me-2"></i> Painel</span>
                <i class="fas fa-chevron-down small"></i>
            </a>
            
            <div class="collapse" id="submenuPainel">
                <div class="bg-dark rounded border border-secondary p-2 ms-2 mb-2">
                    <a href="personalizar_painel.php" class="nav-link submenu-link"><i class="fas fa-paint-brush me-2 text-danger"></i> Personalizar</a>
                    <a href="config_geral.php" class="nav-link submenu-link"><i class="fas fa-cogs me-2 text-warning"></i> Config. Geral</a>
                    <a href="gerenciar_dns.php" class="nav-link submenu-link"><i class="fas fa-network-wired me-2 text-success"></i> Servidores DNS</a>
                    <a href="gerenciar_perfis.php" class="nav-link submenu-link"><i class="fas fa-layer-group me-2 text-primary"></i> Perfis</a>
                    <a href="gerenciar_mascara.php" class="nav-link submenu-link"><i class="fas fa-mask me-2 text-info"></i> Máscaras URL</a>
                    <a href="gerenciar_icones.php" class="nav-link submenu-link"><i class="fas fa-icons me-2 text-white"></i> Ícones</a>
                </div>
            </div>
            
            <a href="gerenciar_email.php" class="nav-link text-white"><i class="fas fa-envelope text-warning"></i> Gateway E-mail</a>
            <a href="permissoes_server.php" class="nav-link text-white"><i class="fas fa-server text-white"></i> Permissões CSP</a>
            <a href="revendedores.php" class="nav-link text-white"><i class="fas fa-store"></i> Revendedores</a>
            <a href="configuracoes.php" class="nav-link text-white"><i class="fas fa-wallet"></i> Pagamentos (Global)</a>
            <div class="mb-2 border-bottom border-secondary opacity-50"></div>
        <?php else: ?>
            <a href="configuracoes.php" class="nav-link text-white"><i class="fas fa-wallet"></i> Meus Pagamentos</a>
            <a href="gerenciar_email.php" class="nav-link text-white"><i class="fas fa-envelope text-warning"></i> Config. E-mail</a>
        <?php endif; ?>

        <a href="clientes.php" class="nav-link text-white"><i class="fas fa-users"></i> Clientes</a>
        <a href="testes.php" class="nav-link text-white"><i class="fas fa-stopwatch"></i> Testes</a>
        <a href="criar_cliente.php" class="nav-link text-white"><i class="fas fa-user-plus"></i> Novo Cliente</a>
        <hr class="border-secondary my-2">
        <a href="sair.php" class="nav-link text-danger"><i class="fas fa-sign-out-alt"></i> Sair do Painel</a>
    </div>
</nav>

<main class="main-content">
    <button class="mobile-toggle" onclick="toggleMenu()"><i class="fas fa-bars"></i></button>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="fw-bold text-white">Visão Geral</h3>
            <p class="text-white-50 m-0">Bem-vindo, <b class="text-white"><?= $_SESSION['usuario'] ?></b></p>
        </div>
    </div>

    <div class="row g-4 mb-4">
        <div class="col-12 col-md-6 col-lg-3">
            <div class="stat-card">
                <div>
                    <p class="text-white-50 small text-uppercase fw-bold">Total Clientes</p>
                    <h3><?= $total_clientes ?></h3>
                </div>
                <i class="fas fa-users fs-1 text-primary position-absolute" style="right:20px; top:20px; opacity:0.1"></i>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-3">
            <div class="stat-card">
                <div>
                    <p class="text-white-50 small text-uppercase fw-bold">Ativos</p>
                    <h3 class="text-success"><?= $ativos ?></h3>
                </div>
                <i class="fas fa-wifi fs-1 text-success position-absolute" style="right:20px; top:20px; opacity:0.1"></i>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-3">
            <div class="stat-card">
                <div>
                    <p class="text-white-50 small text-uppercase fw-bold">Vencidos</p>
                    <h3 class="text-danger"><?= $vencidos ?></h3>
                </div>
                <i class="fas fa-user-times fs-1 text-danger position-absolute" style="right:20px; top:20px; opacity:0.1"></i>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-3">
            <div class="stat-card">
                <div>
                    <p class="text-white-50 small text-uppercase fw-bold">Faturamento</p>
                    <h3 class="text-info">R$ <?= number_format($faturamento, 2, ',', '.') ?></h3>
                </div>
                <i class="fas fa-wallet fs-1 text-info position-absolute" style="right:20px; top:20px; opacity:0.1"></i>
            </div>
        </div>
    </div>

    <div class="card border-0 mb-4 shadow-sm" style="background: linear-gradient(90deg, #1e1e2d 0%, #252540 100%); border-left: 5px solid #7367f0 !important;">
        <div class="card-body d-flex justify-content-between align-items-center flex-wrap gap-3">
            <div>
                <h5 class="text-primary fw-bold mb-1"><i class="fas fa-bolt me-2"></i>Link de Teste Automático</h5>
                <p class="text-white-50 small mb-0">Envie este link para seu cliente gerar o teste sozinho e receber no e-mail.</p>
            </div>
            <div class="input-group" style="max-width: 500px;">
                <?php 
                    $meu_token = base64_encode($_SESSION['usuario']);
                    $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
                    $actual_link = "$protocol://$_SERVER[HTTP_HOST]".dirname($_SERVER['PHP_SELF'])."/cadtest.php?r=$meu_token";
                ?>
                <input type="text" class="form-control bg-dark border-secondary text-white" value="<?= $actual_link ?>" id="linkTesteAuto" readonly>
                <button class="btn btn-primary fw-bold" onclick="copiarLinkTeste()"><i class="fas fa-copy me-2"></i> Copiar</button>
            </div>
        </div>
    </div>

    <div class="card stat-card mb-4 p-0 border-info" style="border-left: 5px solid #0dcaf0;">
        <div class="card-header bg-transparent border-0 p-3">
            <h5 class="mb-0 text-info"><i class="fas fa-server me-2"></i>DNS / Servidores</h5>
        </div>
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0 align-middle">
                <thead>
                    <tr class="text-white-50 small text-uppercase">
                        <th class="ps-4">Nome / Perfil</th>
                        <th>DNS / URL</th>
                        <th>Porta</th>
                        <th>Tipo</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($lista_final_servidores)): ?>
                        <tr><td colspan="4" class="text-center text-white py-3">Nenhum perfil ativo.</td></tr>
                    <?php else: ?>
                        <?php foreach($lista_final_servidores as $item): ?>
                        <tr>
                            <td class="ps-4 fw-bold text-white"><?= $item['nome'] ?></td>
                            <td class="copy-click" onclick="copiarTexto('<?= $item['url'] ?>')" title="Toque para copiar">
                                <?= $item['url'] ?> <i class="fas fa-copy ms-1 small text-info"></i>
                            </td>
                            <td class="text-info fw-bold"><?= $item['porta'] ?></td>
                            <td><span class="badge bg-secondary"><?= $item['tipo'] ?? '---' ?></span></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php if(!empty($lista_proximos_vencimentos)): ?>
    <div class="card stat-card mb-4 p-0 border-warning" style="border-left: 5px solid #ffc107;">
        <div class="card-header bg-transparent border-0 p-3 d-flex justify-content-between align-items-center">
            <h5 class="mb-0 text-warning">Vencendo em 7 Dias (<?= count($lista_proximos_vencimentos) ?>)</h5>
            <div class="d-flex gap-2">
                <button class="pag-btn" onclick="mudarPagina(-1)" id="btnPrev"><i class="fas fa-chevron-left"></i></button>
                <span class="text-muted small align-self-center" id="pagIndicador">1/1</span>
                <button class="pag-btn" onclick="mudarPagina(1)" id="btnNext"><i class="fas fa-chevron-right"></i></button>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0 align-middle">
                <thead><tr class="text-white-50 small text-uppercase"><th class="ps-4">Cliente</th><th>Vence em</th><th>Ação</th></tr></thead>
                <tbody>
                    <?php foreach($lista_proximos_vencimentos as $index => $row): $d = (int)$row['dias_restantes']; ?>
                    <tr class="vencimento-row" style="display: none;">
                        <td class="ps-4 fw-bold text-white"><?= $row['nome'] ?> <small class="d-block text-white-50 fw-normal"><?= $row['usuario'] ?></small></td>
                        <td><span class="badge <?= ($d <= 1) ? 'bg-danger' : 'bg-warning text-dark' ?>"><?= ($d == 0) ? "HOJE" : ($d == 1 ? "Amanhã" : "$d dias") ?></span></td>
                        <td class="text-end pe-4"><a href="clientes.php?busca=<?= $row['usuario'] ?>" class="btn btn-sm btn-primary rounded-circle"><i class="fas fa-eye"></i></a></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>

    <div class="card stat-card mt-4 p-0">
        <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center p-3">
            <h5 class="mb-0 text-white">Últimos Cadastros</h5>
            <a href="clientes.php" class="btn btn-sm btn-outline-light">Ver todos</a>
        </div>
        <div class="table-responsive">
            <table class="table table-dark table-hover align-middle mb-0">
                <thead>
                    <tr class="text-white-50 small text-uppercase">
                        <th class="ps-4">Nome</th>
                        <th>Usuário</th>
                        <th>Vencimento</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(empty($lista_ultimos)): ?><tr><td colspan="4" class="text-center py-3 text-white">Nenhum cliente recente.</td></tr><?php else: ?>
                    <?php foreach($lista_ultimos as $row): $b = match($row['status']) { 'bloqueado'=>'bg-danger', 'vencido'=>'bg-warning text-dark', default=>'bg-success' }; ?>
                    <tr>
                        <td class="ps-4 fw-bold text-white"><?= $row['nome'] ?></td>
                        <td class="text-white-50"><?= $row['usuario'] ?></td>
                        <td class="text-white"><?= date('d/m', strtotime($row['data'])) ?></td>
                        <td><span class="badge <?= $b ?>"><?= ucfirst($row['status']) ?></span></td>
                    </tr>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function toggleMenu() { document.getElementById('sidebar').classList.toggle('show'); document.getElementById('overlay').classList.toggle('show'); }

    function copingLinkTeste() {
        var copyText = document.getElementById("linkTesteAuto");
        copyText.select();
        copyText.setSelectionRange(0, 99999); 
        navigator.clipboard.writeText(copyText.value).then(() => { alert("Link copiado com sucesso!"); });
    }
    function copiarLinkTeste() { copingLinkTeste(); }

    function copiarTexto(texto) {
        navigator.clipboard.writeText(texto).then(() => { alert("Copiado: " + texto); });
    }

    // Paginação
    let pg = 1; const lim = 5; 
    const rws = document.querySelectorAll('.vencimento-row'); 
    const tot = rws.length
