<?php
session_start();
require_once 'conexao.php';

$erro = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = trim($_POST['usuario']);
    $senha = trim($_POST['senha']);

    try {
        // 1. TENTA LOGAR COMO ADMIN
        $stmt = $connUser->prepare("SELECT id, usuario, senha FROM admin WHERE usuario = ? LIMIT 1");
        $stmt->execute([$usuario]);
        $user = $stmt->fetch();

        if ($user && $senha === $user['senha']) { // Se sua senha for criptografada, use password_verify
            $_SESSION['logado'] = true;
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['usuario'] = $user['usuario'];
            $_SESSION['nivel'] = 'admin';
            header("Location: index.php");
            exit;
        }

        // 2. SE NÃO FOR ADMIN, TENTA COMO REVENDA
        $stmt = $connUser->prepare("SELECT id, usuario, senha FROM rev WHERE usuario = ? LIMIT 1");
        $stmt->execute([$usuario]);
        $rev = $stmt->fetch();

        if ($rev && $senha === $rev['senha']) {
            $_SESSION['logado'] = true;
            $_SESSION['user_id'] = $rev['id'];
            $_SESSION['usuario'] = $rev['usuario'];
            $_SESSION['nivel'] = 'revenda';
            header("Location: index.php");
            exit;
        }

        $erro = "Usuário ou senha inválidos!";

    } catch (PDOException $e) {
        $erro = "Erro no sistema: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | Painel CS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #151521; color: #fff; height: 100vh; display: flex; align-items: center; justify-content: center; font-family: 'Segoe UI', sans-serif; }
        .login-card { background: #1e1e2d; border: 1px solid rgba(255,255,255,0.1); border-radius: 15px; width: 100%; max-width: 400px; padding: 40px; box-shadow: 0 10px 30px rgba(0,0,0,0.5); }
        .form-control { background: #2b2b40 !important; border: 1px solid #444 !important; color: #fff !important; height: 50px; }
        .btn-login { background: #7367f0; border: none; height: 50px; font-weight: bold; font-size: 1.1rem; transition: 0.3s; }
        .btn-login:hover { background: #5e50ee; transform: translateY(-2px); }
        .logo-icon { font-size: 3rem; color: #7367f0; margin-bottom: 20px; }
    </style>
</head>
<body>

<div class="login-card text-center">
    <i class="fas fa-tv logo-icon"></i>
    <h3 class="fw-bold mb-1">Bem-vindo</h3>
    <p class="text-muted mb-4">Acesse seu painel de controle</p>

    <?php if($erro): ?>
        <div class="alert alert-danger small p-2"><?= $erro ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3 text-start">
            <label class="form-label small text-muted">Usuário</label>
            <div class="input-group">
                <span class="input-group-text bg-dark border-secondary text-muted"><i class="fas fa-user"></i></span>
                <input type="text" name="usuario" class="form-control" required placeholder="Seu usuário">
            </div>
        </div>

        <div class="mb-4 text-start">
            <label class="form-label small text-muted">Senha</label>
            <div class="input-group">
                <span class="input-group-text bg-dark border-secondary text-muted"><i class="fas fa-lock"></i></span>
                <input type="password" name="senha" class="form-control" required placeholder="******">
            </div>
        </div>

        <button type="submit" class="btn btn-primary w-100 btn-login">Entrar no Painel</button>
    </form>
</div>

</body>
</html>
