<?php
session_start();
// Apenas Admin
if (!isset($_SESSION['logado']) || $_SESSION['nivel'] !== 'admin') { 
    header("Location: index.php"); exit; 
}
require_once 'conexao.php';

$msg = ""; $msg_tipo = "";

// --- 1. BUSCA PERFIS DO SISTEMA (Banco Geral) ---
try {
    $perfis_sistema = $connGeral->query("SELECT id, nome FROM perfil WHERE bloqueado IS NULL OR bloqueado != 'sim'")->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) { $perfis_sistema = []; }

// --- 2. PROCESSAMENTO (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $acao = $_POST['acao'];
        $id_rev = $_POST['id_rev'] ?? 0;

        // CRIAR REVENDEDOR
        if ($acao === 'criar') {
            $user = trim($_POST['usuario']);
            $pass = trim($_POST['senha']);
            $limite = (int)$_POST['limite']; 
            $perfis_selecionados = $_POST['perfis'] ?? [];

            $check = $connUser->prepare("SELECT id FROM rev WHERE usuario = ?");
            $check->execute([$user]);
            
            if($check->rowCount() > 0){
                $msg = "Usuário já existe!"; $msg_tipo = "warning";
            } else {
                // 1. Cria na tabela REV (Banco User)
                $sql = "INSERT INTO rev (usuario, senha, limite, data_cadastro, CadUser) VALUES (?, ?, ?, NOW(), 'Admin')";
                $connUser->prepare($sql)->execute([$user, $pass, $limite]);
                $novo_id = $connUser->lastInsertId();

                // 2. Cria permissões na tabela REV_PERFIL (Banco User)
                if (!empty($perfis_selecionados)) {
                    $stmt_p = $connUser->prepare("INSERT INTO rev_perfil (id_rev, id_perfil) VALUES (?, ?)");
                    foreach ($perfis_selecionados as $pid) {
                        $stmt_p->execute([$novo_id, $pid]);
                    }
                }
                $msg = "Revendedor criado!"; $msg_tipo = "success";
            }
        }

        // EDITAR REVENDEDOR
        if ($acao === 'editar') {
            $user = trim($_POST['usuario']);
            $pass = trim($_POST['senha']);
            $limite = (int)$_POST['limite'];
            $perfis_selecionados = $_POST['perfis'] ?? [];

            $connUser->prepare("UPDATE rev SET usuario = ?, senha = ?, limite = ? WHERE id = ?")->execute([$user, $pass, $limite, $id_rev]);

            // Atualiza permissões
            $connUser->prepare("DELETE FROM rev_perfil WHERE id_rev = ?")->execute([$id_rev]);
            if (!empty($perfis_selecionados)) {
                $stmt_p = $connUser->prepare("INSERT INTO rev_perfil (id_rev, id_perfil) VALUES (?, ?)");
                foreach ($perfis_selecionados as $pid) {
                    $stmt_p->execute([$id_rev, $pid]);
                }
            }
            $msg = "Atualizado!"; $msg_tipo = "primary";
        }

        // RENOVAR
        if ($acao === 'renovar') {
            $qtd = (int)$_POST['qtd_adicionar'];
            $connUser->prepare("UPDATE rev SET limite = limite + ? WHERE id = ?")->execute([$qtd, $id_rev]);
            $msg = "Adicionado +$qtd créditos!"; $msg_tipo = "success";
        }

        // EXCLUIR
        if ($acao === 'excluir') {
            $connUser->prepare("DELETE FROM rev WHERE id = ?")->execute([$id_rev]);
            $connUser->prepare("DELETE FROM rev_perfil WHERE id_rev = ?")->execute([$id_rev]);
            $msg = "Removido!"; $msg_tipo = "danger";
        }

    } catch (Exception $e) { $msg = "Erro: " . $e->getMessage(); $msg_tipo = "danger"; }
}

// --- 3. LISTAGEM ---
$revendas = $connUser->query("SELECT * FROM rev ORDER BY id DESC")->fetchAll();

// FUNÇÃO PARA BUSCAR NOMES DOS PERFIS (CORRIGIDA)
function getBadgesPerfis($id_rev, $connUser, $connGeral) {
    // 1. Busca IDs no Banco User
    $stmt = $connUser->prepare("SELECT id_perfil FROM rev_perfil WHERE id_rev = ?");
    $stmt->execute([$id_rev]);
    $ids = $stmt->fetchAll(PDO::FETCH_COLUMN);

    if (empty($ids)) return '<span class="text-white-50 small">Nenhum</span>';

    // 2. Busca Nomes no Banco Geral
    $ids_str = implode(',', $ids);
    $sql_nomes = "SELECT nome FROM perfil WHERE id IN ($ids_str)";
    $nomes = $connGeral->query($sql_nomes)->fetchAll(PDO::FETCH_COLUMN);

    // 3. Monta HTML (lado a lado)
    $html = '<div class="d-flex flex-wrap gap-1">';
    foreach ($nomes as $n) {
        $html .= "<span class='badge-perfil'>$n</span>";
    }
    $html .= '</div>';
    return $html;
}

// IDs para edição
function getIdsParaEditar($id_rev, $connUser) {
    $stmt = $connUser->prepare("SELECT id_perfil FROM rev_perfil WHERE id_rev = ?");
    $stmt->execute([$id_rev]);
    return $stmt->fetchAll(PDO::FETCH_COLUMN);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Revendedores | Painel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background: #151521; color: #fff; font-family: 'Segoe UI', sans-serif; }
        .sidebar { width: 260px; height: 100vh; position: fixed; background: #1e1e2d; padding: 20px; border-right: 1px solid #333; z-index: 1000; }
        .main-content { margin-left: 260px; padding: 30px; }
        
        /* Tabela */
        .table-dark { background: #1e1e2d; --bs-table-bg: #1e1e2d; color: #e0e0e0; }
        .table-dark td { border-color: #333; vertical-align: middle; }
        .table-dark th { color: #fff; border-color: #444; }
        
        /* Badges de Perfil - Estilo Compacto */
        .badge-perfil { 
            font-size: 0.7rem; 
            padding: 2px 6px; 
            border: 1px solid #7367f0; 
            background: rgba(115, 103, 240, 0.15); 
            color: #fff; 
            border-radius: 4px; 
            white-space: nowrap;
        }
        
        .card-custom { background: #1e1e2d; border: 1px solid #333; }
        .form-control { background: #2b2b40; border: 1px solid #444; color: #fff; }
        .form-control:focus { background: #32324a; border-color: #7367f0; color: #fff; }
        
        /* Checkbox Customizado */
        .check-item { background: #2b2b40; padding: 10px; border-radius: 6px; border: 1px solid #444; cursor: pointer; transition: 0.2s; display: flex; align-items: center; }
        .check-item:hover { border-color: #7367f0; background: #32324a; }
        .form-check-input:checked + span { color: #7367f0; font-weight: bold; }

        @media (max-width: 768px) { .sidebar{display:none;} .main-content{margin-left:0;} }
    </style>
</head>
<body>

<nav class="sidebar">
    <h4 class="mb-4 fw-bold text-white"><i class="fas fa-tv text-primary"></i> Painel v3.0</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="btn btn-dark text-start border-0 py-2"><i class="fas fa-home me-2"></i> Dashboard</a>
        <a href="revendedores.php" class="btn btn-primary text-start border-0 py-2"><i class="fas fa-store me-2"></i> Revendedores</a>
        <a href="clientes.php" class="btn btn-dark text-start border-0 py-2"><i class="fas fa-users me-2"></i> Clientes</a>
    </div>
</nav>

<main class="main-content">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold">Gerenciar Revendedores</h3>
        <button class="btn btn-primary fw-bold" data-bs-toggle="modal" data-bs-target="#modalCriar"><i class="fas fa-user-plus me-2"></i>Novo Revendedor</button>
    </div>

    <?php if($msg): ?><div class="alert alert-<?= $msg_tipo ?> alert-dismissible fade show"><?= $msg ?><button class="btn-close" data-bs-dismiss="alert"></button></div><?php endif; ?>

    <div class="card card-custom">
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0 align-middle">
                <thead>
                    <tr class="text-secondary small text-uppercase">
                        <th class="ps-4">Usuário</th>
                        <th>Senha</th>
                        <th>Limite</th>
                        <th style="min-width: 200px;">Perfis Liberados</th>
                        <th class="text-end pe-4">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($revendas as $r): 
                        $limite = (int)$r['limite'];
                        $badge_limite = ($limite === 0) ? '<span class="badge bg-success">Ilimitado</span>' : '<span class="badge bg-warning text-dark">'.$limite.'</span>';
                        $ids_para_edit = getIdsParaEditar($r['id'], $connUser);
                    ?>
                    <tr>
                        <td class="ps-4 fw-bold text-white"><?= $r['usuario'] ?></td>
                        <td class="text-white-50"><?= $r['senha'] ?></td>
                        <td><?= $badge_limite ?></td>
                        <td>
                            <?= getBadgesPerfis($r['id'], $connUser, $connGeral) ?>
                        </td>
                        <td class="text-end pe-4">
                            <button class="btn btn-sm btn-success rounded-circle me-1" onclick='abrirRenovar(<?= $r['id'] ?>, "<?= $r['usuario'] ?>")' title="Adicionar Crédito"><i class="fas fa-plus"></i></button>
                            <button class="btn btn-sm btn-info rounded-circle me-1" onclick='abrirEditar(<?= json_encode($r) ?>, <?= json_encode($ids_para_edit) ?>)' title="Editar"><i class="fas fa-pen text-white"></i></button>
                            <form method="POST" class="d-inline">
                                <input type="hidden" name="acao" value="excluir"><input type="hidden" name="id_rev" value="<?= $r['id'] ?>">
                                <button class="btn btn-sm btn-danger rounded-circle" onclick="return confirm('Excluir revendedor?')" title="Excluir"><i class="fas fa-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<div class="modal fade" id="modalCriar" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-dark border-secondary">
            <form method="POST">
                <input type="hidden" name="acao" value="criar">
                <div class="modal-header border-secondary text-white"><h5 class="modal-title">Novo Revendedor</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
                <div class="modal-body p-4">
                    <div class="mb-3"><label class="form-label">Usuário</label><input type="text" name="usuario" class="form-control" required></div>
                    <div class="mb-3"><label class="form-label">Senha</label><input type="text" name="senha" class="form-control" required></div>
                    <div class="mb-3">
                        <label class="form-label">Limite de Clientes</label>
                        <input type="number" name="limite" class="form-control" placeholder="0 = Ilimitado" value="10">
                    </div>
                    
                    <hr class="border-secondary my-3">
                    <label class="text-info fw-bold mb-3">Selecione os Perfis:</label>
                    <div class="row g-2" style="max-height: 150px; overflow-y: auto;">
                        <?php foreach($perfis_sistema as $p): ?>
                        <div class="col-12">
                            <label class="check-item w-100">
                                <input class="form-check-input me-3" type="checkbox" name="perfis[]" value="<?= $p['id'] ?>">
                                <span class="text-white"><?= $p['nome'] ?></span>
                            </label>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="modal-footer border-secondary"><button type="submit" class="btn btn-primary w-100 fw-bold">Cadastrar</button></div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditar" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-dark border-secondary">
            <form method="POST">
                <input type="hidden" name="acao" value="editar">
                <input type="hidden" name="id_rev" id="edit_id">
                <div class="modal-header border-secondary text-white"><h5 class="modal-title">Editar Revendedor</h5><button class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
                <div class="modal-body p-4">
                    <div class="mb-3"><label class="form-label">Usuário</label><input type="text" name="usuario" id="edit_user" class="form-control" required></div>
                    <div class="mb-3"><label class="form-label">Senha</label><input type="text" name="senha" id="edit_pass" class="form-control" required></div>
                    <div class="mb-3"><label class="form-label">Limite</label><input type="number" name="limite" id="edit_limite" class="form-control"></div>
                    
                    <hr class="border-secondary my-3">
                    <label class="text-info fw-bold mb-3">Alterar Permissões:</label>
                    <div class="row g-2" style="max-height: 200px; overflow-y: auto;">
                        <?php foreach($perfis_sistema as $p): ?>
                        <div class="col-12">
                            <label class="check-item w-100">
                                <input class="form-check-input me-3 chk-perf" type="checkbox" name="perfis[]" value="<?= $p['id'] ?>" id="chk_<?= $p['id'] ?>">
                                <span class="text-white"><?= $p['nome'] ?></span>
                            </label>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="modal-footer border-secondary"><button type="submit" class="btn btn-primary w-100 fw-bold">Salvar</button></div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalRenovar" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content bg-dark border-secondary">
            <form method="POST">
                <input type="hidden" name="acao" value="renovar">
                <input type="hidden" name="id_rev" id="renov_id">
                <div class="modal-header border-secondary text-white"><h5 class="modal-title">Adicionar Limite</h5><button class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
                <div class="modal-body text-center p-4">
                    <p class="mb-1 text-muted">Revendedor:</p>
                    <h4 id="renov_user" class="text-white fw-bold mb-4"></h4>
                    <label class="mb-2 text-success">Quantos créditos adicionar?</label>
                    <input type="number" name="qtd_adicionar" class="form-control text-center fs-3 fw-bold text-white bg-dark border-success" value="10">
                </div>
                <div class="modal-footer border-secondary"><button type="submit" class="btn btn-success w-100 fw-bold">Confirmar</button></div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function abrirRenovar(id, user) {
        document.getElementById('renov_id').value = id;
        document.getElementById('renov_user').innerText = user;
        new bootstrap.Modal(document.getElementById('modalRenovar')).show();
    }

    function abrirEditar(r, perfis) {
        document.getElementById('edit_id').value = r.id;
        document.getElementById('edit_user').value = r.usuario;
        document.getElementById('edit_pass').value = r.senha;
        document.getElementById('edit_limite').value = r.limite;
        
        document.querySelectorAll('.chk-perf').forEach(el => el.checked = false);
        if(perfis) {
            perfis.forEach(pid => {
                let check = document.getElementById('chk_' + pid);
                if(check) check.checked = true;
            });
        }
        new bootstrap.Modal(document.getElementById('modalEditar')).show();
    }
</script>
</body>
</html>
