<?php
session_start();
require_once 'conexao.php';

if (!isset($_SESSION['logado'])) { 
    // header("Location: login.php"); exit; 
}

$msg = "";
$msg_tipo = "";
$texto_zap = "";
$redirecionar_para_clientes = false; // Flag de controle

// --- 1. FUNÇÕES AUXILIARES ---
function limpar($dado) {
    return strip_tags(str_replace(['\\', "\r", "\n", "\t"], ' ', json_decode('"'.$dado.'"') ? json_decode('"'.$dado.'"') : $dado));
}

// --- 2. BUSCAR PERFIS E ÍCONES (Necessário para a mensagem do Zap) ---
$mapa_perfis = [];
$lista_perfis = [];

try {
    $sql_p = "SELECT p.id, p.nome, p.url, p.porta, i.img 
              FROM perfil p 
              LEFT JOIN perfil_icone i ON p.imagem = i.id 
              WHERE (p.bloqueado IS NULL OR p.bloqueado != 'sim') 
              ORDER BY p.nome ASC";
    
    $stmt_p = $connGeral->query($sql_p);
    $lista_perfis = $stmt_p->fetchAll(PDO::FETCH_ASSOC);

    foreach ($lista_perfis as $lp) {
        $mapa_perfis[$lp['id']] = [
            'nome'  => $lp['nome'],
            'img'   => $lp['img'],
            'url'   => $lp['url'],
            'porta' => $lp['porta']
        ];
    }
} catch (Exception $e) {}

// --- 3. PROCESSAMENTO (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $acao = $_POST['acao'];
        $id_teste = $_POST['id_teste'] ?? 0;

        // CRIAR TESTE
        if ($acao === 'criar') {
            $check = $connUser->prepare("SELECT id FROM teste WHERE usuario = ? UNION SELECT id FROM usuario WHERE usuario = ?");
            $check->execute([$_POST['usuario'], $_POST['usuario']]);
            
            if($check->rowCount() > 0){
                $msg = "Este usuário já existe!"; $msg_tipo = "warning";
            } else {
                $perfil_id = $_POST['perfil_id'] ?? 0;
                $horas = (int)$_POST['tempo'];
                $vencimento = date('Y-m-d H:i:s', strtotime("+$horas hours"));

                $sql = "INSERT INTO teste (CadUser, usuario, senha, data_premio, id_perfil, bloqueado, data_cadastro) 
                        VALUES (?, ?, ?, ?, ?, 'nao', NOW())";
                
                $connUser->prepare($sql)->execute([$_SESSION['usuario'] ?? 'Admin', $_POST['usuario'], $_POST['senha'], $vencimento, $perfil_id]);

                // Mensagem Zap Teste
                $url = $mapa_perfis[$perfil_id]['url'] ?? 'Consulte';
                $porta = $mapa_perfis[$perfil_id]['porta'] ?? '80';
                
                $texto_zap = "*⏱️ Teste Criado!*\n\n👤 User: {$_POST['usuario']}\n🔑 Senha: {$_POST['senha']}\n⏳ Expira: ".date('d/m H:i', strtotime($vencimento))."\n\n🌐 $url\n🔌 Porta: $porta";
                
                $msg = "Teste criado!"; $msg_tipo = "success";
            }
        }

        // CONVERTER PARA CLIENTE (A MÁGICA ACONTECE AQUI)
        if ($acao === 'converter') {
            $t = $connUser->query("SELECT * FROM teste WHERE id=$id_teste")->fetch();
            if ($t) {
                // Define 30 dias a partir de HOJE (não do vencimento do teste)
                $novo_venc = date('Y-m-d', strtotime('+30 days'));
                
                // Insere em Clientes
                $sql_ins = "INSERT INTO usuario (CadUser, nome, usuario, senha, conexao, data_premio, id_perfil, bloqueado, data_cadastro) 
                            VALUES (?, ?, ?, ?, 1, ?, ?, 'nao', NOW())";
                
                $connUser->prepare($sql_ins)->execute([
                    $t['CadUser'], 
                    $t['usuario'], // Nome igual usuário
                    $t['usuario'], 
                    $t['senha'], 
                    $novo_venc, 
                    $t['id_perfil']
                ]);

                // Remove do Teste
                $connUser->prepare("DELETE FROM teste WHERE id=?")->execute([$id_teste]);
                
                // --- GERA MENSAGEM DE RENOVAÇÃO ---
                $pid = $t['id_perfil'];
                $url = $mapa_perfis[$pid]['url'] ?? 'Consulte';
                $porta = $mapa_perfis[$pid]['porta'] ?? '80';
                $venc_br = date('d/m/Y', strtotime($novo_venc));

                $texto_zap = "*✅ Cliente Efetivado!*\n\n";
                $texto_zap .= "Obrigado por contratar!\n\n";
                $texto_zap .= "👤 *Usuário:* {$t['usuario']}\n";
                $texto_zap .= "🔑 *Senha:* {$t['senha']}\n";
                $texto_zap .= "📅 *Vencimento:* $venc_br\n\n";
                $texto_zap .= "🌐 *URL:* $url\n";
                $texto_zap .= "🔌 *Porta:* $porta\n";
                
                $msg = "Convertido com sucesso! Copie os dados."; 
                $msg_tipo = "success";
                
                // Ativa o redirecionamento
                $redirecionar_para_clientes = true;
            }
        }

        // EDITAR TESTE
        if ($acao === 'editar') {
            $perfil_edit = $_POST['perfil_id'] ?? 0;
            $connUser->prepare("UPDATE teste SET usuario=?, senha=?, id_perfil=? WHERE id=?")
                     ->execute([$_POST['usuario'], $_POST['senha'], $perfil_edit, $id_teste]);
            $msg = "Atualizado!"; $msg_tipo = "primary";
        }

        // EXCLUIR
        if ($acao === 'excluir') {
            $connUser->prepare("DELETE FROM teste WHERE id=?")->execute([$id_teste]);
            $msg = "Apagado!"; $msg_tipo = "danger";
        }

    } catch (Exception $e) { $msg = "Erro: " . $e->getMessage(); $msg_tipo = "danger"; }
}

// --- 4. LISTAGEM ---
$termo = $_GET['busca'] ?? '';
$sql = "SELECT * FROM teste WHERE 1=1";
$params = [];
if ($termo) { $sql .= " AND usuario LIKE :t"; $params[':t'] = "%$termo%"; }
if ($_SESSION['nivel'] === 'revenda') { $sql .= " AND CadUser = :u"; $params[':u'] = $_SESSION['usuario']; }
elseif (!empty($_GET['revenda'])) { $sql .= " AND CadUser = :r"; $params[':r'] = $_GET['revenda']; }
$sql .= " ORDER BY id DESC LIMIT 50";

try {
    $stmt = $connUser->prepare($sql);
    $stmt->execute($params);
    $testes = $stmt->fetchAll();
    if($_SESSION['nivel'] === 'admin'){ $revendedores = $connUser->query("SELECT DISTINCT CadUser FROM teste")->fetchAll(PDO::FETCH_COLUMN); }
} catch(Exception $e) { $testes = []; }
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Testes | Painel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background: #151521; color: #e0e0e0; font-family: 'Segoe UI', sans-serif; padding-bottom: 80px; }
        .sidebar { width: 260px; height: 100vh; position: fixed; top: 0; left: 0; background: #1e1e2d; padding: 20px; z-index: 1000; border-right: 1px solid #333; transition: 0.3s; }
        .main-content { margin-left: 260px; padding: 25px; transition: 0.3s; }
        .table-dark { background: #1e1e2d; --bs-table-bg: #1e1e2d; color: #fff; }
        .table-dark td { border-color: #333; vertical-align: middle; }
        .card-custom { background: #1e1e2d; border: 1px solid #333; }
        .form-control, .form-select { background: #2b2b40; border: 1px solid #444; color: #fff; }
        .form-control:focus { background: #32324a; border-color: #7367f0; color: #fff; }
        
        .perfil-icon-sm { width: 35px; height: 35px; object-fit: contain; border-radius: 50%; background: #fff; padding: 2px; }
        .perfil-text { font-size: 0.85rem; color: #0dcaf0; font-weight: bold; }
        
        /* SELEÇÃO NO MODAL */
        .radio-perfil { display: none; }
        .label-perfil { display: flex; align-items: center; gap: 10px; padding: 10px; border: 1px solid #444; border-radius: 8px; cursor: pointer; transition: 0.2s; background: #2b2b40; }
        .label-perfil:hover { background: #3b3b55; }
        .radio-perfil:checked + .label-perfil { border-color: #7367f0; background: rgba(115, 103, 240, 0.2); }
        .perfil-img-select { width: 30px; height: 30px; object-fit: contain; }

        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); } .sidebar.show { transform: translateX(0); }
            .main-content { margin-left: 0; padding: 15px; }
        }
        .overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 999; } .overlay.show { display: block; }
    </style>
</head>
<body>

<div class="overlay" id="overlay" onclick="toggleMenu()"></div>

<div class="modal fade" id="modalZap" tabindex="-1" data-bs-backdrop="static">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-dark border-success">
            <div class="modal-header border-0"><h5 class="modal-title text-success w-100 text-center">Operação Concluída!</h5></div>
            <div class="modal-body">
                <textarea id="textoZapArea" class="form-control" rows="8" style="background:#111; color:#0f0; border:1px solid #333; font-family: monospace;"><?= $texto_zap ?></textarea>
            </div>
            <div class="modal-footer border-0 justify-content-center">
                <button onclick="copiarTexto()" class="btn btn-outline-light">Copiar</button>
                <button onclick="enviarZap()" class="btn btn-success"><i class="fab fa-whatsapp"></i> WhatsApp</button>
                
                <?php if($redirecionar_para_clientes): ?>
                    <a href="clientes.php" class="btn btn-primary fw-bold ms-2">Ir para Clientes <i class="fas fa-arrow-right ms-1"></i></a>
                <?php else: ?>
                    <button data-bs-dismiss="modal" class="btn btn-secondary">Fechar</button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<nav class="sidebar" id="sidebar">
    <h4 class="mb-5 fw-bold ps-2 text-white">Painel v3.0</h4>
    <div class="nav flex-column gap-2">
        <a href="index.php" class="btn btn-dark text-start border-0 py-2 text-white-50"><i class="fas fa-home me-2"></i> Dashboard</a>
        <a href="clientes.php" class="btn btn-dark text-start border-0 py-2 text-white-50"><i class="fas fa-users me-2"></i> Clientes</a>
        <a href="testes.php" class="btn btn-primary text-start border-0 py-2"><i class="fas fa-stopwatch me-2"></i> Testes</a>
        <button onclick="abrirModalCriar()" class="btn btn-dark text-start border-0 py-2 text-warning"><i class="fas fa-plus-circle me-2"></i> Novo Teste</button>
        <a href="sair.php" class="btn btn-dark text-start border-0 py-2 mt-5 text-danger"><i class="fas fa-sign-out-alt me-2"></i> Sair</a>
    </div>
</nav>

<main class="main-content">
    <button class="btn btn-dark d-md-none mb-3" onclick="toggleMenu()"><i class="fas fa-bars"></i></button>

    <?php if($msg): ?>
        <div class="alert alert-<?= $msg_tipo ?> alert-dismissible fade show"><?= $msg ?><button class="btn-close btn-close-white" data-bs-dismiss="alert"></button></div>
    <?php endif; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold">Gerenciar Testes</h3>
        <button onclick="abrirModalCriar()" class="btn btn-warning fw-bold"><i class="fas fa-plus me-2"></i> Novo Teste</button>
    </div>

    <div class="card card-custom mb-4 p-3">
        <form method="GET" class="row g-2">
            <div class="col-md-9">
                <input type="text" name="busca" class="form-control" placeholder="Buscar usuário..." value="<?= htmlspecialchars($termo) ?>">
            </div>
            <div class="col-md-3">
                <button class="btn btn-primary w-100">Filtrar</button>
            </div>
        </form>
    </div>

    <div class="card card-custom">
        <div class="table-responsive">
            <table class="table table-dark table-hover mb-0">
                <thead>
                    <tr class="text-secondary small text-uppercase">
                        <th class="ps-3">Usuário</th>
                        <th>Perfil</th>
                        <th>Expira em</th>
                        <th>Status</th>
                        <th class="text-end pe-3">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($testes) > 0): ?>
                        <?php foreach($testes as $t): 
                            $restante = strtotime($t['data_premio']) - time();
                            $expirado = ($restante < 0);
                            $pid = $t['id_perfil'] ?? 0;
                            
                            // Imagem ou Texto
                            $nome_perfil = $mapa_perfis[$pid]['nome'] ?? '---';
                            $img_src = "";
                            if(isset($mapa_perfis[$pid]) && !empty($mapa_perfis[$pid]['img'])) {
                                $img_src = "assets/img/icones/" . $mapa_perfis[$pid]['img'];
                            }
                        ?>
                        <tr>
                            <td class="ps-3">
                                <div class="fw-bold"><?= $t['usuario'] ?></div>
                                <div class="text-white-50 small">Senha: <?= $t['senha'] ?></div>
                            </td>
                            <td>
                                <?php if($img_src): ?>
                                    <img src="<?= $img_src ?>" class="perfil-icon-sm" title="<?= $nome_perfil ?>" onerror="this.style.display='none'; this.nextElementSibling.style.display='inline'">
                                    <span class="perfil-text" style="display:none"><?= $nome_perfil ?></span>
                                <?php else: ?>
                                    <span class="perfil-text"><?= $nome_perfil ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($expirado): ?>
                                    <span class="text-danger small">Expirado</span>
                                <?php else: ?>
                                    <span class="text-success fw-bold"><?= gmdate("H:i", $restante) ?>h</span>
                                <?php endif; ?>
                            </td>
                            <td><?= $expirado ? '<span class="badge bg-secondary">Inativo</span>' : '<span class="badge bg-success">Ativo</span>' ?></td>
                            <td class="text-end pe-3">
                                <form method="POST" class="d-inline">
                                    <input type="hidden" name="acao" value="converter">
                                    <input type="hidden" name="id_teste" value="<?= $t['id'] ?>">
                                    <button class="btn btn-sm btn-success rounded-circle me-1" title="Tornar Cliente" onclick="return confirm('Efetivar teste como cliente?')"><i class="fas fa-check"></i></button>
                                </form>
                                <button onclick='abrirEditar(<?= json_encode($t) ?>)' class="btn btn-sm btn-info rounded-circle me-1"><i class="fas fa-pen text-white"></i></button>
                                <form method="POST" class="d-inline">
                                    <input type="hidden" name="acao" value="excluir"><input type="hidden" name="id_teste" value="<?= $t['id'] ?>">
                                    <button class="btn btn-sm btn-danger rounded-circle" onclick="return confirm('Excluir?')"><i class="fas fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="5" class="text-center py-4 text-muted">Nenhum teste encontrado.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<div class="modal fade" id="modalCriar" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-dark border-secondary">
            <div class="modal-header border-secondary bg-warning text-dark">
                <h5 class="modal-title fw-bold"><i class="fas fa-stopwatch me-2"></i> Novo Teste</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <input type="hidden" name="acao" value="criar">
                <div class="modal-body p-4">
                    <div class="mb-3">
                        <label>Gerar Usuário</label>
                        <div class="input-group">
                            <input type="text" name="usuario" class="form-control" value="teste<?= rand(100,999) ?>" required>
                            <button type="button" class="btn btn-outline-light" onclick="this.previousElementSibling.value='teste'+Math.floor(Math.random()*1000)"><i class="fas fa-sync"></i></button>
                        </div>
                    </div>
                    <div class="row g-3 mb-4">
                        <div class="col-6"><label>Senha</label><input type="text" name="senha" class="form-control" value="<?= rand(1000,9999) ?>" required></div>
                        <div class="col-6">
                            <label>Duração</label>
                            <select name="tempo" class="form-select">
                                <option value="1">1 Hora</option>
                                <option value="2" selected>2 Horas</option>
                                <option value="3">3 Horas</option>
                                <option value="4">4 Horas</option>
                                <option value="24">24 Horas</option>
                                <option value="48">48 Horas (2 dias)</option>
                            </select>
                        </div>
                    </div>
                    <h6 class="text-info border-bottom border-secondary pb-2 mb-3">Selecione o Serviço</h6>
                    <div class="row g-2" style="max-height: 200px; overflow-y: auto;">
                        <?php if(empty($lista_perfis)): ?>
                            <div class="col-12 text-muted">Nenhum perfil.</div>
                        <?php else: ?>
                            <?php foreach($lista_perfis as $idx => $p): 
                                $checked = ($idx === 0) ? 'checked' : ''; 
                                $img = !empty($p['img']) ? "assets/img/icones/{$p['img']}" : "assets/img/default.png";
                            ?>
                            <div class="col-12 col-md-6">
                                <input type="radio" name="perfil_id" id="t_perf_<?= $p['id'] ?>" value="<?= $p['id'] ?>" class="radio-perfil" <?= $checked ?>>
                                <label for="t_perf_<?= $p['id'] ?>" class="label-perfil">
                                    <img src="<?= $img ?>" class="perfil-img-select" onerror="this.style.display='none'">
                                    <span class="fw-bold text-white small"><?= $p['nome'] ?></span>
                                </label>
                            </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="modal-footer border-secondary"><button type="submit" class="btn btn-warning w-100 fw-bold">Gerar Teste</button></div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditar" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-dark border-secondary">
            <div class="modal-header border-secondary"><h5 class="modal-title">Editar Teste</h5><button class="btn-close btn-close-white" data-bs-dismiss="modal"></button></div>
            <form method="POST">
                <input type="hidden" name="acao" value="editar">
                <input type="hidden" name="id_teste" id="edit_id">
                <div class="modal-body">
                    <div class="mb-3"><label>Usuário</label><input type="text" name="usuario" id="edit_user" class="form-control" required></div>
                    <div class="mb-3"><label>Senha</label><input type="text" name="senha" id="edit_pass" class="form-control" required></div>
                    <div class="mt-3">
                        <label class="text-warning">Alterar Perfil</label>
                        <select name="perfil_id" id="edit_perfil" class="form-select">
                            <option value="0">Sem perfil</option>
                            <?php foreach($lista_perfis as $p): ?>
                                <option value="<?= $p['id'] ?>"><?= $p['nome'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer border-secondary"><button type="submit" class="btn btn-primary w-100">Salvar</button></div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function toggleMenu() { document.getElementById('sidebar').classList.toggle('show'); document.getElementById('overlay').classList.toggle('show'); }
    function abrirModalCriar() { new bootstrap.Modal(document.getElementById('modalCriar')).show(); }

    function abrirEditar(t) {
        document.getElementById('edit_id').value = t.id;
        document.getElementById('edit_user').value = t.usuario;
        document.getElementById('edit_pass').value = t.senha;
        document.getElementById('edit_perfil').value = t.id_perfil || 0;
        new bootstrap.Modal(document.getElementById('modalEditar')).show();
    }

    window.onload = function() {
        let texto = `<?= $texto_zap ?>`;
        // Se tiver texto, abre o modal
        if(texto.trim() !== "") {
            let myModal = new bootstrap.Modal(document.getElementById('modalZap'));
            myModal.show();
            
            // Lógica de Redirecionamento Automático ao FECHAR (opcional)
            <?php if($redirecionar_para_clientes): ?>
            document.getElementById('modalZap').addEventListener('hidden.bs.modal', function () {
                window.location.href = 'clientes.php';
            });
            <?php endif; ?>
        }
    }
    function copiarTexto() { document.getElementById("textoZapArea").select(); document.execCommand("copy"); alert("Copiado!"); }
    function enviarZap() { window.open("https://api.whatsapp.com/send?text=" + encodeURIComponent(document.getElementById("textoZapArea").value), '_blank'); }
</script>
</body>
</html>
