<?php
// ======================================================================
//      GERENCIADOR DE CATEGORIAS COMPLETO v2.1
//      Adicionado suporte para arrastar e soltar em dispositivos móveis (Touch Punch)
// ======================================================================

// --- 1. CONFIGURAÇÃO E CONEXÃO ---
$db_host = 'localhost';
$db_name = 'u535247987_tvbox'; // Suas credenciais
$db_user = 'u535247987_tvbox'; // Suas credenciais
$db_pass = 'Jean#909110';      // Suas credenciais
$charset = 'utf8mb4';

try {
    $dsn = "mysql:host=$db_host;dbname=$db_name;charset=$charset";
    $options = [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC];
    $pdo = new PDO($dsn, $db_user, $db_pass, $options);
} catch (PDOException $e) {
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH'])) {
        header('Content-Type: application/json; charset=utf-8'); http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Falha na conexão.']); exit();
    }
    die("Erro de Conexão: " . $e->getMessage());
}

// --- 2. LÓGICA DA API INTERNA (PARA AJAX) ---
$action = $_POST['action'] ?? $_GET['action'] ?? '';
if ($action) {
    // A lógica da API continua a mesma...
    switch ($action) {
        case 'get_list':
            $type = $_GET['type'] ?? 'streams';
            if (!in_array($type, ['streams', 'movie', 'series'])) { $type = 'streams'; }
            $stmt = $pdo->prepare("SELECT `id`, `nome` FROM `categoria` WHERE `type` = ? ORDER BY `position` ASC");
            $stmt->execute([$type]);
            foreach ($stmt->fetchAll() as $cat) {
                echo '<li data-id="' . $cat['id'] . '">
                        <input type="checkbox" class="category-checkbox" data-id="' . $cat['id'] . '">
                        <span class="drag-handle">↕️</span>
                        <span class="category-name">' . htmlspecialchars($cat['nome']) . '</span>
                        <div class="item-actions">
                            <button class="edit-btn" data-id="' . $cat['id'] . '" title="Editar">✏️</button>
                            <button class="delete-btn" data-id="' . $cat['id'] . '" title="Excluir">🗑️</button>
                        </div>
                      </li>';
            }
            break;

        case 'save_order':
        case 'get_category_details':
        case 'save_edit':
        case 'delete_category':
        case 'delete_bulk':
            header('Content-Type: application/json; charset=utf-8');
            if ($action == 'save_order') {
                $order_data = json_decode($_POST['order'] ?? '[]', true);
                if (empty($order_data)) { http_response_code(400); echo json_encode(['status' => 'error', 'message' => 'Dados inválidos.']); exit(); }
                $pdo->beginTransaction();
                try {
                    $stmt = $pdo->prepare("UPDATE `categoria` SET `position` = ? WHERE `id` = ?");
                    foreach ($order_data as $index => $id) { $stmt->execute([$index + 1, intval($id)]); }
                    $pdo->commit();
                    echo json_encode(['status' => 'success', 'message' => 'Ordem salva com sucesso!']);
                } catch (Exception $e) { $pdo->rollBack(); http_response_code(500); echo json_encode(['status' => 'error', 'message' => 'Erro ao salvar a ordem.']); }
            }
            if ($action == 'get_category_details') {
                $id = intval($_POST['id'] ?? 0);
                $stmt = $pdo->prepare("SELECT `id`, `nome` FROM `categoria` WHERE `id` = ?");
                $stmt->execute([$id]);
                $category = $stmt->fetch();
                if ($category) { echo json_encode(['status' => 'success', 'data' => $category]); } 
                else { http_response_code(404); echo json_encode(['status' => 'error', 'message' => 'Categoria não encontrada.']); }
            }
            if ($action == 'save_edit') {
                $id = intval($_POST['id'] ?? 0);
                $nome = trim($_POST['nome'] ?? '');
                if (empty($id) || empty($nome)) { http_response_code(400); echo json_encode(['status' => 'error', 'message' => 'ID e Nome são obrigatórios.']); exit(); }
                $stmt = $pdo->prepare("UPDATE `categoria` SET `nome` = ? WHERE `id` = ?");
                $stmt->execute([$nome, $id]);
                echo json_encode(['status' => 'success', 'message' => 'Categoria atualizada!']);
            }
            if ($action == 'delete_category') {
                $id = intval($_POST['id'] ?? 0);
                $stmt = $pdo->prepare("DELETE FROM `categoria` WHERE `id` = ?");
                $stmt->execute([$id]);
                echo json_encode(['status' => 'success']);
            }
            if ($action == 'delete_bulk') {
                $ids = $_POST['ids'] ?? [];
                if (empty($ids) || !is_array($ids)) { http_response_code(400); echo json_encode(['status' => 'error', 'message' => 'Nenhum ID selecionado.']); exit(); }
                $placeholders = implode(',', array_fill(0, count($ids), '?'));
                $stmt = $pdo->prepare("DELETE FROM `categoria` WHERE `id` IN ($placeholders)");
                $stmt->execute($ids);
                echo json_encode(['status' => 'success', 'message' => count($ids) . ' categorias foram apagadas.']);
            }
            break;
    }
    exit();
}

// --- 3. BUSCA OS DADOS INICIAIS ---
$categorias_iniciais = $pdo->query("SELECT `id`, `nome` FROM `categoria` WHERE `type` = 'streams' ORDER BY `position` ASC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciador de Categorias</title>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui-touch-punch/0.2.3/jquery.ui.touch-punch.min.js"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        /* O CSS continua o mesmo de antes... */
        body { font-family: sans-serif; background-color: #f4f4f4; color: #333; margin: 0; padding: 20px; }
        .container { max-width: 900px; margin: auto; background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        h1 { text-align: center; color: #0056b3; }
        .tabs { margin-bottom: 20px; display: flex; border-bottom: 2px solid #ccc; }
        .tab-button { background: #e9e9e9; border: 1px solid #ccc; padding: 10px 20px; cursor: pointer; font-size: 16px; border-radius: 5px 5px 0 0; }
        .tab-button.active { background: #fff; border-bottom: 2px solid #fff; position: relative; top: 2px; font-weight: bold; }
        .list-container { border: 1px solid #eee; padding: 10px; border-radius: 4px; }
        #sortable-list { list-style: none; padding: 0; margin: 0; min-height: 100px; }
        #sortable-list li { cursor: move; padding: 10px 15px; margin-bottom: 5px; border: 1px solid #ddd; background-color: #fff; border-radius: 4px; display: flex; align-items: center; justify-content: space-between; }
        .category-checkbox { margin-right: 15px; transform: scale(1.4); }
        .drag-handle { display: inline-block; width: 20px; cursor: grab; font-size: 20px; color: #aaa; }
        .category-name { flex-grow: 1; margin-left: 10px; }
        .item-actions button { background: none; border: none; cursor: pointer; font-size: 20px; margin-left: 10px;}
        .ui-sortable-placeholder { border: 2px dashed #ccc; background-color: #f0f8ff; height: 45px; visibility: visible !important; }
        .controls-container { display: flex; justify-content: space-between; align-items: center; padding: 10px; background-color: #f9f9f9; border-top: 1px solid #eee; }
        .bulk-actions { display: flex; align-items: center; }
        #selectAll { margin-right: 10px; transform: scale(1.4); }
        .main-actions { text-align: center; padding-top: 20px; }
        .action-button { font-size: 16px; font-weight: bold; padding: 12px 25px; color: #fff; border: none; border-radius: 5px; cursor: pointer; }
        #saveButton { background-color: #28a745; }
        #deleteSelectedButton { background-color: #dc3545; margin-left: 10px; }
        .modal-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); display: none; justify-content: center; align-items: center; z-index: 1000; }
        .modal-content { background: #fff; padding: 30px; border-radius: 8px; width: 90%; max-width: 500px; }
        .modal-content h2 { margin-top: 0; }
        .modal-content input[type="text"] { width: 100%; padding: 10px; font-size: 16px; margin-bottom: 20px; box-sizing: border-box; }
        .modal-actions { text-align: right; }
        .modal-actions button { margin-left: 10px; }
    </style>
</head>
<body>
    
    <div class="container">
        <h1>Gerenciador de Categorias</h1>
        <div class="tabs">
            <button class="tab-button active" data-type="streams">Canais</button>
            <button class="tab-button" data-type="movie">Filmes</button>
            <button class="tab-button" data-type="series">Séries</button>
        </div>
        <div class="list-container">
            <div class="controls-container">
                <div class="bulk-actions">
                    <input type="checkbox" id="selectAll" title="Selecionar Tudo">
                    <button id="deleteSelectedButton" class="action-button">Apagar Selecionados</button>
                </div>
            </div>
            <ul id="sortable-list">
                <?php foreach ($categorias_iniciais as $cat): ?>
                    <li data-id="<?php echo $cat['id']; ?>">
                        <input type="checkbox" class="category-checkbox" data-id="<?php echo $cat['id']; ?>">
                        <span class="drag-handle">↕️</span>
                        <span class="category-name"><?php echo htmlspecialchars($cat['nome']); ?></span>
                        <div class="item-actions">
                            <button class="edit-btn" data-id="<?php echo $cat['id']; ?>" title="Editar">✏️</button>
                            <button class="delete-btn" data-id="<?php echo $cat['id']; ?>" title="Excluir">🗑️</button>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
        <div class="main-actions">
            <button id="saveButton" class="action-button">Salvar Ordem da Lista Atual</button>
        </div>
    </div>
    <div id="editModal" class="modal-overlay">
        <div class="modal-content">
            <h2>Editar Categoria</h2>
            <input type="hidden" id="edit_id">
            <input type="text" id="edit_nome" placeholder="Nome da Categoria">
            <div class="modal-actions">
                <button id="cancelEditButton" class="action-button" style="background-color: #6c757d;">Cancelar</button>
                <button id="saveEditButton" class="action-button" style="background-color: #007bff;">Salvar Alterações</button>
            </div>
        </div>
    </div>
    
<script>
// O JavaScript continua o mesmo de antes...
$(document).ready(function() {
    const list = $("#sortable-list");
    const saveBtn = $('#saveButton');
    const deleteSelectedBtn = $('#deleteSelectedButton');
    const selectAllCheckbox = $('#selectAll');
    const editModal = $('#editModal');
    function makeSortable() { list.sortable({ handle: ".drag-handle", placeholder: "ui-sortable-placeholder" }); }
    makeSortable();
    function loadList(type) {
        list.html('<li>Carregando...</li>');
        $.ajax({
            url: window.location.pathname, type: 'GET', data: { action: 'get_list', type: type },
            success: function(responseHtml) {
                list.html(responseHtml);
                makeSortable();
                selectAllCheckbox.prop('checked', false);
            },
            error: function() { list.html('<li><span style="color: red;">Erro ao carregar.</span></li>'); }
        });
    }
    $('.tab-button').on('click', function() {
        $('.tab-button').removeClass('active');
        $(this).addClass('active');
        loadList($(this).data('type'));
    });
    saveBtn.on('click', function() {
        let order = list.find('li').map(function() { return $(this).data('id'); }).get();
        $.post(window.location.pathname, { action: 'save_order', order: JSON.stringify(order) }, function(res) {
            Swal.fire('Sucesso!', res.message, 'success');
        }).fail(function() { Swal.fire('Erro!', 'Não foi possível salvar a ordem.', 'error'); });
    });
    list.on('click', '.edit-btn', function() {
        let id = $(this).data('id');
        $.post(window.location.pathname, { action: 'get_category_details', id: id }, function(res) {
            if (res.status === 'success') {
                $('#edit_id').val(res.data.id);
                $('#edit_nome').val(res.data.nome);
                editModal.css('display', 'flex');
            } else { Swal.fire('Erro!', res.message, 'error'); }
        }).fail(function() { Swal.fire('Erro!', 'Não foi possível buscar os dados.', 'error'); });
    });
    $('#saveEditButton').on('click', function() {
        let id = $('#edit_id').val();
        let nome = $('#edit_nome').val();
        $.post(window.location.pathname, { action: 'save_edit', id: id, nome: nome }, function(res) {
            if (res.status === 'success') {
                editModal.hide();
                Swal.fire('Sucesso!', res.message, 'success');
                list.find('li[data-id="' + id + '"] .category-name').text(nome);
            } else { Swal.fire('Erro!', res.message, 'error'); }
        }).fail(function() { Swal.fire('Erro!', 'Não foi possível salvar.', 'error'); });
    });
    $('#cancelEditButton').on('click', () => editModal.hide());
    list.on('click', '.delete-btn', function() {
        let id = $(this).data('id');
        let li_item = $(this).closest('li');
        Swal.fire({
            title: 'Tem certeza?', text: "Esta ação não pode ser desfeita!", icon: 'warning',
            showCancelButton: true, confirmButtonText: 'Sim, apagar!', cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.post(window.location.pathname, { action: 'delete_category', id: id }, function(res) {
                    if (res.status === 'success') {
                        li_item.fadeOut(400, function() { $(this).remove(); });
                    } else { Swal.fire('Erro!', res.message, 'error'); }
                }).fail(function() { Swal.fire('Erro!', 'Não foi possível apagar.', 'error'); });
            }
        });
    });
    selectAllCheckbox.on('click', function() {
        list.find('.category-checkbox').prop('checked', $(this).prop('checked'));
    });
    deleteSelectedBtn.on('click', function() {
        let selectedIds = list.find('.category-checkbox:checked').map(function() { return $(this).data('id'); }).get();
        if (selectedIds.length === 0) {
            Swal.fire('Atenção', 'Selecione pelo menos uma categoria para apagar.', 'info'); return;
        }
        Swal.fire({
            title: 'Tem certeza?', text: `Você está prestes a apagar ${selectedIds.length} categorias!`, icon: 'warning',
            showCancelButton: true, confirmButtonText: 'Sim, apagar!', cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.post(window.location.pathname, { action: 'delete_bulk', ids: selectedIds }, function(res) {
                    if (res.status === 'success') {
                        loadList($('.tab-button.active').data('type'));
                        Swal.fire('Apagado!', res.message, 'success');
                    } else { Swal.fire('Erro!', res.message, 'error'); }
                }).fail(function() { Swal.fire('Erro!', 'Não foi possível apagar os itens selecionados.', 'error'); });
            }
        });
    });
});
</script>
</body>
</html>