<?php
// ======================================================================
//      SCRIPT DE DIAGNÓSTICO DA API - v1.0
// ======================================================================
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// PASSO 1: EDITE AS INFORMAÇÕES ABAIXO
// ======================================================================

// Coloque o usuário e senha de um cliente de teste.
// Pode ser o seu cliente com o plano completo ou o com plano de canais.
$teste_username = "jean1";
$teste_password = "jean1";

// Coloque aqui o ID de uma categoria de CANAIS que você SABE que deveria ter conteúdo.
$teste_category_id = 35; // Exemplo: 35 para a categoria "CANAIS | 24H SERIES"

// ======================================================================
// NÃO EDITE MAIS NADA ABAIXO DESTA LINHA
// ======================================================================

echo "<pre>"; // Formata a saída para ser fácil de ler
echo "INICIANDO TESTE DE DIAGNÓSTICO...\n\n";

// Inclui a conexão com o banco de dados
require_once($_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php');

// Tenta conectar ao banco
try {
    $conexao = conectar_bd();
    echo "[OK] Conexão com o banco de dados bem-sucedida.\n";
} catch (Exception $e) {
    echo "[ERRO FATAL] Não foi possível conectar ao banco de dados: " . $e->getMessage() . "\n";
    exit();
}

// 1. SIMULANDO AUTENTICAÇÃO
echo "\n--- ETAPA 1: Autenticando o cliente ---\n";
$query_auth = "SELECT * FROM clientes WHERE usuario = ? AND senha = ?";
$stmt_auth = $conexao->prepare($query_auth);
$stmt_auth->execute([$teste_username, $teste_password]);
$cliente_info = $stmt_auth->fetch(PDO::FETCH_ASSOC);

if (!$cliente_info) {
    echo "[ERRO FATAL] Cliente '$teste_username' não encontrado ou senha incorreta.\n";
    exit();
}
echo "[OK] Cliente encontrado: " . $cliente_info['name'] . " (ID: " . $cliente_info['id'] . ")\n";

// 2. SIMULANDO LÓGICA DE BOUQUET
echo "\n--- ETAPA 2: Verificando o pacote (bouquet) do cliente ---\n";
$allowed_category_ids = null;
if (!empty($cliente_info['bouquet_id'])) {
    echo "Cliente tem o bouquet_id: " . $cliente_info['bouquet_id'] . "\n";
    $stmt_bouquet = $conexao->prepare("SELECT category_id FROM bouquet_categories WHERE bouquet_id = ?");
    $stmt_bouquet->execute([$cliente_info['bouquet_id']]);
    $allowed_category_ids = $stmt_bouquet->fetchAll(PDO::FETCH_COLUMN);
    
    if (empty($allowed_category_ids)) {
        $allowed_category_ids = [0];
        echo "Bouquet está definido, mas vazio. Acesso bloqueado (ID [0]).\n";
    } else {
        echo "[OK] IDs de categoria permitidos pelo bouquet: [" . implode(', ', $allowed_category_ids) . "]\n";
    }
} else {
    echo "[INFO] Cliente não tem bouquet definido (acesso total).\n";
}

// 3. SIMULANDO A BUSCA DE CANAIS (A PARTE QUE ESTÁ FALHANDO)
echo "\n--- ETAPA 3: Construindo a consulta SQL para buscar os canais ---\n";
$action = 'get_live_streams';
$category_id = $teste_category_id;
$stream_type = 'streams';
$table = 'streams';

// Lógica de construção da query (copiada do player_api.php)
$query_str = "SELECT * FROM `{$table}` WHERE `stream_type` = ?";
$params = [$stream_type];

if ($cliente_info['adulto'] == 0) { 
    $query_str .= " AND `is_adult` = 0";
    echo "Adicionado filtro de conteúdo adulto.\n";
}

if (isset($category_id)) {
    if ($allowed_category_ids !== null) {
        if (in_array($category_id, $allowed_category_ids)) {
            $query_str .= " AND `category_id` = ?";
            $params[] = $category_id;
            echo "Cliente com bouquet. Filtrando pela categoria específica permitida: ID " . $category_id . "\n";
        } else {
            echo "[ERRO LÓGICO] O cliente pediu a categoria ID $category_id, mas ela NÃO está no seu bouquet. A API retornaria uma lista vazia.\n";
            $query_str = "SELECT * FROM `{$table}` WHERE 1 = 0"; // Força a query a não retornar nada
            $params = [];
        }
    } else {
        $query_str .= " AND `category_id` = ?";
        $params[] = $category_id;
        echo "Cliente sem bouquet. Filtrando pela categoria específica: ID " . $category_id . "\n";
    }
} else {
    if ($allowed_category_ids !== null) {
        $placeholders = implode(',', array_fill(0, count($allowed_category_ids), '?'));
        $query_str .= " AND category_id IN ($placeholders)";
        $params = array_merge($params, $allowed_category_ids);
        echo "Cliente com bouquet. Filtrando por TODAS as categorias do bouquet.\n";
    }
}

$query_str .= " ORDER BY `name` ASC";

echo "\n[INFO] Consulta SQL Final Gerada:\n";
echo "========================================\n";
echo $query_str;
echo "\n========================================\n";

echo "\n[INFO] Parâmetros a serem enviados para a consulta:\n";
print_r($params);
echo "\n";

// 4. EXECUTANDO A CONSULTA
echo "\n--- ETAPA 4: Executando a consulta no banco de dados ---\n";
try {
    $query = $conexao->prepare($query_str);
    $query->execute($params);
    $results = $query->fetchAll();
    $rowCount = count($results);

    echo "[RESULTADO] A consulta encontrou **" . $rowCount . "** canais.\n\n";

    if ($rowCount > 0) {
        echo "TESTE BEM-SUCEDIDO! A consulta está funcionando e retornando canais.\n";
    } else {
        echo "TESTE FALHOU! A consulta funcionou, mas não encontrou NENHUM canal com os critérios atuais. Isso confirma que o problema é de dados (a ligação entre canais e categorias está incorreta no banco de dados).\n";
    }

} catch (Exception $e) {
    echo "[ERRO FATAL] A execução da consulta falhou! Mensagem de erro:\n";
    echo $e->getMessage() . "\n";
}

echo "\nFIM DO TESTE DE DIAGNÓSTICO.\n";
echo "</pre>";
?>