<?php
session_start();
// É crucial que a conexão com o banco de dados e as funções de busca sejam carregadas
require_once('./api/controles/db.php');
require_once('./api/controles/dashboard.php'); // Onde estão as funções Dashboard(), testes(), etc.
require_once("menu.php");

// Executa as funções para buscar os dados que serão exibidos
$dadosAtivos = Dashboard();
$dadosTestes = testes();
$conteudos = conteudos();
?>

<style>
    .section-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 1px solid var(--border-color);
    }
    .color-card {
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        border: none;
        transition: all 0.3s ease;
        color: #ffffff;
        display: flex;
        flex-direction: column;
        height: 100%;
    }
    .color-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
    }
    .color-card .card-body {
        display: flex;
        align-items: center;
        padding: 25px;
        flex-grow: 1;
    }
    .color-card .icon-container {
        font-size: 2.8rem;
        margin-right: 20px;
        opacity: 0.8;
    }
    .color-card .card-text-content {
        flex-grow: 1;
        text-align: right;
    }
    .color-card .card-label {
        font-size: 1rem;
        font-weight: 400;
        margin-bottom: 5px;
        color: rgba(255, 255, 255, 0.9);
        text-transform: uppercase;
    }
    .color-card .card-value {
        font-size: 2.2rem;
        font-weight: 700;
        color: #ffffff;
        margin: 0;
        line-height: 1;
    }
    
    /* Cores dos cards inspiradas na sua referência */
    .card-red { background: linear-gradient(45deg, #e74c3c, #c0392b); }
    .card-orange { background: linear-gradient(45deg, #f39c12, #e67e22); }
    .card-blue { background: linear-gradient(45deg, #3498db, #2980b9); }
    .card-green { background: linear-gradient(45deg, #2ecc71, #27ae60); }
    .card-purple { background: linear-gradient(45deg, #9b59b6, #8e44ad); }
    .card-lightblue { background: linear-gradient(45deg, #34b3e7, #22a7f0); }
    
    /* Tabelas de vencimento */
    .table-card { padding: 20px; }
    .table-responsive { max-height: 250px; overflow-y: auto; }
</style>

<div class="p-3 p-md-4">

    <?php if (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1): ?>
    <div class="row">
        <div class="col-12">
            <h4 class="section-title">Resumo do Conteúdo</h4>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="color-card card-red">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-tv"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Canais</div>
                        <p class="card-value"><?php echo $conteudos['TotalLiveStreams']; ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="color-card card-orange">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-film"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Filmes</div>
                        <p class="card-value"><?php echo $conteudos['TotalMovieStreams']; ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="color-card card-blue">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-clapperboard"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Séries</div>
                        <p class="card-value"><?php echo $conteudos['TotalSeries']; ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="color-card card-green">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-photo-film"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Episódios</div>
                        <p class="card-value"><?php echo $conteudos['TotalEpisodes']; ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <div class="row mt-3">
        <div class="col-12">
            <h4 class="section-title">Resumo de Clientes</h4>
        </div>
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-green">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-users"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Clientes Ativos</div>
                        <p class="card-value"><?php echo $dadosAtivos['clientesAtivos']; ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-red">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-users-slash"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Total Vendidos</div>
                        <p class="card-value"><?php echo $dadosAtivos['clientesvencidostotal']; // Corrigir a variável se necessário ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-lightblue">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-dollar-sign"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Valores a Receber</div>
                        <p class="card-value">R$ <?php echo number_format($dadosAtivos['clientesarenovar_valor'], 2, ',', '.'); ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-orange">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-vial"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Testes Ativos</div>
                        <p class="card-value"><?php echo $dadosTestes['TestesAtivos']; ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-purple">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-user-plus"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Novos (Mês)</div>
                        <p class="card-value"><?php echo $dadosAtivos['clientesnovos']; ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-red">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-user-xmark"></i></div>
                    <div class="card-text-content">
                        <div class="card-label">Vencidos (Mês)</div>
                        <p class="card-value"><?php echo $dadosAtivos['clientesvencidos_este_mes']; ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-12">
            <h4 class="section-title">Acompanhamento de Vencimentos</h4>
        </div>
        <div class="col-lg-6 mb-4">
            <div class="card table-card h-100">
                <h5 class="card-title">Vencendo Hoje</h5>
                <div class="table-responsive">
                    <table class="table table-hover table-sm" style="color: var(--text-primary);">
                        <thead><tr><th>Usuário</th><th>Vencimento</th><th class="text-end">Valor</th><th class="text-center">Ações</th></tr></thead>
                        <tbody>
                            <?php if (empty($dadosAtivos['clientesvencidos_hoje_lista'])): ?>
                                <tr><td colspan="4" class="text-center text-muted">Nenhum cliente vencendo hoje.</td></tr>
                            <?php else: foreach ($dadosAtivos['clientesvencidos_hoje_lista'] as $cliente): ?>
                                <tr>
                                    <td><?php echo $cliente['usuario']; ?></td>
                                    <td><?php echo $cliente['data']; ?></td>
                                    <td class="text-end">R$ <?php echo $cliente['total']; ?></td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-sm btn-outline-primary" title="Renovar" onclick='modal_master("api/clientes.php", "renovar_cliente", "<?php echo $cliente['id']; ?>", "usuario", "<?php echo $cliente['usuario']; ?>")'><i class="fa-retweet fas"></i></button>
                                    </td>
                                </tr>
                            <?php endforeach; endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-6 mb-4">
            <div class="card table-card h-100">
                <h5 class="card-title">Vencendo Amanhã</h5>
                <div class="table-responsive">
                    <table class="table table-hover table-sm" style="color: var(--text-primary);">
                        <thead><tr><th>Usuário</th><th>Vencimento</th><th class="text-end">Valor</th><th class="text-center">Ações</th></tr></thead>
                        <tbody>
                             <?php if (empty($dadosAtivos['clientesvencidos_amanha_lista'])): ?>
                                <tr><td colspan="4" class="text-center text-muted">Nenhum cliente vencendo amanhã.</td></tr>
                            <?php else: foreach ($dadosAtivos['clientesvencidos_amanha_lista'] as $cliente): ?>
                                <tr>
                                    <td><?php echo $cliente['usuario']; ?></td>
                                    <td><?php echo $cliente['data']; ?></td>
                                    <td class="text-end">R$ <?php echo $cliente['total']; ?></td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-sm btn-outline-primary" title="Renovar" onclick='modal_master("api/clientes.php", "renovar_cliente", "<?php echo $cliente['id']; ?>", "usuario", "<?php echo $cliente['usuario']; ?>")'><i class="fa-retweet fas"></i></button>
                                    </td>
                                </tr>
                            <?php endforeach; endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>