<?php
// ======================================================================
//      GERENCIADOR DE BACKUP E RESTAURAÇÃO v1.5
//      Corrigido: Tema Escuro, Download Seguro, Botões e Criação de Backup.
// ======================================================================
session_start();
if (empty($_SESSION['logged_in_fxtream'])) {
    header('Location: ./index.php');
    exit();
}

// --- CONFIGURAÇÕES ---
$db_host = 'localhost';
$db_name = 'geanrober_magaflix';
$db_user = 'geanrober_magaflix';
$db_pass = 'Jean#909110';
$backup_dir = 'backups/';
$feedback = '';

// --- LÓGICA DE AÇÕES ---

// Ação para FAZER BACKUP
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] == 'do_backup') {
    $is_writable = is_writable($backup_dir);
    if (!$is_writable) {
        $feedback = '<div class="alert alert-danger">Erro de Permissão: A pasta de backups não tem permissão de escrita. Altere as permissões (CHMOD) da pasta \'backups/\' para 777.</div>';
    } else {
        $filename = 'backup_' . date('Y-m-d_H-i-s') . '.sql';
        $filepath = $backup_dir . $filename;
        // Comando mysqldump para criar o backup
        $command = "mysqldump --host={$db_host} --user={$db_user} --password={$db_pass} --no-tablespaces {$db_name} > {$filepath} 2>&1";
        $output = shell_exec($command);

        if (file_exists($filepath) && filesize($filepath) > 0 && empty($output)) {
            $feedback = '<div class="alert alert-success">Backup criado com sucesso: ' . $filename . '</div>';
        } else {
            $feedback = '<div class="alert alert-danger">Falha ao criar o backup. O servidor retornou um erro: <pre>' . htmlspecialchars($output) . '</pre> Verifique as credenciais do banco de dados no script e as permissões.</div>';
        }
    }
}

// Ação para DELETAR BACKUP
if (isset($_GET['delete'])) {
    $file_to_delete = basename($_GET['delete']);
    $filepath = $backup_dir . $file_to_delete;
    if (file_exists($filepath)) {
        if (!unlink($filepath)) {
             $feedback = '<div class="alert alert-danger">Não foi possível apagar o arquivo. Verifique as permissões de escrita na pasta e no arquivo.</div>';
        }
    }
    // Redireciona para a própria página para remover o parâmetro da URL e atualizar a lista
    header("Location: " . basename($_SERVER['PHP_SELF']));
    exit();
}

// Ação para DOWNLOAD SEGURO
if (isset($_GET['download'])) {
    $file_to_download = basename($_GET['download']);
    $filepath = $backup_dir . $file_to_download;
    if (file_exists($filepath)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');
        readfile($filepath);
        exit;
    }
    die("Arquivo não encontrado.");
}

// Ação para RESTAURAR BACKUP
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] == 'do_restore') {
    $file_to_restore = $_POST['backup_file'] ?? '';
    $filepath = $backup_dir . basename($file_to_restore);
    if (file_exists($filepath)) {
        // Comando mysql para restaurar
        $command = "mysql --host={$db_host} --user={$db_user} --password={$db_pass} {$db_name} < {$filepath} 2>&1";
        $output = shell_exec($command);
        if (empty($output)) {
            $feedback = '<div class="alert alert-success">Banco de dados restaurado com sucesso a partir de: ' . basename($file_to_restore) . '</div>';
        } else {
            $feedback = '<div class="alert alert-danger">Falha ao restaurar o backup. O servidor retornou um erro: <pre>' . htmlspecialchars($output) . '</pre></div>';
        }
    } else {
        $feedback = '<div class="alert alert-danger">Arquivo de backup não encontrado para restauração.</div>';
    }
}

$backup_files = glob($backup_dir . '*.sql');
rsort($backup_files);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Backup e Restauração</title>
    <link href="//cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <script>
        (function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.documentElement.setAttribute('data-theme', savedTheme);
        })();
    </script>
    <style>
        :root {
            --bg-main: #f0f2f5; --bg-card: #ffffff; --text-primary: #212529; 
            --text-secondary: #6c757d; --border-color: #dee2e6;
        }
        [data-theme="dark"] {
            --bg-main: #16191c; --bg-card: #2a2e33; --text-primary: #e4e6eb;
            --text-secondary: #b0b3b8; --border-color: #495057;
        }
        body { background-color: var(--bg-main); color: var(--text-primary); }
        .card { background-color: var(--bg-card); border-color: var(--border-color); box-shadow: 0 4px 8px rgba(0,0,0,0.1); border-radius: 10px; }
        .list-group-item { background-color: var(--bg-card); border-color: var(--border-color); color: var(--text-primary); }
    </style>
</head>
<body class="p-3 p-md-4">
    <div class="container">
        <div class="card">
            <div class="card-header bg-primary text-white text-center"><h2 class="mb-0"><i class="fas fa-database"></i> Gerenciador de Banco de Dados</h2></div>
            <div class="card-body p-4">
                <?php echo $feedback; ?>
                <div class="text-center mb-4">
                    <form method="POST" action="">
                        <input type="hidden" name="action" value="do_backup">
                        <button type="submit" class="btn btn-lg btn-success"><i class="fas fa-plus-circle"></i> Criar Novo Backup</button>
                    </form>
                </div>
                <h4 class="mb-3" style="color: var(--text-primary);">Backups Existentes</h4>
                <div class="list-group">
                    <?php if (empty($backup_files)): ?>
                        <div class="list-group-item">Nenhum backup encontrado.</div>
                    <?php else: foreach ($backup_files as $file): ?>
                        <div class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                            <div class="mb-2 mb-md-0">
                                <i class="fas fa-file-alt text-muted me-2"></i>
                                <strong><?php echo basename($file); ?></strong>
                                <small class="text-muted ms-2">(<?php echo round(filesize($file) / 1024 / 1024, 2); ?> MB)</small>
                            </div>
                            <div class="mt-2 mt-md-0">
                                <a href="?download=<?php echo basename($file); ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-download"></i> Baixar</a>
                                <button class="btn btn-sm btn-outline-warning ms-2 restore-btn" data-file="<?php echo basename($file); ?>"><i class="fas fa-history"></i> Restaurar</button>
                                <a href="?delete=<?php echo basename($file); ?>" class="btn btn-sm btn-outline-danger ms-2" onclick="return confirm('TEM CERTEZA ABSOLUTA que deseja apagar este arquivo de backup?');"><i class="fas fa-trash"></i> Apagar</a>
                            </div>
                        </div>
                    <?php endforeach; endif; ?>
                </div>
                <form id="restoreForm" method="POST" action="" style="display: none;">
                    <input type="hidden" name="action" value="do_restore">
                    <input type="hidden" id="backup_file_input" name="backup_file">
                </form>
            </div>
        </div>
    </div>
    
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            $('.restore-btn').on('click', function() {
                const fileToRestore = $(this).data('file');
                Swal.fire({
                    title: 'TEM CERTEZA ABSOLUTA?',
                    html: `Você está prestes a restaurar o banco de dados com o arquivo:<br><strong>${fileToRestore}</strong><br><br><strong style="color: red; font-size: 1.2rem;">TODOS OS DADOS ATUAIS SERÃO PERMANENTEMENTE APAGADOS E SUBSTITUÍDOS.</strong><br><br>Digite "CONFIRMAR" no campo abaixo para prosseguir.`,
                    icon: 'warning', input: 'text',
                    confirmButtonText: 'Restaurar Agora', confirmButtonColor: '#dc3545',
                    cancelButtonText: 'Cancelar', showCancelButton: true,
                    preConfirm: (login) => { if (login !== 'CONFIRMAR') { Swal.showValidationMessage('Você precisa digitar "CONFIRMAR" para prosseguir.') } },
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#backup_file_input').val(fileToRestore);
                        $('#restoreForm').submit();
                    }
                })
            });
        });
    </script>
</body>
</html>