<?php
session_start();
if (!isset($_SESSION['nivel_admin']) || $_SESSION['nivel_admin'] != 1) { die("Acesso negado."); }

// ======================================================================
//      LINHA DE CORREÇÃO ADICIONADA AQUI
//      Inclui o seu menu e todo o design do painel.
// ======================================================================
require_once("menu.php");

require_once("./api/controles/db.php");
require_once('./api/controles/clientes.php'); // Essencial para a função de criar cliente
$conexao = conectar_bd();

$feedback = '';
$dados_encontrados = null;

// Ação para CARREGAR dados da URL
if (isset($_POST['action']) && $_POST['action'] == 'load_m3u') {
    $m3u_url = trim($_POST['m3u_url'] ?? '');
    if (filter_var($m3u_url, FILTER_VALIDATE_URL) && strpos($m3u_url, 'username=') !== false && strpos($m3u_url, 'password=') !== false) {
        parse_str(parse_url($m3u_url, PHP_URL_QUERY), $query_params);
        $dados_encontrados = [
            'usuario' => $query_params['username'] ?? '',
            'senha' => $query_params['password'] ?? ''
        ];
    } else {
        $feedback = '<div class="alert alert-danger mt-3">URL M3U inválida ou não contém usuário e senha.</div>';
    }
}

// Ação para CRIAR o cliente migrado
if (isset($_POST['action']) && $_POST['action'] == 'create_client') {
    $data_vencimento = $_POST['vencimento'] ?? null;
    
    // Simula os dados do formulário para a função existente
    $_POST['name'] = $_POST['nome_cliente'];
    $_POST['usuario'] = $_POST['usuario'];
    $_POST['senha'] = $_POST['senha'];
    $_POST['data_de_vencimento'] = $data_vencimento;
    $_POST['conexoes_maximas'] = $_POST['conexoes'];
    $_POST['adulto'] = $_POST['adulto'];
    $_POST['plano'] = $_POST['plano'];
    $_POST['bouquet_id'] = $_POST['bouquet_id'];
    
    $resultado = confirme_adicionar_clientes(
        $_POST['name'], $_POST['usuario'], $_POST['senha'], $_POST['adulto'],
        $_POST['plano'], null, null, null, null, null, null, null, null,
        $data_vencimento, 
        $_POST['conexoes_maximas']
    );

    if (isset($resultado['icon']) && $resultado['icon'] === 'success') {
        $feedback = '<div class="alert alert-success mt-3">Cliente migrado com sucesso!</div>';
    } else {
        $feedback = '<div class="alert alert-danger mt-3">Falha ao migrar cliente: ' . ($resultado['msg'] ?? 'Erro desconhecido.') . '</div>';
    }
}

$planos = $conexao->query("SELECT * FROM planos")->fetchAll();
$bouquets = $conexao->query("SELECT * FROM bouquets ORDER BY bouquet_name ASC")->fetchAll();
?>

<h4 class="mb-4 text-muted text-uppercase">Sistema de Migração de Clientes</h4>
<?php echo $feedback; ?>
<div class="card">
    <div class="card-body">
        <ul class="nav nav-tabs">
            <li class="nav-item"><a class="nav-link active" href="#">Migração Individual</a></li>
            <li class="nav-item"><a class="nav-link disabled" href="#" title="Função desabilitada por segurança e performance.">Migração em Massa</a></li>
        </ul>

        <div class="tab-content pt-3">
            <div class="tab-pane fade show active">
                <form method="POST" action="migrar_clientes.php">
                    <input type="hidden" name="action" value="load_m3u">
                    <div class="mb-3">
                        <label for="m3u_url" class="form-label">URL M3U do servidor de origem:</label>
                        <input type="text" id="m3u_url" name="m3u_url" class="form-control" placeholder="http://servidor.com/get.php?username=user&password=pass" required>
                        <div class="form-text">Exemplo: http://servidor.com/get.php?username=user&password=pass&type=m3u_plus&output=ts</div>
                    </div>
                    <button type="submit" class="btn btn-info"><i class="fas fa-download me-2"></i>Carregar Dados para Migração</button>
                </form>

                <?php if ($dados_encontrados): ?>
                <hr>
                <h5 class="mt-4">Confirmar Dados do Novo Cliente</h5>
                <form id="individual-migration-form">
                    <input type="hidden" name="action" value="create_client">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Nome do Cliente:</label>
                            <input type="text" name="nome_cliente" class="form-control" value="<?php echo htmlspecialchars($dados_encontrados['usuario']); ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Usuário:</label>
                            <input type="text" name="usuario" class="form-control" value="<?php echo htmlspecialchars($dados_encontrados['usuario']); ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Senha:</label>
                            <input type="text" name="senha" class="form-control" value="<?php echo htmlspecialchars($dados_encontrados['senha']); ?>" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Data de Vencimento:</label>
                            <input type="date" id="vencimento" name="vencimento" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Conexões Máximas:</label>
                            <input type="number" name="conexoes" class="form-control" value="1" min="1" required>
                        </div>
                         <div class="col-md-6 mb-3">
                            <label class="form-label">Plano:</label>
                            <select name="plano" class="form-select" required>
                                <?php foreach($planos as $plano): ?>
                                <option value="<?php echo $plano['id']; ?>"><?php echo htmlspecialchars($plano['nome']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Pacote (Bouquet):</label>
                            <select name="bouquet_id" class="form-select">
                                <option value="">Acesso Total</option>
                                <?php foreach($bouquets as $bouquet): ?>
                                <option value="<?php echo $bouquet['id']; ?>"><?php echo htmlspecialchars($bouquet['bouquet_name']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Conteúdo Adulto:</label>
                            <select name="adulto" class="form-select">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                            </select>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-success"><i class="fas fa-user-plus me-2"></i>Migrar Cliente</button>
                </form>
                
                <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const dateInput = document.getElementById('vencimento');
                    if (dateInput) {
                        const today = new Date();
                        today.setDate(today.getDate() + 30);
                        dateInput.value = today.toISOString().split('T')[0];
                    }
                });
                </script>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>