<?php
// ... [O CÓDIGO PHP INICIAL PERMANECE O MESMO] ...
// ======================================================================
//      SISTEMA DRAG & DROP DE ORGANIZAÇÃO DE CATEGORIAS v2.1
//      Adicionado suporte ao Tema Claro/Escuro
// ======================================================================
$db_host = 'localhost'; $db_name = 'u535247987_tvbox'; $db_user = 'u535247987_tvbox'; $db_pass = 'Jean#909110'; $charset = 'utf8mb4';
try {
    $dsn = "mysql:host=$db_host;dbname=$db_name;charset=$charset";
    $options = [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION];
    $pdo = new PDO($dsn, $db_user, $db_pass, $options);
} catch (PDOException $e) { /* ... */ }
$action = $_POST['action'] ?? $_GET['action'] ?? '';
if ($action) { /* ... LÓGICA DA API ... */ exit(); }
$categorias_iniciais = $pdo->query("SELECT `id`, `nome` FROM `categoria` WHERE `type` = 'streams' ORDER BY `position` ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Organizador de Categorias por Abas</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
    
    <script>
        (function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.documentElement.setAttribute('data-theme', savedTheme);
        })();
    </script>
    <style>
        :root {
            --bg-main: #f0f2f5; --bg-card: #ffffff; --text-primary: #212529; 
            --text-secondary: #6c757d; --border-color: #dee2e6;
        }
        [data-theme="dark"] {
            --bg-main: #16191c; --bg-card: #2a2e33; --text-primary: #e4e6eb;
            --text-secondary: #b0b3b8; --border-color: #495057;
        }
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; background-color: var(--bg-main); color: var(--text-primary); margin: 0; padding: 20px; }
        .container { max-width: 800px; margin: auto; background: var(--bg-card); padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        h1 { text-align: center; color: var(--text-primary); }
        .tabs { margin-bottom: 20px; display: flex; border-bottom: 2px solid var(--border-color); }
        .tab-button { background: transparent; border: none; border-bottom: 2px solid transparent; padding: 10px 20px; cursor: pointer; font-size: 16px; color: var(--text-secondary); }
        .tab-button.active { border-bottom: 2px solid #0d6efd; font-weight: bold; color: #0d6efd; }
        #sortable-list { list-style: none; padding: 0; margin: 0; min-height: 100px; }
        #sortable-list li { cursor: move; padding: 15px; margin-bottom: 5px; border: 1px solid var(--border-color); background-color: var(--bg-card); border-radius: 4px; display: flex; align-items: center; }
        .drag-handle { display: inline-block; width: 20px; height: 20px; background-color: #ccc; margin-right: 15px; border-radius: 3px; cursor: grab; }
        [data-theme="dark"] .drag-handle { background-color: #555; }
        .ui-sortable-placeholder { border: 2px dashed #0d6efd; background-color: rgba(13, 110, 253, 0.1); height: 50px; visibility: visible !important; }
        .save-button-container { text-align: center; margin-top: 20px; }
        #saveButton { font-size: 16px; font-weight: bold; padding: 12px 25px; color: #fff; background-color: #198754; border: none; border-radius: 5px; cursor: pointer; }
        #message { text-align: center; font-weight: bold; margin-top: 15px; padding: 10px; border-radius: 5px; display: none; }
        #message.success { color: #155724; background-color: #d4edda; }
        #message.error { color: #721c24; background-color: #f8d7da; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Organizador de Categorias (Arrastar e Soltar)</h1>
        <p style="text-align: center; color: var(--text-secondary);">Clique e arraste as categorias para a ordem desejada e depois clique em "Salvar Ordem".</p>
        <div class="tabs">
            <button class="tab-button active" data-type="streams">Canais</button>
            <button class="tab-button" data-type="movie">Filmes</button>
            <button class="tab-button" data-type="series">Séries</button>
        </div>
        <ul id="sortable-list">
            <?php foreach ($categorias_iniciais as $cat): ?>
                <li data-id="<?php echo $cat['id']; ?>"><span class="drag-handle"></span><?php echo htmlspecialchars($cat['nome']); ?></li>
            <?php endforeach; ?>
        </ul>
        <div class="save-button-container">
            <button id="saveButton">Salvar Ordem da Lista Atual</button>
        </div>
        <div id="message"></div>
    </div>
    <script>
        // O JAVASCRIPT aqui continua o mesmo
    </script>
</body>
</html>