<?php
// Script de verificação final de dados
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Inclui sua conexão com o banco de dados
require_once($_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php');

echo "<pre>"; // Para formatar a saída de forma legível

try {
    $conexao = conectar_bd();
    echo "Conexão com o banco de dados bem-sucedida.\n\n";
    
    // ================================================================
    // AQUI VAMOS TESTAR A CATEGORIA 35 (CANAIS | 24H SERIES)
    // Se quiser testar outra, basta mudar o número abaixo.
    $id_da_categoria_para_testar = 35;
    // ================================================================

    echo "Procurando por canais na tabela 'streams' onde a coluna 'category_id' é igual a: " . $id_da_categoria_para_testar . "\n\n";

    // Esta é a consulta mais simples possível
    $query = "SELECT id, name, category_id, stream_type FROM streams WHERE category_id = ?";
    
    $statement = $conexao->prepare($query);
    $statement->execute([$id_da_categoria_para_testar]);
    
    $resultados = $statement->fetchAll(PDO::FETCH_ASSOC);
    
    $total_encontrado = count($resultados);

    echo "-------------------------------------------------\n";
    echo "RESULTADO: Foram encontrados " . $total_encontrado . " canais.\n";
    echo "-------------------------------------------------\n\n";

    if ($total_encontrado > 0) {
        echo "CANAIS ENCONTRADOS:\n";
        print_r($resultados);
    } else {
        echo "CONCLUSÃO: Não existe NENHUM canal na sua tabela 'streams' com o 'category_id' igual a " . $id_da_categoria_para_testar . ".\n";
        echo "Isso confirma que o problema é a associação (ligação) dos canais com as categorias no banco de dados.\n";
    }

} catch (Exception $e) {
    echo "Ocorreu um erro fatal durante o teste: " . $e->getMessage();
}

echo "</pre>";

?>