<?php
/**
 * API para gerenciar as categorias.
 * Versão final e correta. O funcionamento depende da liberação das regras de segurança do servidor de hospedagem.
 */

// --- 1. CONFIGURAÇÃO DE DEBUG E CABEÇALHO ---
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=utf-8');


// --- 2. CONFIGURAÇÃO DO BANCO DE DADOS ---
$db_host = 'localhost';
$db_name = 'geanrober_jean';
$db_user = 'geanrober_jean';
$db_pass = 'Jean#909110';


// --- 3. LÓGICA PRINCIPAL ---
// Usa o método padrão e mais compatível para ler os dados.
$action = $_POST['action'] ?? '';

if ($action == 'save_order') {
    $orderData = json_decode($_POST['order'] ?? '[]', true);

    if (json_last_error() === JSON_ERROR_NONE && is_array($orderData) && !empty($orderData)) {
        try {
            // Usa o driver MySQLi que se mostrou mais informativo nos testes.
            $mysqli = new mysqli($db_host, $db_user, $db_pass, $db_name);
            if ($mysqli->connect_error) {
                throw new Exception('Erro de conexão (MySQLi): ' . $mysqli->connect_error);
            }
            $mysqli->set_charset("utf8");

            $total_affected_rows = 0;
            // Prepara o comando UMA VEZ, fora do loop (melhor prática).
            $stmt = $mysqli->prepare("UPDATE `categoria` SET `position` = ? WHERE `id` = ?");

            foreach ($orderData as $item) {
                $id = intval($item['id']);
                $ordem = intval($item['ordem']);
                
                // 'ii' significa que ambos os parâmetros são inteiros (integer)
                $stmt->bind_param('ii', $ordem, $id);
                $stmt->execute();
                $total_affected_rows += $stmt->affected_rows;
            }
            
            $stmt->close();
            $mysqli->close();
            echo json_encode(['status' => 'success', 'message' => "Ordem salva com sucesso! {$total_affected_rows} categorias foram atualizadas."]);

        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['status' => 'error', 'message' => 'Erro ao salvar a ordem: ' . $e->getMessage()]);
        }
    } else {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Dados de ordenação inválidos ou vazios.']);
    }
    exit();

} else if ($action == 'listar') {
    // A lógica de listagem usa PDO, pois está a funcionar corretamente.
    try {
        $pdo = new PDO("mysql:host={$db_host};dbname={$db_name};charset=utf8", $db_user, $db_pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table_name = 'categoria';
        $category_type = $_POST['type'] ?? 'streams';

        $query_base = "FROM `{$table_name}`";
        $query_where = " WHERE `type` = :category_type";

        $stmt_total = $pdo->prepare("SELECT COUNT(`id`) " . $query_base . $query_where);
        $stmt_total->execute([':category_type' => $category_type]);
        $totalRecords = $stmt_total->fetchColumn();
        
        $search_value = $_POST['search']['value'] ?? '';
        if (!empty($search_value)) {
            $query_where .= " AND (`nome` LIKE :search_value)";
        }

        $stmt_filtered = $pdo->prepare("SELECT COUNT(`id`) " . $query_base . $query_where);
        $stmt_filtered->bindValue(':category_type', $category_type, PDO::PARAM_STR);
        if (!empty($search_value)) {
            $stmt_filtered->bindValue(':search_value', '%' . $search_value . '%', PDO::PARAM_STR);
        }
        $stmt_filtered->execute();
        $recordsFiltered = $stmt_filtered->fetchColumn();

        $order_column_name = 'position';
        $order_dir = 'asc';
        $start = $_POST['start'] ?? 0;
        $length = $_POST['length'] ?? 10;

        $query_data = "SELECT `id` as id_categoria, `nome` as category_name, `type` as tipo, `is_adult`, `position` "
                    . $query_base . $query_where
                    . " ORDER BY `{$order_column_name}` {$order_dir}"
                    . " LIMIT " . intval($start) . ", " . intval($length);
        
        $stmt_data = $pdo->prepare($query_data);
        $stmt_data->bindValue(':category_type', $category_type, PDO::PARAM_STR);
        if (!empty($search_value)) {
            $stmt_data->bindValue(':search_value', '%' . $search_value . '%', PDO::PARAM_STR);
        }
        $stmt_data->execute();
        $data = $stmt_data->fetchAll(PDO::FETCH_ASSOC);

        $formatted_data = [];
        foreach($data as $row) {
            $row['is_adult'] = ($row['is_adult'] == 1) ? '<span class="badge bg-danger">Sim</span>' : '<span class="badge bg-success">Não</span>';
            $row['bg_ssiptv'] = '-';
            $row['acoes'] = '
                <button type="button" class="btn btn-sm btn-warning fa-edit fas" onclick=\'modal_master("api/categorias.php", "edit_categoria", ' . $row['id_categoria'] . ')\'></button>
                <button type="button" class="btn btn-sm btn-danger fa-trash-alt fas" onclick="remover(' . $row['id_categoria'] . ')"></button>
            ';
            $formatted_data[] = $row;
        }

        $response = [
            "draw"            => intval($_POST['draw'] ?? 0),
            "recordsTotal"    => intval($totalRecords),
            "recordsFiltered" => intval($recordsFiltered),
            "data"            => $formatted_data
        ];

        echo json_encode($response, JSON_INVALID_UTF8_SUBSTITUTE);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["error" => "Ocorreu um erro na API ao listar: " . $e->getMessage()]);
    }
    exit();
}

// Se nenhuma ação for válida
http_response_code(400);
echo json_encode(['error' => 'Ação inválida.']);
exit();
?>
