<?php
session_start();
require_once('./api/controles/db.php');
require_once('./api/controles/dashboard.php');
require_once("menu.php");
require_once('./api/is_trial.php');

// As suas funções PHP para buscar os dados continuam as mesmas
$dadosAtivos = Dashboard();
$dadosTestes = testes();
$conteudos = conteudos();
$resposta = contar_clientes_is_trial_0();
?>

<!-- Estilos específicos para o Dashboard com cores fixas -->
<style>
    .section-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--text-primary);
        margin-bottom: 20px;
        padding-bottom: 10px;
        border-bottom: 1px solid var(--border-color);
    }

    .color-card {
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        border: none;
        transition: all 0.3s ease;
        color: #ffffff;
        display: flex;
        flex-direction: column;
        height: 100%;
    }

    .color-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    }

    .color-card .card-body {
        display: flex;
        align-items: center;
        padding: 20px;
        flex-grow: 1;
    }

    .color-card .icon-container {
        font-size: 2.5rem;
        margin-right: 20px;
        opacity: 0.9;
    }

    .color-card .card-text-content {
        flex-grow: 1;
        text-align: right;
    }

    .color-card .card-label {
        font-size: 0.9rem;
        font-weight: 400;
        margin-bottom: 5px;
        color: rgba(255, 255, 255, 0.85);
    }

    .color-card .card-value {
        font-size: 2rem;
        font-weight: 700;
        color: #ffffff;
    }
    
    /* Cores dos cartões baseadas na sua imagem de referência */
    .card-blue { background-color: #3498db; }
    .card-green { background-color: #2ecc71; }
    .card-red { background-color: #e74c3c; }
    .card-orange { background-color: #f39c12; }
    .card-purple { background-color: #9b59b6; }
    .card-lightblue { background-color: #34b3e7; }

    /* Estilo para as tabelas de vencimento */
    .table-card {
        background-color: var(--bg-card);
        border-radius: 12px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        border: 1px solid var(--border-color);
        padding: 20px;
    }

    .table-card h5 {
        font-weight: 600;
        color: var(--text-primary);
    }

    .table-responsive {
        max-height: 250px;
        overflow-y: auto;
    }
</style>

<div class="p-3 p-md-4">

    <!-- Seção de Conteúdos (Apenas para Admin) -->
    <?php if ($_SESSION['nivel_admin'] == 1): ?>
    <div class="row">
        <div class="col-12">
            <h4 class="section-title">Resumo do Conteúdo</h4>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="color-card card-blue">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-tv"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Canais</p>
                        <h4 class="card-value"><?php echo $conteudos['TotalLiveStreams']; ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="color-card card-blue">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-film"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Filmes</p>
                        <h4 class="card-value"><?php echo $conteudos['TotalMovieStreams']; ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="color-card card-blue">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-clapperboard"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Séries</p>
                        <h4 class="card-value"><?php echo $conteudos['TotalSeries']; ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="color-card card-blue">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-photo-film"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Episódios</p>
                        <h4 class="card-value"><?php echo $conteudos['TotalEpisodes']; ?></h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Seção Financeira e de Clientes -->
    <div class="row mt-3">
        <div class="col-12">
            <h4 class="section-title">Resumo de Clientes</h4>
        </div>

        <!-- CLIENTES ATIVOS -->
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-green">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-users"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Clientes Ativos</p>
                        <h4 class="card-value"><?php echo $dadosAtivos['clientesAtivos']; ?></h4>
                    </div>
                </div>
            </div>
        </div>

        <!-- TOTAL VENCIDOS -->
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-red">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-users-slash"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Total Vencidos</p>
                        <h4 class="card-value"><?php echo $dadosAtivos['clientesvencidostotal']; ?></h4>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- VALORES A RECEBER -->
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-lightblue">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-dollar-sign"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Valores a Receber</p>
                        <h4 class="card-value">R$ <?php echo $dadosAtivos['clientesarenovar_valor']; ?></h4>
                    </div>
                </div>
            </div>
        </div>

        <!-- TESTES ATIVOS -->
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-orange">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-vial"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Testes Ativos</p>
                        <h4 class="card-value"><?php echo $dadosTestes['TestesAtivos']; ?></h4>
                    </div>
                </div>
            </div>
        </div>

        <!-- NOVOS USUÁRIOS -->
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-purple">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-user-plus"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Novos (Mês)</p>
                        <h4 class="card-value"><?php echo $dadosAtivos['clientesnovos']; ?></h4>
                    </div>
                </div>
            </div>
        </div>

        <!-- VENCIDOS ESTE MÊS -->
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="color-card card-red">
                <div class="card-body">
                    <div class="icon-container"><i class="fa-solid fa-user-xmark"></i></div>
                    <div class="card-text-content">
                        <p class="card-label">Vencidos (Mês)</p>
                        <h4 class="card-value"><?php echo $dadosAtivos['clientesvencidos_este_mes']; ?></h4>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Seção de Vencimentos -->
    <div class="row mt-3">
        <div class="col-12">
            <h4 class="section-title">Acompanhamento de Vencimentos</h4>
        </div>
        
        <!-- Vencimento Hoje -->
        <div class="col-lg-6 mb-4">
            <div class="table-card h-100">
                <h5>Vencendo Hoje</h5>
                <div class="table-responsive">
                    <table class="table table-hover table-sm">
                        <thead>
                            <tr>
                                <th>Usuário</th>
                                <th>Vencimento</th>
                                <th class="text-end">Valor</th>
                                <th class="text-center">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($dadosAtivos['clientesvencidos_hoje_lista'])): ?>
                                <tr><td colspan="4" class="text-center text-muted">Nenhum cliente vencendo hoje.</td></tr>
                            <?php else: ?>
                                <?php foreach ($dadosAtivos['clientesvencidos_hoje_lista'] as $cliente): ?>
                                <tr>
                                    <td><?php echo $cliente['usuario']; ?></td>
                                    <td><?php echo $cliente['data']; ?></td>
                                    <td class="text-end">R$ <?php echo $cliente['total']; ?></td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-sm btn-outline-primary" title="Renovar" onclick='modal_master("api/clientes.php", "renovar_cliente", "<?php echo $cliente['id']; ?>", "usuario", "<?php echo $cliente['usuario']; ?>")'><i class="fa-retweet fas"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Vencimento Amanhã -->
        <div class="col-lg-6 mb-4">
            <div class="table-card h-100">
                <h5>Vencendo Amanhã</h5>
                <div class="table-responsive">
                    <table class="table table-hover table-sm">
                        <thead>
                            <tr>
                                <th>Usuário</th>
                                <th>Vencimento</th>
                                <th class="text-end">Valor</th>
                                <th class="text-center">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($dadosAtivos['clientesvencidos_amanha_lista'])): ?>
                                <tr><td colspan="4" class="text-center text-muted">Nenhum cliente vencendo amanhã.</td></tr>
                            <?php else: ?>
                                <?php foreach ($dadosAtivos['clientesvencidos_amanha_lista'] as $cliente): ?>
                                <tr>
                                    <td><?php echo $cliente['usuario']; ?></td>
                                    <td><?php echo $cliente['data']; ?></td>
                                    <td class="text-end">R$ <?php echo $cliente['total']; ?></td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-sm btn-outline-primary" title="Renovar" onclick='modal_master("api/clientes.php", "renovar_cliente", "<?php echo $cliente['id']; ?>", "usuario", "<?php echo $cliente['usuario']; ?>")'><i class="fa-retweet fas"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- O seu modal continua o mesmo -->
<div class="modal fade" id="modal_master" tabindex="-1" aria-labelledby="modal_master" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="d-block modal-header" id="modal_master-header">
        <h5 class="float-start modal-title" id="modal_master-titulo"></h5>
        <button type="button" class="fa btn text-white fa-close fs-6 float-end" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form id="modal_master_form" onsubmit="event.preventDefault();" autocomplete="off">
        <div id="modal_master-body" class="modal-body overflow-auto" style="max-height: 421px;"></div>
        <div id="modal_master-footer" class="modal-footer"></div>
      </form>
    </div>
  </div>
</div>
